unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  LogBase, LogError, StdCtrls, ExtCtrls, ComCtrls;

type
  TfrmMain = class(TForm)
    SMExceptionLog: TSMExceptionLog;
    pcExceptionLog: TPageControl;
    tsGeneral: TTabSheet;
    tsEMail: TTabSheet;
    tsWEB: TTabSheet;
    rgTypeErrorDialog: TRadioGroup;
    pnlGoWEB: TPanel;
    lblWWW: TLabel;
    edGoWEB: TEdit;
    cbGoWEB: TCheckBox;
    pnlSendEMail: TPanel;
    lblEMail: TLabel;
    lblSubject: TLabel;
    lblBody: TLabel;
    cbAttachLog: TCheckBox;
    cbAttachScreenshot: TCheckBox;
    edEMail: TEdit;
    edSubject: TEdit;
    memoBody: TMemo;
    cbOpenBeforeSend: TCheckBox;
    cbSendMail: TCheckBox;
    gbFormats: TGroupBox;
    cbAddDate: TCheckBox;
    cbAddTime: TCheckBox;
    cbAddPhysAddr: TCheckBox;
    cbAddMessage: TCheckBox;
    cbAddSeparator: TCheckBox;
    tsViewLog: TTabSheet;
    lbLog: TListBox;
    gbRaiseError: TGroupBox;
    btnRaise: TButton;
    rbDivideByZero: TRadioButton;
    rbConvertError: TRadioButton;
    rbStringListError: TRadioButton;
    rbAccessViolation: TRadioButton;
    rbInvalidPointer: TRadioButton;
    rbResNotFound: TRadioButton;
    tsExceptionFilter: TTabSheet;
    pcFilters: TPageControl;
    tsStandard: TTabSheet;
    tsClass: TTabSheet;
    tsGraphic: TTabSheet;
    gbGraphic: TGroupBox;
    cbInvalidGraphic: TCheckBox;
    cbInvalidGraphicOperation: TCheckBox;
    gbClass: TGroupBox;
    cbStreamError: TCheckBox;
    cbFCreateError: TCheckBox;
    cbFOpenError: TCheckBox;
    cbReadError: TCheckBox;
    cbFilerError: TCheckBox;
    cbWriteError: TCheckBox;
    cbClassNotFound: TCheckBox;
    cbMethodNotFound: TCheckBox;
    cbInvalidImage: TCheckBox;
    cbResNotFound: TCheckBox;
    cbListError: TCheckBox;
    cbBitsError: TCheckBox;
    cbStringListError: TCheckBox;
    cbComponentError: TCheckBox;
    cbParserError: TCheckBox;
    cbOutOfResources: TCheckBox;
    cbInvalidOperation: TCheckBox;
    cbThread: TCheckBox;
    gbStandard: TGroupBox;
    cbAbort: TCheckBox;
    cbOutOfMemory: TCheckBox;
    cbInOutError: TCheckBox;
    cbDivByZero: TCheckBox;
    cbIntError: TCheckBox;
    cbRangeError: TCheckBox;
    cbIntOverflow: TCheckBox;
    cbMathError: TCheckBox;
    cbInvalidOp: TCheckBox;
    cbZeroDivide: TCheckBox;
    cbOverflow: TCheckBox;
    cbUnderflow: TCheckBox;
    cbInvalidPointer: TCheckBox;
    cbInvalidCast: TCheckBox;
    cbConvertError: TCheckBox;
    cbAccessViolation: TCheckBox;
    cbPrivilege: TCheckBox;
    cbStackOverflow: TCheckBox;
    cbControlC: TCheckBox;
    cbVariantError: TCheckBox;
    cbPropReadOnly: TCheckBox;
    cbPropWriteOnly: TCheckBox;
    cbExternalException: TCheckBox;
    cbAssertionFailed: TCheckBox;
    cbAbstractError: TCheckBox;
    cbIntfCastError: TCheckBox;
    cbInvalidContainer: TCheckBox;
    cbInvalidInsert: TCheckBox;
    cbPackageError: TCheckBox;
    cbWin32Error: TCheckBox;
    procedure rgTypeErrorDialogClick(Sender: TObject);
    procedure cbSendMailClick(Sender: TObject);
    procedure cbGoWEBClick(Sender: TObject);
    procedure edGoWEBExit(Sender: TObject);
    procedure edEMailExit(Sender: TObject);
    procedure edSubjectExit(Sender: TObject);
    procedure memoBodyExit(Sender: TObject);
    procedure cbAttachLogClick(Sender: TObject);
    procedure cbAttachScreenshotClick(Sender: TObject);
    procedure cbOpenBeforeSendClick(Sender: TObject);
    procedure cbAddDateClick(Sender: TObject);
    procedure cbAddTimeClick(Sender: TObject);
    procedure cbAddPhysAddrClick(Sender: TObject);
    procedure cbAddMessageClick(Sender: TObject);
    procedure cbAddSeparatorClick(Sender: TObject);
    procedure btnRaiseClick(Sender: TObject);
    procedure SMExceptionLogSaveException(Sender: TObject; E: Exception;
      var LogText: string; var Accept: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.rgTypeErrorDialogClick(Sender: TObject);
begin
  SMExceptionLog.ErrorDialog := TSMLErrorDialog(rgTypeErrorDialog.ItemIndex)
end;

procedure TfrmMain.cbSendMailClick(Sender: TObject);
begin
  if cbSendMail.Checked then
    SMExceptionLog.Options := SMExceptionLog.Options + [laShowSendEMail]
  else
    SMExceptionLog.Options := SMExceptionLog.Options - [laShowSendEMail]
end;

procedure TfrmMain.cbGoWEBClick(Sender: TObject);
begin
  if cbGoWEB.Checked then
    SMExceptionLog.Options := SMExceptionLog.Options + [laShowSupportLink]
  else
    SMExceptionLog.Options := SMExceptionLog.Options - [laShowSupportLink]
end;



procedure TfrmMain.edGoWEBExit(Sender: TObject);
begin
  SMExceptionLog.SendTo.WWW := edGoWEB.Text
end;

procedure TfrmMain.edEMailExit(Sender: TObject);
begin
  SMExceptionLog.SendTo.EMail := edEMail.Text
end;

procedure TfrmMain.edSubjectExit(Sender: TObject);
begin
  SMExceptionLog.SendTo.EMailSubject := edSubject.Text
end;

procedure TfrmMain.memoBodyExit(Sender: TObject);
begin
  SMExceptionLog.SendTo.EMailBody := memoBody.Lines.Text
end;

procedure TfrmMain.cbAttachLogClick(Sender: TObject);
begin
  SMExceptionLog.SendTo.AttachLog := cbAttachLog.Checked
end;

procedure TfrmMain.cbAttachScreenshotClick(Sender: TObject);
begin
  SMExceptionLog.SendTo.AttachScreenShot := cbAttachScreenshot.Checked
end;

procedure TfrmMain.cbOpenBeforeSendClick(Sender: TObject);
begin
  SMExceptionLog.SendTo.EMailOpenBeforeSend := cbOpenBeforeSend.Checked
end;





procedure TfrmMain.cbAddDateClick(Sender: TObject);
begin
  if cbAddDate.Checked then
    SMExceptionLog.Formats := SMExceptionLog.Formats + [lfDate]
  else
    SMExceptionLog.Formats := SMExceptionLog.Formats - [lfDate]
end;

procedure TfrmMain.cbAddTimeClick(Sender: TObject);
begin
  if cbAddTime.Checked then
    SMExceptionLog.Formats := SMExceptionLog.Formats + [lfTime]
  else
    SMExceptionLog.Formats := SMExceptionLog.Formats - [lfTime]
end;

procedure TfrmMain.cbAddPhysAddrClick(Sender: TObject);
begin
  if cbAddPhysAddr.Checked then
    SMExceptionLog.Formats := SMExceptionLog.Formats + [lfPhysAddress]
  else
    SMExceptionLog.Formats := SMExceptionLog.Formats - [lfPhysAddress]
end;

procedure TfrmMain.cbAddMessageClick(Sender: TObject);
begin
  if cbAddMessage.Checked then
    SMExceptionLog.Formats := SMExceptionLog.Formats + [lfMessage]
  else
    SMExceptionLog.Formats := SMExceptionLog.Formats - [lfMessage]
end;

procedure TfrmMain.cbAddSeparatorClick(Sender: TObject);
begin
  if cbAddSeparator.Checked then
    SMExceptionLog.Formats := SMExceptionLog.Formats + [lfSeparator]
  else
    SMExceptionLog.Formats := SMExceptionLog.Formats - [lfSeparator]
end;

procedure TfrmMain.btnRaiseClick(Sender: TObject);
var
  i: Integer;
begin
  SMExceptionLog.FilterStandard := [];
  if cbAbort.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efAbort];
  if cbOutOfMemory.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efOutOfMemory];
  if cbInOutError.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efInOutError];
  if cbIntError.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efIntError];
  if cbDivByZero.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efDivByZero];
  if cbRangeError.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efRangeError];
  if cbIntOverflow.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efIntOverflow];
  if cbMathError.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efMathError];
  if cbInvalidOp.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efInvalidOp];
  if cbZeroDivide.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efZeroDivide];
  if cbOverflow.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efOverflow];
  if cbUnderflow.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efUnderflow];
  if cbInvalidPointer.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efInvalidPointer];
  if cbInvalidCast.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efInvalidCast];
  if cbConvertError.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efConvertError];
  if cbAccessViolation.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efAccessViolation];
  if cbPrivilege.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efPrivilege];
  if cbStackOverflow.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efStackOverflow];
  if cbControlC.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efControlC];
  if cbVariantError.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efVariantError];
  if cbPropReadOnly.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efPropReadOnly];
  if cbPropWriteOnly.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efPropWriteOnly];
  if cbExternalException.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efExternalException];
  if cbAssertionFailed.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efAssertionFailed];
  if cbAbstractError.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efAbstractError];
  if cbIntfCastError.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efIntfCastError];
  if cbInvalidContainer.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efInvalidContainer];
  if cbInvalidInsert.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efInvalidInsert];
  if cbPackageError.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efPackageError];
  if cbWin32Error.Checked then
    SMExceptionLog.FilterStandard := SMExceptionLog.FilterStandard + [efWin32Error];



  SMExceptionLog.FilterClasses := [];
  if cbStreamError.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efStreamError];
  if cbFCreateError.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efFCreateError];
  if cbFOpenError.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efFOpenError];
  if cbFilerError.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efFilerError];
  if cbReadError.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efReadError];
  if cbWriteError.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efWriteError];
  if cbClassNotFound.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efClassNotFound];
  if cbMethodNotFound.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efMethodNotFound];
  if cbInvalidImage.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efInvalidImage];
  if cbResNotFound.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efResNotFound];
  if cbListError.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efListError];
  if cbBitsError.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efBitsError];
  if cbStringListError.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efStringListError];
  if cbComponentError.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efComponentError];
  if cbParserError.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efParserError];
  if cbOutOfResources.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efOutOfResources];
  if cbInvalidOperation.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efInvalidOperation];
  if cbThread.Checked then
    SMExceptionLog.FilterClasses := SMExceptionLog.FilterClasses + [efThread];



  SMExceptionLog.FilterGraphics := [];
  if cbInvalidGraphic.Checked then
    SMExceptionLog.FilterGraphics := SMExceptionLog.FilterGraphics + [efInvalidGraphic];
  if cbInvalidGraphicOperation.Checked then
    SMExceptionLog.FilterGraphics := SMExceptionLog.FilterGraphics + [efInvalidGraphicOperation];



  if rbDivideByZero.Checked then
  begin
    i := 0;
    ShowMessage(IntToStr(23 div i))
  end
  else
  if rbConvertError.Checked then
  begin
    i := StrToInt('aaa' + IntToStr(Random(19)));
    Caption := FloatToStr(i);
  end
  else
  if rbStringListError.Checked then
    ShowMessage(lbLog.Items[-3])
  else
  if rbAccessViolation.Checked then
    GetClass('TDBGrid').Create
  else
  if rbInvalidPointer.Checked then
    raise EInvalidPointer.Create('InvalidPointer')
  else
  if rbResNotFound.Checked then
    raise EResNotFound.Create('ResNotFound')
end;

procedure TfrmMain.SMExceptionLogSaveException(Sender: TObject;
  E: Exception; var LogText: string; var Accept: Boolean);
begin
  lbLog.Items.Add(FormatDateTime('dd mmm yyyy, hh:nn:ss', Now()) + ': we must fix this bug in new build (see smevent.log file)')
end;

end.
