unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Grids, DBGrids, Db, DBTables, StdCtrls, LogBase, LogDS;

type
  TfrmMain = class(TForm)
    lbLog: TListBox;
    dSrc: TDataSource;
    tblCustomer: TTable;
    SMDatasetLog: TSMDatasetLog;
    DBGrid: TDBGrid;
    Splitter: TSplitter;
    procedure SMDatasetLogChange(Sender: TObject; State: TSMLDBTypeEvents;
      Field: TField; var LogText: string);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.SMDatasetLogChange(Sender: TObject;
  State: TSMLDBTypeEvents; Field: TField; var LogText: string);
const
  ASMLDBTypeEvents: array[TSMLDBTypeEvents] of string =
    ('ActiveChanged',
     'EditingChanged',
     'DataSetChanged',
     'DataSetScrolled',
     'LayoutChanged',
     'RecordChanged',
     'UpdateData');
begin
  lbLog.Items.Add(ASMLDBTypeEvents[State]);
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  SMDatasetLog.Active := True
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  SMDatasetLog.Active := False
end;

end.
