// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'LogFile.pas' rev: 3.00

#ifndef LogFileHPP
#define LogFileHPP
#include <LogBase.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Logfile
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EFileNotificationError;
class PASCALIMPLEMENTATION EFileNotificationError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall EFileNotificationError(const System::AnsiString Msg) : Sysutils::
		Exception(Msg) { }
	/* Exception.CreateFmt */ __fastcall EFileNotificationError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall EFileNotificationError(int Ident, Extended Dummy) : Sysutils::
		Exception(Ident, Dummy) { }
	/* Exception.CreateResFmt */ __fastcall EFileNotificationError(int Ident, const System::TVarRec * Args
		, const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall EFileNotificationError(const System::AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall EFileNotificationError(const System::AnsiString Msg, const 
		System::TVarRec * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size
		, AHelpContext) { }
	/* Exception.CreateResHelp */ __fastcall EFileNotificationError(int Ident, int AHelpContext) : Sysutils::
		Exception(Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall EFileNotificationError(int Ident, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~EFileNotificationError(void) { }
	
};

enum TFileNotificationOption { foFile, foFolder, foAttributes, foSize, foTime, foWatchSubFolders };

typedef Set<TFileNotificationOption, foFile, foWatchSubFolders>  TFileNotificationOptions;

typedef void __fastcall (__closure *TFileNotifyEvent)(System::TObject* Sender, TFileNotificationOption 
	Action);

class DELPHICLASS TNotificationThread;
class DELPHICLASS TSMFileLog;
class PASCALIMPLEMENTATION TSMFileLog : public Logbase::TSMLogBase 
{
	typedef Logbase::TSMLogBase inherited;
	
private:
	TNotificationThread* FThread;
	System::AnsiString FFolder;
	TFileNotificationOptions FOptions;
	TFileNotifyEvent FOnFileNotification;
	void __fastcall SetOptions(TFileNotificationOptions Value);
	void __fastcall SetFolder(System::AnsiString Value);
	
protected:
	virtual void __fastcall Notify(TFileNotificationOption Action);
	virtual void __fastcall Loaded(void);
	
public:
	__fastcall virtual TSMFileLog(Classes::TComponent* AOwner);
	__fastcall virtual ~TSMFileLog(void);
	
__published:
	__property System::AnsiString Folder = {read=FFolder, write=SetFolder};
	__property TFileNotificationOptions Options = {read=FOptions, write=SetOptions, nodefault};
	__property TFileNotifyEvent OnFileNotification = {read=FOnFileNotification, write=FOnFileNotification
		};
};

class PASCALIMPLEMENTATION TNotificationThread : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
private:
	TSMFileLog* FOwner;
	int FHandles[8];
	TFileNotificationOption FHandleFilters[8];
	int FHandleCount;
	TFileNotificationOption FActiveFilter;
	void __fastcall ReleaseHandles(void);
	void __fastcall AllocateHandles(void);
	
protected:
	virtual void __fastcall Execute(void);
	void __fastcall Notify(void);
	
public:
	__fastcall TNotificationThread(TSMFileLog* Owner);
	__fastcall virtual ~TNotificationThread(void);
	void __fastcall Reset(void);
};

//-- var, const, procedure ---------------------------------------------------

}	/* namespace Logfile */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Logfile;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// LogFile
