unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, Db, DBTables, StdCtrls, ComCtrls, SMIBase, SMIWiz,
  ExtCtrls;

type
  TfrmMain = class(TForm)
    dSrc: TDataSource;
    tbl: TTable;
    SMIWizardDlg: TSMIWizardDlg;
    PageControl: TPageControl;
    tsCountries: TTabSheet;
    tsErrorLog: TTabSheet;
    tsImported: TTabSheet;
    DBGrid: TDBGrid;
    lbErrorLog: TListBox;
    lbImported: TListBox;
    pnlTop: TPanel;
    btnImport: TButton;
    procedure btnImportClick(Sender: TObject);
    procedure SMIWizardDlgErrorEvent(Sender: TObject; Error: Exception;
      var Abort: Boolean);
    procedure SMIWizardDlgGetCellParams(Sender: TObject; Field: TField;
      var Value: Variant);
    procedure SMIWizardDlgBeforeExecute(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.btnImportClick(Sender: TObject);
begin
  lbErrorLog.Items.Clear;
  lbImported.Items.Clear;

  SMIWizardDlg.Execute
end;


procedure TfrmMain.SMIWizardDlgErrorEvent(Sender: TObject;
  Error: Exception; var Abort: Boolean);
begin
  lbErrorLog.Items.Add(Error.Message);
end;

procedure TfrmMain.SMIWizardDlgGetCellParams(Sender: TObject;
  Field: TField; var Value: Variant);
begin
  lbImported.Items.Add(Field.FieldName + ' : ' + Value);
end;

procedure TfrmMain.SMIWizardDlgBeforeExecute(Sender: TObject);
begin
  lbErrorLog.Items.Clear;
  lbImported.Items.Clear;
end;

end.
