unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ShapeImgCtrl, ExtCtrls, StdCtrls, Menus, ExtDlgs;

type
  TForm1 = class(TForm)
    ShapeImgCtrl1: TShapeImgCtrl;
    PopupMenu1: TPopupMenu;
    MaskOutItem: TMenuItem;
    LoadImageItem: TMenuItem;
    AutoDragItem: TMenuItem;
    OpenPictureDialog1: TOpenPictureDialog;
    ShowImageItem: TMenuItem;
    ActiveItem: TMenuItem;
    procedure MaskOutItemClick(Sender: TObject);
    procedure LoadImageItemClick(Sender: TObject);
    procedure AutoDragItemClick(Sender: TObject);
    procedure ShowImageItemClick(Sender: TObject);
    procedure ActiveItemClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.MaskOutItemClick(Sender: TObject);
begin
 MaskOutItem.Checked := not MaskOutItem.Checked;
 ShapeImgCtrl1.ImageInfo.MaskOut := MaskOutItem.Checked;
end;

procedure TForm1.LoadImageItemClick(Sender: TObject);
begin
 if OpenPictureDialog1.Execute then begin
   ShapeImgCtrl1.ImageInfo.IMAGE.LoadFromFile(OpenPictureDialog1.FileName);
 end;
end;

procedure TForm1.AutoDragItemClick(Sender: TObject);
begin
 AutoDragItem.Checked := not AutoDragItem.Checked;
 ShapeImgCtrl1.AutoDragWindow := AutoDragItem.Checked;
end;

procedure TForm1.ShowImageItemClick(Sender: TObject);
begin
 ShowImageItem.Checked := not ShowImageItem.Checked;
 ShapeImgCtrl1.ShowImage := ShowImageItem.Checked;
end;

procedure TForm1.ActiveItemClick(Sender: TObject);
begin
 ActiveItem.Checked := not ActiveItem.Checked;
 ShapeImgCtrl1.Active := ActiveItem.Checked;
end;

end.
