unit ShellTree_Unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ShellTree, ComCtrls, StdCtrls, SHLOBJ, ExtCtrls,  ActiveX, CommCtrl,
  Menus, ComObj, ItemProp;//, CheckLst;//, ShellList;

{$DEFINE CheckBoxes}

type
  TForm_Demo = class(TForm)
    DirectoryLabel: TPanel;
    Quit: TButton;
    ShellTree1: TShellTree;
    Label3: TLabel;
    Pages: TPageControl;
    RootOptions: TTabSheet;
    PidlRoot: TRadioGroup;
    GroupBox1: TGroupBox;
    RootUsePidl: TCheckBox;
    SetRootDir: TButton;
    RootDir: TEdit;
    Button1: TButton;
    Button3: TButton;
    Standard: TTabSheet;
    Path: TEdit;
    Label1: TLabel;
    Misc: TGroupBox;
    UpdateMode: TGroupBox;
    UpdAuto: TCheckBox;
    UpdAutoRec: TCheckBox;
    Options: TGroupBox;
    CB_TF_FOLDERS: TCheckBox;
    CB_TF_NONFOLDERS: TCheckBox;
    CB_TF_HIDDEN: TCheckBox;
    FileOptions: TTabSheet;
    GroupBox2: TGroupBox;
    FileMask: TEdit;
    FileMaskUse: TCheckBox;
    ChangeFileMask: TButton;
    FileSortOrder: TRadioGroup;
    FileSorttype: TRadioGroup;
    Update: TButton;
    ReadOnly: TCheckBox;
    UpdSel: TButton;
    ShowOptions: TGroupBox;
    ShowSharedOverlay: TCheckBox;
    ShowLinkOverlay: TCheckBox;
    ShowVirtualFolders: TCheckBox;
    ShowIcons: TCheckBox;
    EditName: TButton;
    PopupMenu1: TPopupMenu;
    Popupentry11: TMenuItem;
    Popupentry21: TMenuItem;
    PopupMenuMode: TCheckBox;
    ShowMessages: TCheckBox;
    Button2: TButton;
    UpdAutoThread: TCheckBox;
    FolderTools: TTabSheet;
    Button4: TButton;
    Button5: TButton;
    SpecialFolders: TRadioGroup;
    DefaultAction: TButton;
    Button6: TButton;
    CheckBoxes: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure ShellTree1Change(Sender: TObject; Node: TTreeNode);
    procedure PidlRootClick(Sender: TObject);
    procedure QuitClick(Sender: TObject);
    procedure RootUsePidlClick(Sender: TObject);
    procedure SetRootDirClick(Sender: TObject);
    procedure RootDirKeyPress(Sender: TObject; var Key: Char);
    procedure PathKeyPress(Sender: TObject; var Key: Char);
    procedure CB_TF_FOLDERSClick(Sender: TObject);
    procedure CB_TF_NONFOLDERSClick(Sender: TObject);
    procedure CB_TF_HIDDENClick(Sender: TObject);
    procedure UpdateClick(Sender: TObject);
    procedure UpdAutoClick(Sender: TObject);
    procedure UpdAutoRecClick(Sender: TObject);
    procedure ShellTree1Expanded(Sender: TObject; Node: TTreeNode);
    procedure ShellTree1Collapsing(Sender: TObject; Node: TTreeNode;
      var AllowCollapse: Boolean);
    procedure ShellTree1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ShowIconsClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ShowVirtualFoldersClick(Sender: TObject);
    procedure FileMaskUseClick(Sender: TObject);
    procedure ChangeFileMaskClick(Sender: TObject);
    procedure FileSorttypeClick(Sender: TObject);
    procedure FileSortOrderClick(Sender: TObject);
    procedure ShellTree1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button3Click(Sender: TObject);
    procedure ReadOnlyClick(Sender: TObject);
    procedure EditNameClick(Sender: TObject);
    procedure UpdSelClick(Sender: TObject);
    procedure ShowSharedOverlayClick(Sender: TObject);
    procedure ShowLinkOverlayClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Popupentry11Click(Sender: TObject);
    procedure Popupentry21Click(Sender: TObject);
    procedure PopupMenuModeClick(Sender: TObject);
    procedure ShowMessagesClick(Sender: TObject);
    procedure UpdAutoThreadClick(Sender: TObject);
    procedure GetDataClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FileMaskKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DefaultActionClick(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure CheckBoxesClick(Sender: TObject);
  private
    { Private declarations }
  protected
    procedure Shelltree1CheckBoxChanged(Node : TShellNode;NewState : Boolean);
  public
    Pidl1 : PItemidList;
    function ConvertGroupBoxToPidls(Index : Integer) : TPidls;
  end;

var
  Form_Demo: TForm_Demo;

implementation

{$R *.DFM}

procedure TForm_Demo.FormShow(Sender: TObject);
begin
  RootUsePidl.Checked:=Shelltree1.RootUsePidl;
  RootDir.Text:=ShellTree1.RootDir;
  UpdAutoThread.Checked:=Shelltree1.UpdAutoThread;
  UpdAuto.Checked:=ShellTree1.UpdAuto;
  UpdAutoRec.Checked:=Shelltree1.UpdAutoRec;
  CB_TF_FOLDERS.Checked     :=(TF_FOLDERS in Shelltree1.Options);
  CB_TF_NONFOLDERS.Checked  :=(TF_NONFOLDERS in Shelltree1.Options);
  CB_TF_HIDDEN.Checked      :=(TF_HIDDEN in Shelltree1.Options);
  PidlRoot.ItemIndex        :=Byte(ShellTree1.RootPidl);
  ShowIcons.Checked         :=ShellTree1.ShowIcons;
  ShowVirtualFolders.Checked:=ShellTree1.ShowVirtualFolders;
  FileMask.Text             :=ShellTree1.Filemask;
  FileMaskUse.Checked       :=ShellTree1.FileMaskUse;
  FileSorttype.ItemIndex    :=Byte(ShellTree1.FileSortType);
  FileSortOrder.ItemIndex   :=Byte(ShellTree1.FileSortOrder);
  ReadOnly.Checked          :=Shelltree1.ReadOnly;
  ShowSharedOverlay.Checked :=Shelltree1.ShowSharedOverlay;
  ShowLinkOverlay.Checked   :=Shelltree1.ShowLinkOverlay;
  PopupMenuMode.Checked     :=(Shelltree1.PopupMenuMode=pmm_System);
  ShowMessages.Checked      :=Shelltree1.ShowMessages;
  Pages.ActivePage          :=Standard;
  {$IFDEF CheckBoxes}
  Shelltree1.OnCheckBoxChanged:=Shelltree1CheckBoxChanged;
  CheckBoxes.Visible:=True;
  CheckBoxes.Checked:=ShellTree1.CheckBoxes;
  {$ENDIF}
{  With TShellList.Create(self) do begin
    Shelltree:=Shelltree1;
    Parent:=ListView;
    Align:=alclient;
  end;}

end;

procedure TForm_Demo.Shelltree1CheckBoxChanged(Node : TShellNode;NewState : Boolean);
begin
  IF NewState Then Caption:='Checked' else Caption:='UnChanged';
  beep;
end;

procedure TForm_Demo.ShellTree1Change(Sender: TObject; Node: TTreeNode);
begin
  DirectoryLabel.Caption:=ShellTree1.Path;
//  LogMsg('OnChange: '+DirectoryLabel.Caption);
  Path.Text:=DirectoryLabel.Caption;
  UpdSel.Enabled:=Assigned(Shelltree1.Selected);
  IF NOT Assigned(Shelltree1.Selected) Then exit;
  EditName.Enabled:=(TShellNode(Shelltree1.Selected).HasAttribute(SFGAO_CANRENAME))
    AND NOT Shelltree1.ReadOnly;
end;

function TForm_Demo.ConvertGroupBoxToPidls(Index : Integer) : TPidls;
begin
  Case Index OF
    0  : Result:=PIDL_DESKTOP;
    1  : Result:=PIDL_PROGRAMS;
    2  : Result:=PIDL_CONTROLS;
    3  : Result:=PIDL_PRINTERS;
    4  : Result:=PIDL_PERSONAL;
    5  : Result:=PIDL_FAVORITES;
    6  : Result:=PIDL_STARTUP;
    7  : Result:=PIDL_RECENT;
    8  : Result:=PIDL_SENDTO;
    9  : Result:=PIDL_BITBUCKET;
   10  : Result:=PIDL_STARTMENU;
   11  : Result:=PIDL_DESKTOPDIRECTORY;
   12  : Result:=PIDL_DRIVES;
   13  : Result:=PIDL_NETWORK;
   14  : Result:=PIDL_NETHOOD;
   15  : Result:=PIDL_FONTS;
   16  : Result:=PIDL_TEMPLATES;
   17  : Result:=PIDL_USERDEFINED;
   else
     Result:=PIDL_DESKTOP;
  end;
end;

procedure TForm_Demo.PidlRootClick(Sender: TObject);
Var
  T : TPidls;
begin
  T:=ConvertGroupBoxToPidls(PidlRoot.ItemIndex);
  ShellTree1.RootPIDL:=T;
end;

procedure TForm_Demo.QuitClick(Sender: TObject);
begin
  Close;
end;

procedure TForm_Demo.RootUsePidlClick(Sender: TObject);
begin
  Shelltree1.RootUsePidl:=RootUsePidl.Checked;
end;

procedure TForm_Demo.SetRootDirClick(Sender: TObject);
begin
  ShellTree1.RootDir:=RootDir.Text;
  RootDir.Text:=ShellTree1.RootDir;
end;

procedure TForm_Demo.RootDirKeyPress(Sender: TObject; var Key: Char);
begin
  IF Key=#13 Then begin
    SetRootDirClick(Sender);
    Key:=#0;
  end;
end;

procedure TForm_Demo.PathKeyPress(Sender: TObject; var Key: Char);
begin
  IF Key=#13 Then begin
    ShellTree1.Path:=Path.Text;
    Key:=#0;
    Path.Text:=ShellTree1.Path;
  end;
end;

procedure TForm_Demo.CB_TF_FOLDERSClick(Sender: TObject);
begin
  IF CB_TF_Folders.Checked Then
    ShellTree1.Options:=ShellTree1.Options+[TF_FOLDERS]
  else
    ShellTree1.Options:=ShellTree1.Options-[TF_FOLDERS];
end;

procedure TForm_Demo.CB_TF_NONFOLDERSClick(Sender: TObject);
begin
  IF CB_TF_NONFolders.Checked Then
    ShellTree1.Options:=ShellTree1.Options+[TF_NONFOLDERS]
  else
    ShellTree1.Options:=ShellTree1.Options-[TF_NONFOLDERS];
end;

procedure TForm_Demo.CB_TF_HIDDENClick(Sender: TObject);
begin
  IF CB_TF_Hidden.Checked Then
    ShellTree1.Options:=ShellTree1.Options+[TF_Hidden]
  else
    ShellTree1.Options:=ShellTree1.Options-[TF_Hidden];
end;

procedure TForm_Demo.UpdateClick(Sender: TObject);
begin
  ShellTree1.UpdateTree;
end;

procedure TForm_Demo.UpdAutoClick(Sender: TObject);
begin
  ShellTree1.UpdAuto:=UpdAuto.Checked;
end;

procedure TForm_Demo.UpdAutoRecClick(Sender: TObject);
begin
  ShellTree1.UpdAutoRec:=UpdAutoRec.Checked;
end;

procedure TForm_Demo.ShellTree1Expanded(Sender: TObject; Node: TTreeNode);
begin
//  Label2.Caption:='Number of Elements : '+InttoStr(Shelltree1.Items.Count);
end;

procedure TForm_Demo.ShellTree1Collapsing(Sender: TObject; Node: TTreeNode;
  var AllowCollapse: Boolean);
begin

//  Label2.Caption:='Number of Elements : '+InttoStr(Shelltree1.Items.Count);
end;

procedure TForm_Demo.ShellTree1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Label3.Caption:='Drop on : '+TShellNode(ShellTree1.GetNodeAt(X,Y)).Path;
end;

procedure TForm_Demo.ShowIconsClick(Sender: TObject);
begin
  ShellTree1.ShowIcons:=ShowIcons.Checked;
end;

procedure TForm_Demo.Button1Click(Sender: TObject);
begin
  IF Assigned(ShellTree1.Selected) Then
    ShellTree1.RootUserPidl:=ShellTree1.AbsolutePIDL;
end;

procedure TForm_Demo.ShowVirtualFoldersClick(Sender: TObject);
begin
  ShellTree1.ShowVirtualFolders:=ShowVirtualFolders.Checked;
end;

procedure TForm_Demo.FileMaskUseClick(Sender: TObject);
begin
  ShellTree1.FileMaskUse:=FileMaskUse.Checked;
end;

procedure TForm_Demo.ChangeFileMaskClick(Sender: TObject);
begin
  Shelltree1.FileMask:=Filemask.text;
end;

procedure TForm_Demo.FileSorttypeClick(Sender: TObject);
begin
  ShellTree1.FileSortType:=TFileSortType(FileSorttype.ItemIndex);
end;

procedure TForm_Demo.FileSortOrderClick(Sender: TObject);
begin
  ShellTree1.FileSortOrder:=TFileSortOrder(FileSortOrder.ItemIndex);
end;

procedure TForm_Demo.ShellTree1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  IF Key=VK_F2 Then begin
    ShellTree1.Selected.EditText;
  end;
end;

procedure TForm_Demo.Button3Click(Sender: TObject);
begin
  ShellTree1.RootUserPidl:=nil;
end;



procedure TForm_Demo.ReadOnlyClick(Sender: TObject);
begin
  Shelltree1.ReadOnly:=ReadOnly.Checked;
  EditName.Enabled:=(TShellNode(Shelltree1.Selected).HasAttribute(SFGAO_CANRENAME))
    AND NOT Shelltree1.ReadOnly;
end;

procedure TForm_Demo.EditNameClick(Sender: TObject);
begin
  IF Assigned(Shelltree1.Selected) Then begin
    ShellTree1.SetFocus;
    Shelltree1.Selected.EditText;
  end;
end;

procedure TForm_Demo.UpdSelClick(Sender: TObject);
begin
  Shelltree1.UpdateNode(Shelltree1.Selected,True);
end;


procedure TForm_Demo.ShowSharedOverlayClick(Sender: TObject);
begin
  Shelltree1.ShowSharedOverlay:=ShowSharedOverlay.Checked;
end;

procedure TForm_Demo.ShowLinkOverlayClick(Sender: TObject);
begin
  Shelltree1.ShowLinkOverlay:=ShowLinkOverlay.Checked;
end;


procedure TForm_Demo.Button2Click(Sender: TObject);
begin
  ShellTree1.SaveToFile(InputBox('Filename','Please enter Filename:','C:\Directory.txt'));
end;

procedure TForm_Demo.Popupentry11Click(Sender: TObject);
begin
  Showmessage('Popupentry 1');
end;

procedure TForm_Demo.Popupentry21Click(Sender: TObject);
begin
  Showmessage('Popupentry 2');
end;

procedure TForm_Demo.PopupMenuModeClick(Sender: TObject);
begin
  IF PopupMenuMode.Checked Then Shelltree1.PopupMenumode:=pmm_System
    else Shelltree1.PopupMenumode:=pmm_PopupMenu;
end;

procedure TForm_Demo.ShowMessagesClick(Sender: TObject);
begin
  Shelltree1.ShowMessages:=ShowMessages.Checked;
end;


procedure TForm_Demo.UpdAutoThreadClick(Sender: TObject);
begin
  Shelltree1.UpdAutoThread:=UpdAutoThread.Checked;
end;

procedure TForm_Demo.GetDataClick(Sender: TObject);
{const
  cb = 15000;
Var
  ShellNode : TShellNode;
  Res : HResult;
  Data : Pointer;
  Pidl : PItemIdList;}
begin
{  try
  Shelltree1.Path:='C:\';
  Shellnode:=TShellNode(Shelltree1.Selected);
  IF NOT Assigned(Shellnode) Then exit;
  With ShellNode DO begin
    Data:=Shelltree.allocator.Alloc(cb);
    Pidl:=RelativeIDL;
    res:=SHGetDataFromIDList(ParentShellfolder,Pidl,1,Data,cb);
    IF NOT Succeeded(Res) Then beep;
    Oleerror(Res);
  end;
  except

  end;}
end;

procedure TForm_Demo.Button4Click(Sender: TObject);
Var
  P : TPidls;
begin
  P:=ConvertGroupBoxToPidls(SpecialFolders.ItemIndex);
  Shelltree1.SelectSpecialFolder(P);
end;

procedure TForm_Demo.Button5Click(Sender: TObject);
Var
  P : TPidls;
  Node : TShellnode;
begin
  P:=ConvertGroupBoxToPidls(SpecialFolders.ItemIndex);
  Node:=Shelltree1.SpecialFolder(P);
  IF Assigned(Node) Then begin
    Shelltree1.TopItem:=Node;
    ShowMessage('Displayname of the special Folder :'+#13+Node.text);
  end else begin
    ShowMessage('This special Folder is not visible at the moment'+#13+
    'Use the SelectSpecialFolder Button to make it visible.');
  end;
end;

procedure TForm_Demo.FileMaskKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  IF Key=VK_Return then ChangeFileMaskClick(nil);
end;

procedure TForm_Demo.DefaultActionClick(Sender: TObject);
Var
  SN : TShellNode;
begin
  SN:=TShellnode(Shelltree1.Selected);
  IF NOT Assigned(SN) then exit;
  SN.PerformDefaultAction;
end;

procedure TForm_Demo.Button6Click(Sender: TObject);
const
  B : ARRAY[BOOLEAN] Of String = ('False','True');
Var
 S : String;
begin
  IF TShellNode(Shelltree1.Selected).Checked Then beep;
  With TShellNode(Shelltree1.Selected) do begin
    S:='IsFile %s'+#13+'IsFolder %s'+#13+'IsSysObject %s'+#13+'IsFileSystemancestor %s';
    ShowMessage(Format(S,[B[IsFile],B[IsFolder],B[IsSysObject],B[HasAttribute(SFGAO_FILESYSANCESTOR)]]));
  end;
end;

procedure TForm_Demo.CheckBoxesClick(Sender: TObject);
begin
{$IFDEF CheckBoxes}
  ShellTree1.CheckBoxes:=CheckBoxes.Checked;
{$ENDIF}
end;

end.
