unit main;

// Advanced Sample for ShellBrowser
// This sample project looks like the windows explorer. The FolderIdList
// of each folder is stored in the Data property of each TreeNode

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ShellBrowser, Menus, ShellApi, ComCtrls, ExtCtrls,
  ShellControls, ShellLink;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    PropertiesButton: TSpeedButton;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    TreeViewPopup: TPopupMenu;
    FullExpand1: TMenuItem;
    FullCollapse1: TMenuItem;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    DeleteButton: TSpeedButton;
    ParentButton: TSpeedButton;
    SpeedButton5: TSpeedButton;
    Splitter1: TSplitter;
    ShellListView: TJamShellList;
    ShellTree: TJamShellTree;
    JamShellLink: TJamShellLink;
    ShellCombo: TJamShellCombo;
    procedure PropertiesButtonClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FullExpand1Click(Sender: TObject);
    procedure FullCollapse1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure ParentButtonClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
  private
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation
{$R *.DFM}

// OnClick of the Properties button
procedure TMainForm.PropertiesButtonClick(Sender: TObject);
begin
  if ShellListView.Focused then
    ShellListView.InvokeCommandOnSelected('properties');
  if ShellTree.Focused then
    ShellTree.InvokeCommandOnSelected('properties');
end;

procedure TMainForm.SpeedButton1Click(Sender: TObject);
begin
  ShellListView.ViewStyle := TViewStyle(Ord(vsIcon) + TComponent(Sender).Tag);
end;

procedure TMainForm.FullExpand1Click(Sender: TObject);
begin
  ShellTree.Selected.Expand(True);
end;

procedure TMainForm.FullCollapse1Click(Sender: TObject);
begin
  ShellTree.Selected.Collapse(True);
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.About1Click(Sender: TObject);
begin
  ShellAbout(Application.Handle, 'Advanced Sample for ShellBrowser components'+#10, 'Advanced sample for TShellBrowser'+#10+'More info at: http://www.jam-software.com', Application.Icon.Handle);
end;

procedure TMainForm.ParentButtonClick(Sender: TObject);
begin
  ShellTree.GoUp;
end;

procedure TMainForm.DeleteButtonClick(Sender: TObject);
begin
  if ShellListView.Focused then
    ShellListView.InvokeCommandOnSelected('delete');
  if ShellTree.Focused then
    ShellTree.InvokeCommandOnSelected('delete');
end;

procedure TMainForm.SpeedButton5Click(Sender: TObject);
begin
  ShellTree.ShowNetConnectionDialog;
end;

end.

