unit StrTestFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses SuperStream;

{$R *.DFM}

type
	TTest = class
  public
  	s,t : String;
  end;

  TExtra = class(TTest)
  public
  	d : Integer;
  end;

  TBoth = class
  public
  	test : TTest;
    extra : TExtra;

    constructor Create;

  end;

  TComplex = class
  public
  	tm : TDateTime;
  	a : array[1..5] of String;
  end;

constructor TBoth.Create;
begin
	test := TTest.Create;
  test.s := 'big metal hooba joob';
  test.t := 'there';

  extra := TExtra.Create;
  extra.s := 'extra';
  extra.d := 555;
end;

procedure TestIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
	with obj as TTest do
  	case version of
     1:
     	begin
      	// old version didn't have a t value
		  	stream.TransferItems([s], [@s], direction, version);
        t := 'yipe';
      end;
     2:
	  	stream.TransferItems([s,t], [@s, @t], direction, version);
    end;

end;

procedure ExtraIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
	with obj as TExtra do
  	stream.TransferItems([d], [@d], direction, version);
end;

procedure BothIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
	with obj as TBoth do
  	stream.TransferItems([test, extra], [@test, @extra], direction, version);
end;

procedure ComplexIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
	with obj as TComplex do
  	begin
    	stream.TransferItemsEx([tm], [@tm], [ssvtDateTime], direction, version);
      stream.TransferArrays([a[1]], [@a[1]], [High(a)], direction);
    end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var b : TBoth;
begin
	b := TBoth.Create;
	TObjStream.WriteObjectToFile('x.od', [], b);
  b.free;
end;

procedure TForm1.Button2Click(Sender: TObject);
var b : TBoth;
begin
	b := TObjStream.ReadObjectinFile('x.od', []) as TBoth;
  b.free;
end;

procedure TForm1.Button3Click(Sender: TObject);
var ol : TObjList;
begin
	ol := TObjList.Create;
  ol.Add(TBoth.Create);
  ol.Add(TBoth.Create);
  TObjStream.WriteObjectToFile('ol.od', [], ol);
  ol.free;

  ol := TobjStream.ReadObjectInFile('ol.od', []) as TObjList;
  ol.free;
end;

procedure TForm1.Button4Click(Sender: TObject);
var cmp : TComplex;
		i : Integer;
begin
	cmp := TComplex.Create;
  cmp.tm := Now;
  for i := Low(cmp.a) to High(cmp.a) do
  	cmp.a[i] := IntToStr(i);

  TObjStream.WriteObjectToFile('complex.od', [], cmp);
  cmp.free;

  cmp := TObjStream.ReadObjectInFile('complex.od', []) as TComplex;

end;

procedure TForm1.Button5Click(Sender: TObject);
var cmp : TComplex;
		ol : TObjList;
    i : Integer;
begin
	ol := TObjList.Create;
  ol.owns := true;
	for i := 1 to 10000 do
  	begin
      ol.Add(TBoth.Create);
    end;

  TObjStream.WriteObjectToFile('many.od', [], ol);
  ol.free;

  ol := TObjStream.ReadObjectInFile('many.od', []) as TObjList;

end;

procedure TForm1.Button6Click(Sender: TObject);
var os : TObjStream;
		ol : TObjList;
    i : Integer;
begin
	ol := TObjList.Create;
  ol.owns := true;
	for i := 1 to 10000 do
  	begin
      ol.Add(TBoth.Create);
    end;

  os := TObjStream.CreateOnFile('onfile.od', [], iodirWrite);
  os.WriteObject(ol);
  os.free;
  ol.free;

  os := TObjStream.CreateOnFile('onfile.od', [], iodirRead);
  ol := os.ReadObject as TObjList;
  os.free;
  ol.free;

end;

initialization
	TObjStream.RegisterDefaultClasses;

  // note that the version here is 2
	TObjStream.RegisterClass(TTest, TestIO, 2);

  TObjStream.RegisterClass(TExtra, ExtraIO, 1);
  TObjStream.RegisterClass(TBoth, BothIO, 1);
  TObjStream.RegisterClass(TComplex, ComplexIO, 1);
end.
