unit TestFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TFormX = class(TForm)
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormX: TFormX;

implementation

uses SuperStream;

{$R *.DFM}

var

	bk : array[1..10] of string[25] = (
  	'hello',
    'checking',
    'test',
    'zonk',
    'beef',
    'radio',
    'chair',
    'cubicle',
    'office',
    'join');

type

TTest = class
public
  	s,t : String;
	yipe : Integer;

	constructor Create;
end;

TExtra = class(TTest)
public
  d : Integer;
end;

TEmbed = class
  Int1, int2 : Integer;
  T : TTest;

  Constructor Create;
End;

Constructor TEmbed.Create;
Begin
  Int1 := Random(1000);
  Int2 := Random(1000);
  T := TTest.Create;
End;

procedure EmbedIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
	with obj as TEmbed do
		stream.TransferItems(
			[int1, int2, t],
			[@int1, @int2, @t],
			direction, version);
end;


procedure ExtraIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
	with obj as TExtra do
  	stream.TransferItems([d], [@d], direction, version);
end;

function RandomString : String;
begin
	result := bk[Random(10) + 1];
end;

constructor TTest.Create;
begin
  s := 'zonk';
  t := RandomString;
  yipe := Integer(self);
end;

procedure TestIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
  	with obj as TTest do stream.TransferItems([s, t, yipe], [@s, @t, @yipe], direction, version);
end;

procedure SimpleExample;
var test : TTest;
begin
	TObjStream.RegisterClass(TTest, TestIO, 1);
	Test := TTest.Create;
	TObjStream.WriteObjectToFile('simple.od', [], test);
	Test.free;
	Test := TObjStream.ReadObjectInFile('simple.od', []) as TTest;
// We're done!
	Test.free;
end;


Procedure ThreeObjects;
Var t1, t2 : TTest;
    E1 : TExtra;
    Ms : TMemoryStream;
    Os : TObjStream;
Begin
  TObjStream.RegisterClass(TTest, TestIO, 1);
  TObjStream.RegisterClass(TExtra, ExtraIO, 1);
  T1 := TTest.Create;
  T2 := TTest.Create;
  E1 := TExtra.Create;
  Ms := TMemoryStream.Create;
  Os := TObjStream.Create(ms, false, []);
  Os.WriteObject(t1);
  Os.WriteObject(e1);
  Os.WriteObject(t2);
  // FreeAll([t1, t2, e1]);
  Os.free;
  Ms.position := 0;
  Os := TObjStream.Create(ms, true, []);
  T1 := os.readObject as TTest;
  E1 := os.readObject as TExtra;
  T2 := os.readObject as TTest;
  Os.free;
End;


procedure EmbedExample;
var e : TEmbed;
begin
	TObjStream.RegisterClass(TTest, TestIO, 1);
   TObjStream.RegisterClass(TEmbed, EmbedIO, 1);
   E := TEmbed.Create;
   TObjStream.WriteObjectToFile('test.out', [], e);
   e.free;
   e := TObjStream.ReadObjectInfile('test.out', []) as TEmbed;
end;

Type
	TBase = class
     I1, i2 : Integer;
   End;

   TDerived = class(TBase)
     S : String;
   End;

   TAnother = class(TDerived)
    Toast : String;
   End;

procedure BaseIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
  with obj as TBase do
	stream.transferItems([i1, i2], [@i1, @i2], direction, version);
end;

procedure DerivedIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
	with obj as TDerived do
	  stream.transferItems([s], [@s], direction, version);
end;

procedure AnotherIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
	with obj as TAnother do
	  stream.transferItems([i1, toast], [@i1, @toast], direction, version);
   callSuper := false;
end;

procedure InheritanceExample;
var b : TBase;
    d : TDerived;
    a : TAnother;
begin
	TObjStream.RegisterClass(TBase, BaseIO, 1);
   TObjStream.RegisterClass(TDerived, DerivedIO, 1);
   TObjStream.RegisterClass(TAnother, AnotherIO, 1);

   b := TBase.Create;
   d := TDerived.Create;
   a := TAnother.Create;

   b.i1 := 100;
   b.i2 := 101;
   TObjStream.WriteObjectToFile('base.od', [], b);

   d.i1 := 200;
   d.i2 := 201;
   d.s := 'Hello';
   TObjStream.WriteObjectToFile('derived.od', [], d);

   a.i1 := 300;
   a.i2 := 301;
   a.s := 'yarf';
   a.toast := 'toast';
   TObjStream.WriteObjectToFile('another.od', [], a);

   // FreeAll([b,d,a]);

   b := TObjStream.ReadObjectInFile('base.od', []) as TBase;
   D := TObjStream.ReadObjectInFile('derived.od', []) as TDerived;
   A := TObjStream.ReadObjectInFile('another.od', []) as TAnother;

{   Writeln('base: ', b.i1, ' ', b.i2);
   Writeln('derived: ', d.i1, ' ', d.i2, ' ', d.s);
   Writeln('another: ', a.i1, ' ', a.i2, ' ', a.s, ' ', a.toast);
}

   // FreeAll([b,d,a]);
end;

Type

TSpecial = class
  Int1, int2 : Integer;
  St : String;
  When : TDateTime;
  R : Single;
End;

procedure SpecialIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
	with obj as TSpecial do
		stream.TransferItemsEx(
			[when, r, int1, int2, st],
			[@when, @r, @int1, @int2, @st],
			[ssvtDateTime, ssvtSingle],
			direction, version);
end;

procedure SpecialExample;
var s : TSpecial;
begin
	TObjStream.RegisterClass(TSpecial, SpecialIO, 1);
	s := TSpecial.Create;
	with s do
	  begin
	    s.int1 := Random(1000);
	    s.int2 := Random(1000);
		s.st := RandomString;
		s.when := Now;
    s.r := Random(1000) / 1000;
 end;
	TObjStream.WriteObjectToFile('test.out', [], s);
	S.free;
	S := TObjStream.ReadObjectInFile('test.out', []) as TSpecial;
   s.free;
end;


Type
TOne = class;
TTwo = class;
TOne = class
  FHello : String;
  Inside : TTwo;
End;
TTwo = class
  Inside : TOne;
  Ouch : String;
End;

procedure OneIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
	with obj as TOne do
	  stream.TransferItems([FHello, Inside], [@Fhello, @Inside], direction, version);
end;

procedure TwoIO(obj : TObject; stream : TObjStream; direction : TObjIODirection; version : Integer; var callSuper : Boolean);
begin
	with obj as TTwo do
	  stream.TransferItems([Ouch, Inside], [@Ouch, @Inside], direction, version);
end;

procedure GraphExample;
var o : TOne;
    t : TTwo;
begin
	TObjStream.RegisterClass(TOne, OneIO, 1);
   TObjStream.Registerclass(TTwo, TwoIO, 1);
   O := TOne.Create;
   T := TTwo.Create;
   o.FHello := 'hello';
   o.inside := t;
   t.ouch := 'ouch';
   t.inside := o;

   TObjStream.WriteObjectToFile('test.od', [osoGraph], o);
   //FreeAll([o,t]);

   O := TObjStream.ReadObjectInFile('test.od', [osoGraph]) as TOne;

   ShowMessage(o.inside.inside.Fhello);
end;


procedure TFormX.FormShow(Sender: TObject);
begin
	GraphExample;
  SpecialExample;
  InheritanceExample;
  SimpleExample;
  ThreeObjects;
  EmbedExample;
end;

end.
