unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ScreenRes, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    ScreenRes1: TScreenRes;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    RadioGroup1: TRadioGroup;
    procedure FormShow(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure ScreenRes1ChangeError(Sender: TObject);
    procedure ScreenRes1RestoreError(Sender: TObject);
    procedure ScreenRes1AfterChange(Sender: TObject);
    procedure ScreenRes1BeforeChange(Sender: TObject);
    procedure ScreenRes1RestartError(Sender: TObject);
    procedure ScreenRes1NoOptimalError(Sender: TObject);
    procedure ScreenRes1OptimalError(Sender: TObject);
  private
    { Private-Deklarationen}
  public
    { Public-Deklarationen}
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
begin
  ListBox1.Items:=ScreenRes1.ReadModi;
//  ComboBox1.Items:=ScreenRes1.ScreenResModus;
//  ComboBox1.Itemindex:=1;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  ScreenRes1.Change:=TScreenResChange(RadioGroup1.ItemIndex);
  ScreenRes1.Modus:=ListBox1.ItemIndex;
  if ScreenRes1.Result=DISP_CHANGE_SUCCESSFUL then
    ShowMessage('OK');
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  ScreenRes1.RestoreModus;
end;

procedure TForm1.ScreenRes1ChangeError(Sender: TObject);
begin
  case ScreenRes1.Result of
    DISP_CHANGE_BADFLAGS: ShowMessage(ScreenResErrors[3]);
    DISP_CHANGE_FAILED: ShowMessage(ScreenResErrors[4]);
    DISP_CHANGE_BADMODE: ShowMessage(ScreenResErrors[5]);
    DISP_CHANGE_NOTUPDATED: ShowMessage(ScreenResErrors[6]);
  end;
end;

procedure TForm1.ScreenRes1RestoreError(Sender: TObject);
begin
  case ScreenRes1.Result of
    DISP_CHANGE_RESTORE: ShowMessage(ScreenResErrors[1]);
    DISP_CHANGE_BADFLAGS: ShowMessage(ScreenResErrors[3]);
    DISP_CHANGE_FAILED: ShowMessage(ScreenResErrors[4]);
    DISP_CHANGE_BADMODE: ShowMessage(ScreenResErrors[5]);
    DISP_CHANGE_NOTUPDATED: ShowMessage(ScreenResErrors[6]);
  end;
end;

procedure TForm1.ScreenRes1AfterChange(Sender: TObject);
begin
  ShowMessage('Before this message the screen resolution had changed!');
end;

procedure TForm1.ScreenRes1BeforeChange(Sender: TObject);
begin
  ShowMessage('After this message the screen resolution will change!');
end;

procedure TForm1.ScreenRes1RestartError(Sender: TObject);
begin
  ShowMessage(ScreenResErrors[2]);
  if MessageDlg('You have to restrat Windows to change modues! Restart now?',
    mtConfirmation, [mbYes, mbNo], 0) = mrYes then
      ScreenRes1.ExitWindows;
end;

procedure TForm1.ScreenRes1NoOptimalError(Sender: TObject);
begin
  ShowMessage('No optimal modus for you resolution!');
end;

procedure TForm1.ScreenRes1OptimalError(Sender: TObject);
begin
  ShowMessage('Can not set the optimal modus');
end;

end.
