unit _main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ImgList, ActnList, ExtCtrls, ComCtrls, ToolWin,
  ExtDlgs, StdCtrls, Spin,
  SchemePaintObjects,
  SchemeVisual, Buttons, DrawComboBox, ExtEdit;

type


  TFormMain = class(TForm)
    StatusBar1: TStatusBar;
    ActionList1: TActionList;
    ImageList1: TImageList;
    ActionLoad: TAction;
    ActionSave: TAction;
    OpenPictureDialog1: TOpenPictureDialog;
    OpenDialog1: TOpenDialog;
    ActionObjectAdd: TAction;
    ActionObjectDelete: TAction;
    ActionObjectState: TAction;
    SaveDialog1: TSaveDialog;
    PopupMenu1: TPopupMenu;
    Add1: TMenuItem;
    ActionState1: TMenuItem;
    ActionDelete1: TMenuItem;
    N1: TMenuItem;
    ActionCenter: TAction;
    ActionZoomIn: TAction;
    ActionZoomOut: TAction;
    ZoomIn1: TMenuItem;
    ZoomOut1: TMenuItem;
    N2: TMenuItem;
    Center1: TMenuItem;
    ActionZoomActual: TAction;
    ActionZoomActual1: TMenuItem;
    ActionObjectAddZone: TAction;
    AddV1: TMenuItem;
    Splitter1: TSplitter;
    ActionObjectFind: TAction;
    SchemeVisual1: TSchemeVisual;
    SchemeVisual2: TSchemeVisual;
    SchemeData1: TSchemeData;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Panel1: TPanel;
    Label1: TLabel;
    SpinEditLayerId: TSpinEdit;
    Label2: TLabel;
    SpinEditObjectId: TSpinEdit;
    BitBtn1: TBitBtn;
    Panel4: TPanel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    Memo1: TMemo;
    Layers: TTabSheet;
    BitBtn2: TBitBtn;
    SpinEdit3: TSpinEdit;
    Label3: TLabel;
    Panel2: TPanel;
    Label4: TLabel;
    SpinEdit4: TSpinEdit;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Panel5: TPanel;
    Shape11: TShape;
    Label25: TLabel;
    LabelColorLayerId: TLabel;
    Shape12: TShape;
    Label27: TLabel;
    Shape13: TShape;
    Label28: TLabel;
    Shape14: TShape;
    Label29: TLabel;
    Shape15: TShape;
    Label30: TLabel;
    Shape16: TShape;
    Label31: TLabel;
    Shape17: TShape;
    Label32: TLabel;
    Shape18: TShape;
    Label33: TLabel;
    Shape19: TShape;
    Label34: TLabel;
    Shape20: TShape;
    Label35: TLabel;
    ColorDialog1: TColorDialog;
    Label5: TLabel;
    Label6: TLabel;
    Panel6: TPanel;
    Label38: TLabel;
    Label41: TLabel;
    FloatEdit9: TFloatEdit;
    Panel9: TPanel;
    Label48: TLabel;
    Label49: TLabel;
    Label50: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    CheckBox5: TCheckBox;
    IntEdit7: TIntEdit;
    IntEdit8: TIntEdit;
    LineStyleComboBox2: TLineStyleComboBox;
    ColorComboBoxEx2: TColorComboBoxEx;
    BitBtn3: TBitBtn;
    ActionObjectType: TAction;
    BitBtn4: TBitBtn;
    ActionPictuteA: TAction;
    ActionPictureB: TAction;
    LabelObjectsCount: TLabel;
    BitBtn5: TBitBtn;
    ActionLayerClear: TAction;
    TabSheet4: TTabSheet;
    Panel3: TPanel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label56: TLabel;
    FloatEdit4: TFloatEdit;
    FloatEdit5: TFloatEdit;
    ComboBox1: TComboBox;
    IntEdit1: TIntEdit;
    Label36: TLabel;
    FloatEdit6: TFloatEdit;
    CheckBox4: TCheckBox;
    Panel7: TPanel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    IntEdit2: TIntEdit;
    FillStyleComboBox1: TFillStyleComboBox;
    TabSheet5: TTabSheet;
    BitBtn6: TBitBtn;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    Label19: TLabel;
    IntEdit3: TIntEdit;
    TabSheet6: TTabSheet;
    Label20: TLabel;
    SpinEditLaerIdAdd: TSpinEdit;
    Label21: TLabel;
    ActionObjectVisible: TAction;
    BitBtn9: TBitBtn;
    CheckBox1: TCheckBox;
    SpeedButton1: TSpeedButton;
    IntEdit4: TIntEdit;
    IntEdit5: TIntEdit;
    Panel8: TPanel;
    Label22: TLabel;
    Label23: TLabel;
    FloatEdit1: TFloatEdit;
    Panel10: TPanel;
    Label24: TLabel;
    Label26: TLabel;
    Label37: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    CheckBox6: TCheckBox;
    IntEdit6: TIntEdit;
    IntEdit9: TIntEdit;
    LineStyleComboBox1: TLineStyleComboBox;
    ColorComboBoxEx1: TColorComboBoxEx;
    BitBtn10: TBitBtn;
    Changetype1: TMenuItem;
    BitBtn11: TBitBtn;
    procedure ActionLoadExecute(Sender: TObject);
    procedure ActionSaveExecute(Sender: TObject);
    procedure ActionObjectAddExecute(Sender: TObject);
    procedure SchemeVisual2MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SchemeVisual2MouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure SchemeVisual2MouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure ActionCenterExecute(Sender: TObject);
    procedure ActionZoomInExecute(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure ActionObjectFindExecute(Sender: TObject);
    procedure ActionObjectVisibleExecute(Sender: TObject);
    procedure ActionObjectStateExecute(Sender: TObject);
    procedure ActionObjectTypeExecute(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure CheckBox10Click(Sender: TObject);
    procedure SchemeVisual1HideHint(Sender: TObject);
    procedure SchemeData1MouseDown(Sender, VisualSender: TObject;
      Button: TMouseButton; Shift: TShiftState;
      AObject: TAbstractPaintObject);
    procedure SchemeVisual1ShowHint(Sender: TObject;
      AObject: TAbstractPaintObject; APoint: TPoint;
      var HintString: String; var CanVisible: Boolean);
    procedure CheckBox2Click(Sender: TObject);
    procedure SpinEdit4Change(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure ActionLayerClearExecute(Sender: TObject);
    procedure Shape11MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FloatEdit5Change(Sender: TObject);
    procedure FloatEdit9Change(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure IntEdit7Change(Sender: TObject);
    procedure ActionPictuteAExecute(Sender: TObject);
    procedure FloatEdit1Change(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure IntEdit6Change(Sender: TObject);
    procedure ActionPictureBExecute(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn11Click(Sender: TObject);
  private
    pCurrentPoint:TPoint;
    pSelectedObject:TAbstractPaintObject;   //  
    pSelectedSchemeVisual:TSchemeVisual;    //   
    procedure CreateLayer(AId:integer);
    procedure SetLayerParams(AId:integer);
    procedure SetCurrentPoint(X,Y:integer);
    procedure SetSelectedObject(Value:TObject);
    procedure SetSelectedSchemeVisual(Value:TObject);
    procedure UpdateObjectCountInfo;
    procedure UpdateStatusBarInfo;
    procedure UpdateLayerColorPaletteInfo;
    procedure TestEnabledActions;
    procedure LoadDemo;
    function  GetComponentForTag(Value:integer):TComponent;
  public
  end;

var
  FormMain: TFormMain;

implementation
{$R *.DFM}
uses
  _cv;

procedure TFormMain.FormCreate(Sender: TObject);
begin
  with Constraints do
  begin
    MinHeight:=Height;
    MinWidth:=Width;
  end;
  StatusBar1.Panels[1].Text := Format('Zoom L:%.1f  R:%.1f',
    [SchemeVisual1.Zoom,SchemeVisual2.Zoom]);
  LabelObjectsCount.Caption:='Objects: 0';
  ComboBox1.ItemIndex:=0;
  TestEnabledActions;
  WindowState:=wsMaximized;
  LoadDemo;
end;

procedure TFormMain.LoadDemo;
begin // Load demo example
  with SchemeData1 do
  try
    BeginUpdate;
    SetSelectedObject(nil);
    LoadFromFile(ExtractFilePath(Application.ExeName)+'DEMO_EXAMPLES.TXT');
    UpdateObjectCountInfo;
    //Disable Mouse for layer with zonen
    //Layer[1].Enabled:=false;
    //Layer[3].Enabled:=false;
    //Layer[5].Enabled:=false;
  finally
    EndUpdate;
    RepaintAllVisualControls;
  end;
  SpinEdit4Change(nil);
end;

//-------------------- Common -----------------------

procedure TFormMain.CreateLayer(AId:integer);
begin
  with SchemeData1 do
  begin
    try
      LayerDelete(AId);
    except
    end;
    LayerAdd(AId);
    SetLayerParams(AId);
  end;
end;

procedure TFormMain.SetLayerParams(AId:integer);
begin
  with SchemeData1 do
  try
    //BeginUpdate;     //if necessary
    Layer[AId].MinZoomForText:=3.4;
    Layer[AId].EnabledZoomForText:=false;
    LayerSetAllStateColors(AId,aclStateColors);
    UpdateLayerColorPaletteInfo;
  finally
    //EndUpdate;
    //RepaintAllVisualControls;
  end;
end;

procedure TFormMain.SetCurrentPoint(X,Y:integer);
begin
  pCurrentPoint.X:=X;
  pCurrentPoint.Y:=Y;
end;

procedure TFormMain.UpdateStatusBarInfo;
var s:string;
begin
  s:='';
  if pSelectedObject<>nil then
  with pSelectedObject do
  begin
    s:=Format('For selected object: Layer ID: %d   Object Id: %d    State:%d    Hint: %s',
      [Layer.Id,Id,State,HintString]);
    SpinEditObjectId.Value:=Id;
    SpinEditLayerId.Value:=Layer.Id;
  end;
  StatusBar1.Panels[2].Text:=s;
end;

procedure TFormMain.UpdateObjectCountInfo;
begin
  try
    LabelObjectsCount.Caption:='Objects: '+IntToStr(
      SchemeData1.Layer[SpinEdit4.Value].Count);
  except
    LabelObjectsCount.Caption:='Objects: 0';
  end;
end;

procedure TFormMain.UpdateLayerColorPaletteInfo;
var i:integer;
begin
  try
    LabelColorLayerId.Caption:=Format('Color palette for states (Layer ID: %d)',
      [SpinEdit4.Value]);
    for i:=0 to 9 do //Color Palette for Layer
    if GetComponentForTag(10+i) is TShape then
      TShape(GetComponentForTag(10+i)).Brush.Color:=
        SchemeData1.LayerStateColor[SpinEdit4.Value,i];
  except
  end;
end;

procedure TFormMain.SetSelectedObject(Value:TObject);
begin
  if pSelectedObject=Value then exit;
  if pSelectedObject<>nil then
    SchemeData1.ObjectSelectedDirect[pSelectedObject]:=false;//deselect old
  pSelectedObject:=TAbstractPaintObject(Value);
  if pSelectedObject<>nil then
    SchemeData1.ObjectSelectedDirect[pSelectedObject]:=true; //select new object
  UpdateStatusBarInfo;
  TestEnabledActions;
end;

procedure TFormMain.SetSelectedSchemeVisual(Value:TObject);
begin
  pSelectedSchemeVisual:=TSchemeVisual(Value);
end;

procedure TFormMain.TestEnabledActions;
var b:boolean;
begin
  b := pSelectedObject<>nil;
  ActionObjectDelete.Enabled   := b;
  ActionObjectState.Enabled    := b;
  ActionObjectVisible.Enabled  := b;
  ActionObjectType.Enabled     := b and
    (pSelectedObject is TPaintObjectShape);
end;

procedure TFormMain.PopupMenu1Popup(Sender: TObject);
var p:TPoint;
begin
  GetCursorPos(p);
  p:=pSelectedSchemeVisual.ScreenToClient(p);
  SetCurrentPoint(p.x,p.y);
end;

function TFormMain.GetComponentForTag(Value:integer):TComponent;
var i:integer;
begin
  result:=nil;
  for i:=0 to ComponentCount-1 do
  if Components[i].Tag=Value then
  begin
    result:=Components[i];
    exit;
  end;
end;

//--------------------------- Mouse -------------------------

procedure TFormMain.SchemeVisual2MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin  // MouseDown
  SetSelectedObject(nil);          //clear old selections
  SetSelectedSchemeVisual(Sender); //window Right or Left
  SetCurrentPoint(X,Y);
end;

procedure TFormMain.SchemeData1MouseDown(Sender, VisualSender: TObject;
  Button: TMouseButton; Shift: TShiftState; AObject: TAbstractPaintObject);
begin //SchemeData   Mouse Down  -> Object selected!
  SetSelectedObject(AObject);
end;


procedure TFormMain.SchemeVisual2MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var a,b:extended;
begin //Mouse Move
  SetCurrentPoint(0,0);
  a:=x; b:=y;
  TSchemeVisual(Sender).TransformZoomAndOriginXYExt(a,b);//get real
  StatusBar1.Panels[0].Text := Format('%.2f   %.2f',[a,b]);
end;

procedure TFormMain.SchemeVisual2MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
end;

//------------------ Actions --------------------------

procedure TFormMain.ActionLoadExecute(Sender: TObject);
begin //Load
  if not OpenDialog1.Execute then exit;
  SaveDialog1.InitialDir:=OpenDialog1.InitialDir;
  with SchemeData1 do
  try
    BeginUpdate;
    SetSelectedObject(nil);
    LayerClear;
    LoadFromFile(OpenDialog1.FileName);
    UpdateObjectCountInfo;
  finally
    EndUpdate;
    RepaintAllVisualControls;
  end;
end;

procedure TFormMain.ActionSaveExecute(Sender: TObject);
begin //Save
  if SaveDialog1.Execute then
  begin
    OpenDialog1.InitialDir:=SaveDialog1.InitialDir;
    SchemeData1.SaveToFile(SaveDialog1.FileName);
  end;
end;

procedure TFormMain.ActionObjectAddExecute(Sender: TObject);
var p:TSchemeVisual;
  pp:TPoint;
  x,y,h,w:extended;
  i,j,a,b,ix,iy:integer;
  ap:array[0..4] of TPoint;
begin // Add and Delete objects
  p:=pSelectedSchemeVisual;
  x:=pCurrentPoint.x;
  y:=pCurrentPoint.y;
  p.TransformZoomAndOriginXYExt(x,y);
  ix:=Trunc(x); iy:=Trunc(y);
  if (TAction(Sender)=ActionObjectAdd)or
   (TAction(Sender)=ActionObjectAddZone) then
  begin
    i:=SpinEditLaerIdAdd.Value; //default Layer for added objects or zone
    try
      SchemeData1.Layer[i];
    except
      CreateLayer(i);           //create layer if not exists
    end;
    j:=SchemeData1.Layer[i].GetObjectMaxId+1; //calculate ObjectId - not necessary
    if (TAction(Sender)=ActionObjectAdd) then
      SchemeData1.ObjectAddShapeExt(i,j,      //Add object
        x,y,ciObjectW,ciObjectH,ciObjectState,TShapeType(ciObjectType))
    else
    begin
      ap[0]:=Point(ix+(ciZoneW div 2),iy);
      ap[1]:=Point(ix+ciZoneW,iy+(ciZoneH div 2));
      ap[2]:=Point(ix+(ciZoneW div 2),iy+ciZoneH);
      ap[3]:=Point(ix,iy+(ciZoneH div 2));
      ap[4]:=Point(ix+(ciZoneW div 2),iy+(ciZoneH div 2));
      SchemeData1.ObjectAddZoneAmount(i,j,ap,ciZoneCount,
        ciZoneState,TBrushStyle(ciZoneType),IntToStr(j),Point(ix,iy));
    end;
    SchemeData1.Layer[i].Items[j].HintString:=
      Format('%s LayerID:%d ObjectID:%d',
        [SchemeData1.Layer[i].Items[j].ClassName,i,j]);
    SchemeData1.Layer[i].Sort; //Sort, not necessary
  end;
  if TAction(Sender)=ActionObjectDelete then
  begin  //Delete
    SchemeData1.ObjectDeleteDirect(pSelectedObject);
    pSelectedObject:=nil;
    SetSelectedObject(nil);
    StatusBar1.Panels[2].Text:='';
  end;
  TestEnabledActions;
  UpdateObjectCountInfo;
end;

procedure TFormMain.ActionCenterExecute(Sender: TObject);
var
  p:TSchemeVisual;
  x,y:integer;
begin //Set center in other window
  x:=pCurrentPoint.x;
  y:=pCurrentPoint.y;
  pSelectedSchemeVisual.TransformZoomAndOriginXY(x,y);
  if pSelectedSchemeVisual=SchemeVisual1 then p:=SchemeVisual2
  else p:=SchemeVisual1;
  p.SetCenterToPoint(Point(X,Y));
end;

procedure TFormMain.ActionZoomInExecute(Sender: TObject);
var
  delta:extended;
  x,y:integer;
  bmovetozenter:boolean;
begin// Zoom
  bmovetozenter:=(pCurrentPoint.x<>0)and(pCurrentPoint.y<>0);
  if bmovetozenter then
  begin //
    x:=pCurrentPoint.x;
    y:=pCurrentPoint.y;
    pSelectedSchemeVisual.TransformZoomAndOriginXY(x,y);
  end;
  if pSelectedSchemeVisual=SchemeVisual1 then
    delta:=crWindowZoomDeltaA else delta:=crWindowZoomDeltaB;
  if (TAction(Sender)=ActionZoomOut) then
    delta:=-delta;
  if (TAction(Sender)=ActionZoomActual) then
    delta:=0;
  if delta=0 then pSelectedSchemeVisual.Zoom:=1
  else pSelectedSchemeVisual.Zoom:=pSelectedSchemeVisual.Zoom+delta;
  if bmovetozenter then
  begin // //to center
    pSelectedSchemeVisual.SetCenterToPoint(Point(x,y));
  end;
  StatusBar1.Panels[1].Text := Format('Zoom L:%.1f  R:%.1f',
    [SchemeVisual1.Zoom,SchemeVisual2.Zoom]);
end;

//-------------------- Page: Objects --------------------

procedure TFormMain.ActionObjectFindExecute(Sender: TObject);
var i,j:integer;
begin  //Find;
  i:=SpinEditLayerId.Value;  //Layer Id
  j:=SpinEditObjectId.Value; //Object Id
  try
    SchemeVisual1.FindPaintObject(i,j); //Find in RWindow
    SchemeVisual2.FindPaintObject(i,j); //Find in LWindow
  except
    raise Exception.Create('Object not found!');
  end;
  SetSelectedObject(SchemeData1.Layer[i].Items[j]); //Select Object
end;

procedure TFormMain.ActionObjectVisibleExecute(Sender: TObject);
begin //Visible
  SchemeData1.ObjectVisibleDirect[pSelectedObject]:=not
    SchemeData1.ObjectVisibleDirect[pSelectedObject];
end;

procedure TFormMain.ActionObjectStateExecute(Sender: TObject);
var i:integer;
begin //State
  i:=pSelectedObject.State;
  inc(i); if i>9 then i:=0;
  SchemeData1.ObjectStateDirect[pSelectedObject]:=i;
  UpdateStatusBarInfo;
end;

procedure TFormMain.ActionObjectTypeExecute(Sender: TObject);
var i:integer; b:boolean;
begin //Type - only for TPaintObjectShape
  i:=integer(TPaintObjectShape(pSelectedObject).ShapeType);
  inc(i); if i>5 then i:=0;
  with TPaintObjectShape(pSelectedObject) do
  begin //the type changes the size!
    b:=Visible;
    Visible:=false;
    SchemeData1.ObjectRepaintDirect(pSelectedObject);
    ShapeType:=TShapeType(i);
    Visible:=b;
    SchemeData1.ObjectRepaintDirect(pSelectedObject);
  end;
end;

procedure TFormMain.SpinEdit3Change(Sender: TObject);
begin //Blink interval
  SchemeData1.TimerInterval:=SpinEdit3.Value;
end;

procedure TFormMain.CheckBox10Click(Sender: TObject);
var i:integer;
begin //AutoSize for Hint
  if CheckBox10.Checked then i:=0 else i:=100;
  SchemeVisual1.HintWidth:=i;
  SchemeVisual2.HintWidth:=i;
end;

procedure TFormMain.SchemeVisual1ShowHint(Sender: TObject;
  AObject: TAbstractPaintObject; APoint: TPoint; var HintString: String;
  var CanVisible: Boolean);
begin //Before show hint
  CanVisible:=CheckBox9.Checked;
  if not CanVisible then exit;
  if CheckBox1.Checked then HintString:=Memo1.Text;
  if Sender=SchemeVisual1 then Label15.Color:=clRed;
  if Sender=SchemeVisual2 then Label16.Color:=clRed;
end;

procedure TFormMain.SchemeVisual1HideHint(Sender: TObject);
begin //On Hide Hint
  if Sender=SchemeVisual1 then Label15.Color:=Color;
  if Sender=SchemeVisual2 then Label16.Color:=Color;
end;

//-------------------- Page: Layers --------------------
(*
function  TFormMain.GetSelectedLayer:TSchemeLayer;
begin  //Layer selected in SpinEdit4 (Layer Id:)
  try
    result:=SchemeData1.Layer[SpinEdit4.Value];
  except
    raise Exception.Create('Layer not found!');
  end;
end;
*)

procedure TFormMain.SpinEdit4Change(Sender: TObject);
begin //Layer selected in SpinEdit4 (Layer Id:)
  with SchemeData1.Layer[SpinEdit4.Value] do
  begin
    CheckBox2.Checked:=Visible;
    CheckBox3.Checked:=Enabled;
    CheckBox4.Checked:=EnabledZoomForText;
    FloatEdit6.Value :=MinZoomForText;
  end;
  UpdateObjectCountInfo;
  UpdateLayerColorPaletteInfo;
end;

procedure TFormMain.CheckBox2Click(Sender: TObject);
begin //Layer visible
  SchemeData1.Layer[SpinEdit4.Value].Visible:=CheckBox2.Checked;
  SchemeData1.RepaintAllVisualControls;
end;

procedure TFormMain.SpeedButton1Click(Sender: TObject);
begin //Min zoom for painting text in objects for this layer
  SchemeData1.Layer[SpinEdit4.Value].MinZoomForText:=FloatEdit6.Value;
  SchemeData1.RepaintAllVisualControls;
end;

procedure TFormMain.CheckBox3Click(Sender: TObject);
begin //Layer enabled for Mouse
  SchemeData1.Layer[SpinEdit4.Value].Enabled:=CheckBox3.Checked;
  SchemeData1.RepaintAllVisualControls;
end;

procedure TFormMain.CheckBox4Click(Sender: TObject);
begin //Zoom for text
  SchemeData1.Layer[SpinEdit4.Value].EnabledZoomForText:=CheckBox4.Checked;
  SchemeData1.RepaintAllVisualControls;
end;

procedure TFormMain.ActionLayerClearExecute(Sender: TObject);
begin //LayerClear -> delete all objects in layer;
  SchemeData1.Layer[SpinEdit4.Value].Clear;
  SchemeData1.RepaintAllVisualControls;
end;

procedure TFormMain.Shape11MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var i:integer;
begin //Color palette for Layer
  ColorDialog1.Color := TShape(Sender).Brush.Color;
  if not ColorDialog1.Execute then exit;
  TShape(Sender).Brush.Color := ColorDialog1.Color;
  with SchemeData1 do
  begin
    BeginUpdate;
    for i:=0 to 9 do
    if GetComponentForTag(10+i) is TShape then
      LayerStateColor[SpinEdit4.Value,i]:=TShape(GetComponentForTag(10+i)).Brush.Color;
    EndUpdate;
    RepaintAllVisualControls(true);
  end;
end;

//---------------- Page: Default params for adding -----------

procedure TFormMain.FloatEdit5Change(Sender: TObject);
begin // Set default params for adding
  ciObjectW     := FloatEdit4.Value;
  ciObjectH     := FloatEdit5.Value;
  ciObjectType  := ComboBox1.ItemIndex;
  ciObjectState := IntEdit1.Value;
  ciZoneW       := IntEdit4.Value;
  ciZoneH       := IntEdit5.Value;
  ciZoneType    := integer(FillStyleComboBox1.FillStyle);
  ciZoneState   := IntEdit2.Value;
  ciZoneCount   := IntEdit3.Value;
end;

//---------------- Page: Left window -----------

procedure TFormMain.FloatEdit9Change(Sender: TObject);
begin //Delta for zooming left window
  crWindowZoomDeltaA:=FloatEdit9.Value;
end;

procedure TFormMain.CheckBox5Click(Sender: TObject);
begin //Grid Visible
  SchemeVisual1.Grid.Enabled:=CheckBox5.Checked;
end;

procedure TFormMain.IntEdit7Change(Sender: TObject);
begin //Grid params
  with SchemeVisual1 do
  begin
    Grid.DeltaX:=IntEdit7.Value;
    Grid.DeltaY:=IntEdit8.Value;
    GridPen.Style:=LineStyleComboBox2.LineStyle;
    GridPen.Color:=ColorComboBoxEx2.ColorValue;
  end;
end;

procedure TFormMain.ActionPictuteAExecute(Sender: TObject);
begin //Picture
  with OpenPictureDialog1 do
  begin
    if not OpenPictureDialog1.Execute then exit;
    SchemeVisual1.Picture.LoadFromFile(FileName);
  end;
end;

//---------------- Page: Right window -----------

procedure TFormMain.FloatEdit1Change(Sender: TObject);
begin //Delta for zooming right window
  crWindowZoomDeltaB:=FloatEdit1.Value;
end;

procedure TFormMain.CheckBox6Click(Sender: TObject);
begin //Grid Visible
  SchemeVisual2.Grid.Enabled:=CheckBox6.Checked;
end;

procedure TFormMain.IntEdit6Change(Sender: TObject);
begin //Grid params
  with SchemeVisual2 do
  begin
    Grid.DeltaX:=IntEdit6.Value;
    Grid.DeltaY:=IntEdit9.Value;
    GridPen.Style:=LineStyleComboBox1.LineStyle;
    GridPen.Color:=ColorComboBoxEx1.ColorValue;
  end;
end;

procedure TFormMain.ActionPictureBExecute(Sender: TObject);
begin //Picture
  with OpenPictureDialog1 do
  begin
    if not OpenPictureDialog1.Execute then exit;
    SchemeVisual2.Picture.LoadFromFile(FileName);
  end;
end;

//---------------- Page: Speed test -----------

procedure TFormMain.BitBtn6Click(Sender: TObject);
var i,j,n,w,h:integer;
begin //Speed
  SetSelectedObject(nil);
  w:=8; h:=4;
  with SchemeData1 do
  try
    BeginUpdate;
    LayerClear;
    for i:=0 to 32 do
    begin
      CreateLayer(i);
      Layer[i].MinZoomForText:=10; //don't show text in objects
      for j:=0 to 32 do
      begin
        n:=random(6);
        ObjectAddShapeExt(i,j,    //Add object
          i*(w+2),j*(h+4),w,h,n,TShapeType(n));
      end;
      Layer[i].Sort;
    end;
  finally
    EndUpdate;
    RepaintAllVisualControls;
  end;
end;

procedure TFormMain.BitBtn11Click(Sender: TObject);
var s:string;
begin //About;
  SetSelectedObject(nil);
  SchemeData1.LayerClear;
  s:=ExtractFilePath(Application.ExeName)+'ABOUT.EMF';
  SchemeVisual1.Picture.LoadFromFile(s);
  SchemeVisual2.Picture.LoadFromFile(s);
end;

end.
