{
Copyright (c) 1998.  All rights reserved.
Orbital Decisions (Pty) Ltd
PO Box 1080, Milnerton, 7435, South Africa
sales@orbital.co.za
http://wwww.orbital.co.za/contents.htm

Demonstrates the functionality of the TODJobScheduler component
with a few simple rules:-
  The various ite types are restricted to various job types, e.g.
    'Item A1' is only allowed on a 'Job Type A'.
  Only on instance of an item type is allowed per job.
These rules are implemented in the schedule event handlers.
Some jobs and items are created on program startup by using the
schedule component API.
No attempt has been made here to manage start and end dates.
}

unit DemoUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ODSched, StdCtrls, Buttons;

type
  TDemoForm = class(TForm)
    ODJobSchedule1: TODJobSchedule;
    ODJobSchedule2: TODJobSchedule;
    ODJobSchedule3: TODJobSchedule;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label9: TLabel;
    Panel2: TPanel;
    AboutButton: TSpeedButton;
    ExitButton: TSpeedButton;
    procedure InitJobDialog(Schedule: TODJobSchedule;
      Job: TODJob; UpperCaptionList, LowerCaptionList: TStrings);
    procedure InitItemDialog(Schedule: TODJobSchedule;
      Job: TODJob; Item: TODJobItem; CaptionList: TStrings);
    procedure AfterJobAdd(Schedule: TODJobSchedule;
      Job: TODJob);
    procedure FormShow(Sender: TObject);
    procedure ItemDragOver(Schedule: TODJobSchedule;
      Job: TODJob; Item: TODJobItem; Index: Integer; var Accept: Boolean);
    procedure AboutButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure ScheduleResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DemoForm: TDemoForm;

implementation

uses AboutUnit;

{$R *.DFM}

procedure TDemoForm.FormShow(Sender: TObject);
begin
  ShortDateFormat := 'dd/mm/yy';
  // Initialize schedules with some jobs and items
  with ODJobSchedule1 do
  begin
    with AddJobFrom(0, 'Job Type A', '',
      StrToDateTime('1/6/98'), StrToDateTime('10/6/98')) do
    begin
      AddItemFrom(0, 'Item A1');
      AddItemFrom(0, 'Item A2');
    end;
    with AddJobFrom(0, 'Job Type B', '',
      StrToDateTime('10/6/98'), StrToDateTime('20/6/98')) do
    begin
      AddItemFrom(0, 'Item B1');
      AddItemFrom(0, 'Item B2');
    end;
  end;
  with ODJobSchedule2.AddJobFrom(0, 'Job Type A', '',
    StrToDateTime('15/6/98'), StrToDateTime('22/6/98')) do
  begin
    AddItemFrom(0, 'Item A1');
    AddItemFrom(0, 'Item A3');
  end;
end;

procedure TDemoForm.InitJobDialog(Schedule: TODJobSchedule;
  Job: TODJob; UpperCaptionList, LowerCaptionList: TStrings);
begin
  if Job = nil then  //if adding a new job then list all available types
  begin
    UpperCaptionList.Add('Job Type A');
    UpperCaptionList.Add('Job Type B');
    UpperCaptionList.Add('Job Type C');
    UpperCaptionList.Add('Job Type D');
  end
  else  //else editing an existing job so prevent from changing the type
    UpperCaptionList.Add(Job.UpperCaption);  
end;

procedure TDemoForm.InitItemDialog(Schedule: TODJobSchedule;
  Job: TODJob; Item: TODJobItem; CaptionList: TStrings);
begin
  if Job.UpperCaption = 'Job Type A' then
  begin
    if Job.ItemByCaption('Item A1') = nil then
      CaptionList.Add('Item A1');
    if Job.ItemByCaption('Item A2') = nil then
      CaptionList.Add('Item A2');
    if Job.ItemByCaption('Item A3') = nil then
      CaptionList.Add('Item A3');
  end
  else if Job.UpperCaption = 'Job Type B' then
  begin
    if Job.ItemByCaption('Item B1') = nil then
      CaptionList.Add('Item B1');
    if Job.ItemByCaption('Item B2') = nil then
      CaptionList.Add('Item B2');
    if Job.ItemByCaption('Item B3') = nil then
      CaptionList.Add('Item B3');
  end
  else if Job.UpperCaption = 'Job Type C' then
  begin
    if Job.ItemByCaption('Item C1') = nil then
      CaptionList.Add('Item C1');
    if Job.ItemByCaption('Item C2') = nil then
      CaptionList.Add('Item C2');
    if Job.ItemByCaption('Item C3') = nil then
      CaptionList.Add('Item C3');
  end
  else if Job.UpperCaption = 'Job Type D' then
  begin
    if Job.ItemByCaption('Item D1') = nil then
      CaptionList.Add('Item D1');
    if Job.ItemByCaption('Item D2') = nil then
      CaptionList.Add('Item D2');
    if Job.ItemByCaption('Item D3') = nil then
      CaptionList.Add('Item D3');
  end;
end;

procedure TDemoForm.AfterJobAdd(Schedule: TODJobSchedule;
  Job: TODJob);
begin
  if Job.UpperCaption = 'Job Type A' then
    Job.Color := clBlue
  else if Job.UpperCaption = 'Job Type B' then
    Job.Color := clGreen
  else if Job.UpperCaption = 'Job Type C' then
    Job.Color := clMaroon
  else if Job.UpperCaption = 'Job Type D' then
    Job.Color := clPurple;
end;

procedure TDemoForm.ItemDragOver(Schedule: TODJobSchedule;
  Job: TODJob; Item: TODJobItem; Index: Integer; var Accept: Boolean);
begin
  Accept := (Job = Item.Job) or     //can rearrange on same job
    ((Job.Color = Item.Job.Color) and         //only accept items form the job type
     (Job.ItemByCaption(Item.Caption) = nil));   //and if not already has item type
end;

procedure TDemoForm.AboutButtonClick(Sender: TObject);
begin
  ODAboutForm.ShowModal;
end;

procedure TDemoForm.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TDemoForm.ScheduleResize(Sender: TObject);
begin
  ODJobSchedule2.Left := ODJobSchedule1.Left + ODJobSchedule1.Width;
  ODJobSchedule3.Left := ODJobSchedule2.Left + ODJobSchedule2.Width;
  Panel1.Left := ODJobSchedule3.Left + ODJobSchedule3.Width;
end;

end.
