{*************************************************************************}
{****** UnitTestEditor: A unit by JACK email TRTFInfo@NetCreativ.com *****}
{*************************************************************************}
{This unit is designed to show how to use Editor.pas                      }
{Improvements:
06/06/98 release to DSP of the Delphi 3 version
15/06/98 from Carlos Fernandes: Stop editing before closing formToEdit and
correction of other bug due to creation deletion of objects
}


unit UnitTestEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Editor, Buttons, ComCtrls,DsgnIntf;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    StartButton: TSpeedButton;
    EndButton: TSpeedButton;
    PanelObject: TGroupBox;
    CreateButton: TButton;
    SpeedTButton: TSpeedButton;
    SpeedTEdit: TSpeedButton;
    SpeedTGroupBox: TSpeedButton;
    SpeedTRadioButton: TSpeedButton;
    SpeedTScrollBar: TSpeedButton;
    PanelForm: TGroupBox;
    SaveButton: TButton;
    LoadButton: TButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    NewButton: TButton;
    GroupBox4: TGroupBox;
    TreeProperty: TTreeView;
    Panel1: TPanel;
    Button1: TButton;
    LabelProp: TLabel;
    Combo: TComboBox;
    Edit1: TEdit;
    Label1: TLabel;
    GroupBox2: TGroupBox;
    LabelEditor: TLabel;
    procedure StartButtonClick(Sender: TObject);
    procedure EndButtonClick(Sender: TObject);
    procedure CreateButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure NewButtonClick(Sender: TObject);
    procedure TreePropertyClick(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    ControlSizer:TControlSizer;
    EditorSelected: TPropertyEditor;
    procedure ChangeSelection(Sender: TObject);
//*** It was changed (const included)
    procedure FillCombo(Const S:string);
  end;

var
  Form1: TForm1;

implementation

uses UnitFormToEdit;

{$R *.DFM}

procedure TForm1.StartButtonClick(Sender: TObject);
var i:integer;
begin
   if not(Assigned(ControlSizer)) then
   begin
   EditorSelected:=Nil;
   TreeProperty.Items.Clear;
   PanelObject.Enabled:=False;
   PanelForm.Enabled:=False;
   ControlSizer:=TControlSizer.Create(FormToEdit);
   for i:=0 to FormTOedit.ComponentCount-1 do
           if (FormTOedit.Components[i] is TControl) then ControlSizer.Add(TControl(FormTOedit.Components[i]));
   ControlSizer.Onchange:=ChangeSelection;
   end;
end;

procedure TForm1.EndButtonClick(Sender: TObject);
begin
if Assigned(ControlSizer) then
   begin
   EditorSelected:=Nil;
   TreeProperty.Items.Clear;
   PanelObject.Enabled:=True;
   PanelForm.enabled:=True;
   Button1.Visible:=False;
   Edit1.Text:='';
   Combo.clear;
   ControlSizer.Free;
   ControlSizer:=Nil;
   end;
end;


procedure TForm1.CreateButtonClick(Sender: TObject);
var C:TControl;
begin
     C:=Nil;
     if  SpeedTButton.down then C:=TButton.Create(FormToEdit);
     if  SpeedTEdit.down then C:=TEdit.Create(FormToEdit);
     if  SpeedTGroupBox.down then C:=TGroupBox.Create(FormToEdit);
     if  SpeedTRadioButton.down then C:=TRadioButton.Create(FormToEdit);
     if  SpeedTScrollBar.down then C:=TScrollBar.Create(FormToEdit);
     if  Assigned(C) then
         begin
         C.Width:=100;
         C.Height:=20;
         C.Parent:=FormToEdit;
         end;
end;

procedure TForm1.SaveButtonClick(Sender: TObject);
begin
     if SaveDialog1.Execute then WriteForm(SaveDialog1.FileName,FormToEdit);
end;

procedure TForm1.LoadButtonClick(Sender: TObject);
begin
 if OpenDialog1.Execute then ReadForm(OpenDialog1.FileName,FormToEdit);
end;

procedure TForm1.NewButtonClick(Sender: TObject);
var i:Integer;
begin
    for i:=FormTOedit.ComponentCount-1 downto 0
           do FormTOedit.Components[i].Free;
end;

procedure TForm1.ChangeSelection(Sender: TObject);
var i,j:integer;
    S,SParent, S1,S1Parent:String;
begin
    // Fill the tree with the name and the value
    TreeProperty.Items.Clear;
    if Assigned(ControlSizer) then with ControlSizer do for i:=0 To PropEdList.Count-1
         do begin
            if TPropEd(PropEdList[i]).ParentEditor <> Nil then
               begin
               for j:=0 to TreeProperty.Items.Count-1 do
                   begin
                   if TreeProperty.Items[j].Text=TPropEd(PropEdList[i]).ParentEditor.GetNAme Then
                   TreeProperty.Items.AddChild(TreeProperty.Items[j],TPropEd(PropEdList[i]).Editor.GetName);
                   end;
               end
               else   TreeProperty.Items.AddChild(TreeProperty.Selected,TpropEd(PropEdList[i]).Editor.GetName);

            end;

end;

//*** It was changed (const included)
procedure TForm1.FillCombo(Const S:string);
begin
   Combo.Items.Add(S);
end;


procedure TForm1.TreePropertyClick(Sender: TObject);
var i:integer;
    PropEd:TPropertyEditor ;
begin
   // Fill the edit and the combo to change the property
    if Assigned(ControlSizer) then  with ControlSizer do for i:=0 To PropEdList.Count-1
            do
            if TreeProperty.Selected.Text=TPropEd(PropEdList[i]).Editor.GetName Then
            begin
            // Selected Property is found
            PropEd:=TPropEd(PropEdList[i]).Editor;
            LabelProp.Caption:=PropEd.GetName;
            LabelEditor.Caption:=PropEd.ClassName;
            if paValueList in Proped.GetAttributes then
               Begin
                    Combo.Clear;
                    Proped.GetValues(FillCombo);
                    Combo.Text:=PropEd.GetValue;
                    Combo.Visible:=True;
                    Combo.BringToFront;
                    Form1.Combo.SetFocus;
               end
               else
               begin
                    Combo.Visible:=False;
                    Edit1.Text:=PropEd.GetValue;
               end;
             if paDialog in Proped.GetAttributes then Button1.Visible:=True
                                                 else Button1.Visible:=False;

             EditorSelected:=PropEd;
            end;
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
     if ((Ord(Key)=vk_return) and (Assigned(EditorSelected))) then
        begin
             if Sender is TEdit then EditorSelected.SetValue(Edit1.Text);
             if sender is TComboBox then EditorSelected.SetValue(Combo.text);
        end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
     if Assigned(EditorSelected) then EditorSelected.Edit;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if StartButton.down then  EndButtonClick(Self);
end;

end.
