unit ImagePropEditor;

interface

uses SysUtils, Classes, Graphics, Controls, Forms, TypInfo, ImageDialog,
ExtCtrls,DsgnIntf;

type
{*************************************************************************}
{ A sample of properties editor                                           }
{*************************************************************************}

TPictureProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

implementation


procedure TPictureProperty.Edit;
var
  ImageDialog: TFormImageDialog;
  Picture:TPicture;
begin
  ImageDialog := TFormImageDialog.Create(Application);
  try
    Picture:=TPicture(GetOrdValue);
    ImageDialog.Image.Picture := Picture;
    ImageDialog.ShowModal;
  finally
    SetOrdValue(LongInt(ImageDialog.Image.Picture));
    ImageDialog.Free;
  end;
end;

function TPictureProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paSubProperties, paDialog];
end;

end.
