unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Ruler;

type
  TForm1 = class(TForm)
    TopTabRuler: TTabRuler;
    LeftTabRuler: TTabRuler;
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure Edit2Exit(Sender: TObject);
    procedure TopTabRulerEditTabChange(Sender: TObject);
  private
    { Private-Deklarationen }
    HorzEditTabList : TTabList;
    VertEditTabList : TTabList;
    HorzTabList : TTabList;
    VertTabList : TTabList;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  HorzTabList.Visible := True;
  TopTabRuler.EditTabList := @HorzEditTabList;
  TopTabRuler.TabList := @HorzTabList;
  TopTabRuler.DefaultTabPos := 250;
  TopTabRuler.TabPrecision := 25;
  VertTabList.Visible := True;
  LeftTabRuler.EditTabList := @VertEditTabList;
  LeftTabRuler.TabList := @VertTabList;
  LeftTabRuler.DefaultTabPos := 250;
  LeftTabRuler.TabPrecision := 25;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  TopTabRuler.TabKind := tkLeftJustify;
  LeftTabRuler.TabKind := tkLeftJustify;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  TopTabRuler.TabKind := tkCenter;
  LeftTabRuler.TabKind := tkCenter;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  TopTabRuler.TabKind := tkRightJustify;
  LeftTabRuler.TabKind := tkRightJustify;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  TopTabRuler.TabKind := tkDecimal;
  LeftTabRuler.TabKind := tkDecimal;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
  TopTabRuler.TabKind := tkLine;
  LeftTabRuler.TabKind := tkLine;
end;

procedure TForm1.Edit1Exit(Sender: TObject);
var
  DefaultTabPos : Integer;
begin
  DefaultTabPos := Round(StrToFloat(Edit1.Text) * 100);
  Edit1.Text := FloatToStrF(DefaultTabPos / 100, ffFixed, 18, 2);
  TopTabRuler.DefaultTabPos := DefaultTabPos;
  LeftTabRuler.DefaultTabPos := DefaultTabPos;
end;

procedure TForm1.Edit2Exit(Sender: TObject);
var
  TabPrecision : Integer;
begin
  TabPrecision := Round(StrToFloat(Edit2.Text) * 100);
  Edit2.Text := FloatToStrF(TabPrecision / 100, ffFixed, 18, 2);
  TopTabRuler.TabPrecision := TabPrecision;
  LeftTabRuler.TabPrecision := TabPrecision;
end;

procedure TForm1.TopTabRulerEditTabChange(Sender: TObject);
begin
  with TTabRuler(Sender).EditTabList^ do
    if not Visible then
      Edit3.Text := ''
    else if Count > 0 then
      Edit3.Text := FloatToStrF(Tabs^[0].Pos / 100, ffFixed, 18, 2);
end;

end.
