unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Ruler;

type
  TForm1 = class(TForm)
    charRuler: TRuler;
    lineRuler: TRuler;
    cmRuler: TRuler;
    inRuler: TRuler;
    twipsRuler: TRuler;
    Ruler1: TRuler;
    Ruler2: TRuler;
    Ruler3: TRuler;
    Memo1: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Memo1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Memo1Change(Sender: TObject);
    procedure Memo1Click(Sender: TObject);
    procedure Memo1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Memo1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private-Deklarationen }
    ControlCanvas : TControlCanvas;
    procedure UpdateCursorPos(AMemo : TMemo);
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type
  TWYSIWIGControl = class(TGraphicControl)
  protected
    procedure Paint; override;
  end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ControlCanvas := TControlCanvas.Create;
  ControlCanvas.Control := Memo1;
  ControlCanvas.Font := Memo1.Font;
  with charRuler do
  begin
    { Set base unit to the width of 1 character }
    PixelExtent := ControlCanvas.TextWidth('0');
    BaseExtent := 1;
    { Set ruler scale unit equal to the base unit }
    ScalePixelExtent := PixelExtent;
    ScaleExtent := BaseExtent;
    { Use 1 ruler scale unit (= 1 character) as unit of measure }
    ScaleUnit := 1;
    { Draw every ruler scale unit (= 1 character) a small mark }
    ScaleDivision := 1;
    { Draw every 10 ruler scale units (= 10 characters) a numbered large mark }
    ScaleInterval := 10;
    { The following is only design stuff if you want to
      match the left edge of the ruler and the memo }
    { Adjust the pixel origin to match Delphi's text drawing routines }
    PixelOrigin := 3;
    { Avoid showing the left spare area ... }
    BaseOrigin := 1;
    { ... and correct the ruler scale origin by the above value }
    ScaleOrigin := 1;
    Options := [roShowMousePos, roShowCursorPos, roShowTabMarks, roTabEditing];
  end;
  with lineRuler do
  begin
    PixelExtent := ControlCanvas.TextHeight('0');
    BaseExtent := 1;
    ScalePixelExtent := PixelExtent;
    ScaleExtent := BaseExtent;
    ScaleUnit := 1;
    ScaleDivision := 1;
    ScaleInterval := 2;
    PixelOrigin := 3;
    BaseOrigin := 1;
    ScaleOrigin := 1;
    Options := [roShowMousePos, roShowCursorPos, roShowTabMarks, roTabEditing];
  end;
  with cmRuler do
  begin
    {BaseExtent := beLoMetric;
    ScaleExtent := BaseExtent;}
  end;
  with inRuler do
  begin
    BaseExtent := beLoEnglish;
    ScaleExtent := BaseExtent;
    ScaleDivision := 10;
  end;
  with twipsRuler do
  begin
    BaseExtent := beTWIPS;
    ScaleExtent := BaseExtent;
    ScaleUnit := 10;
    ScaleDivision := 250;
    ScaleInterval := 1000;
  end;
  with TWYSIWIGControl.Create(Self) do
  begin
    Parent := Self;
    SetBounds(360, 8, 60, 40);
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  ControlCanvas.Free;
end;

procedure TForm1.Memo1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  charRuler.MousePos := X;
  lineRuler.MousePos := Y;
end;

procedure TForm1.UpdateCursorPos(AMemo : TMemo);
var
  X, Y, DY : Integer;
begin
  { This routine is only an example for TRuler - it's not always correct! }
  Y := AMemo.Perform(EM_LINEFROMCHAR, AMemo.SelStart, 0);
  X := AMemo.SelStart - AMemo.Perform(EM_LINEINDEX, Y, 0);
  charRuler.CursorPos := ControlCanvas.TextWidth(Copy(AMemo.Lines[Y], 1, X));
  DY := AMemo.Perform(EM_GETFIRSTVISIBLELINE, 0, 0);
  lineRuler.ScaleOrigin := lineRuler.BaseOrigin - DY;
  lineRuler.CursorPos := (Y - DY + 1) * ControlCanvas.TextHeight('0');
end;

procedure TForm1.Memo1Change(Sender: TObject);
begin
  UpdateCursorPos(Sender as TMemo);
end;

procedure TForm1.Memo1Click(Sender: TObject);
begin
  UpdateCursorPos(Sender as TMemo);
end;

procedure TForm1.Memo1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  { To follow auto-repeating cursor keys (1 movement behind) }
  UpdateCursorPos(Sender as TMemo);
end;

procedure TForm1.Memo1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  UpdateCursorPos(Sender as TMemo);
end;

{ Test of Windows GDI mapping precision }
procedure TWYSIWIGControl.Paint;
begin
  with Canvas do
  begin
    Brush.Color := clWhite;
    FillRect(Rect(0, 0, Width, Height));
    SetMapMode(Handle, mm_Anisotropic);

    { Pixel intervals (Windows 3.11 & 95): [-2..-1][0..0][1..2] }
    SetWindowExtEx(Handle, 2, 2, nil);
    SetViewportExtEx(Handle, 1, 1, nil);
    SetWindowOrgEx(Handle, 0, 0, nil);
    SetViewportOrgEx(Handle, Left + 20, Top + 20, nil);
    Pen.Color := clRed;
    WinProcs.MoveToEx(Handle, 0, -40, nil);
    WinProcs.LineTo(Handle, 0, 40);
    Pen.Color := clGreen;
    WinProcs.MoveToEx(Handle, 1, 0, nil);
    WinProcs.LineTo(Handle, 1, 30);
    Pen.Color := clRed;
    WinProcs.MoveToEx(Handle, 2, 0, nil);
    WinProcs.LineTo(Handle, 2, 20);
    Pen.Color := clGreen;
    WinProcs.MoveToEx(Handle, 3, 0, nil);
    WinProcs.LineTo(Handle, 3, 10);
    Pen.Color := clGreen;
    WinProcs.MoveToEx(Handle, -1, 0, nil);
    WinProcs.LineTo(Handle, -1, -30);
    Pen.Color := clRed;
    WinProcs.MoveToEx(Handle, -2, 0, nil);
    WinProcs.LineTo(Handle, -2, -20);
    Pen.Color := clGreen;
    WinProcs.MoveToEx(Handle, -3, 0, nil);
    WinProcs.LineTo(Handle, -3, -10);

    { Pixel intervals (Windows 3.11 & 95): [-4..-2][-1..1][2..4] }
    SetWindowExtEx(Handle, 3, 3, nil);
    SetViewportExtEx(Handle, 1, 1, nil);
    SetWindowOrgEx(Handle, 0, 0, nil);
    SetViewportOrgEx(Handle, Left + 40, Top + 20, nil);
    Pen.Color := clRed;
    WinProcs.MoveToEx(Handle, 0, -60, nil);
    WinProcs.LineTo(Handle, 0, 60);
    Pen.Color := clGreen;
    WinProcs.MoveToEx(Handle, 1, 0, nil);
    WinProcs.LineTo(Handle, 1, 50);
    Pen.Color := clRed;
    WinProcs.MoveToEx(Handle, 2, 0, nil);
    WinProcs.LineTo(Handle, 2, 40);
    Pen.Color := clGreen;
    WinProcs.MoveToEx(Handle, 3, 0, nil);
    WinProcs.LineTo(Handle, 3, 30);
    Pen.Color := clRed;
    WinProcs.MoveToEx(Handle, 4, 0, nil);
    WinProcs.LineTo(Handle, 4, 20);
    Pen.Color := clGreen;
    WinProcs.MoveToEx(Handle, 5, 0, nil);
    WinProcs.LineTo(Handle, 5, 10);
    Pen.Color := clGreen;
    WinProcs.MoveToEx(Handle, -1, 0, nil);
    WinProcs.LineTo(Handle, -1, -50);
    Pen.Color := clRed;
    WinProcs.MoveToEx(Handle, -2, 0, nil);
    WinProcs.LineTo(Handle, -2, -40);
    Pen.Color := clGreen;
    WinProcs.MoveToEx(Handle, -3, 0, nil);
    WinProcs.LineTo(Handle, -3, -30);
    Pen.Color := clRed;
    WinProcs.MoveToEx(Handle, -4, 0, nil);
    WinProcs.LineTo(Handle, -4, -20);
    Pen.Color := clGreen;
    WinProcs.MoveToEx(Handle, -5, 0, nil);
    WinProcs.LineTo(Handle, -5, -10);
  end;
end;

end.
