unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, RapidEvaluator, ComCtrls, Spin;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    Eval: TRapidEvaluator;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Panel1: TPanel;
    Image1: TImage;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure DrawImage;
    procedure DrawFunc;
  end;

var
  Form1: TForm1;

implementation

uses
  math;

const
  X1 : Double = -10;
  X2 : Double =  10;
  Y1 : Double = -1;
  Y2 : Double =  1;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  Image1.Picture.Bitmap := TBitmap.Create;
  with Image1.Picture.Bitmap do begin
    Width := Image1.Width;
    Height := Image1.Height;
  end;
  DrawImage;
end;

procedure TForm1.DrawImage;
var
  x,y : Integer;
begin
  x := Image1.Width div 2;
  y := Image1.Height div 2;
  with Image1.Picture.Bitmap.Canvas do begin
    Brush.Color := clWhite;
    Pen.Color := clBlack;
    FillRect(Rect(0,0, Image1.Width, Image1.Height));
    MoveTo(x, 0);
    LineTo(x, Image1.Height);
    MoveTo(0, y);
    LineTo(Image1.Width, y);
  end;
end;

procedure TForm1.DrawFunc;
var
  scale : Double;
  x, y : Double;
  ix, iy : Integer;
  first : boolean;
begin
  Eval.Formula := Edit1.Text;
  // 
  try
    Eval.Compile;
  except
    on E: Exception do begin
      MessageDlg(Format('%s ("%s")', [E.Message, Eval.Token]), mtError, [mbOk], 0);
      Edit1.SetFocus;
      Edit1.SelStart := Eval.Pos - Length(Eval.Token) - 1;
      Edit1.SelLength := Length(Eval.Token);
      exit;
    end;
  end;

  if Abs(Y1-Y2) > Abs(X1-X2) then
    scale := Image1.Height/Abs(Y1-Y2)
  else
    scale := Image1.Width/Abs(X1-X2);

  Image1.Picture.Bitmap.Canvas.Pen.Color := clBlue;
  first := True;
  x := X1;
  while x < X2 do begin
    try
      y := Eval.Evaluate(x);
      ix := Image1.Width div 2 + round(x*scale);
      iy := Image1.Height div 2 - round(y*scale);
      if first then begin
        Image1.Picture.Bitmap.Canvas.MoveTo(ix, iy);
        first := False;
      end
      else
        Image1.Picture.Bitmap.Canvas.LineTo(ix, iy);
    except
    end;

    x := x + 1/scale;
  end;
  Image1.Refresh;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  DrawImage;
  DrawFunc;
end;

end.
