// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'RapidEvaluator.pas' rev: 4.00

#ifndef RapidEvaluatorHPP
#define RapidEvaluatorHPP

#pragma delphiheader begin
#pragma option push -w-
#include <Dialogs.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Rapidevaluator
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS ESyntaxError;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION ESyntaxError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall ESyntaxError(const AnsiString Msg) : Sysutils::Exception(Msg
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall ESyntaxError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall ESyntaxError(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall ESyntaxError(int Ident, const System::TVarRec * Args
		, const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall ESyntaxError(const AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall ESyntaxError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall ESyntaxError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall ESyntaxError(int Ident, const System::TVarRec * 
		Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~ESyntaxError(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

typedef Byte TByte[65535];

#pragma pack(push, 1)
struct TCommand
{
	System::SmallString<20>  command;
	Byte tok;
} ;
#pragma pack(pop)

typedef TCommand Commands[13];

#pragma option push -b-
enum TError { eNo, eMath, eSyntax };
#pragma option pop

#pragma option push -b-
enum TStackItemType { siConst, siVariable, siOperation, siFunction, siExternalFunction };
#pragma option pop

#pragma option push -b-
enum TOpType { otNone, otAdd, otSub, otMul, otDiv, otMod, otPow };
#pragma option pop

class DELPHICLASS TStackItem;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TStackItem : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TStackItemType Kind;
	double ConstValue;
	int Idx;
	TOpType Operation;
	__fastcall TStackItem(TStackItemType AKind, double aValue, TOpType AOpType, int AIdx);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TStackItem(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TCommandList;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TCommandList : public Classes::TList 
{
	typedef Classes::TList inherited;
	
public:
	int Tag;
	void __fastcall FreeAll(void);
	__fastcall virtual ~TCommandList(void);
	void __fastcall WriteToFile(AnsiString FName);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TCommandList(void) : Classes::TList() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TCode;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TCode : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int SegCodeSize;
	int FPos;
	
public:
	void *seg_code;
	__fastcall TCode(void);
	__fastcall virtual ~TCode(void);
	int __fastcall CodePos( System::ShortString &Subcode);
	void __fastcall AddCodeByte(Byte B);
	void __fastcall AddCodeWord(Word W);
	void __fastcall AddCodeDWord(int I);
	void __fastcall AddCodeDouble(double D);
	double __fastcall Evaluate(void);
	void __fastcall Optimize(void);
};

#pragma pack(pop)

class DELPHICLASS TLookupItem;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TLookupItem : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	AnsiString Name;
	__fastcall TLookupItem(AnsiString AName);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TLookupItem(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TExtPointer;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TExtPointer : public TLookupItem 
{
	typedef TLookupItem inherited;
	
public:
	void *Addr;
	__fastcall TExtPointer(AnsiString AName, void * AAddr);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TExtPointer(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TLookupTable;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TLookupTable : public Classes::TList 
{
	typedef Classes::TList inherited;
	
public:
	TLookupItem* __fastcall Lookup(AnsiString S);
	void __fastcall FreeItems(void);
	__fastcall virtual ~TLookupTable(void);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TLookupTable(void) : Classes::TList() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TRapidEvaluator;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRapidEvaluator : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Byte token_type;
	int tok;
	AnsiString prog;
	TError error_type;
	TCode* Code;
	void *address;
	TCommandList* CommandList;
	TLookupTable* FuncList;
	TLookupTable* VarList;
	bool FCompiled;
	bool FAutoCompile;
	void __fastcall Level1(void);
	void __fastcall Level2(void);
	void __fastcall Level3(void);
	void __fastcall Level4(void);
	void __fastcall Level5(void);
	void __fastcall Level6(void);
	void __fastcall Primitive(void);
	void __fastcall Unary(char o);
	void __fastcall Arith(char o);
	void __fastcall PutBack(void);
	int __fastcall LookUp(AnsiString S);
	void __fastcall LevelFunction(void);
	void __fastcall GetToken(void);
	void __fastcall GetNumber(void);
	AnsiString __fastcall SError(Byte Error);
	bool __fastcall CheckParenthesis(bool Which);
	bool __fastcall IsDelim(char C);
	bool __fastcall IsWhite(char C);
	bool __fastcall IsDigit(char C);
	bool __fastcall IsAlpha(char C);
	void __fastcall FSetFormula(AnsiString Value);
	void __fastcall Translate(void);
	void __fastcall Build(void);
	
public:
	AnsiString Token;
	Byte Pos;
	bool Error_founded;
	AnsiString Err_Str;
	__fastcall virtual TRapidEvaluator(Classes::TComponent* AOwner);
	__fastcall virtual ~TRapidEvaluator(void);
	void __fastcall Compile(void);
	void __fastcall AddFunc(AnsiString Name, void * Addr);
	void __fastcall AddVariable(AnsiString Name, void * Addr);
	double __fastcall Evaluate(void);
	double __fastcall Evaluate1D(double ax);
	double __fastcall Evaluate2D(double ax, double ay);
	double __fastcall Evaluate3D(double ax, double ay, double az);
	__property bool Compiled = {read=FCompiled, nodefault};
	
__published:
	__property AnsiString Formula = {read=prog, write=FSetFormula};
	__property bool AutoCompile = {read=FAutoCompile, write=FAutoCompile, nodefault};
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
static const Shortint COMMANDS_QUANTITY = 0xd;
static const Shortint _DELIMITER = 0x1;
static const Shortint _NUMBER = 0x2;
static const Shortint _COMMAND = 0x3;
static const Shortint _EOL = 0x4;
static const Shortint _FINISHED = 0x5;
static const Shortint _VARIABLE = 0x6;
static const Shortint _STRING = 0x7;
static const Shortint _EXT_FUNC = 0x8;
static const Byte _NEG = 0xc7;
static const Byte _SIN = 0xc8;
static const Byte _COS = 0xc9;
static const Byte _TG = 0xca;
static const Byte _CTG = 0xcb;
static const Byte _SEC = 0xcc;
static const Byte _COSEC = 0xcd;
static const Byte _ATAN = 0xce;
static const Byte _ASIN = 0xcf;
static const Byte _ACOS = 0xd0;
static const Byte _ABS = 0xd1;
static const Byte _SIGN = 0xd2;
static const Byte _INT = 0xd3;
static const Byte _ROUND = 0xd4;
static const Byte _FRAC = 0xd5;
static const Byte _LN = 0xd6;
static const Byte _LG = 0xd7;
static const Byte _SQRT = 0xd8;
static const Byte _POW = 0xd9;
static const Byte _CHX = 0xda;
static const Byte _SHX = 0xdb;
static const Byte _CTHX = 0xdc;
static const Byte _PI = 0xdd;
static const Byte _E = 0xde;
static const Byte _EXP = 0xdf;
extern PACKAGE TCommand table[13];
extern PACKAGE System::Set<char, 0, 255>  delimiters;
extern PACKAGE char TOpChar[7];
extern PACKAGE double _x;
extern PACKAGE double _y;
extern PACKAGE double _z;
extern PACKAGE void __fastcall Register(void);

}	/* namespace Rapidevaluator */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Rapidevaluator;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// RapidEvaluator
