unit fmTestComp;

interface

uses
  //VCL/RTL
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls,
  //Components
  cpqdExecuteScript,
  //Project
  fmPasswordEnter;

type
  TfrmSample = class(TForm)
    ExeScript: TqdExecuteScript;
    btnMaintain: TButton;
    btnUpdate: TButton;
    Open: TOpenDialog;
    lblDestineDir: TLabel;
    edtDestineDir: TEdit;
    btnSourceDir: TButton;
    OpenMnt: TOpenDialog;
    btnDestine: TButton;
    edtSourceDir: TEdit;
    lblSourceDir: TLabel;
    procedure btnUpdateClick(Sender: TObject);
    procedure btnMaintainClick(Sender: TObject);
    procedure ExeScriptShowErrorMsg(CodeError: Integer);
    function ExeScriptGetPassword: Boolean;
    procedure btnDestineDirClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure edtDestineDirChange(Sender: TObject);
    procedure edtSourceDirChange(Sender: TObject);
    procedure btnSourceDirClick(Sender: TObject);
  protected
    function LoadString(ID: Integer): String;
    procedure ShowMessage(Error: Integer; Item: string; BtnType: Integer);
  end;

var
  frmSample: TfrmSample;

implementation

{$R *.DFM}
{$R Messages.res}

Uses DbTables, FileCtrl;

procedure TfrmSample.btnUpdateClick(Sender: TObject);
begin
  if Open.Execute then begin
    ExeScript.ScriptFileName := Copy(Trim(Open.FileName), 1, Pos('.', Open.FileName) - 1);
    ExeScript.ScriptType := stUPDATE;
    ExeScript.Execute(edtSourceDir.Text, edtDestineDir.Text);
  end
end;

procedure TfrmSample.btnMaintainClick(Sender: TObject);
begin
  if Open.Execute then begin
    ExeScript.ScriptFileName := Copy(Trim(Open.FileName), 1, Pos('.', Open.FileName) - 1);
    ExeScript.ScriptType := stMAINTANED;
    ExeScript.Execute('', edtDestineDir.Text);
  end
end;

function TfrmSample.ExeScriptGetPassword: Boolean;
begin
  FormPasswordEnter :=  TFormPasswordEnter.Create(Self, 'Password', 'Password');
  try
    if FormPasswordEnter.ShowModal = IDOK then begin
      Session.AddPassword(FormPasswordEnter.Text);
      Result := True;
    end else
      Result := False;
  finally
    FormPasswordEnter.Free;
  end
end;

procedure TfrmSample.ExeScriptShowErrorMsg(CodeError: Integer);
begin
  ShowMessage(CodeError, '', MB_OK)
end;

function TfrmSample.LoadString(ID: Integer): String;
var
  pStr: PChar;
  Error: Integer;
begin
  pStr := AllocMem(2048);
  try
    Error := Windows.LoadString(hInstance, ID, pStr, 2048);
    if Error = 0 then
      Result := ''
    else
      Result := pStr;
  finally
    FreeMem(pStr)
  end;
end;

procedure TfrmSample.ShowMessage(Error: Integer; Item: string; BtnType: Integer);
var
  Str: String;
begin
  if Error > 0 then
    DbTables.Check(Error)
  else begin
    Str := LoadString(-Error);
    if Str <> '' then begin
      Str := Format(Str, [Item]);
      Application.MessageBox(PChar(Str), PChar(Application.Title), BtnType)
    end else begin
      Str := LoadString(0);
      Application.MessageBox(PChar(Str), PChar(Application.Title), MB_OK);
    end
  end
end;

procedure TfrmSample.btnDestineDirClick(Sender: TObject);
var
  Dir: String;
begin
  SelectDirectory(Dir, [sdAllowCreate, sdPrompt], 0);
  edtDestineDir.Text := Dir;
end;

procedure TfrmSample.btnSourceDirClick(Sender: TObject);
var
  Dir: String;
begin
  SelectDirectory(Dir, [sdAllowCreate, sdPrompt], 0);
  edtSourceDir.Text := Dir;
end;

procedure TfrmSample.FormActivate(Sender: TObject);
begin
  try
    btnMaintain.Enabled := DirectoryExists(edtDestineDir.Text);
    btnUpdate.Enabled   := DirectoryExists(edtSourceDir.Text);
  except
  end;
end;

procedure TfrmSample.edtDestineDirChange(Sender: TObject);
begin
  try
    btnMaintain.Enabled := DirectoryExists(edtDestineDir.Text);
  except
  end;
end;


procedure TfrmSample.edtSourceDirChange(Sender: TObject);
begin
  try
    btnUpdate.Enabled   := DirectoryExists(edtSourceDir.Text);
  except
  end;
end;

end.
