unit fmNameEnter;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons;

type
  TFormNameEnter = class(TForm)
    EditText: TEdit;
    LabelText: TLabel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    Panel1: TPanel;
    procedure BitBtnCancelClick(Sender: TObject);
  protected
    function GetText: String;
    procedure SetText(Value: String);
  public
    property Text: String read GetText write SetText;
    constructor Create(AOwner: TComponent; Caption, LabelName : String); 
  end;

var
  FormNameEnter: TFormNameEnter;

implementation

{$R *.DFM}

procedure TFormNameEnter.BitBtnCancelClick(Sender: TObject);
begin
  EditText.Text := '';
end;

constructor TFormNameEnter.Create(AOwner: TComponent; Caption, LabelName : String);
Begin
  inherited Create(AOwner);
  Self.Caption := Caption;
  LabelText.Caption := LabelName;
End;

function TFormNameEnter.GetText: String;
begin
  Result := EditText.Text;
end;

procedure TFormNameEnter.SetText(Value: String);
begin
  EditText.Text := Value;
end;

end.
