unit mainunit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, FlicPlayer, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    PowerFlic1: TPowerFlic;
    ListBox1: TListBox;
    PowerFlic2: TPowerFlic;
    TrackBar1: TTrackBar;
    Label1: TLabel;
    TrackBar2: TTrackBar;
    Label2: TLabel;
    Label3: TLabel;
    TrackBar3: TTrackBar;
    SpeedButton5: TSpeedButton;
    CurFrame1: TLabel;
    FrameShown1: TLabel;
    CurFrame2: TLabel;
    FrameShown2: TLabel;
    FlicShown1: TLabel;
    FlicShown2: TLabel;
    Status1: TLabel;
    Status2: TLabel;
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure PowerFlic1FrameChange(Sender: TObject);
    procedure PowerFlic2FrameChange(Sender: TObject);
    procedure PowerFlic1Loop(Sender: TObject);
    procedure PowerFlic2Loop(Sender: TObject);
    procedure PowerFlic1Stop(Sender: TObject);
    procedure PowerFlic2Stop(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


  TFlicQuery  =
  Record
    Width         : Integer;
    Height        : Integer;
    Speed         : Integer;
    Frames        : Integer;
    CurrentFrame  : Integer;
    FramesPlayed  : Integer;
    Format        : (frOLD,frNEW);
    Status        : (stPlay,stStop,stNone);
  End;

var
  Form1      : TForm1;
  FlicInfo   : TFlicQuery;
  LoopCount1 : Integer = 0;
  LoopCount2 : Integer = 0;

implementation

{$R *.DFM}

procedure TForm1.SpeedButton1Click(Sender: TObject);
var
  S : String;
begin
  PowerFlic1.Open;
  PowerFlic2.Open;
  PowerFlic1.QueryFlicInfo(Addr(FlicInfo));
  ListBox1.Items.Add('File Name    : '+PowerFlic1.FileName);
  ListBox1.Items.Add('Width        : '+IntToStr(FlicInfo.Width));
  ListBox1.Items.Add('Height       : '+IntToStr(FlicInfo.Height));
  ListBox1.Items.Add('Total Frames : '+IntToStr(FlicInfo.Frames));
  Case FlicInfo.Format of
    frOLD : S := 'Old FLI format';
    frNEW : S := 'New FLC format';
  End;
  ListBox1.Items.Add('Flic Format  : '+S);
  ListBox1.Items.Add('*******************************');
  PowerFlic2.QueryFlicInfo(Addr(FlicInfo));
  ListBox1.Items.Add('File Name    : '+PowerFlic2.FileName);
  ListBox1.Items.Add('Width        : '+IntToStr(FlicInfo.Width));
  ListBox1.Items.Add('Height       : '+IntToStr(FlicInfo.Height));
  ListBox1.Items.Add('Total Frames : '+IntToStr(FlicInfo.Frames));
  Case FlicInfo.Format of
    frOLD : S := 'Old FLI format';
    frNEW : S := 'New FLC format';
  End;
  ListBox1.Items.Add('Flic Format  : '+S);
  Status1.Caption := 'Status       : Open';
  Status2.Caption := 'Status       : Open';
end;



procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  Status1.Caption := 'Status       : Playing';
  Status2.Caption := 'Status       : Playing';
  PowerFlic1.Play;
  PowerFlic2.Play;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  PowerFlic1.Stop;
  PowerFlic2.Stop;
end;


procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  Close;
end;





procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  PowerFlic1.CustomSpeed := TrackBar1.Position;
  PowerFlic2.CustomSpeed := TrackBar1.Position;
end;

procedure TForm1.TrackBar2Change(Sender: TObject);
begin
  PowerFlic1.Brightness  := TrackBar2.Position;
  PowerFlic2.Brightness  := TrackBar2.Position;
end;


procedure TForm1.TrackBar3Change(Sender: TObject);
begin
  PowerFlic1.Contrast  := TrackBar3.Position / 10;
  PowerFlic2.Contrast  := TrackBar3.Position / 10;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
  TrackBar1.Position := 70;
  TrackBar2.Position := 0;
  TrackBar3.Position := 10;
  TrackBar1Change(Sender);
  TrackBar2Change(Sender);
  TrackBar3Change(Sender);
end;

procedure TForm1.PowerFlic1FrameChange(Sender: TObject);
begin
  PowerFlic1.QueryFlicInfo(Addr(FlicInfo));
  CurFrame1.Caption   := 'Current Frame: '+IntToStr(FlicInfo.CurrentFrame);
  FrameShown1.Caption := 'Frames Shown : '+IntToStr(FlicInfo.FramesPlayed);
end;

procedure TForm1.PowerFlic2FrameChange(Sender: TObject);
begin
  PowerFlic2.QueryFlicInfo(Addr(FlicInfo));
  CurFrame2.Caption   := 'Current Frame: '+IntToStr(FlicInfo.CurrentFrame);
  FrameShown2.Caption := 'Frames Shown : '+IntToStr(FlicInfo.FramesPlayed);
end;

procedure TForm1.PowerFlic1Loop(Sender: TObject);
begin
  Inc(LoopCount1);
  FlicShown1.Caption := 'Flic Shown   : '+IntToStr(LoopCount1)+' times';
end;

procedure TForm1.PowerFlic2Loop(Sender: TObject);
begin
  Inc(LoopCount2);
  FlicShown2.Caption := 'Flic Shown   : '+IntToStr(LoopCount2)+' times';
end;

procedure TForm1.PowerFlic1Stop(Sender: TObject);
begin
  Status1.Caption := 'Status       : Stopped';
end;

procedure TForm1.PowerFlic2Stop(Sender: TObject);
begin
  Status2.Caption := 'Status       : Stopped';
end;

end.
