// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ProfGrid.pas' rev: 6.00

#ifndef ProfGridHPP
#define ProfGridHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Menus.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Grids.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <ComCtrls.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Profgrid
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TProfGridCellInnerBorder;
class DELPHICLASS TProfGridCell;
class DELPHICLASS TProfGridCol;
class DELPHICLASS TProfGrid;
class DELPHICLASS TProfGridSelection;
class PASCALIMPLEMENTATION TProfGridSelection : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TProfGrid* FParent;
	Classes::TList* FCells;
	void __fastcall Add(const TProfGridCell* ACell);
	bool __fastcall Contains(const TProfGridCell* ACell);
	void __fastcall Invalidate(void);
	bool __fastcall IsColRowSelected(const int ACol, const int ARow);
	void __fastcall Remove(const TProfGridCell* ACell);
	int __fastcall GetBottom(void);
	TProfGridCell* __fastcall GetCells(int AIndex);
	int __fastcall GetCount(void);
	int __fastcall GetLeft(void);
	Types::TRect __fastcall GetRect();
	int __fastcall GetRight(void);
	int __fastcall GetTop(void);
	void __fastcall SetColor(const Graphics::TColor Value);
	void __fastcall SetFont(const Graphics::TFont* Value);
	void __fastcall SetReadOnly(const bool Value);
	void __fastcall SetWordWrap(const bool Value);
	void __fastcall SetTextAlignment(const Classes::TAlignment Value);
	void __fastcall SetTextLayout(const Stdctrls::TTextLayout Value);
	void __fastcall SetGraphicAlignment(const Classes::TAlignment Value);
	void __fastcall SetGraphicLayout(const Stdctrls::TTextLayout Value);
	void __fastcall SetButton(const bool Value);
	void __fastcall SetCheckBox(const bool Value);
	void __fastcall SetCheckBoxChecked(const bool Value);
	void __fastcall SetCheckBoxAlignment(const Classes::TAlignment Value);
	
public:
	__fastcall TProfGridSelection(const TProfGrid* AParent);
	__fastcall virtual ~TProfGridSelection(void);
	bool __fastcall Clear(const bool ClearReadOnly);
	bool __fastcall CopyToClipboard(void);
	bool __fastcall CutToClipboard(void);
	__property TProfGridCell* Cells[int Index] = {read=GetCells};
	__property int Count = {read=GetCount, nodefault};
	__property int Left = {read=GetLeft, nodefault};
	__property int Top = {read=GetTop, nodefault};
	__property int Right = {read=GetRight, nodefault};
	__property int Bottom = {read=GetBottom, nodefault};
	__property Types::TRect Rect = {read=GetRect};
	__property Graphics::TColor Color = {write=SetColor, nodefault};
	__property Graphics::TFont* Font = {write=SetFont};
	__property bool ReadOnly = {write=SetReadOnly, nodefault};
	__property bool WordWrap = {write=SetWordWrap, nodefault};
	__property Classes::TAlignment TextAlignment = {write=SetTextAlignment, nodefault};
	__property Stdctrls::TTextLayout TextLayout = {write=SetTextLayout, nodefault};
	__property Classes::TAlignment GraphicAlignment = {write=SetGraphicAlignment, nodefault};
	__property Stdctrls::TTextLayout GraphicLayout = {write=SetGraphicLayout, nodefault};
	__property bool Button = {write=SetButton, nodefault};
	__property bool CheckBox = {write=SetCheckBox, nodefault};
	__property bool CheckBoxChecked = {write=SetCheckBoxChecked, nodefault};
	__property Classes::TAlignment CheckBoxAlignment = {write=SetCheckBoxAlignment, nodefault};
};


class DELPHICLASS TProfGridPrintMargins;
class PASCALIMPLEMENTATION TProfGridPrintMargins : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	double FLeft;
	double FTop;
	double FRight;
	double FBottom;
	void __fastcall SetLeft(const double Value);
	void __fastcall SetRight(const double Value);
	void __fastcall SetBottom(const double Value);
	void __fastcall SetTop(const double Value);
	
__published:
	__property double Left = {read=FLeft, write=SetLeft};
	__property double Top = {read=FTop, write=SetTop};
	__property double Right = {read=FRight, write=SetRight};
	__property double Bottom = {read=FBottom, write=SetBottom};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TProfGridPrintMargins(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TProfGridPrintMargins(void) : Classes::TPersistent() { }
	#pragma option pop
	
};


class DELPHICLASS TProfGridPrintHeaderFooter;
class PASCALIMPLEMENTATION TProfGridPrintHeaderFooter : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Classes::TStrings* FLines;
	Graphics::TFont* FFont;
	double FDistance;
	Classes::TAlignment FAlignment;
	void __fastcall SetFont(const Graphics::TFont* Value);
	void __fastcall SetLines(const Classes::TStrings* Value);
	void __fastcall SetDistance(const double Value);
	
public:
	__fastcall TProfGridPrintHeaderFooter(void);
	__fastcall virtual ~TProfGridPrintHeaderFooter(void);
	
__published:
	__property Classes::TAlignment Alignment = {read=FAlignment, write=FAlignment, nodefault};
	__property Classes::TStrings* Lines = {read=FLines, write=SetLines};
	__property Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property double Distance = {read=FDistance, write=SetDistance};
};


typedef int __fastcall (*TProfGridCompareProc)(const AnsiString S1, const AnsiString S2);

class DELPHICLASS TProfGridInplaceEditor;
class PASCALIMPLEMENTATION TProfGridInplaceEditor : public Comctrls::TCustomRichEdit 
{
	typedef Comctrls::TCustomRichEdit inherited;
	
private:
	int FRequestedHeight;
	bool FShowScrollBar;
	HIDESBASE MESSAGE void __fastcall WMNCCalcSize(Messages::TWMNCCalcSize &Message);
	HIDESBASE MESSAGE void __fastcall WMGetDlgCode(Messages::TWMNoParams &Message);
	HIDESBASE MESSAGE void __fastcall CMRecreateWnd(Messages::TMessage &Message);
	MESSAGE void __fastcall CMCancelMode(Controls::TCMCancelMode &Message);
	
protected:
	DYNAMIC void __fastcall DragOver(System::TObject* Source, int X, int Y, Controls::TDragState State, bool &Accept);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyPress(char &Key);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	virtual void __fastcall RequestSize(const Types::TRect &Rect);
	DYNAMIC void __fastcall SelectionChange(void);
	
public:
	__fastcall virtual TProfGridInplaceEditor(Classes::TComponent* AOwner);
	DYNAMIC void __fastcall DragDrop(System::TObject* Source, int X, int Y);
	HIDESBASE void __fastcall PasteFromClipboard(void);
public:
	#pragma option push -w-inl
	/* TCustomRichEdit.Destroy */ inline __fastcall virtual ~TProfGridInplaceEditor(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TProfGridInplaceEditor(HWND ParentWindow) : Comctrls::TCustomRichEdit(ParentWindow) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TProfGridOption { pgoFixedVertLine, pgoFixedHorzLine, pgoVertLine, pgoHorzLine, pgoRangeSelect, pgoDrawFocusSelected, pgoRowSizing, pgoColSizing, pgoRowMoving, pgoColMoving, pgoEditing, pgoTabs, pgoRowSelect, pgoAlwaysShowEditor, pgoThumbTracking, pgoAutoIncreaseRowHeights, pgoAutoDecreaseRowHeights, pgoDrawFocusRectangle, pgoMultiLineCells, pgoMultiSelect, pgoSelectFixedCols, pgoSelectFixedRows, pgoEnterThrough, pgoClearCellOnDel, pgoTabThrough, pgoCut, pgoCopy, pgoPaste, pgoAddColsOnPaste, pgoAddRowsOnPaste, pgoStretchImages, pgoFreeCellObjects };
#pragma option pop

typedef Set<TProfGridOption, pgoFixedVertLine, pgoFreeCellObjects>  TProfGridOptions;

#pragma option push -b-
enum TProfGridPrintOption { poRepeatFixedCols, poRepeatFixedRows, poPrintSpreadsheetHeaders, poUseVertLine, poUseHorzLine, poUseFixedVertLine, poUseFixedHorzLine, poUseCellColors, poUseFontColors, poUseFixedColor, poUseGridColor, poUseGridLineColor, poUseFixedGridLineColor, poFitPageWidth, poFitPageHeight };
#pragma option pop

typedef Set<TProfGridPrintOption, poRepeatFixedCols, poFitPageHeight>  TProfGridPrintOptions;

#pragma option push -b-
enum TProfGridEditorOption { eoAutoIncreaseRowHeight, eoAutoDecreaseRowHeight, eoShowOnChar, eoClearOnChar, eoCursorAtEnd, eoSelectAll, eoAllowPaste };
#pragma option pop

typedef Set<TProfGridEditorOption, eoAutoIncreaseRowHeight, eoAllowPaste>  TProfGridEditorOptions;

#pragma option push -b-
enum TProfGridEditControlOption { ecoAutoIncreaseRowHeight, ecoAutoIncreaseColumnWidth, ecoUseEditColor, ecoUseEditFontColor, ecoUseCellFont, ecoMakeFlat };
#pragma option pop

typedef Set<TProfGridEditControlOption, ecoAutoIncreaseRowHeight, ecoMakeFlat>  TProfGridEditControlOptions;

#pragma option push -b-
enum TProfGridTabOption { toSkipMergedRows, toTabOutOfGrid };
#pragma option pop

typedef Set<TProfGridTabOption, toSkipMergedRows, toTabOutOfGrid>  TProfGridTabOptions;

#pragma option push -b-
enum TProfGridLoadedEvent { leOnSelectCell, leOnClick };
#pragma option pop

typedef Set<TProfGridLoadedEvent, leOnSelectCell, leOnClick>  TProfGridLoadedEvents;

#pragma option push -b-
enum TProfGridSpreadsheetOption { soExcelStyleHeadings, soExcelStyleHeadingHighlight, soExcelStyleNavigation };
#pragma option pop

typedef Set<TProfGridSpreadsheetOption, soExcelStyleHeadings, soExcelStyleNavigation>  TProfGridSpreadsheetOptions;

typedef void __fastcall (__closure *TProfGridGetEditControlEvent)(TProfGrid* Sender, int ACol, int ARow, Controls::TWinControl* &AControl);

typedef void __fastcall (__closure *TProfGridGetEditControlTextEvent)(TProfGrid* Sender, int ACol, int ARow, Controls::TWinControl* AControl, AnsiString &Value, bool &DoSetText);

typedef void __fastcall (__closure *TProfGridGetEditControlResultEvent)(TProfGrid* Sender, int ACol, int ARow, Controls::TWinControl* AControl, AnsiString &Value);

typedef void __fastcall (__closure *TProfGridCellChangedEvent)(TProfGrid* Sender, int ACol, int ARow, const AnsiString OldValue, AnsiString &NewValue, bool &AllowExit);

typedef void __fastcall (__closure *TProfGridCellTextChangedEvent)(TProfGrid* Sender, int ACol, int ARow, const AnsiString OldText, const AnsiString NewText);

typedef void __fastcall (__closure *TProfGridKeyPressExEvent)(TProfGrid* Sender, char &Key, int ACol, int ARow, AnsiString &EditText, int &Position);

typedef void __fastcall (__closure *TProfGridNotifyEvent)(TProfGrid* Sender, int ACol, int ARow);

typedef void __fastcall (__closure *TProfGridColRowResizedEvent)(TProfGrid* Sender, int Index, int OldSize, int NewSize);

typedef void __fastcall (__closure *TProfGridEditorSelectionChangedEvent)(TProfGrid* Sender, const AnsiString SelText);

typedef void __fastcall (__closure *TProfGridShowScrollBarsEvent)(TProfGrid* Sender, bool &HScrollBar, bool &VScrollBar);

typedef void __fastcall (__closure *TProfGridCellRecalculatedEvent)(TProfGrid* Sender, int ACol, int ARow, AnsiString &NewText);

typedef void __fastcall (__closure *TProfGridPrintEvent)(TProfGrid* Sender, int APage);

class DELPHICLASS TProfGridClipboardCell;
typedef void __fastcall (__closure *TProfGridPasteEvent)(TProfGrid* Sender, int ACol, int ARow, TProfGridClipboardCell* ACell, bool &CanPaste);

typedef void __fastcall (__closure *TProfGridPastePlainTextEvent)(TProfGrid* Sender, int ACol, int ARow, AnsiString &AText, bool &CanPaste);

typedef void __fastcall (__closure *TProfGridPasteGraphicsEvent)(TProfGrid* Sender, int ACol, int ARow, Graphics::TGraphic* AGraphic, bool &CanPaste);

typedef void __fastcall (__closure *TProfGridResizeRowEvent)(TProfGrid* Sender, int ARow, int &NewHeight, bool &CanResize);

typedef void __fastcall (__closure *TProfGridExportImportProgressEvent)(TProfGrid* Sender, int Position, int EndPosition, bool &Stop);

typedef void __fastcall (__closure *TProfGridCompareCellsEvent)(TProfGrid* Sender, TProfGridCell* Cell1, TProfGridCell* Cell2, int &Result);

typedef void __fastcall (__closure *TProfGridColRowStartDragEvent)(TProfGrid* Sender, int Index, bool &CanDrag);

typedef void __fastcall (__closure *TProfGridColRowDragDropEvent)(TProfGrid* Sender, int FromIndex, int ToIndex, bool &CanDrop);

typedef void __fastcall (__closure *TProfGridCheckBoxChangedEvent)(TProfGrid* Sender, int ACol, int ARow, bool Checked);

typedef void __fastcall (__closure *TProfGridClearCellEvent)(TProfGrid* Sender, int ACol, int ARow, bool &CanClear);

typedef void __fastcall (__closure *TProfGridEditControlValidateErrorEvent)(TProfGrid* Sender, int ACol, int ARow, const AnsiString ErrorMessage);

typedef void __fastcall (__closure *TProfGridRecalculateCellEvent)(TProfGrid* Sender, int ACol, int ARow, bool &DoCalculate, Variant &CellValue);

typedef void __fastcall (__closure *TProfGridDisplayTextEvent)(TProfGrid* Sender, TProfGridCell* Cell, const AnsiString DisplayText);

typedef void __fastcall (__closure *TProfGridShowHintEvent)(TProfGrid* Sender, int ACol, int ARow, AnsiString &HintStr, bool &CanShow, Forms::THintInfo &HintInfo);

typedef Grids::TGridCoord *PGridCoord;

class PASCALIMPLEMENTATION TProfGrid : public Grids::TCustomGrid 
{
	typedef Grids::TCustomGrid inherited;
	
private:
	Classes::TList* FAbsoluteCols;
	Classes::TList* FCols;
	Classes::TList* FHiddenCols;
	int FFixedRows;
	int FAbsFixedCols;
	int FGlobalColumnID;
	TProfGridSelection* FSelection;
	TProfGridPrintMargins* FPrintMargins;
	TProfGridPrintHeaderFooter* FPrintHeader;
	TProfGridPrintHeaderFooter* FPrintFooter;
	Graphics::TColor FGridLineColor;
	Graphics::TColor FFixedGridLineColor;
	Graphics::TColor FEditColor;
	Graphics::TColor FEditFontColor;
	Graphics::TColor FSelectionColor;
	Graphics::TColor FSelectionFontColor;
	Graphics::TColor FSortIndicatorColor;
	int FSortColumn;
	TProfGridCompareProc FCompareProc;
	AnsiString FExportTag;
	TProfGridCell* FHintCell;
	Graphics::TBitmap* FChecked;
	Graphics::TBitmap* FUnchecked;
	Classes::TList* FPrintOuterBorders;
	TProfGridInplaceEditor* FEditor;
	Controls::TWinControl* FEditControl;
	Graphics::TFont* FOldFont;
	int FDisableCount;
	int FWindowStyle;
	AnsiString FEditorSelText;
	AnsiString FOldCellText;
	int FOldRowHeight;
	TProfGridCell* FEditedCell;
	TProfGridCell* FButtonCell;
	TProfGridOptions FOptions;
	TProfGridPrintOptions FPrintOptions;
	TProfGridEditorOptions FEditorOptions;
	TProfGridEditControlOptions FEditControlOptions;
	TProfGridTabOptions FTabOptions;
	TProfGridLoadedEvents FLoadedEvents;
	TProfGridSpreadsheetOptions FSpreadsheetOptions;
	Byte FBorder;
	bool FWordWrap;
	bool FInplaceScrollBar;
	bool FEditorMode;
	bool FSortDescending;
	bool FSortOnDblClick;
	bool FSortOnClick;
	bool FSortIndicator;
	bool FSpreadsheetHeaders;
	bool FSpreadsheetEnabled;
	bool FHideSelection;
	bool FMouseDown;
	bool FHideEditControl;
	bool FHideEditor;
	bool FEscape;
	bool FClearEditor;
	bool FEditorRequestSize;
	bool FIgnorePaint;
	bool FDecreaseRowHeight;
	bool FIgnoreRowHeightsChanged;
	bool FIgnoreEraseBkgnd;
	bool FIgnoreMouseMove;
	bool FTopLeftChanged;
	bool FLoading;
	bool FExitNotAllowed;
	bool FPasting;
	System::TDateTime FClickTime;
	Classes::TWndMethod FOldWindowProc;
	Forms::TCloseQueryEvent FSaveOnCloseQuery;
	Grids::TMovedEvent FOnColumnMoved;
	Grids::TGetEditEvent FOnGetEditText;
	Grids::TMovedEvent FOnRowMoved;
	Grids::TSelectCellEvent FOnSelectCell;
	Grids::TSetEditEvent FOnSetEditText;
	Classes::TNotifyEvent FOnTopLeftChanged;
	TProfGridGetEditControlEvent FOnGetEditControl;
	TProfGridGetEditControlTextEvent FOnGetEditControlText;
	TProfGridGetEditControlResultEvent FOnGetEditControlResult;
	TProfGridCellChangedEvent FOnCellChanged;
	TProfGridCellTextChangedEvent FOnCellTextChanged;
	TProfGridKeyPressExEvent FOnKeyPressEx;
	TProfGridNotifyEvent FOnCellExit;
	TProfGridColRowResizedEvent FOnColumnResized;
	TProfGridColRowResizedEvent FOnColumnWidthChanged;
	TProfGridEditorSelectionChangedEvent FOnEditorSelectionChanged;
	TProfGridShowScrollBarsEvent FOnShowScrollBars;
	TProfGridCellRecalculatedEvent FOnCellRecalculated;
	TProfGridPrintEvent FOnPrintPageBegin;
	TProfGridPrintEvent FOnPrintPageContinued;
	TProfGridNotifyEvent FOnCellCleared;
	TProfGridPasteEvent FOnPaste;
	TProfGridPastePlainTextEvent FOnPastePlainText;
	TProfGridPasteGraphicsEvent FOnPasteGraphics;
	TProfGridResizeRowEvent FOnResizeRow;
	Classes::TNotifyEvent FOnStartSort;
	Classes::TNotifyEvent FOnEndSort;
	TProfGridExportImportProgressEvent FOnExportProgress;
	TProfGridExportImportProgressEvent FOnImportProgress;
	TProfGridCompareCellsEvent FOnCompareCells;
	TProfGridColRowStartDragEvent FOnColumnStartDrag;
	TProfGridColRowStartDragEvent FOnRowStartDrag;
	TProfGridColRowDragDropEvent FOnColumnDragDrop;
	TProfGridColRowDragDropEvent FOnRowDragDrop;
	TProfGridCheckBoxChangedEvent FOnCheckBoxChanged;
	Grids::TSelectCellEvent FOnSelectRange;
	TProfGridClearCellEvent FOnClearCell;
	TProfGridNotifyEvent FOnCellCut;
	Classes::TNotifyEvent FOnRecalculated;
	TProfGridNotifyEvent FOnButtonClicked;
	TProfGridColRowResizedEvent FOnRowResized;
	TProfGridNotifyEvent FOnCellDeselected;
	TProfGridEditControlValidateErrorEvent FOnEditControlValidateError;
	TProfGridRecalculateCellEvent FOnRecalculateCell;
	TProfGridDisplayTextEvent FOnDisplayText;
	TProfGridShowHintEvent FOnShowHint;
	void __fastcall AdjustEditControl(void);
	bool __fastcall AnalyzeExpression(const TProfGridCell* ACell);
	void __fastcall AssignInheritedColWidths(const int Index, const int Value);
	HIDESBASE void __fastcall CalcSizingState(int X, int Y, Grids::TGridState &State, int &Index, int &SizingPos, int &SizingOfs);
	void __fastcall CheckAlwaysShowEditor(void);
	bool __fastcall CheckEditorMode(void);
	void __fastcall CheckSelection(void);
	void __fastcall ClearSelection(void);
	void __fastcall CloseQuery(System::TObject* Sender, bool &CanClose);
	void __fastcall DoAutoSizeColumn(const int ACol, const bool ByUser);
	void __fastcall DoCancelMode(void);
	void __fastcall DoDeleteRow(const int ARow);
	bool __fastcall DoExportToExcel(int AMode, const AnsiString AFileName);
	bool __fastcall DoExportToWord(int AMode, const AnsiString AFileName);
	bool __fastcall DoFocusCell(const int ACol, const int ARow, const int ALeftCol, const int ATopRow, const bool AMoveAnchor);
	bool __fastcall DoInsertRow(const int ARow, const bool CreateCells);
	bool __fastcall DoLoadFromIniFile(const AnsiString FileName, const Classes::TStrings* AStrings);
	void __fastcall DoMoveColumn(const int FromIndex, const int ToIndex);
	void __fastcall DoMoveRow(const int FromIndex, const int ToIndex);
	int __fastcall DoPrint(const Graphics::TCanvas* DestCanvas, const int Page, const int Mode, const int YPos, const int AStartCol, const int AStartRow, const int AEndCol, const int AEndRow, const double Distance);
	bool __fastcall DoResizeRow(const int ARow, const bool DoIncrease, const bool DoDecrease, const int EditorRequestedHeight);
	bool __fastcall DoSaveToIniFile(const AnsiString FileName, const Classes::TStrings* AStrings);
	void __fastcall DrawCellDesignTime(const int CurCol, const int CurRow, const Types::TRect &Where, const Grids::TGridDrawState ADrawState);
	void __fastcall DrawCellRunTime(const int CurCol, const int CurRow, const Types::TRect &Where, Grids::TGridDrawState DrawState);
	HIDESBASE void __fastcall DrawMove(void);
	HIDESBASE void __fastcall DrawSizingLine(void);
	void __fastcall DrawSortIndicator(const Types::TRect &ARect);
	void __fastcall EditControlWndProc(Messages::TMessage &Message);
	void __fastcall EditorPopupHandler(System::TObject* Sender);
	HIDESBASE void __fastcall HideEditor(void);
	HIDESBASE void __fastcall Initialize(void);
	HIDESBASE void __fastcall InvalidateEditor(void);
	HIDESBASE bool __fastcall IsActiveControl(void);
	bool __fastcall IsCurrentCell(const TProfGridCell* ACell);
	HIDESBASE void __fastcall MoveAnchor(const Grids::TGridCoord &NewAnchor);
	HIDESBASE void __fastcall MoveCurrent(const int ACol, const int ARow, const bool AMoveAnchor, const bool AShow, const bool AClearSelection);
	Grids::TGridCoord __fastcall ReadFAnchor();
	Grids::TGridCoord __fastcall ReadFCurrent();
	void * __fastcall ReadFRowHeights(void);
	PGridCoord __fastcall ReadPFAnchor(void);
	System::PInteger __fastcall ReadPFMoveIndex(void);
	System::PInteger __fastcall ReadPFMovePos(void);
	System::PInteger __fastcall ReadPFSizingIndex(void);
	System::PInteger __fastcall ReadPFSizingPos(void);
	System::PInteger __fastcall ReadPFSizingOfs(void);
	Grids::TGridCoord __fastcall ReadFTopLeft();
	bool __fastcall Recalculate(const TProfGridCell* Skip);
	HIDESBASE bool __fastcall ResizeRow(const int ARow);
	HIDESBASE void __fastcall ShowEditorChar(const char Ch);
	HIDESBASE bool __fastcall Sizing(const int X, const int Y);
	void __fastcall UpdateInheritedColCount(const int Value);
	void __fastcall UpdateInheritedRowCount(const int Value);
	void __fastcall WriteFAnchor(const Grids::TGridCoord &Value);
	void __fastcall WriteFCurrent(const Grids::TGridCoord &Value);
	void __fastcall WriteFTopLeft(const Grids::TGridCoord &Value);
	AnsiString __fastcall GetAbout();
	TProfGridCell* __fastcall GetAbsoluteCells(int ACol, int ARow);
	TProfGridCol* __fastcall GetAbsoluteCols(int ACol);
	int __fastcall GetAbsoluteColCount(void);
	TProfGridCell* __fastcall GetCells(int ACol, int ARow);
	int __fastcall GetCol(void);
	int __fastcall GetColCount(void);
	TProfGridCol* __fastcall GetCols(int ACol);
	HIDESBASE Word __fastcall GetColWidths(int ACol);
	Word __fastcall GetDefaultColWidth(void);
	Word __fastcall GetDefaultRowHeight(void);
	Graphics::TColor __fastcall GetFixedColor(void);
	int __fastcall GetFixedCols(void);
	Byte __fastcall GetGridLineWidth(void);
	TProfGridCol* __fastcall GetHiddenCols(int ACol);
	int __fastcall GetHiddenColCount(void);
	int __fastcall GetLeftCol(void);
	System::TObject* __fastcall GetObjects(int ACol, int ARow);
	int __fastcall GetRow(void);
	int __fastcall GetRowCount(void);
	HIDESBASE int __fastcall GetRowHeights(int ARow);
	HIDESBASE bool __fastcall GetTabStops(int ACol);
	int __fastcall GetTopRow(void);
	HIDESBASE int __fastcall GetVisibleRowCount(void);
	void __fastcall SetAbout(const AnsiString dummy);
	void __fastcall SetBorderForText(const Byte Value);
	HIDESBASE void __fastcall SetCol(const int Value);
	HIDESBASE void __fastcall SetColCount(int iValue);
	HIDESBASE void __fastcall SetColWidths(int ACol, const Word Value);
	void __fastcall SetCompareProc(const TProfGridCompareProc Value);
	HIDESBASE void __fastcall SetDefaultColWidth(const Word Value);
	HIDESBASE void __fastcall SetDefaultRowHeight(const Word Value);
	void __fastcall SetEditColor(const Graphics::TColor Value);
	void __fastcall SetEditFontColor(const Graphics::TColor Value);
	HIDESBASE void __fastcall SetEditorMode(const bool Value);
	void __fastcall SetEditorOptions(TProfGridEditorOptions Value);
	void __fastcall SetExportTag(const AnsiString Value);
	HIDESBASE void __fastcall SetFixedColor(const Graphics::TColor Value);
	HIDESBASE void __fastcall SetFixedCols(const int Value);
	void __fastcall SetFixedGridLineColor(const Graphics::TColor Value);
	HIDESBASE void __fastcall SetFixedRows(int iValue);
	void __fastcall SetGridLineColor(const Graphics::TColor Value);
	HIDESBASE void __fastcall SetGridLineWidth(const Byte Value);
	void __fastcall SetInplaceScrollBar(const bool Value);
	HIDESBASE void __fastcall SetLeftCol(const int Value);
	void __fastcall SetObjects(int ACol, int ARow, const System::TObject* Value);
	HIDESBASE void __fastcall SetOptions(TProfGridOptions Value);
	HIDESBASE void __fastcall SetRow(const int Value);
	HIDESBASE void __fastcall SetRowCount(int iValue);
	HIDESBASE void __fastcall SetRowHeights(int ARow, int iValue);
	void __fastcall SetSelectionColor(const Graphics::TColor Value);
	void __fastcall SetSelectionFontColor(const Graphics::TColor Value);
	void __fastcall SetSortIndicator(const bool Value);
	void __fastcall SetSortIndicatorColor(const Graphics::TColor Value);
	void __fastcall SetSortColumn(const int Value);
	void __fastcall SetSortDescending(const bool Value);
	void __fastcall SetSortOnClick(const bool Value);
	void __fastcall SetSortOnDblClick(const bool Value);
	void __fastcall SetSpreadsheetHeaders(const bool Value);
	void __fastcall SetSpreadsheetEnabled(const bool Value);
	void __fastcall SetSpreadsheetOptions(const TProfGridSpreadsheetOptions Value);
	HIDESBASE void __fastcall SetTabStops(int ACol, const bool Value);
	HIDESBASE void __fastcall SetTopRow(const int Value);
	void __fastcall SetWordWrap(const bool Value);
	HIDESBASE MESSAGE void __fastcall CMColorChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMDesignHitTest(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall CMFontChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMHintShow(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMCommand(Messages::TWMCommand &Message);
	HIDESBASE MESSAGE void __fastcall WMEraseBkgnd(Messages::TWMEraseBkgnd &Message);
	HIDESBASE MESSAGE void __fastcall WMGetDlgCode(Messages::TWMNoParams &Msg);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TWMKillFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMNCCalcSize(Messages::TWMNCCalcSize &Message);
	HIDESBASE MESSAGE void __fastcall WMSetCursor(Messages::TWMSetCursor &Msg);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMVScroll(Messages::TWMScroll &Msg);
	__property Grids::TGridCoord FAnchor = {read=ReadFAnchor, write=WriteFAnchor};
	__property PGridCoord PFAnchor = {read=ReadPFAnchor};
	__property Grids::TGridCoord FCurrent = {read=ReadFCurrent, write=WriteFCurrent};
	__property Grids::TGridCoord FTopLeft = {read=ReadFTopLeft, write=WriteFTopLeft};
	__property System::PInteger PFSizingIndex = {read=ReadPFSizingIndex};
	__property System::PInteger PFSizingPos = {read=ReadPFSizingPos};
	__property System::PInteger PFSizingOfs = {read=ReadPFSizingOfs};
	__property System::PInteger PFMoveIndex = {read=ReadPFMoveIndex};
	__property System::PInteger PFMovePos = {read=ReadPFMovePos};
	__property void * FRowHeights = {read=ReadFRowHeights};
	
protected:
	DYNAMIC bool __fastcall BeginColumnDrag(int &Origin, int &Destination, const Types::TPoint &MousePt);
	DYNAMIC bool __fastcall BeginRowDrag(int &Origin, int &Destination, const Types::TPoint &MousePt);
	DYNAMIC void __fastcall DoEnter(void);
	DYNAMIC void __fastcall DoExit(void);
	DYNAMIC bool __fastcall DoMouseWheelDown(Classes::TShiftState Shift, const Types::TPoint &MousePos);
	DYNAMIC bool __fastcall DoMouseWheelUp(Classes::TShiftState Shift, const Types::TPoint &MousePos);
	virtual void __fastcall DrawCell(int ACol, int ARow, const Types::TRect &ARect, Grids::TGridDrawState AState);
	DYNAMIC bool __fastcall EndColumnDrag(int &Origin, int &Destination, const Types::TPoint &MousePt);
	DYNAMIC bool __fastcall EndRowDrag(int &Origin, int &Destination, const Types::TPoint &MousePt);
	virtual void __fastcall Loaded(void);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyPress(char &Key);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall Paint(void);
	DYNAMIC void __fastcall RowHeightsChanged(void);
	virtual bool __fastcall SelectCell(int ACol, int ARow);
	DYNAMIC void __fastcall SetEditText(int ACol, int ARow, const AnsiString Value);
	DYNAMIC void __fastcall TimedScroll(Grids::TGridScrollDirection Direction);
	DYNAMIC void __fastcall TopLeftChanged(void);
	DYNAMIC void __fastcall VisibleChanging(void);
	virtual void __fastcall CellChanged(int ACol, int ARow, const AnsiString OldValue, AnsiString &NewValue, bool &AllowExit);
	
public:
	__fastcall virtual TProfGrid(Classes::TComponent* AOwner);
	__fastcall virtual ~TProfGrid(void);
	virtual void __fastcall Invalidate(void);
	virtual void __fastcall Update(void);
	DYNAMIC bool __fastcall Focused(void);
	virtual void __fastcall SetFocus(void);
	virtual void __fastcall SetBounds(int ALeft, int ATop, int AWidth, int AHeight);
	bool __fastcall AutoSizeColumn(const int ACol);
	bool __fastcall AutoSizeColumns(void);
	bool __fastcall AutoSizeColumnsEx(const int * AColumns, const int AColumns_Size);
	bool __fastcall AutoSizeRow(const int ARow);
	bool __fastcall AutoSizeRows(void);
	bool __fastcall AutoSizeRowsEx(const int * ARows, const int ARows_Size);
	int __fastcall BeginPrint(void);
	TProfGridCell* __fastcall CellByName(const AnsiString A1Name);
	HIDESBASE Types::TRect __fastcall CellRect(const int ACol, const int ARow);
	bool __fastcall ColumnIsEmpty(const int ACol);
	int __fastcall ContinuePrint(const int I, double Distance);
	bool __fastcall CopyToClipboard(void);
	HIDESBASE bool __fastcall DeleteColumn(const int ACol);
	HIDESBASE bool __fastcall DeleteRow(const int ARow);
	int __fastcall DisableControls(void);
	int __fastcall EnableControls(void);
	int __fastcall EndPrint(const int I, double Distance);
	bool __fastcall ExportToExcel(void);
	bool __fastcall ExportToExcelFile(const AnsiString FileName);
	bool __fastcall ExportToWord(void);
	bool __fastcall ExportToWordFile(const AnsiString FileName);
	bool __fastcall Find(const AnsiString FindText, const Dialogs::TFindOptions FindOptions);
	bool __fastcall FindAndReplace(const AnsiString FindText, const AnsiString ReplaceText, const Dialogs::TFindOptions FindOptions);
	HIDESBASE bool __fastcall FocusCell(const int ACol, const int ARow);
	bool __fastcall FocusCellEx(const int ACol, const int ARow);
	bool __fastcall GetEditorSelection(int &ASelStart, int &ASelLength, AnsiString &ASelText);
	int __fastcall GetX(const int ACol);
	int __fastcall GetY(const int ARow);
	bool __fastcall HideColumn(const int ACol);
	bool __fastcall ImportFromExcelFile(const AnsiString FileName, const Variant &SheetNameOrIndex);
	bool __fastcall InsertColumn(const int ACol);
	bool __fastcall InsertRow(const int ARow);
	bool __fastcall InsertRowEx(const int ACol, const int ARow, const bool After);
	bool __fastcall LoadFromCSV(const AnsiString FileName);
	bool __fastcall LoadFromIniFile(const AnsiString FileName);
	bool __fastcall LoadFromIniStrings(const Classes::TStrings* AStrings);
	bool __fastcall LoadFromStrings(const Classes::TStrings* AStrings);
	bool __fastcall LoadFromTabDelimited(const AnsiString FileName);
	bool __fastcall MergeHoriz(const int AStartCol, const int AEndCol, const int ARow, const AnsiString Separator = "");
	bool __fastcall MergeRect(const Types::TRect &ARect, bool MergeDataByRow = true, const AnsiString ColSeparator = "", const AnsiString RowSeparator = "");
	bool __fastcall MergeVert(const int ACol, const int AStartRow, const int AEndRow, const AnsiString Separator = "");
	bool __fastcall MouseToCell(const int X, const int Y, int &ACol, int &ARow);
	HIDESBASE bool __fastcall MoveColumn(const int FromIndex, const int ToIndex);
	HIDESBASE bool __fastcall MoveRow(const int FromIndex, const int ToIndex);
	bool __fastcall PasteFromClipboard(void);
	int __fastcall Print(void);
	int __fastcall PrintPage(const int APage);
	int __fastcall PrintPreview(const Extctrls::TImage* AImage, const int APage);
	int __fastcall PrintPreviewRange(const int AStartCol, const int AStartRow, const int AEndCol, const int AEndRow, const Extctrls::TImage* AImage, const int APage);
	int __fastcall PrintRange(const int AStartCol, const int AStartRow, const int AEndCol, const int AEndRow);
	bool __fastcall RowIsEmpty(const int ARow);
	bool __fastcall SaveToBitmap(const Graphics::TBitmap* ABitmap);
	bool __fastcall SaveToIniFile(const AnsiString FileName);
	bool __fastcall SaveToIniStrings(const Classes::TStrings* AStrings);
	bool __fastcall SaveToStrings(const Classes::TStrings* AStrings);
	bool __fastcall SetEditorSelection(const int ASelStart, const int ASelLength);
	HIDESBASE bool __fastcall SetSelection(const int ALeft, const int ATop, const int ARight, const int ABottom);
	int __fastcall ShowHiddenColumn(const int AHiddenCol);
	bool __fastcall Sort(void);
	__property int Row = {read=GetRow, write=SetRow, nodefault};
	__property int Col = {read=GetCol, write=SetCol, nodefault};
	__property int TopRow = {read=GetTopRow, write=SetTopRow, nodefault};
	__property VisibleRowCount  = {read=GetVisibleRowCount};
	__property TProfGridCell* AbsoluteCells[int ACol][int ARow] = {read=GetAbsoluteCells};
	__property int AbsoluteColCount = {read=GetAbsoluteColCount, nodefault};
	__property TProfGridCol* AbsoluteCols[int ACol] = {read=GetAbsoluteCols};
	__property TProfGridCell* Cells[int ACol][int ARow] = {read=GetCells/*, default*/};
	__property TProfGridCol* Cols[int ACol] = {read=GetCols};
	__property Word ColWidths[int ACol] = {read=GetColWidths, write=SetColWidths};
	__property TProfGridCompareProc CompareProc = {read=FCompareProc, write=SetCompareProc};
	__property bool EditorMode = {read=FEditorMode, write=SetEditorMode, nodefault};
	__property int HiddenColCount = {read=GetHiddenColCount, nodefault};
	__property TProfGridCol* HiddenCols[int ACol] = {read=GetHiddenCols};
	__property int LeftCol = {read=GetLeftCol, write=SetLeftCol, nodefault};
	__property System::TObject* Objects[int ACol][int ARow] = {read=GetObjects, write=SetObjects};
	__property int RowHeights[int ARow] = {read=GetRowHeights, write=SetRowHeights};
	__property TProfGridSelection* Selection = {read=FSelection};
	__property bool TabStops[int ACol] = {read=GetTabStops, write=SetTabStops};
	__property Grids::TGridState GridState = {read=FGridState, nodefault};
	__property Canvas ;
	__property GridHeight ;
	__property GridWidth ;
	__property VisibleColCount ;
	
__published:
	__property int ColCount = {read=GetColCount, write=SetColCount, nodefault};
	__property int RowCount = {read=GetRowCount, write=SetRowCount, nodefault};
	__property int FixedCols = {read=GetFixedCols, write=SetFixedCols, nodefault};
	__property int FixedRows = {read=FFixedRows, write=SetFixedRows, nodefault};
	__property AnsiString About = {read=GetAbout, write=SetAbout};
	__property Byte BorderForText = {read=FBorder, write=SetBorderForText, nodefault};
	__property Word DefaultColWidth = {read=GetDefaultColWidth, write=SetDefaultColWidth, nodefault};
	__property Word DefaultRowHeight = {read=GetDefaultRowHeight, write=SetDefaultRowHeight, nodefault};
	__property Graphics::TColor EditColor = {read=FEditColor, write=SetEditColor, nodefault};
	__property Graphics::TColor EditFontColor = {read=FEditFontColor, write=SetEditFontColor, nodefault};
	__property TProfGridEditControlOptions EditControlOptions = {read=FEditControlOptions, write=FEditControlOptions, nodefault};
	__property TProfGridEditorOptions EditorOptions = {read=FEditorOptions, write=SetEditorOptions, nodefault};
	__property AnsiString ExportTag = {read=FExportTag, write=SetExportTag};
	__property Graphics::TColor FixedColor = {read=GetFixedColor, write=SetFixedColor, nodefault};
	__property Graphics::TColor FixedGridLineColor = {read=FFixedGridLineColor, write=SetFixedGridLineColor, nodefault};
	__property Graphics::TColor GridLineColor = {read=FGridLineColor, write=SetGridLineColor, nodefault};
	__property Byte GridLineWidth = {read=GetGridLineWidth, write=SetGridLineWidth, nodefault};
	__property bool HideSelection = {read=FHideSelection, write=FHideSelection, nodefault};
	__property bool InplaceScrollBar = {read=FInplaceScrollBar, write=SetInplaceScrollBar, nodefault};
	__property TProfGridLoadedEvents LoadedEvents = {read=FLoadedEvents, write=FLoadedEvents, nodefault};
	__property TProfGridOptions Options = {read=FOptions, write=SetOptions, nodefault};
	__property TProfGridPrintHeaderFooter* PrintFooter = {read=FPrintFooter, write=FPrintFooter};
	__property TProfGridPrintHeaderFooter* PrintHeader = {read=FPrintHeader, write=FPrintHeader};
	__property TProfGridPrintMargins* PrintMargins = {read=FPrintMargins, write=FPrintMargins};
	__property TProfGridPrintOptions PrintOptions = {read=FPrintOptions, write=FPrintOptions, nodefault};
	__property Graphics::TColor SelectionColor = {read=FSelectionColor, write=SetSelectionColor, nodefault};
	__property Graphics::TColor SelectionFontColor = {read=FSelectionFontColor, write=SetSelectionFontColor, nodefault};
	__property int SortColumn = {read=FSortColumn, write=SetSortColumn, nodefault};
	__property bool SortDescending = {read=FSortDescending, write=SetSortDescending, nodefault};
	__property bool SortIndicator = {read=FSortIndicator, write=SetSortIndicator, nodefault};
	__property Graphics::TColor SortIndicatorColor = {read=FSortIndicatorColor, write=SetSortIndicatorColor, nodefault};
	__property bool SortOnClick = {read=FSortOnClick, write=SetSortOnClick, nodefault};
	__property bool SortOnDblClick = {read=FSortOnDblClick, write=SetSortOnDblClick, nodefault};
	__property bool SpreadsheetEnabled = {read=FSpreadsheetEnabled, write=SetSpreadsheetEnabled, nodefault};
	__property bool SpreadsheetHeaders = {read=FSpreadsheetHeaders, write=SetSpreadsheetHeaders, nodefault};
	__property TProfGridSpreadsheetOptions SpreadsheetOptions = {read=FSpreadsheetOptions, write=SetSpreadsheetOptions, nodefault};
	__property TProfGridTabOptions TabOptions = {read=FTabOptions, write=FTabOptions, nodefault};
	__property bool WordWrap = {read=FWordWrap, write=SetWordWrap, nodefault};
	__property Align  = {default=0};
	__property BorderStyle  = {default=1};
	__property Color  = {default=-2147483643};
	__property Ctl3D ;
	__property DragCursor  = {default=-12};
	__property DragMode  = {default=0};
	__property Enabled  = {default=1};
	__property Font ;
	__property ParentColor  = {default=0};
	__property ParentCtl3D  = {default=1};
	__property ParentFont  = {default=1};
	__property ParentShowHint  = {default=1};
	__property PopupMenu ;
	__property ScrollBars  = {default=3};
	__property ShowHint ;
	__property TabOrder  = {default=-1};
	__property TabStop  = {default=1};
	__property Visible  = {default=1};
	__property Anchors  = {default=3};
	__property Constraints ;
	__property DragKind  = {default=0};
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property OnKeyDown ;
	__property OnKeyPress ;
	__property OnKeyUp ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnStartDrag ;
	__property OnEndDock ;
	__property OnStartDock ;
	__property OnMouseWheelDown ;
	__property OnMouseWheelUp ;
	__property OnContextPopup ;
	__property Grids::TMovedEvent OnColumnMoved = {read=FOnColumnMoved, write=FOnColumnMoved};
	__property Grids::TGetEditEvent OnGetEditText = {read=FOnGetEditText, write=FOnGetEditText};
	__property Grids::TMovedEvent OnRowMoved = {read=FOnRowMoved, write=FOnRowMoved};
	__property Grids::TSelectCellEvent OnSelectCell = {read=FOnSelectCell, write=FOnSelectCell};
	__property Grids::TSetEditEvent OnSetEditText = {read=FOnSetEditText, write=FOnSetEditText};
	__property Classes::TNotifyEvent OnTopLeftChanged = {read=FOnTopLeftChanged, write=FOnTopLeftChanged};
	__property TProfGridNotifyEvent OnButtonClicked = {read=FOnButtonClicked, write=FOnButtonClicked};
	__property TProfGridCellChangedEvent OnCellChanged = {read=FOnCellChanged, write=FOnCellChanged};
	__property TProfGridNotifyEvent OnCellCleared = {read=FOnCellCleared, write=FOnCellCleared};
	__property TProfGridNotifyEvent OnCellCut = {read=FOnCellCut, write=FOnCellCut};
	__property TProfGridNotifyEvent OnCellDeselected = {read=FOnCellDeselected, write=FOnCellDeselected};
	__property TProfGridNotifyEvent OnCellExit = {read=FOnCellExit, write=FOnCellExit};
	__property TProfGridCellRecalculatedEvent OnCellRecalculated = {read=FOnCellRecalculated, write=FOnCellRecalculated};
	__property TProfGridCellTextChangedEvent OnCellTextChanged = {read=FOnCellTextChanged, write=FOnCellTextChanged};
	__property TProfGridCheckBoxChangedEvent OnCheckBoxChanged = {read=FOnCheckBoxChanged, write=FOnCheckBoxChanged};
	__property TProfGridClearCellEvent OnClearCell = {read=FOnClearCell, write=FOnClearCell};
	__property TProfGridColRowDragDropEvent OnColumnDragDrop = {read=FOnColumnDragDrop, write=FOnColumnDragDrop};
	__property TProfGridColRowResizedEvent OnColumnResized = {read=FOnColumnResized, write=FOnColumnResized};
	__property TProfGridColRowStartDragEvent OnColumnStartDrag = {read=FOnColumnStartDrag, write=FOnColumnStartDrag};
	__property TProfGridColRowResizedEvent OnColumnWidthChanged = {read=FOnColumnWidthChanged, write=FOnColumnWidthChanged};
	__property TProfGridCompareCellsEvent OnCompareCells = {read=FOnCompareCells, write=FOnCompareCells};
	__property TProfGridDisplayTextEvent OnDisplayText = {read=FOnDisplayText, write=FOnDisplayText};
	__property TProfGridEditControlValidateErrorEvent OnEditControlValidateError = {read=FOnEditControlValidateError, write=FOnEditControlValidateError};
	__property TProfGridEditorSelectionChangedEvent OnEditorSelectionChanged = {read=FOnEditorSelectionChanged, write=FOnEditorSelectionChanged};
	__property Classes::TNotifyEvent OnEndSort = {read=FOnEndSort, write=FOnEndSort};
	__property TProfGridExportImportProgressEvent OnExportProgress = {read=FOnExportProgress, write=FOnExportProgress};
	__property TProfGridGetEditControlEvent OnGetEditControl = {read=FOnGetEditControl, write=FOnGetEditControl};
	__property TProfGridGetEditControlResultEvent OnGetEditControlResult = {read=FOnGetEditControlResult, write=FOnGetEditControlResult};
	__property TProfGridGetEditControlTextEvent OnGetEditControlText = {read=FOnGetEditControlText, write=FOnGetEditControlText};
	__property TProfGridExportImportProgressEvent OnImportProgress = {read=FOnImportProgress, write=FOnImportProgress};
	__property TProfGridKeyPressExEvent OnKeyPressEx = {read=FOnKeyPressEx, write=FOnKeyPressEx};
	__property TProfGridPasteEvent OnPaste = {read=FOnPaste, write=FOnPaste};
	__property TProfGridPasteGraphicsEvent OnPasteGraphics = {read=FOnPasteGraphics, write=FOnPasteGraphics};
	__property TProfGridPastePlainTextEvent OnPastePlainText = {read=FOnPastePlainText, write=FOnPastePlainText};
	__property TProfGridPrintEvent OnPrintPageBegin = {read=FOnPrintPageBegin, write=FOnPrintPageBegin};
	__property TProfGridPrintEvent OnPrintPageContinued = {read=FOnPrintPageContinued, write=FOnPrintPageContinued};
	__property TProfGridRecalculateCellEvent OnRecalculateCell = {read=FOnRecalculateCell, write=FOnRecalculateCell};
	__property Classes::TNotifyEvent OnRecalculated = {read=FOnRecalculated, write=FOnRecalculated};
	__property TProfGridResizeRowEvent OnResizeRow = {read=FOnResizeRow, write=FOnResizeRow};
	__property TProfGridColRowDragDropEvent OnRowDragDrop = {read=FOnRowDragDrop, write=FOnRowDragDrop};
	__property TProfGridColRowResizedEvent OnRowResized = {read=FOnRowResized, write=FOnRowResized};
	__property TProfGridColRowStartDragEvent OnRowStartDrag = {read=FOnRowStartDrag, write=FOnRowStartDrag};
	__property Grids::TSelectCellEvent OnSelectRange = {read=FOnSelectRange, write=FOnSelectRange};
	__property TProfGridShowHintEvent OnShowHint = {read=FOnShowHint, write=FOnShowHint};
	__property TProfGridShowScrollBarsEvent OnShowScrollBars = {read=FOnShowScrollBars, write=FOnShowScrollBars};
	__property Classes::TNotifyEvent OnStartSort = {read=FOnStartSort, write=FOnStartSort};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TProfGrid(HWND ParentWindow) : Grids::TCustomGrid(ParentWindow) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TProfGridCol : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TProfGrid* FParent;
	Classes::TList* FCells;
	int FId;
	TProfGridCompareProc FCompareProc;
	Graphics::TColor FGridLineColor;
	Graphics::TFont* FFont;
	Graphics::TFont* FOldFont;
	Graphics::TFont* FFixedFont;
	Graphics::TFont* FOldFixedFont;
	Graphics::TColor FColor;
	Graphics::TColor FFixedColor;
	Word FWidth;
	Word FMinWidth;
	Word FMaxWidth;
	Word FMaxLength;
	Word FFixedMaxLength;
	bool FReadOnly;
	bool FFixedReadOnly;
	bool FWordWrap;
	bool FFixedWordWrap;
	Classes::TAlignment FTextAlignment;
	Classes::TAlignment FFixedTextAlignment;
	Stdctrls::TTextLayout FTextLayout;
	Stdctrls::TTextLayout FFixedTextLayout;
	Classes::TAlignment FGraphicAlignment;
	Classes::TAlignment FFixedGraphicAlignment;
	Stdctrls::TTextLayout FGraphicLayout;
	Stdctrls::TTextLayout FFixedGraphicLayout;
	bool FButton;
	bool FFixedButton;
	bool FCheckBox;
	bool FFixedCheckBox;
	bool FCheckBoxChecked;
	bool FFixedCheckBoxChecked;
	Classes::TAlignment FCheckBoxAlignment;
	Classes::TAlignment FFixedCheckBoxAlignment;
	bool FFontUsed;
	bool FFixedFontUsed;
	Byte FGridLineWidth;
	bool FVisible;
	bool FMovable;
	bool FResizable;
	bool FTabStop;
	bool __fastcall Hide(void);
	int __fastcall Show(void);
	void __fastcall Invalidate(void);
	void __fastcall Sort(void);
	AnsiString __fastcall GetA1Name();
	int __fastcall GetAbsoluteNumber(void);
	TProfGridCell* __fastcall GetCells(int ARow);
	int __fastcall GetCol(void);
	TProfGridCompareProc __fastcall GetCompareProc(void);
	int __fastcall GetHiddenNumber(void);
	Graphics::TColor __fastcall GetGridLineColor(void);
	Byte __fastcall GetGridLineWidth(void);
	void __fastcall SetVisible(const bool Value);
	void __fastcall SetWidth(const Word Value);
	void __fastcall SetMaxWidth(const Word Value);
	void __fastcall SetMinWidth(const Word Value);
	void __fastcall SetGridLineColor(const Graphics::TColor Value);
	void __fastcall SetGridLineWidth(const Byte Value);
	Graphics::TFont* __fastcall CalcFont(void);
	void __fastcall FontChanged(System::TObject* Sender);
	Graphics::TFont* __fastcall CalcFixedFont(void);
	void __fastcall FixedFontChanged(System::TObject* Sender);
	void __fastcall DoSetButtonCheckbox(const bool AButton, const bool AFixed, const bool AValue);
	void __fastcall DoSetCheckBoxAlignment(const bool AFixed, Classes::TAlignment AValue);
	void __fastcall DoSetCheckBoxChecked(const bool AFixed, const bool AValue);
	void __fastcall DoSetColor(const bool AFixed, const Graphics::TColor AValue);
	void __fastcall DoSetGraphicAlignment(const bool AFixed, const Classes::TAlignment AValue);
	void __fastcall DoSetMaxLength(const bool AFixed, const Word AValue);
	void __fastcall DoSetReadOnly(const bool AFixed, const bool AValue);
	void __fastcall DoSetTextAlignment(const bool AFixed, const Classes::TAlignment AValue);
	void __fastcall DoSetTextGraphicLayout(const bool AText, const bool AFixed, const Stdctrls::TTextLayout AValue);
	void __fastcall DoSetWordWrap(const bool AFixed, const bool AValue);
	void __fastcall SetButton(const bool Value);
	void __fastcall SetCheckBox(const bool Value);
	void __fastcall SetCheckBoxChecked(const bool Value);
	void __fastcall SetCheckBoxAlignment(const Classes::TAlignment Value);
	Graphics::TColor __fastcall GetColor(void);
	void __fastcall SetColor(const Graphics::TColor Value);
	Graphics::TFont* __fastcall GetFont(void);
	void __fastcall SetFont(const Graphics::TFont* Value);
	void __fastcall SetGraphicAlignment(const Classes::TAlignment Value);
	void __fastcall SetGraphicLayout(const Stdctrls::TTextLayout Value);
	void __fastcall SetMaxLength(const Word Value);
	void __fastcall SetReadOnly(const bool Value);
	void __fastcall SetTextAlignment(const Classes::TAlignment Value);
	void __fastcall SetTextLayout(const Stdctrls::TTextLayout Value);
	void __fastcall SetWordWrap(const bool Value);
	void __fastcall SetFixedButton(const bool Value);
	void __fastcall SetFixedCheckBox(const bool Value);
	void __fastcall SetFixedCheckBoxChecked(const bool Value);
	void __fastcall SetFixedCheckBoxAlignment(const Classes::TAlignment Value);
	Graphics::TColor __fastcall GetFixedColor(void);
	void __fastcall SetFixedColor(const Graphics::TColor Value);
	Graphics::TFont* __fastcall GetFixedFont(void);
	void __fastcall SetFixedFont(const Graphics::TFont* Value);
	void __fastcall SetFixedGraphicAlignment(const Classes::TAlignment Value);
	void __fastcall SetFixedGraphicLayout(const Stdctrls::TTextLayout Value);
	void __fastcall SetFixedMaxLength(const Word Value);
	void __fastcall SetFixedReadOnly(const bool Value);
	void __fastcall SetFixedTextAlignment(const Classes::TAlignment Value);
	void __fastcall SetFixedTextLayout(const Stdctrls::TTextLayout Value);
	void __fastcall SetFixedWordWrap(const bool Value);
	
public:
	__fastcall TProfGridCol(const TProfGrid* AParent);
	__fastcall virtual ~TProfGridCol(void);
	__property AnsiString A1Name = {read=GetA1Name};
	__property int AbsoluteNumber = {read=GetAbsoluteNumber, nodefault};
	__property TProfGridCell* Cells[int ARow] = {read=GetCells};
	__property int Col = {read=GetCol, nodefault};
	__property TProfGridCompareProc CompareProc = {read=GetCompareProc, write=FCompareProc};
	__property Graphics::TColor GridLineColor = {read=GetGridLineColor, write=SetGridLineColor, nodefault};
	__property Byte GridLineWidth = {read=GetGridLineWidth, write=SetGridLineWidth, nodefault};
	__property int HiddenNumber = {read=GetHiddenNumber, nodefault};
	__property int ID = {read=FId, nodefault};
	__property Word MaxWidth = {read=FMaxWidth, write=SetMaxWidth, nodefault};
	__property Word MinWidth = {read=FMinWidth, write=SetMinWidth, nodefault};
	__property bool Movable = {read=FMovable, write=FMovable, nodefault};
	__property bool Resizable = {read=FResizable, write=FResizable, nodefault};
	__property bool TabStop = {read=FTabStop, write=FTabStop, nodefault};
	__property bool Visible = {read=FVisible, write=SetVisible, nodefault};
	__property Word Width = {read=FWidth, write=SetWidth, nodefault};
	__property bool Button = {read=FButton, write=SetButton, nodefault};
	__property bool FixedRowsButton = {read=FFixedButton, write=SetFixedButton, nodefault};
	__property bool CheckBox = {read=FCheckBox, write=SetCheckBox, nodefault};
	__property bool FixedRowsCheckBox = {read=FFixedCheckBox, write=SetFixedCheckBox, nodefault};
	__property Classes::TAlignment CheckBoxAlignment = {read=FCheckBoxAlignment, write=SetCheckBoxAlignment, nodefault};
	__property Classes::TAlignment FixedRowsCheckBoxAlignment = {read=FFixedCheckBoxAlignment, write=SetFixedCheckBoxAlignment, nodefault};
	__property bool CheckBoxChecked = {read=FCheckBoxChecked, write=SetCheckBoxChecked, nodefault};
	__property bool FixedRowsCheckBoxChecked = {read=FFixedCheckBoxChecked, write=SetFixedCheckBoxChecked, nodefault};
	__property Graphics::TColor Color = {read=GetColor, write=SetColor, nodefault};
	__property Graphics::TColor FixedRowsColor = {read=GetFixedColor, write=SetFixedColor, nodefault};
	__property Graphics::TFont* Font = {read=GetFont, write=SetFont};
	__property Graphics::TFont* FixedRowsFont = {read=GetFixedFont, write=SetFixedFont};
	__property Classes::TAlignment GraphicAlignment = {read=FGraphicAlignment, write=SetGraphicAlignment, nodefault};
	__property Classes::TAlignment FixedRowsGraphicAlignment = {read=FFixedGraphicAlignment, write=SetFixedGraphicAlignment, nodefault};
	__property Stdctrls::TTextLayout GraphicLayout = {read=FGraphicLayout, write=SetGraphicLayout, nodefault};
	__property Stdctrls::TTextLayout FixedRowsGraphicLayout = {read=FFixedGraphicLayout, write=SetFixedGraphicLayout, nodefault};
	__property Word MaxLength = {read=FMaxLength, write=SetMaxLength, nodefault};
	__property Word FixedRowsMaxLength = {read=FFixedMaxLength, write=SetFixedMaxLength, nodefault};
	__property bool ReadOnly = {read=FReadOnly, write=SetReadOnly, nodefault};
	__property bool FixedRowsReadOnly = {read=FFixedReadOnly, write=SetFixedReadOnly, nodefault};
	__property Classes::TAlignment TextAlignment = {read=FTextAlignment, write=SetTextAlignment, nodefault};
	__property Classes::TAlignment FixedRowsTextAlignment = {read=FFixedTextAlignment, write=SetFixedTextAlignment, nodefault};
	__property Stdctrls::TTextLayout TextLayout = {read=FTextLayout, write=SetTextLayout, nodefault};
	__property Stdctrls::TTextLayout FixedRowsTextLayout = {read=FFixedTextLayout, write=SetFixedTextLayout, nodefault};
	__property bool WordWrap = {read=FWordWrap, write=SetWordWrap, nodefault};
	__property bool FixedRowsWordWrap = {read=FFixedWordWrap, write=SetFixedWordWrap, nodefault};
};


struct TProfGridCellProperties;
typedef TProfGridCellProperties *PProfGridCellProperties;

class DELPHICLASS TProfGridCellOuterBorder;
class PASCALIMPLEMENTATION TProfGridCell : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FStartRow;
	TProfGridCol* FStartCol;
	TProfGridCellProperties *FProperties;
	Variant FValue;
	int __fastcall CalcHeight(const int EditorRequestedHeight);
	Graphics::TFont* __fastcall CalcFont(void);
	bool __fastcall DoPasteGraphic(const Graphics::TGraphic* AGraphic);
	bool __fastcall DoPasteText(AnsiString &AText);
	void __fastcall FontChanged(System::TObject* Sender);
	bool __fastcall FontUsed(void);
	void __fastcall Invalidate(void);
	AnsiString __fastcall GetA1Name();
	bool __fastcall GetButton(void);
	bool __fastcall GetCheckBox(void);
	Classes::TAlignment __fastcall GetCheckBoxAlignment(void);
	bool __fastcall GetCheckBoxChecked(void);
	Graphics::TColor __fastcall GetColor(void);
	int __fastcall GetEndCol(void);
	bool __fastcall GetFixed(void);
	Graphics::TFont* __fastcall GetFont(void);
	Graphics::TGraphic* __fastcall GetGraphic(void);
	Classes::TAlignment __fastcall GetGraphicAlignment(void);
	Stdctrls::TTextLayout __fastcall GetGraphicLayout(void);
	TProfGridCellInnerBorder* __fastcall GetInnerBorder(void);
	Word __fastcall GetMaxLength(void);
	TProfGridCellOuterBorder* __fastcall GetOuterBorder(void);
	bool __fastcall GetReadOnly(void);
	bool __fastcall GetSelected(void);
	Graphics::TColor __fastcall GetSelectedColor(void);
	Graphics::TColor __fastcall GetSelectedFontColor(void);
	int __fastcall GetStartCol(void);
	AnsiString __fastcall GetText();
	Classes::TAlignment __fastcall GetTextAlignment(void);
	Stdctrls::TTextLayout __fastcall GetTextLayout(void);
	bool __fastcall GetVisible(void);
	bool __fastcall GetWordWrap(void);
	void __fastcall SetButton(const bool AValue);
	void __fastcall SetCheckBox(const bool AValue);
	void __fastcall SetCheckBoxAlignment(const Classes::TAlignment AValue);
	void __fastcall SetCheckBoxChecked(const bool AValue);
	void __fastcall SetColor(const Graphics::TColor AValue);
	void __fastcall SetFont(const Graphics::TFont* AValue);
	void __fastcall SetFormula(const AnsiString AValue);
	void __fastcall SetGraphic(const Graphics::TGraphic* AValue);
	void __fastcall SetGraphicAlignment(const Classes::TAlignment AValue);
	void __fastcall SetGraphicLayout(const Stdctrls::TTextLayout AValue);
	void __fastcall SetMaxLength(const Word AValue);
	void __fastcall SetReadOnly(const bool AValue);
	void __fastcall SetSelected(const bool AValue);
	void __fastcall SetSelectedColor(const Graphics::TColor AValue);
	void __fastcall SetSelectedFontColor(const Graphics::TColor AValue);
	void __fastcall SetText(const AnsiString AValue);
	void __fastcall SetTextAlignment(const Classes::TAlignment AValue);
	void __fastcall SetTextLayout(const Stdctrls::TTextLayout AValue);
	void __fastcall SetValue(const Variant &AValue);
	void __fastcall SetWordWrap(const bool AValue);
	void __fastcall CreateProperties(void);
	void __fastcall CheckProperties(void);
	int __fastcall ReadFEndRow(void);
	TProfGridCol* __fastcall ReadFEndCol(void);
	AnsiString __fastcall ReadFFormula();
	Graphics::TFont* __fastcall ReadFFont(void);
	Graphics::TPicture* __fastcall ReadFPicture(void);
	Graphics::TColor __fastcall ReadFColor(void);
	Graphics::TColor __fastcall ReadFSelectedColor(void);
	Graphics::TColor __fastcall ReadFSelectedFontColor(void);
	AnsiString __fastcall ReadFHint();
	System::TObject* __fastcall ReadFObject(void);
	Word __fastcall ReadFMaxLength(void);
	Byte __fastcall ReadFReadOnly(void);
	Byte __fastcall ReadFWordWrap(void);
	Byte __fastcall ReadFCheckBox(void);
	Byte __fastcall ReadFCheckBoxAlignment(void);
	Byte __fastcall ReadFCheckBoxChecked(void);
	Byte __fastcall ReadFButton(void);
	Byte __fastcall ReadFTextAlignment(void);
	Byte __fastcall ReadFTextLayout(void);
	Byte __fastcall ReadFGraphicAlignment(void);
	Byte __fastcall ReadFGraphicLayout(void);
	TProfGridCellInnerBorder* __fastcall ReadFInnerBorder(void);
	TProfGridCellOuterBorder* __fastcall ReadFOuterBorder(void);
	bool __fastcall ReadFFontUsed(void);
	bool __fastcall ReadFButtonPushed(void);
	bool __fastcall ReadFError(void);
	void __fastcall WriteFEndRow(const int AValue);
	void __fastcall WriteFEndCol(const TProfGridCol* AValue);
	void __fastcall WriteFFormula(const AnsiString AValue);
	void __fastcall WriteFFont(const Graphics::TFont* AValue);
	void __fastcall WriteFPicture(const Graphics::TPicture* AValue);
	void __fastcall WriteFColor(const Graphics::TColor AValue);
	void __fastcall WriteFSelectedColor(const Graphics::TColor AValue);
	void __fastcall WriteFSelectedFontColor(const Graphics::TColor AValue);
	void __fastcall WriteFHint(const AnsiString AValue);
	void __fastcall WriteFObject(const System::TObject* AValue);
	void __fastcall WriteFMaxLength(const Word AValue);
	void __fastcall WriteFReadOnly(const Byte AValue);
	void __fastcall WriteFWordWrap(const Byte AValue);
	void __fastcall WriteFCheckBox(const Byte AValue);
	void __fastcall WriteFCheckBoxAlignment(const Byte AValue);
	void __fastcall WriteFCheckBoxChecked(const Byte AValue);
	void __fastcall WriteFButton(const Byte AValue);
	void __fastcall WriteFTextAlignment(const Byte AValue);
	void __fastcall WriteFTextLayout(const Byte AValue);
	void __fastcall WriteFGraphicAlignment(const Byte AValue);
	void __fastcall WriteFGraphicLayout(const Byte AValue);
	void __fastcall WriteFInnerBorder(const TProfGridCellInnerBorder* AValue);
	void __fastcall WriteFOuterBorder(const TProfGridCellOuterBorder* AValue);
	void __fastcall WriteFFontUsed(const bool AValue);
	void __fastcall WriteFButtonPushed(const bool AValue);
	void __fastcall WriteFError(const bool AValue);
	__property int FEndRow = {read=ReadFEndRow, write=WriteFEndRow, nodefault};
	__property TProfGridCol* FEndCol = {read=ReadFEndCol, write=WriteFEndCol};
	__property AnsiString FFormula = {read=ReadFFormula, write=WriteFFormula};
	__property Graphics::TFont* FFont = {read=ReadFFont, write=WriteFFont};
	__property Graphics::TPicture* FPicture = {read=ReadFPicture, write=WriteFPicture};
	__property Graphics::TColor FColor = {read=ReadFColor, write=WriteFColor, nodefault};
	__property Graphics::TColor FSelectedColor = {read=ReadFSelectedColor, write=WriteFSelectedColor, nodefault};
	__property Graphics::TColor FSelectedFontColor = {read=ReadFSelectedFontColor, write=WriteFSelectedFontColor, nodefault};
	__property Word FMaxLength = {read=ReadFMaxLength, write=WriteFMaxLength, nodefault};
	__property Byte FReadOnly = {read=ReadFReadOnly, write=WriteFReadOnly, nodefault};
	__property Byte FWordWrap = {read=ReadFWordWrap, write=WriteFWordWrap, nodefault};
	__property Byte FCheckBox = {read=ReadFCheckBox, write=WriteFCheckBox, nodefault};
	__property Byte FCheckBoxAlignment = {read=ReadFCheckBoxAlignment, write=WriteFCheckBoxAlignment, nodefault};
	__property Byte FCheckBoxChecked = {read=ReadFCheckBoxChecked, write=WriteFCheckBoxChecked, nodefault};
	__property Byte FButton = {read=ReadFButton, write=WriteFButton, nodefault};
	__property Byte FTextAlignment = {read=ReadFTextAlignment, write=WriteFTextAlignment, nodefault};
	__property Byte FTextLayout = {read=ReadFTextLayout, write=WriteFTextLayout, nodefault};
	__property Byte FGraphicAlignment = {read=ReadFGraphicAlignment, write=WriteFGraphicAlignment, nodefault};
	__property Byte FGraphicLayout = {read=ReadFGraphicLayout, write=WriteFGraphicLayout, nodefault};
	__property TProfGridCellInnerBorder* FInnerBorder = {read=ReadFInnerBorder, write=WriteFInnerBorder};
	__property TProfGridCellOuterBorder* FOuterBorder = {read=ReadFOuterBorder, write=WriteFOuterBorder};
	__property bool FFontUsed = {read=ReadFFontUsed, write=WriteFFontUsed, nodefault};
	__property bool FButtonPushed = {read=ReadFButtonPushed, write=WriteFButtonPushed, nodefault};
	__property bool FError = {read=ReadFError, write=WriteFError, nodefault};
	
public:
	__fastcall TProfGridCell(const TProfGridCol* ACol, const int ARow);
	__fastcall virtual ~TProfGridCell(void);
	bool __fastcall CopyToClipboard(void);
	bool __fastcall CutToClipboard(void);
	bool __fastcall IsEmpty(void);
	bool __fastcall PasteFromClipboard(void);
	bool __fastcall Recalculate(void);
	bool __fastcall Split(void);
	__property Variant Value = {read=FValue, write=SetValue};
	__property AnsiString Formula = {read=ReadFFormula, write=SetFormula};
	__property AnsiString Text = {read=GetText, write=SetText};
	__property AnsiString A1Name = {read=GetA1Name};
	__property bool Button = {read=GetButton, write=SetButton, nodefault};
	__property System::TObject* CellObject = {read=ReadFObject, write=WriteFObject};
	__property bool CheckBox = {read=GetCheckBox, write=SetCheckBox, nodefault};
	__property Classes::TAlignment CheckBoxAlignment = {read=GetCheckBoxAlignment, write=SetCheckBoxAlignment, nodefault};
	__property bool CheckBoxChecked = {read=GetCheckBoxChecked, write=SetCheckBoxChecked, nodefault};
	__property Graphics::TColor Color = {read=GetColor, write=SetColor, nodefault};
	__property int EndCol = {read=GetEndCol, nodefault};
	__property int EndRow = {read=ReadFEndRow, nodefault};
	__property bool Fixed = {read=GetFixed, nodefault};
	__property Graphics::TFont* Font = {read=GetFont, write=SetFont};
	__property Graphics::TGraphic* Graphic = {read=GetGraphic, write=SetGraphic};
	__property Classes::TAlignment GraphicAlignment = {read=GetGraphicAlignment, write=SetGraphicAlignment, nodefault};
	__property Stdctrls::TTextLayout GraphicLayout = {read=GetGraphicLayout, write=SetGraphicLayout, nodefault};
	__property AnsiString Hint = {read=ReadFHint, write=WriteFHint};
	__property TProfGridCellInnerBorder* InnerBorder = {read=GetInnerBorder};
	__property TProfGridCellOuterBorder* OuterBorder = {read=GetOuterBorder};
	__property Word MaxLength = {read=GetMaxLength, write=SetMaxLength, nodefault};
	__property bool ReadOnly = {read=GetReadOnly, write=SetReadOnly, nodefault};
	__property bool Selected = {read=GetSelected, write=SetSelected, nodefault};
	__property Graphics::TColor SelectedColor = {read=GetSelectedColor, write=SetSelectedColor, nodefault};
	__property Graphics::TColor SelectedFontColor = {read=GetSelectedFontColor, write=SetSelectedFontColor, nodefault};
	__property int StartRow = {read=FStartRow, nodefault};
	__property int StartCol = {read=GetStartCol, nodefault};
	__property Classes::TAlignment TextAlignment = {read=GetTextAlignment, write=SetTextAlignment, nodefault};
	__property Stdctrls::TTextLayout TextLayout = {read=GetTextLayout, write=SetTextLayout, nodefault};
	__property bool Visible = {read=GetVisible, nodefault};
	__property bool WordWrap = {read=GetWordWrap, write=SetWordWrap, nodefault};
};


class PASCALIMPLEMENTATION TProfGridCellInnerBorder : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	TProfGridCell* FOwner;
	Graphics::TColor FColor;
	Byte FWidth;
	virtual void __fastcall SetColor(const Graphics::TColor Value);
	virtual void __fastcall SetWidth(const Byte Value);
	
public:
	__fastcall TProfGridCellInnerBorder(const TProfGridCell* AOwner);
	__property Graphics::TColor Color = {read=FColor, write=SetColor, nodefault};
	__property Byte Width = {read=FWidth, write=SetWidth, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TProfGridCellInnerBorder(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TProfGridCellOuterBorder : public TProfGridCellInnerBorder 
{
	typedef TProfGridCellInnerBorder inherited;
	
protected:
	virtual void __fastcall SetColor(const Graphics::TColor Value);
	virtual void __fastcall SetWidth(const Byte Value);
public:
	#pragma option push -w-inl
	/* TProfGridCellInnerBorder.Create */ inline __fastcall TProfGridCellOuterBorder(const TProfGridCell* AOwner) : TProfGridCellInnerBorder(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TProfGridCellOuterBorder(void) { }
	#pragma option pop
	
};


#pragma pack(push, 4)
struct TProfGridCellProperties
{
	AnsiString FFormula;
	AnsiString FHint;
	Graphics::TFont* FFont;
	Graphics::TPicture* FPicture;
	TProfGridCellInnerBorder* FInnerBorder;
	TProfGridCellOuterBorder* FOuterBorder;
	System::TObject* FObject;
	TProfGridCol* FEndCol;
	int FEndRow;
	Graphics::TColor FColor;
	Graphics::TColor FSelectedColor;
	Graphics::TColor FSelectedFontColor;
	Word FMaxLength;
	Byte FReadOnly;
	Byte FWordWrap;
	Byte FCheckBox;
	Byte FCheckBoxAlignment;
	Byte FCheckBoxChecked;
	Byte FButton;
	Byte FTextAlignment;
	Byte FTextLayout;
	Byte FGraphicAlignment;
	Byte FGraphicLayout;
	bool FFontUsed;
	bool FButtonPushed;
	bool FError;
} ;
#pragma pack(pop)

class PASCALIMPLEMENTATION TProfGridClipboardCell : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	int FCol;
	int FRow;
	Graphics::TFont* FFont;
	Variant FValue;
	AnsiString FFormula;
	AnsiString FHint;
	Graphics::TPicture* FPicture;
	System::TObject* FObject;
	Graphics::TColor FColor;
	Graphics::TColor FSelectedColor;
	Graphics::TColor FSelectedFontColor;
	Graphics::TColor FInnerborderColor;
	Graphics::TColor FOuterBorderColor;
	Word FMaxLength;
	Byte FInnerBorderWidth;
	Byte FOuterBorderWidth;
	Classes::TAlignment FTextAlignment;
	Classes::TAlignment FGraphicAlignment;
	Classes::TAlignment FCheckBoxAlignment;
	Stdctrls::TTextLayout FTextLayout;
	Stdctrls::TTextLayout FGraphicLayout;
	bool FReadOnly;
	bool FWordWrap;
	bool FCheckBox;
	bool FCheckBoxChecked;
	bool FButton;
	Graphics::TGraphic* __fastcall GetGraphic(void);
	void __fastcall SetFont(const Graphics::TFont* AFont);
	void __fastcall SetGraphic(const Graphics::TGraphic* AGraphic);
	
public:
	__fastcall virtual TProfGridClipboardCell(Classes::TComponent* AOwner);
	__fastcall virtual ~TProfGridClipboardCell(void);
	__property Graphics::TGraphic* Graphic = {read=GetGraphic, write=SetGraphic};
	
__published:
	__property int Col = {read=FCol, write=FCol, nodefault};
	__property int Row = {read=FRow, write=FRow, nodefault};
	__property Variant Value = {read=FValue, write=FValue};
	__property AnsiString Formula = {read=FFormula, write=FFormula};
	__property AnsiString Hint = {read=FHint, write=FHint};
	__property Graphics::TPicture* Picture = {read=FPicture, write=FPicture};
	__property Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property Graphics::TColor Color = {read=FColor, write=FColor, nodefault};
	__property Classes::TAlignment TextAlignment = {read=FTextAlignment, write=FTextAlignment, nodefault};
	__property Stdctrls::TTextLayout TextLayout = {read=FTextLayout, write=FTextLayout, nodefault};
	__property Classes::TAlignment GraphicAlignment = {read=FGraphicAlignment, write=FGraphicAlignment, nodefault};
	__property Stdctrls::TTextLayout GraphicLayout = {read=FGraphicLayout, write=FGraphicLayout, nodefault};
	__property Word MaxLength = {read=FMaxLength, write=FMaxLength, nodefault};
	__property bool ReadOnly = {read=FReadOnly, write=FReadOnly, nodefault};
	__property bool WordWrap = {read=FWordWrap, write=FWordWrap, nodefault};
	__property bool CheckBox = {read=FCheckBox, write=FCheckBox, nodefault};
	__property bool CheckBoxChecked = {read=FCheckBoxChecked, write=FCheckBoxChecked, nodefault};
	__property Classes::TAlignment CheckBoxAlignment = {read=FCheckBoxAlignment, write=FCheckBoxAlignment, nodefault};
	__property Byte InnerBorderWidth = {read=FInnerBorderWidth, write=FInnerBorderWidth, nodefault};
	__property Graphics::TColor InnerBorderColor = {read=FInnerborderColor, write=FInnerborderColor, nodefault};
	__property Byte OuterBorderWidth = {read=FOuterBorderWidth, write=FOuterBorderWidth, nodefault};
	__property Graphics::TColor OuterBorderColor = {read=FOuterBorderColor, write=FOuterBorderColor, nodefault};
	__property bool Button = {read=FButton, write=FButton, nodefault};
	__property Graphics::TColor SelectedColor = {read=FSelectedColor, write=FSelectedColor, nodefault};
	__property Graphics::TColor SelectedFontColor = {read=FSelectedFontColor, write=FSelectedFontColor, nodefault};
	__property System::TObject* CellObject = {read=FObject, write=FObject};
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);

}	/* namespace Profgrid */
using namespace Profgrid;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ProfGrid
