// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'PSJob.pas' rev: 5.00

#ifndef PSJobHPP
#define PSJobHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Math.hpp>	// Pascal unit
#include <PSCommon.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Printers.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Psjob
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TMargins;
class PASCALIMPLEMENTATION TMargins : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	double FLeft;
	double FTop;
	double FRight;
	double FBottom;
	
__published:
	__property double Left = {read=FLeft, write=FLeft};
	__property double Top = {read=FTop, write=FTop};
	__property double Right = {read=FRight, write=FRight};
	__property double Bottom = {read=FBottom, write=FBottom};
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TMargins(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TMargins(void) : Classes::TPersistent() { }
	#pragma option pop
	
};


#pragma option push -b-
enum TDrawTarget { dtPrint, dtPreview, dtMetaPreview };
#pragma option pop

#pragma option push -b-
enum TDrawArea { daHeader, daPage, daFooter };
#pragma option pop

typedef void __fastcall (__closure *TInitDrawEvent)(System::TObject* Sender, Graphics::TCanvas* TheCanvas
	, TDrawTarget Target);

typedef void __fastcall (__closure *TDrawEvent)(System::TObject* Sender, Graphics::TCanvas* TheCanvas
	, int PageIndex, const Windows::TRect &TheRect, TDrawArea Area, TDrawTarget Target);

typedef void __fastcall (__closure *TPSProgressEvent)(System::TObject* Sender, int Pos, int Min, int 
	Max);

typedef void __fastcall (__closure *TPageNotifyEvent)(System::TObject* Sender, int PageIndex);

#pragma option push -b-
enum TUnits { unPixels, unPercents, unInches, unMillimeters };
#pragma option pop

#pragma option push -b-
enum TDirection { dirHorizontal, dirVertical };
#pragma option pop

#pragma option push -b-
enum TPageMode { pmDefault, pmCustom };
#pragma option pop

#pragma option push -b-
enum TPageOrientation { orDefault, orPortrait, orLandscape };
#pragma option pop

#pragma option push -b-
enum TJobOptions { joMargins, joHeader, joFooter };
#pragma option pop

typedef Set<TJobOptions, joMargins, joFooter>  TJobOptionsSet;

#pragma option push -b-
enum TStretchMode { sm1x1, smFit, smStretch, sm50, sm75, sm125, sm150, sm175, sm200 };
#pragma option pop

#pragma option push -b-
enum TAlignHorizontal { ahLeft, ahCenter, ahRight };
#pragma option pop

#pragma option push -b-
enum TAlignVertical { avTop, avCenter, avBottom };
#pragma option pop

class DELPHICLASS EPrintJobException;
class PASCALIMPLEMENTATION EPrintJobException : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EPrintJobException(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EPrintJobException(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EPrintJobException(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EPrintJobException(int Ident, const System::TVarRec 
		* Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EPrintJobException(const AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EPrintJobException(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EPrintJobException(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EPrintJobException(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EPrintJobException(void) { }
	#pragma option pop
	
};


class DELPHICLASS TCustomPrintJob;
class PASCALIMPLEMENTATION TCustomPrintJob : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	bool FSmartUpdate;
	bool FNeedUpdate;
	Forms::TIdleEvent FSavedIdle;
	bool FMustAbort;
	int FUpdateLocker;
	int FUpdateJobsLocker;
	int FUpdateControlsLocker;
	int FDrawLocker;
	Classes::TList* FControls;
	Classes::TList* FPrintJobs;
	Classes::TNotifyEvent FOnCreate;
	Classes::TNotifyEvent FOnDestroy;
	TInitDrawEvent FOnInitDraw;
	TDrawEvent FOnDraw;
	Classes::TNotifyEvent FOnPrinterSetupChange;
	Classes::TNotifyEvent FOnStartPrint;
	Classes::TNotifyEvent FOnEndPrint;
	TPSProgressEvent FOnPrintProgress;
	TPageNotifyEvent FOnStartPrintPage;
	TPageNotifyEvent FOnEndPrintPage;
	Classes::TNotifyEvent FOnUpdate;
	int FPageCount;
	AnsiString FTitle;
	TMargins* FMargins;
	TUnits FMarginsUnits;
	double FHeader;
	TUnits FHeaderUnits;
	double FFooter;
	TUnits FFooterUnits;
	TPageMode FPageMode;
	double FPageWidth;
	double FPageHeight;
	TUnits FPageUnits;
	TPageOrientation FOrientation;
	TJobOptionsSet FOptions;
	void __fastcall ApplicationIdle(System::TObject* Sender, bool &Done);
	bool __fastcall GetAborted(void);
	void __fastcall SetPageCount(const int Value);
	void __fastcall SetMargins(const TMargins* Value);
	void __fastcall SetMarginsUnits(const TUnits Value);
	void __fastcall SetHeader(const double Value);
	void __fastcall SetHeaderUnits(const TUnits Value);
	void __fastcall SetFooter(const double Value);
	void __fastcall SetFooterUnits(const TUnits Value);
	void __fastcall SetPageMode(const TPageMode Value);
	void __fastcall SetPageWidth(const double Value);
	void __fastcall SetPageHeight(const double Value);
	void __fastcall SetPageUnits(const TUnits Value);
	void __fastcall SetOrientation(const TPageOrientation Value);
	void __fastcall SetOptions(const TJobOptionsSet Value);
	bool __fastcall GetUpdateLocked(void);
	bool __fastcall GetUpdateJobsLocked(void);
	bool __fastcall GetUpdateControlsLocked(void);
	bool __fastcall GetDrawLocked(void);
	int __fastcall GetPhysicalPageWidth(void);
	int __fastcall GetPhysicalPageHeight(void);
	
protected:
	__property Classes::TNotifyEvent OnCreate = {read=FOnCreate, write=FOnCreate};
	__property Classes::TNotifyEvent OnDestroy = {read=FOnDestroy, write=FOnDestroy};
	__property TInitDrawEvent OnInitDraw = {read=FOnInitDraw, write=FOnInitDraw};
	__property TDrawEvent OnDraw = {read=FOnDraw, write=FOnDraw};
	__property Classes::TNotifyEvent OnPrinterSetupChange = {read=FOnPrinterSetupChange, write=FOnPrinterSetupChange
		};
	__property Classes::TNotifyEvent OnStartPrint = {read=FOnStartPrint, write=FOnStartPrint};
	__property Classes::TNotifyEvent OnEndPrint = {read=FOnEndPrint, write=FOnEndPrint};
	__property TPSProgressEvent OnPrintProgress = {read=FOnPrintProgress, write=FOnPrintProgress};
	__property TPageNotifyEvent OnStartPrintPage = {read=FOnStartPrintPage, write=FOnStartPrintPage};
	__property TPageNotifyEvent OnEndPrintPage = {read=FOnEndPrintPage, write=FOnEndPrintPage};
	__property Classes::TNotifyEvent OnUpdate = {read=FOnUpdate, write=FOnUpdate};
	
public:
	__fastcall virtual TCustomPrintJob(Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomPrintJob(void);
	void __fastcall LockUpdate(void);
	void __fastcall UnlockUpdate(void);
	void __fastcall LockJobsUpdate(void);
	void __fastcall UnlockJobsUpdate(void);
	void __fastcall LockControlsUpdate(void);
	void __fastcall UnlockControlsUpdate(void);
	void __fastcall LockDraw(void);
	void __fastcall UnlockDraw(void);
	virtual void __fastcall InitDraw(Graphics::TCanvas* TheCanvas, TDrawTarget Target);
	virtual void __fastcall Draw(Graphics::TCanvas* TheCanvas, int PageIndex, TDrawTarget Target);
	virtual void __fastcall DrawArea(Graphics::TCanvas* TheCanvas, int PageIndex, const Windows::TRect 
		&Rect, TDrawArea Area, TDrawTarget Target);
	virtual void __fastcall PrinterSetupChange(void);
	virtual void __fastcall StartPrint(void);
	virtual void __fastcall EndPrint(void);
	virtual void __fastcall PrintProgress(int CurPage, int MinPage, int MaxPage);
	virtual void __fastcall StartPrintPage(int PageIndex);
	virtual void __fastcall EndPrintPage(int PageIndex);
	virtual void __fastcall Print(void);
	virtual void __fastcall PrintDialog(void);
	virtual void __fastcall PrinterSetupDialog(void);
	virtual void __fastcall Abort(void);
	virtual Windows::TRect __fastcall GetSheetRect();
	virtual Windows::TRect __fastcall GetPrintableRect();
	virtual Windows::TRect __fastcall GetMarginRect();
	virtual Windows::TRect __fastcall GetHeaderRect();
	virtual Windows::TRect __fastcall GetPageRect();
	virtual Windows::TRect __fastcall GetFooterRect();
	virtual void __fastcall ResetToDefaultPage(void);
	virtual bool __fastcall PrinterOK(void);
	virtual void __fastcall Update(void);
	virtual void __fastcall ApplyUpdates(void);
	void __fastcall AddControlNotification(Controls::TControl* AControl);
	void __fastcall DeleteControlNotification(Controls::TControl* AControl);
	void __fastcall AddPrintJobNotification(TCustomPrintJob* APrintJob);
	void __fastcall DeletePrintJobNotification(TCustomPrintJob* APrintJob);
	void __fastcall DrawBitmap(Graphics::TCanvas* TheCanvas, const Windows::TRect &Rect, Graphics::TBitmap* 
		Bitmap, TDrawTarget Target);
	void __fastcall StretchBitmap(Graphics::TCanvas* TheCanvas, const Windows::TRect &Rect, Graphics::TBitmap* 
		Bitmap, TStretchMode StretchMode, TAlignHorizontal AlignHorizontal, TAlignVertical AlignVertical, 
		TDrawTarget Target);
	int __fastcall DPIX(void);
	int __fastcall DPIY(void);
	double __fastcall InchToMm(double Inches);
	double __fastcall MmToInch(double Millimeters);
	double __fastcall InchToPix(double Inches, TDirection Direction);
	double __fastcall MmToPix(double Millimeters, TDirection Direction);
	double __fastcall PixToMm(double Pixels, TDirection Direction);
	double __fastcall PixToInch(double Pixels, TDirection Direction);
	double __fastcall ConvertUnits(double Source, TUnits FromUnits, TUnits ToUnits, TDirection Dir, double 
		FullRange);
	void __fastcall ConvertMargins(TMargins* M, TUnits FromUnits, TUnits ToUnits);
	__property bool UpdateLocked = {read=GetUpdateLocked, nodefault};
	__property bool UpdateJobsLocked = {read=GetUpdateJobsLocked, nodefault};
	__property bool UpdateControlsLocked = {read=GetUpdateControlsLocked, nodefault};
	__property bool DrawLocked = {read=GetDrawLocked, nodefault};
	__property bool Aborted = {read=GetAborted, nodefault};
	__property int PageCount = {read=FPageCount, write=SetPageCount, nodefault};
	__property AnsiString Title = {read=FTitle, write=FTitle};
	__property TMargins* Margins = {read=FMargins, write=SetMargins};
	__property TUnits MarginsUnits = {read=FMarginsUnits, write=SetMarginsUnits, nodefault};
	__property double Header = {read=FHeader, write=SetHeader};
	__property TUnits HeaderUnits = {read=FHeaderUnits, write=SetHeaderUnits, nodefault};
	__property double Footer = {read=FFooter, write=SetFooter};
	__property TUnits FooterUnits = {read=FFooterUnits, write=SetFooterUnits, nodefault};
	__property TPageMode PageMode = {read=FPageMode, write=SetPageMode, nodefault};
	__property double PageWidth = {read=FPageWidth, write=SetPageWidth};
	__property double PageHeight = {read=FPageHeight, write=SetPageHeight};
	__property int PhysicalPageWidth = {read=GetPhysicalPageWidth, nodefault};
	__property int PhysicalPageHeight = {read=GetPhysicalPageHeight, nodefault};
	__property TUnits PageUnits = {read=FPageUnits, write=SetPageUnits, nodefault};
	__property TPageOrientation Orientation = {read=FOrientation, write=SetOrientation, nodefault};
	__property TJobOptionsSet Options = {read=FOptions, write=SetOptions, nodefault};
};


class DELPHICLASS TPrintJob;
class PASCALIMPLEMENTATION TPrintJob : public TCustomPrintJob 
{
	typedef TCustomPrintJob inherited;
	
__published:
	__property PageCount ;
	__property Title ;
	__property Margins ;
	__property MarginsUnits ;
	__property Header ;
	__property HeaderUnits ;
	__property Footer ;
	__property FooterUnits ;
	__property PageMode ;
	__property PageWidth ;
	__property PageHeight ;
	__property PageUnits ;
	__property Orientation ;
	__property Options ;
	__property OnCreate ;
	__property OnDestroy ;
	__property OnInitDraw ;
	__property OnDraw ;
	__property OnPrinterSetupChange ;
	__property OnStartPrint ;
	__property OnEndPrint ;
	__property OnPrintProgress ;
	__property OnStartPrintPage ;
	__property OnEndPrintPage ;
	__property OnUpdate ;
public:
	#pragma option push -w-inl
	/* TCustomPrintJob.Create */ inline __fastcall virtual TPrintJob(Classes::TComponent* AOwner) : TCustomPrintJob(
		AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomPrintJob.Destroy */ inline __fastcall virtual ~TPrintJob(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);

}	/* namespace Psjob */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Psjob;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// PSJob
