// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'PJGrid.pas' rev: 5.00

#ifndef PJGridHPP
#define PJGridHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <PSJob.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Pjgrid
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TCellBorder { cbTop, cbLeft, cbRight, cbBottom };
#pragma option pop

typedef Set<TCellBorder, cbTop, cbBottom>  TCellBorders;

#pragma option push -b-
enum TCellType { ctTable, ctHeader, ctPage, ctFooter };
#pragma option pop

typedef void __fastcall (__closure *TColWidthEvent)(System::TObject* Sender, Graphics::TCanvas* TheCanvas
	, int ACol, int &ColWidth);

typedef void __fastcall (__closure *TDrawCellEvent)(System::TObject* Sender, Graphics::TCanvas* TheCanvas
	, const Windows::TRect &Rect, int PageIndex, int ACol, int ARow, Psjob::TDrawTarget Target);

class DELPHICLASS TCustomGridPrintJob;
class PASCALIMPLEMENTATION TCustomGridPrintJob : public Psjob::TCustomPrintJob 
{
	typedef Psjob::TCustomPrintJob inherited;
	
private:
	int FColCount;
	int FRowCount;
	int FRowsPerPage;
	TCellBorders FTableBorders;
	TCellBorders FHeaderCellBorders;
	TCellBorders FPageCellBorders;
	TCellBorders FFooterCellBorders;
	bool FIndexColumn;
	int FIndexStart;
	void __fastcall SetColCount(const int Value);
	void __fastcall SetRowCount(const int Value);
	void __fastcall SetRowsPerPage(const int Value);
	void __fastcall SetTableBorders(const TCellBorders Value);
	void __fastcall SetHeaderCellBorders(const TCellBorders Value);
	void __fastcall SetPageCellBorders(const TCellBorders Value);
	void __fastcall SetFooterCellBorders(const TCellBorders Value);
	void __fastcall SetIndexColumn(const bool Value);
	void __fastcall SetIndexStart(const int Value);
	int __fastcall GetRowTop(int PageIndex, int R);
	
protected:
	__property int ColCount = {read=FColCount, write=SetColCount, nodefault};
	__property int RowCount = {read=FRowCount, write=SetRowCount, nodefault};
	__property int RowsPerPage = {read=FRowsPerPage, write=SetRowsPerPage, nodefault};
	__property TCellBorders TableBorders = {read=FTableBorders, write=SetTableBorders, nodefault};
	__property TCellBorders HeaderCellBorders = {read=FHeaderCellBorders, write=SetHeaderCellBorders, nodefault
		};
	__property TCellBorders PageCellBorders = {read=FPageCellBorders, write=SetPageCellBorders, nodefault
		};
	__property TCellBorders FooterCellBorders = {read=FFooterCellBorders, write=SetFooterCellBorders, nodefault
		};
	__property bool IndexColumn = {read=FIndexColumn, write=SetIndexColumn, nodefault};
	__property int IndexStart = {read=FIndexStart, write=SetIndexStart, nodefault};
	
public:
	__fastcall virtual TCustomGridPrintJob(Classes::TComponent* AOwner);
	virtual void __fastcall DrawCell(Graphics::TCanvas* TheCanvas, const Windows::TRect &Rect, int PageIndex
		, int ACol, int ARow, Psjob::TDrawTarget Target) = 0 ;
	virtual void __fastcall DrawBorders(Graphics::TCanvas* TheCanvas, const Windows::TRect &Rect, TCellType 
		CellType, Psjob::TDrawTarget Target);
	virtual void __fastcall Draw(Graphics::TCanvas* TheCanvas, int PageIndex, Psjob::TDrawTarget Target
		);
	virtual void __fastcall DrawArea(Graphics::TCanvas* TheCanvas, int PageIndex, const Windows::TRect 
		&Rect, Psjob::TDrawArea Area, Psjob::TDrawTarget Target);
	virtual int __fastcall GetColWidth(Graphics::TCanvas* TheCanvas, int ACol);
public:
	#pragma option push -w-inl
	/* TCustomPrintJob.Destroy */ inline __fastcall virtual ~TCustomGridPrintJob(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const int rowHeader = 0x80000001;
static const int rowFooter = 0x7fffffff;
static const Shortint colIndex = 0xffffffff;

}	/* namespace Pjgrid */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Pjgrid;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// PJGrid
