// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'planner.pas' rev: 5.00

#ifndef plannerHPP
#define plannerHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Printers.hpp>	// Pascal unit
#include <Mask.hpp>	// Pascal unit
#include <Menus.hpp>	// Pascal unit
#include <ComCtrls.hpp>	// Pascal unit
#include <RichEdit.hpp>	// Pascal unit
#include <Buttons.hpp>	// Pascal unit
#include <Grids.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Planner
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EPlannerError;
class PASCALIMPLEMENTATION EPlannerError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EPlannerError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EPlannerError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EPlannerError(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EPlannerError(int Ident, const System::TVarRec * Args
		, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EPlannerError(const AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EPlannerError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EPlannerError(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EPlannerError(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EPlannerError(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlannerItem;
typedef void __fastcall (__closure *TItemEvent)(System::TObject* Sender, TPlannerItem* Item);

typedef void __fastcall (__closure *TItemAnchorEvent)(System::TObject* Sender, TPlannerItem* Item, AnsiString 
	Anchor);

typedef void __fastcall (__closure *TItemImageEvent)(System::TObject* Sender, TPlannerItem* Item, int 
	ImageIdx);

typedef void __fastcall (__closure *TItemHintEvent)(System::TObject* Sender, TPlannerItem* Item, AnsiString 
	&hint);

typedef void __fastcall (__closure *TItemMoveEvent)(System::TObject* Sender, TPlannerItem* Item, int 
	fromBegin, int fromEnd, int fromPos, int toBegin, int toEnd, int toPos);

typedef void __fastcall (__closure *TItemSizeEvent)(System::TObject* Sender, TPlannerItem* Item, int 
	position, int fromBegin, int fromEnd, int toBegin, int toEnd);

typedef void __fastcall (__closure *TPlannerEvent)(System::TObject* Sender, int position, int fromSel
	, int fromSelPrecis, int toSel, int toSelPrecis);

typedef void __fastcall (__closure *TPlannerKeyEvent)(System::TObject* Sender, char &key, int position
	, int fromSel, int fromSelPrecis, int toSel, int toSelPrecis);

typedef void __fastcall (__closure *TPlannerItemDraw)(System::TObject* Sender, TPlannerItem* aItem, 
	Graphics::TCanvas* aCanvas, const Windows::TRect &aRect, bool Selected);

typedef void __fastcall (__closure *TPlannerSideDraw)(System::TObject* Sender, Graphics::TCanvas* aCanvas
	, const Windows::TRect &aRect, int aIndex);

typedef void __fastcall (__closure *TPlannerBkgDraw)(System::TObject* Sender, Graphics::TCanvas* aCanvas
	, const Windows::TRect &aRect, int aIndex, int aPosition);

typedef void __fastcall (__closure *TPlannerPrintEvent)(System::TObject* Sender, Graphics::TCanvas* 
	canvas);

typedef void __fastcall (__closure *TPlannerBtnEvent)(System::TObject* Sender);

#pragma option push -b-
enum TSideBarPosition { spLeft, spRight, spTop };
#pragma option pop

class DELPHICLASS TPlannerSideBar;
class DELPHICLASS TPlanner;
class DELPHICLASS TPlannerRichEdit;
class PASCALIMPLEMENTATION TPlannerRichEdit : public Comctrls::TRichEdit 
{
	typedef Comctrls::TRichEdit inherited;
	
private:
	TPlannerItem* fPlannerItem;
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	
protected:
	DYNAMIC void __fastcall DoEnter(void);
	DYNAMIC void __fastcall DoExit(void);
	
__published:
	__property TPlannerItem* PlannerItem = {read=fPlannerItem, write=fPlannerItem};
public:
	#pragma option push -w-inl
	/* TCustomRichEdit.Create */ inline __fastcall virtual TPlannerRichEdit(Classes::TComponent* AOwner
		) : Comctrls::TRichEdit(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomRichEdit.Destroy */ inline __fastcall virtual ~TPlannerRichEdit(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TPlannerRichEdit(HWND ParentWindow) : Comctrls::TRichEdit(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TPlannerGrid;
class DELPHICLASS TPlannerMemo;
class PASCALIMPLEMENTATION TPlannerMemo : public Stdctrls::TMemo 
{
	typedef Stdctrls::TMemo inherited;
	
private:
	TPlannerItem* fPlannerItem;
	TPlanner* fPlanner;
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonDblClk(Messages::TWMMouse &Message);
	
protected:
	DYNAMIC void __fastcall DoEnter(void);
	DYNAMIC void __fastcall DoExit(void);
	
__published:
	__property TPlannerItem* PlannerItem = {read=fPlannerItem, write=fPlannerItem};
	__property TPlanner* Planner = {read=fPlanner, write=fPlanner};
public:
	#pragma option push -w-inl
	/* TCustomMemo.Create */ inline __fastcall virtual TPlannerMemo(Classes::TComponent* AOwner) : Stdctrls::TMemo(
		AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomMemo.Destroy */ inline __fastcall virtual ~TPlannerMemo(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TPlannerMemo(HWND ParentWindow) : Stdctrls::TMemo(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TPlannerMaskEdit;
class PASCALIMPLEMENTATION TPlannerMaskEdit : public Mask::TMaskEdit 
{
	typedef Mask::TMaskEdit inherited;
	
private:
	TPlannerItem* fPlannerItem;
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	
protected:
	DYNAMIC void __fastcall DoExit(void);
	
__published:
	__property TPlannerItem* PlannerItem = {read=fPlannerItem, write=fPlannerItem};
public:
	#pragma option push -w-inl
	/* TCustomMaskEdit.Create */ inline __fastcall virtual TPlannerMaskEdit(Classes::TComponent* AOwner
		) : Mask::TMaskEdit(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TPlannerMaskEdit(HWND ParentWindow) : Mask::TMaskEdit(
		ParentWindow) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.Destroy */ inline __fastcall virtual ~TPlannerMaskEdit(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlannerColorArrayList;
typedef void __fastcall (__closure *TColorChangeEvent)(System::TObject* Sender, int index);

typedef Graphics::TColor TPlannerColorArray[256];

typedef Graphics::TColor *PPlannerColorArray;

class PASCALIMPLEMENTATION TPlannerColorArrayList : public Classes::TList 
{
	typedef Classes::TList inherited;
	
private:
	TColorChangeEvent fOnChange;
	void __fastcall SetArray(int Index, PPlannerColorArray Value);
	PPlannerColorArray __fastcall GetArray(int Index);
	
public:
	__fastcall TPlannerColorArrayList(void);
	__fastcall virtual ~TPlannerColorArrayList(void);
	__property PPlannerColorArray Items[int index] = {read=GetArray, write=SetArray};
	HIDESBASE PPlannerColorArray __fastcall Add(void);
	HIDESBASE void __fastcall Delete(int Index);
	
__published:
	__property TColorChangeEvent OnChange = {read=fOnChange, write=fOnChange};
};


class PASCALIMPLEMENTATION TPlannerGrid : public Grids::TCustomGrid 
{
	typedef Grids::TCustomGrid inherited;
	
private:
	Windows::TPoint fLastHintPos;
	int fUpdateCount;
	TPlanner* fPlanner;
	TPlannerMemo* fMemo;
	TPlannerMaskEdit* fMaskEdit;
	bool fMouseDown;
	bool fMouseDownMove;
	bool fMouseDownSizeUp;
	bool fMouseDownSizeDown;
	bool fMouseStart;
	Windows::TPoint fMouseXY;
	TPlannerColorArrayList* fColorList;
	Controls::THintWindow* fScrollHintWnd;
	Windows::TPoint fItemXY;
	Windows::TRect fItemXYS;
	bool fEraseBkGnd;
	TPlannerItem* fSelItem;
	HIDESBASE MESSAGE void __fastcall WMSize(Messages::TWMSize &Msg);
	HIDESBASE MESSAGE void __fastcall WMVScroll(Messages::TWMScroll &WMScroll);
	HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMLButtonUp(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMRButtonDown(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMLButtonDblClk(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMMouseMove(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMEraseBkGnd(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall CNKeyDown(Messages::TWMKey &Message);
	HIDESBASE MESSAGE void __fastcall CMHintShow(Messages::TMessage &Msg);
	void __fastcall UpdatePositions(void);
	void __fastcall RTFPaint(const Windows::TRect &arect, AnsiString rtf, Graphics::TColor bkg);
	void __fastcall StartEditCol(const Windows::TRect &arect, TPlannerItem* plIt, int x, int y);
	void __fastcall StartEditRow(const Windows::TRect &arect, TPlannerItem* plIt);
	void __fastcall PaintItemCol(Graphics::TCanvas* canvas, const Windows::TRect &arect, TPlannerItem* 
		plIt, bool print);
	void __fastcall PaintItemRow(Graphics::TCanvas* canvas, const Windows::TRect &arect, TPlannerItem* 
		plIt, bool print);
	void __fastcall PaintSideCol(Graphics::TCanvas* canvas, const Windows::TRect &arect, int arow, bool 
		print);
	void __fastcall PaintSideRow(Graphics::TCanvas* canvas, const Windows::TRect &arect, int acol, bool 
		print);
	void __fastcall DrawCellCol(int ACol, int ARow, const Windows::TRect &ARect, Grids::TGridDrawState 
		AState);
	void __fastcall DrawCellRow(int ACol, int ARow, const Windows::TRect &ARect, Grids::TGridDrawState 
		AState);
	
protected:
	virtual void __fastcall DrawCell(int ACol, int ARow, const Windows::TRect &ARect, Grids::TGridDrawState 
		AState);
	void __fastcall HintShow(int x, int y, AnsiString caption);
	void __fastcall HintHide(void);
	virtual void __fastcall Loaded(void);
	virtual void __fastcall DestroyWnd(void);
	DYNAMIC void __fastcall KeyPress(char &key);
	DYNAMIC void __fastcall TopLeftChanged(void);
	int __fastcall GetScrollSize(void);
	__property RowCount ;
	DYNAMIC void __fastcall DoEnter(void);
	__property TPlannerColorArrayList* ColorList = {read=fColorList, write=fColorList};
	DYNAMIC void __fastcall DragOver(System::TObject* Source, int X, int Y, Controls::TDragState State, 
		bool &Accept);
	
public:
	__fastcall virtual TPlannerGrid(Classes::TComponent* AOwner);
	__fastcall virtual ~TPlannerGrid(void);
	virtual void __fastcall CreateWnd(void);
	DYNAMIC void __fastcall DragDrop(System::TObject* Source, int X, int Y);
	void __fastcall HideSelection(void);
	__property Canvas ;
	__property Col ;
	__property EditorMode ;
	__property GridHeight ;
	__property GridWidth ;
	__property LeftCol ;
	__property Selection ;
	__property Row ;
	__property TabStops ;
	__property TopRow ;
	
__published:
	__property ScrollBars ;
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TPlannerGrid(HWND ParentWindow) : Grids::TCustomGrid(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TAdvHeader;
#pragma option push -b-
enum TVAlignment { vtaCenter, vtaTop, vtaBottom };
#pragma option pop

#pragma option push -b-
enum TImagePosition { ipLeft, ipRight };
#pragma option pop

typedef void __fastcall (__closure *THeaderClickEvent)(System::TObject* Sender, int SectionIdx);

#pragma option push -b-
enum THeaderOrientation { hoHorizontal, hoVertical };
#pragma option pop

class PASCALIMPLEMENTATION TAdvHeader : public Extctrls::THeader 
{
	typedef Extctrls::THeader inherited;
	
private:
	int fOffset;
	int fLeftPos;
	Classes::TAlignment fAlignment;
	TVAlignment fVAlignment;
	Graphics::TColor fColor;
	Graphics::TColor fLineColor;
	bool fFlat;
	Controls::TImageList* fImageList;
	TImagePosition fImagePosition;
	THeaderClickEvent fOnClick;
	THeaderClickEvent fOnRightClick;
	THeaderOrientation fOrientation;
	void __fastcall SetAlignment(const Classes::TAlignment Value);
	HIDESBASE void __fastcall SetColor(const Graphics::TColor value);
	void __fastcall SetImageList(const Controls::TImageList* value);
	void __fastcall SetImagePosition(const TImagePosition Value);
	HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMRButtonDown(Messages::TWMMouse &Message);
	void __fastcall SetOrientation(const THeaderOrientation Value);
	void __fastcall SetFlat(const bool Value);
	void __fastcall SetLineColor(const Graphics::TColor Value);
	void __fastcall SetVAlignment(const TVAlignment Value);
	
public:
	__fastcall virtual TAdvHeader(Classes::TComponent* aOwner);
	
protected:
	int __fastcall XYToSection(int x, int y);
	virtual void __fastcall Paint(void);
	
__published:
	__property Classes::TAlignment Alignment = {read=fAlignment, write=SetAlignment, nodefault};
	__property Graphics::TColor Color = {read=fColor, write=SetColor, nodefault};
	__property bool Flat = {read=fFlat, write=SetFlat, nodefault};
	__property Controls::TImageList* Images = {read=fImageList, write=SetImageList};
	__property TImagePosition ImagePosition = {read=fImagePosition, write=SetImagePosition, nodefault};
		
	__property Graphics::TColor LineColor = {read=fLineColor, write=SetLineColor, nodefault};
	__property TVAlignment VAlignment = {read=fVAlignment, write=SetVAlignment, nodefault};
	__property THeaderOrientation Orientation = {read=fOrientation, write=SetOrientation, default=0};
	__property THeaderClickEvent OnClick = {read=fOnClick, write=fOnClick};
	__property THeaderClickEvent OnRightClick = {read=fOnRightClick, write=fOnRightClick};
public:
	#pragma option push -w-inl
	/* THeader.Destroy */ inline __fastcall virtual ~TAdvHeader(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TAdvHeader(HWND ParentWindow) : Extctrls::THeader(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TPlannerMode;
#pragma option push -b-
enum TPlannerType { plDay, plWeek, plMonth, plCustom };
#pragma option pop

class PASCALIMPLEMENTATION TPlannerMode : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TPlanner* fOwner;
	TPlannerType fPlannerType;
	int fWeekStart;
	int fYear;
	int fMonth;
	AnsiString fDateTimeFormat;
	void __fastcall SetMonth(const int Value);
	void __fastcall SetPlannerType(const TPlannerType Value);
	void __fastcall SetWeekStart(const int Value);
	void __fastcall SetYear(const int Value);
	void __fastcall SetDateTimeFormat(const AnsiString Value);
	
public:
	__fastcall TPlannerMode(TPlanner* aOwner);
	__fastcall virtual ~TPlannerMode(void);
	
__published:
	__property TPlannerType PlannerType = {read=fPlannerType, write=SetPlannerType, nodefault};
	__property int Month = {read=fMonth, write=SetMonth, nodefault};
	__property int Year = {read=fYear, write=SetYear, nodefault};
	__property int WeekStart = {read=fWeekStart, write=SetWeekStart, nodefault};
	__property AnsiString DateTimeFormat = {read=fDateTimeFormat, write=SetDateTimeFormat};
};


class DELPHICLASS TPlannerCaption;
class PASCALIMPLEMENTATION TPlannerCaption : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	AnsiString fTitle;
	Classes::TAlignment fAlignment;
	Graphics::TColor fBackGround;
	Graphics::TFont* fFont;
	TPlanner* fOwner;
	int fHeight;
	void __fastcall SetAlignment(const Classes::TAlignment Value);
	void __fastcall SetBackground(const Graphics::TColor Value);
	void __fastcall SetFont(const Graphics::TFont* Value);
	void __fastcall SetTitle(const AnsiString Value);
	void __fastcall SetHeigth(const int Value);
	void __fastcall FontChanged(System::TObject* Sender);
	
protected:
	void __fastcall UpdatePanel(void);
	
public:
	__fastcall TPlannerCaption(TPlanner* aOwner);
	__fastcall virtual ~TPlannerCaption(void);
	
__published:
	__property AnsiString Title = {read=fTitle, write=SetTitle};
	__property Graphics::TFont* Font = {read=fFont, write=SetFont};
	__property Classes::TAlignment Alignment = {read=fAlignment, write=SetAlignment, nodefault};
	__property Graphics::TColor Background = {read=fBackGround, write=SetBackground, nodefault};
	__property int Height = {read=fHeight, write=SetHeigth, nodefault};
};


class DELPHICLASS TPlannerDisplay;
class PASCALIMPLEMENTATION TPlannerDisplay : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TPlanner* fOwner;
	int fDisplayStart;
	int fDisplayScale;
	int fDisplayEnd;
	int fDisplayUnit;
	int fActiveEnd;
	int fActiveStart;
	Graphics::TColor fColorNonActive;
	Graphics::TColor fColorActive;
	int fActiveStartPrecis;
	int fActiveEndPrecis;
	int fDisplayStartPrecis;
	int fDisplayEndPrecis;
	void __fastcall SetDisplayStart(const int Value);
	void __fastcall SetDisplayEnd(const int Value);
	void __fastcall SetDisplayScale(const int Value);
	void __fastcall SetDisplayUnit(const int Value);
	void __fastcall UpdatePlanner(void);
	void __fastcall SetActiveEnd(const int Value);
	void __fastcall SetActiveStart(const int Value);
	void __fastcall SetColorActive(const Graphics::TColor Value);
	void __fastcall SetColorNonActive(const Graphics::TColor Value);
	
public:
	__fastcall TPlannerDisplay(TPlanner* aOwner);
	__fastcall virtual ~TPlannerDisplay(void);
	
__published:
	__property int DisplayUnit = {read=fDisplayUnit, write=SetDisplayUnit, nodefault};
	__property int ActiveStart = {read=fActiveStart, write=SetActiveStart, nodefault};
	__property int ActiveEnd = {read=fActiveEnd, write=SetActiveEnd, nodefault};
	__property int DisplayStart = {read=fDisplayStart, write=SetDisplayStart, nodefault};
	__property int DisplayEnd = {read=fDisplayEnd, write=SetDisplayEnd, nodefault};
	__property int DisplayScale = {read=fDisplayScale, write=SetDisplayScale, nodefault};
	__property Graphics::TColor ColorActive = {read=fColorActive, write=SetColorActive, nodefault};
	__property Graphics::TColor ColorNonActive = {read=fColorNonActive, write=SetColorNonActive, nodefault
		};
};


#pragma option push -b-
enum THourType { ht24hrs, ht12hrs };
#pragma option pop

class DELPHICLASS TPlannerHeader;
class PASCALIMPLEMENTATION TPlannerHeader : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TPlanner* fOwner;
	Classes::TStringList* fCaptions;
	bool fVisible;
	int fHeight;
	Graphics::TFont* fFont;
	Graphics::TColor fColor;
	bool fFlat;
	Classes::TAlignment fAlignment;
	TVAlignment fVAlignment;
	Controls::TImageList* fImages;
	TImagePosition fImagePosition;
	void __fastcall SetAlignment(const Classes::TAlignment Value);
	void __fastcall SetCaptions(const Classes::TStringList* Value);
	void __fastcall SetHeight(const int Value);
	void __fastcall SetVisible(const bool Value);
	void __fastcall SetColor(const Graphics::TColor Value);
	void __fastcall SetFont(const Graphics::TFont* Value);
	void __fastcall FontChanged(System::TObject* Sender);
	void __fastcall ItemsChanged(System::TObject* Sender);
	void __fastcall SetImages(const Controls::TImageList* Value);
	void __fastcall SetImagePosition(const TImagePosition Value);
	void __fastcall SetFlat(const bool Value);
	void __fastcall SetVAlignment(const TVAlignment Value);
	
public:
	__fastcall TPlannerHeader(TPlanner* aOwner);
	__fastcall virtual ~TPlannerHeader(void);
	
__published:
	__property Classes::TAlignment Alignment = {read=fAlignment, write=SetAlignment, nodefault};
	__property int Height = {read=fHeight, write=SetHeight, nodefault};
	__property bool Visible = {read=fVisible, write=SetVisible, nodefault};
	__property Classes::TStringList* Captions = {read=fCaptions, write=SetCaptions};
	__property Graphics::TFont* Font = {read=fFont, write=SetFont};
	__property Graphics::TColor Color = {read=fColor, write=SetColor, nodefault};
	__property bool Flat = {read=fFlat, write=SetFlat, nodefault};
	__property Controls::TImageList* Images = {read=fImages, write=SetImages};
	__property TImagePosition ImagePosition = {read=fImagePosition, write=SetImagePosition, nodefault};
		
	__property TVAlignment VAlignment = {read=fVAlignment, write=SetVAlignment, nodefault};
};


class DELPHICLASS TPlannerItems;
class PASCALIMPLEMENTATION TPlannerItems : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TPlanner* fOwner;
	TPlannerItem* fSelected;
	int fUpdateCount;
	HIDESBASE TPlannerItem* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TPlannerItem* Value);
	int __fastcall NumConflicts(int &itembegin, int &itemend, int &itempos);
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	Windows::TPoint __fastcall NumItem(int ItemBegin, int ItemEnd, int ItemPos);
	Windows::TPoint __fastcall NumItemPos(int ItemBegin, int ItemEnd, int ItemPos);
	TPlannerItem* __fastcall FindItem(int ItemBegin, int ItemPos);
	TPlannerItem* __fastcall FindItemPos(int ItemBegin, int ItemPos, int ItemSubPos);
	TPlannerItem* __fastcall FindItemPosIdx(int ItemBegin, int ItemPos, int ItemSubPos);
	TPlannerItem* __fastcall FindItemIndex(int ItemBegin, int ItemPos, int ItemSubIdx);
	TPlannerItem* __fastcall QueryItem(TPlannerItem* Item, int ItemBegin, int ItemPos);
	TPlannerItem* __fastcall FocusItem(int ItemBegin, int ItemPos, int ItemSubPos);
	
public:
	__fastcall TPlannerItems(TPlanner* aOwner);
	bool __fastcall HasItem(int ItemBegin, int ItemEnd, int ItemPos);
	HIDESBASE TPlannerItem* __fastcall Add(void);
	HIDESBASE TPlannerItem* __fastcall Insert(int index);
	__property TPlannerItem* Items[int Index] = {read=GetItem, write=SetItem};
	TPlannerItem* __fastcall SelectNext(void);
	TPlannerItem* __fastcall SelectPrev(void);
	__property TPlannerItem* Selected = {read=fSelected, write=fSelected};
	bool __fastcall InVisibleLayer(int layer);
	void __fastcall ClearConflicts(void);
	void __fastcall SetConflicts(void);
	virtual void __fastcall BeginUpdate(void);
	virtual void __fastcall EndUpdate(void);
	void __fastcall ClearPosition(int pos);
	void __fastcall ClearLayer(int layer);
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TPlannerItems(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlannerPrintOptions;
class PASCALIMPLEMENTATION TPlannerPrintOptions : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	int fFooterSize;
	int fLeftMargin;
	int fRightMargin;
	int fHeaderSize;
	Graphics::TFont* fHeaderFont;
	Graphics::TFont* fFooterFont;
	Printers::TPrinterOrientation FOrientation;
	Classes::TStrings* fFooter;
	Classes::TStrings* fHeader;
	Classes::TAlignment fHeaderAlignment;
	Classes::TAlignment fFooterAlignment;
	AnsiString fJobname;
	void __fastcall SetFooter(const Classes::TStrings* Value);
	void __fastcall SetFooterFont(const Graphics::TFont* Value);
	void __fastcall SetHeader(const Classes::TStrings* Value);
	void __fastcall SetHeaderFont(const Graphics::TFont* Value);
	
public:
	__fastcall TPlannerPrintOptions(void);
	__fastcall virtual ~TPlannerPrintOptions(void);
	
__published:
	__property AnsiString Jobname = {read=fJobname, write=fJobname};
	__property Classes::TStrings* Header = {read=fHeader, write=SetHeader};
	__property Classes::TStrings* Footer = {read=fFooter, write=SetFooter};
	__property Graphics::TFont* HeaderFont = {read=fHeaderFont, write=SetHeaderFont};
	__property Graphics::TFont* FooterFont = {read=fFooterFont, write=SetFooterFont};
	__property Classes::TAlignment HeaderAlignment = {read=fHeaderAlignment, write=fHeaderAlignment, nodefault
		};
	__property Classes::TAlignment FooterAlignment = {read=fFooterAlignment, write=fFooterAlignment, nodefault
		};
	__property int LeftMargin = {read=fLeftMargin, write=fLeftMargin, nodefault};
	__property int RightMargin = {read=fRightMargin, write=fRightMargin, nodefault};
	__property int HeaderSize = {read=fHeaderSize, write=fHeaderSize, nodefault};
	__property int FooterSize = {read=fFooterSize, write=fFooterSize, nodefault};
	__property Printers::TPrinterOrientation Orientation = {read=FOrientation, write=FOrientation, nodefault
		};
};


class DELPHICLASS TPlannerHTMLOptions;
class PASCALIMPLEMENTATION TPlannerHTMLOptions : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	AnsiString fFooterFile;
	AnsiString fHeaderFile;
	int fBorderSize;
	int fCellSpacing;
	AnsiString fTableStyle;
	AnsiString fPrefixTag;
	AnsiString fSuffixTag;
	int fWidth;
	
public:
	__fastcall TPlannerHTMLOptions(void);
	
__published:
	__property int BorderSize = {read=fBorderSize, write=fBorderSize, default=1};
	__property int CellSpacing = {read=fCellSpacing, write=fCellSpacing, default=0};
	__property AnsiString FooterFile = {read=fFooterFile, write=fFooterFile};
	__property AnsiString HeaderFile = {read=fHeaderFile, write=fHeaderFile};
	__property AnsiString TableStyle = {read=fTableStyle, write=fTableStyle};
	__property AnsiString PrefixTag = {read=fPrefixTag, write=fPrefixTag};
	__property AnsiString SuffixTag = {read=fSuffixTag, write=fSuffixTag};
	__property int Width = {read=fWidth, write=fWidth, nodefault};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TPlannerHTMLOptions(void) { }
	#pragma option pop
	
};


class DELPHICLASS TNavigatorButtons;
class PASCALIMPLEMENTATION TNavigatorButtons : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TPlanner* fOwner;
	bool fVisible;
	bool fShowHint;
	AnsiString fNextHint;
	AnsiString fPrevHint;
	void __fastcall SetVisible(bool value);
	void __fastcall SetNextHint(const AnsiString Value);
	void __fastcall SetPrevHint(const AnsiString Value);
	void __fastcall SetShowHint(const bool Value);
	
public:
	__fastcall TNavigatorButtons(TPlanner* aOwner);
	
__published:
	__property bool Visible = {read=fVisible, write=SetVisible, nodefault};
	__property AnsiString PrevHint = {read=fPrevHint, write=SetPrevHint};
	__property AnsiString NextHint = {read=fNextHint, write=SetNextHint};
	__property bool ShowHint = {read=fShowHint, write=SetShowHint, nodefault};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TNavigatorButtons(void) { }
	#pragma option pop
	
};


typedef void __fastcall (__closure *TDragOverItemEvent)(System::TObject* Sender, System::TObject* Source
	, int X, int Y, TPlannerItem* plIt, Controls::TDragState State, bool &Accept);

typedef void __fastcall (__closure *TDragDropItemEvent)(System::TObject* Sender, System::TObject* Source
	, int X, int Y, TPlannerItem* plIt);

class PASCALIMPLEMENTATION TPlanner : public Controls::TCustomControl 
{
	typedef Controls::TCustomControl inherited;
	
private:
	double fHTMLFactor;
	TPlannerRichEdit* fRichEdit;
	bool fActiveDisplay;
	bool fOverlap;
	Graphics::TColor fColor;
	int fLayer;
	bool fEditRTF;
	bool fEditDirect;
	Stdctrls::TScrollStyle fEditScroll;
	Graphics::TColor fTrackColor;
	bool fTrackProportional;
	Graphics::TFont* fFont;
	TPlannerGrid* fGrid;
	Menus::TPopupMenu* fGridPopup;
	Graphics::TColor fGridLineColor;
	Menus::TPopupMenu* fItemPopup;
	TAdvHeader* fHeader;
	bool fHintOnItemChange;
	Graphics::TColor fHintColor;
	int fItemGap;
	Buttons::TSpeedButton* fNext;
	Buttons::TSpeedButton* fPrev;
	TPlannerMode* fMode;
	TPlannerCaption* fCaption;
	TPlannerSideBar* fSidebar;
	TPlannerDisplay* fDisplay;
	Classes::TStringList* fDayNames;
	THourType fHourType;
	TPlannerHeader* fPlannerHeader;
	TPlannerItems* fPlannerItems;
	Controls::TImageList* fPlannerImages;
	Extctrls::TPanel* fPanel;
	int fPositions;
	int fPositionWidth;
	TPlannerPrintOptions* fPrintOptions;
	TPlannerHTMLOptions* fHTMLOptions;
	bool fLinkUpdate;
	bool fPrinterDriverFix;
	TNavigatorButtons* fNavigatorButtons;
	TItemAnchorEvent fOnItemAnchorClick;
	TItemAnchorEvent fOnItemAnchorEnter;
	TItemAnchorEvent fOnItemAnchorExit;
	TItemEvent fOnItemRightClick;
	TItemEvent fOnItemDblClick;
	TItemImageEvent fOnItemImageClick;
	TItemEvent fOnItemLeftClick;
	TItemMoveEvent fOnItemMove;
	TItemSizeEvent fOnItemSize;
	TItemEvent fOnItemDelete;
	TPlannerEvent fOnItemInsert;
	TItemEvent fOnItemStartEdit;
	TItemEvent fOnItemEndEdit;
	TItemEvent fOnItemSelect;
	TItemEvent fOnItemEnter;
	TItemEvent fOnItemExit;
	TItemHintEvent fOnItemHint;
	TItemEvent fOnItemSelChange;
	TPlannerEvent fOnPlannerLeftClick;
	TPlannerEvent fOnPlannerRightClick;
	TPlannerEvent fOnPlannerDblClick;
	TPlannerKeyEvent fOnPlannerKeypress;
	TPlannerItemDraw fOnPlannerItemDraw;
	TPlannerSideDraw fOnPlannerSideDraw;
	TPlannerBkgDraw fOnPlannerBkgDraw;
	TPlannerBtnEvent fOnPlannerNext;
	TPlannerBtnEvent fOnPlannerPrev;
	Controls::TMouseMoveEvent fOnPlannerMouseMove;
	THeaderClickEvent fOnHeaderClick;
	THeaderClickEvent fOnHeaderRightClick;
	TPlannerPrintEvent fOnPrintStart;
	TPlannerBtnEvent fOnTopLeftChanged;
	Controls::TDragOverEvent FOnDragOver;
	Controls::TDragOverEvent FOnDragOverCell;
	TDragOverItemEvent FOnDragOverItem;
	Controls::TDragDropEvent FOnDragDrop;
	Controls::TDragDropEvent FOnDragDropCell;
	TDragDropItemEvent FOnDragDropItem;
	HIDESBASE MESSAGE void __fastcall WMSize(Messages::TWMSize &Msg);
	HIDESBASE MESSAGE void __fastcall WMEraseBkGnd(Messages::TMessage &Message);
	void __fastcall SetCaption(const TPlannerCaption* Value);
	void __fastcall SetSideBar(const TPlannerSideBar* Value);
	void __fastcall SetDisplay(const TPlannerDisplay* Value);
	void __fastcall SetDayNames(const Classes::TStringList* Value);
	void __fastcall SetHeader(const TPlannerHeader* Value);
	void __fastcall SetMode(const TPlannerMode* Value);
	void __fastcall SetPlannerItems(const TPlannerItems* Value);
	void __fastcall SetImages(const Controls::TImageList* Value);
	void __fastcall SetLayer(const int Value);
	void __fastcall SetHourType(const THourType Value);
	void __fastcall SetPositions(const int Value);
	void __fastcall SetPositionWidth(const int Value);
	void __fastcall SetGridTopRow(const int Value);
	void __fastcall SetGridLeftCol(const int Value);
	int __fastcall GetGridTopRow(void);
	int __fastcall GetGridLeftCol(void);
	HIDESBASE void __fastcall SetFont(Graphics::TFont* Value);
	void __fastcall SetTrackColor(const Graphics::TColor Value);
	void __fastcall SetTrackProportional(const bool Value);
	void __fastcall SetActiveDisplay(const bool Value);
	HIDESBASE void __fastcall FontChanged(System::TObject* Sender);
	void __fastcall NextClick(System::TObject* Sender);
	void __fastcall PrevClick(System::TObject* Sender);
	void __fastcall HeaderClick(System::TObject* Sender, int SectionIdx);
	void __fastcall HeaderRightClick(System::TObject* Sender, int SectionIdx);
	void __fastcall UpdateSizes(void);
	int __fastcall GetSelItemEnd(void);
	int __fastcall GetSelItemBegin(void);
	int __fastcall GetSelPosition(void);
	void __fastcall SetSelItemEnd(const int Value);
	void __fastcall SetSelItemBegin(const int Value);
	void __fastcall SetSelPosition(const int Value);
	void __fastcall SelChange(System::TObject* sender);
	void __fastcall SetGridLineColor(const Graphics::TColor Value);
	HIDESBASE void __fastcall SetColor(const Graphics::TColor Value);
	Graphics::TColor __fastcall GetBkgColor(int i, int j);
	void __fastcall SetBkgColor(int i, int j, const Graphics::TColor Value);
	void __fastcall SetItemGap(const int Value);
	void __fastcall SaveToHTMLCol(AnsiString filename);
	void __fastcall SaveToHTMLRow(AnsiString filename);
	
protected:
	virtual void __fastcall Loaded(void);
	virtual void __fastcall CreateWnd(void);
	virtual void __fastcall DestroyWnd(void);
	virtual void __fastcall Paint(void);
	virtual AnsiString __fastcall GetDayName(Word w);
	void __fastcall PrintCol(void);
	void __fastcall PrintRow(void);
	
public:
	__fastcall virtual TPlanner(Classes::TComponent* AOwner);
	__fastcall virtual ~TPlanner(void);
	void __fastcall SaveToHTML(AnsiString filename);
	void __fastcall SaveToStream(Classes::TStream* st);
	void __fastcall LoadFromStream(Classes::TStream* st);
	void __fastcall InsertFromStream(Classes::TStream* st);
	void __fastcall SavePositionToStream(Classes::TStream* st, int pos);
	void __fastcall LoadPositionFromStream(Classes::TStream* st, int pos);
	void __fastcall SaveLayerToStream(Classes::TStream* st, int layer);
	void __fastcall LoadLayerFromStream(Classes::TStream* st, int layer);
	void __fastcall SaveToFile(AnsiString fn);
	void __fastcall LoadFromFile(AnsiString fn);
	void __fastcall InsertFromFile(AnsiString fn);
	void __fastcall SavePositionToFile(AnsiString fn, int pos);
	void __fastcall LoadPositionFromFile(AnsiString fn, int pos);
	void __fastcall SaveLayerToFile(AnsiString fn, int layer);
	void __fastcall LoadLayerFromFile(AnsiString fn, int layer);
	void __fastcall Print(void);
	virtual void __fastcall Invalidate(void);
	void __fastcall TextToRich(AnsiString rtf);
	AnsiString __fastcall RichToText();
	__property int SelPosition = {read=GetSelPosition, write=SetSelPosition, nodefault};
	__property int SelItemBegin = {read=GetSelItemBegin, write=SetSelItemBegin, nodefault};
	__property int SelItemEnd = {read=GetSelItemEnd, write=SetSelItemEnd, nodefault};
	__property TPlannerRichEdit* RichEdit = {read=fRichEdit, write=fRichEdit};
	__property Graphics::TColor BackGroundColor[int i][int j] = {read=GetBkgColor, write=SetBkgColor};
	__property bool PrinterDriverFix = {read=fPrinterDriverFix, write=fPrinterDriverFix, nodefault};
	Windows::TPoint __fastcall XYToCell(int x, int y);
	TPlannerItem* __fastcall XYToItem(int x, int y);
	TPlannerItem* __fastcall CellToItem(int x, int y);
	int __fastcall CellToItemNum(int x, int y);
	TPlannerItem* __fastcall CellToItemIdx(int x, int y, int i);
	void __fastcall HideSelection(void);
	void __fastcall MovePosition(int frompos, int topos);
	void __fastcall DeletePosition(int pos);
	void __fastcall InsertPosition(int pos);
	
__published:
	__property bool ActiveDisplay = {read=fActiveDisplay, write=SetActiveDisplay, nodefault};
	__property Align ;
	__property TPlannerCaption* Caption = {read=fCaption, write=SetCaption};
	__property Graphics::TColor Color = {read=fColor, write=SetColor, nodefault};
	__property TPlannerSideBar* Sidebar = {read=fSidebar, write=SetSideBar};
	__property TPlannerDisplay* Display = {read=fDisplay, write=SetDisplay};
	__property Classes::TStringList* DayNames = {read=fDayNames, write=SetDayNames};
	__property TPlannerHeader* Header = {read=fPlannerHeader, write=SetHeader};
	__property int ItemGap = {read=fItemGap, write=SetItemGap, nodefault};
	__property TPlannerMode* Mode = {read=fMode, write=SetMode};
	__property THourType HourType = {read=fHourType, write=SetHourType, nodefault};
	__property int Positions = {read=fPositions, write=SetPositions, nodefault};
	__property int PositionWidth = {read=fPositionWidth, write=SetPositionWidth, nodefault};
	__property Graphics::TColor HintColor = {read=fHintColor, write=fHintColor, nodefault};
	__property bool HintOnItemChange = {read=fHintOnItemChange, write=fHintOnItemChange, nodefault};
	__property TPlannerItems* Items = {read=fPlannerItems, write=SetPlannerItems};
	__property Graphics::TFont* Font = {read=fFont, write=SetFont};
	__property bool Overlap = {read=fOverlap, write=fOverlap, nodefault};
	__property int Layer = {read=fLayer, write=SetLayer, nodefault};
	__property bool EditRTF = {read=fEditRTF, write=fEditRTF, nodefault};
	__property bool EditDirect = {read=fEditDirect, write=fEditDirect, nodefault};
	__property Stdctrls::TScrollStyle EditScroll = {read=fEditScroll, write=fEditScroll, nodefault};
	__property Menus::TPopupMenu* GridPopup = {read=fGridPopup, write=fGridPopup};
	__property Graphics::TColor GridLineColor = {read=fGridLineColor, write=SetGridLineColor, nodefault
		};
	__property Menus::TPopupMenu* ItemPopup = {read=fItemPopup, write=fItemPopup};
	__property int GridTopRow = {read=GetGridTopRow, write=SetGridTopRow, nodefault};
	__property int GridLeftCol = {read=GetGridLeftCol, write=SetGridLeftCol, nodefault};
	__property TNavigatorButtons* NavigatorButtons = {read=fNavigatorButtons, write=fNavigatorButtons};
		
	__property Graphics::TColor TrackColor = {read=fTrackColor, write=SetTrackColor, nodefault};
	__property bool TrackProportional = {read=fTrackProportional, write=SetTrackProportional, nodefault
		};
	__property Controls::TImageList* PlannerImages = {read=fPlannerImages, write=SetImages};
	__property TPlannerPrintOptions* PrintOptions = {read=fPrintOptions, write=fPrintOptions};
	__property TPlannerHTMLOptions* HTMLOptions = {read=fHTMLOptions, write=fHTMLOptions};
	__property TItemAnchorEvent OnItemAnchorClick = {read=fOnItemAnchorClick, write=fOnItemAnchorClick}
		;
	__property TItemAnchorEvent OnItemAnchorEnter = {read=fOnItemAnchorEnter, write=fOnItemAnchorEnter}
		;
	__property TItemAnchorEvent OnItemAnchorExit = {read=fOnItemAnchorExit, write=fOnItemAnchorExit};
	__property TItemEvent OnItemLeftClick = {read=fOnItemLeftClick, write=fOnItemLeftClick};
	__property TItemEvent OnItemRightClick = {read=fOnItemRightClick, write=fOnItemRightClick};
	__property TItemEvent OnItemDblClick = {read=fOnItemDblClick, write=fOnItemDblClick};
	__property TItemImageEvent OnItemImageClick = {read=fOnItemImageClick, write=fOnItemImageClick};
	__property TItemSizeEvent OnItemSize = {read=fOnItemSize, write=fOnItemSize};
	__property TItemMoveEvent OnItemMove = {read=fOnItemMove, write=fOnItemMove};
	__property TItemEvent OnItemDelete = {read=fOnItemDelete, write=fOnItemDelete};
	__property TPlannerEvent OnItemInsert = {read=fOnItemInsert, write=fOnItemInsert};
	__property TItemEvent OnItemStartEdit = {read=fOnItemStartEdit, write=fOnItemStartEdit};
	__property TItemEvent OnItemEndEdit = {read=fOnItemEndEdit, write=fOnItemEndEdit};
	__property TItemEvent OnItemSelect = {read=fOnItemSelect, write=fOnItemSelect};
	__property TItemEvent OnItemEnter = {read=fOnItemEnter, write=fOnItemEnter};
	__property TItemEvent OnItemExit = {read=fOnItemExit, write=fOnItemExit};
	__property TItemHintEvent OnItemHint = {read=fOnItemHint, write=fOnItemHint};
	__property TItemEvent OnItemSelChange = {read=fOnItemSelChange, write=fOnItemSelChange};
	__property TPlannerEvent OnPlannerLeftClick = {read=fOnPlannerLeftClick, write=fOnPlannerLeftClick}
		;
	__property TPlannerEvent OnPlannerRightClick = {read=fOnPlannerRightClick, write=fOnPlannerRightClick
		};
	__property TPlannerEvent OnPlannerDblClick = {read=fOnPlannerDblClick, write=fOnPlannerDblClick};
	__property TPlannerKeyEvent OnPlannerKeyPress = {read=fOnPlannerKeypress, write=fOnPlannerKeypress}
		;
	__property TPlannerItemDraw OnPlannerItemDraw = {read=fOnPlannerItemDraw, write=fOnPlannerItemDraw}
		;
	__property TPlannerSideDraw OnPlannerSideDraw = {read=fOnPlannerSideDraw, write=fOnPlannerSideDraw}
		;
	__property TPlannerBkgDraw OnPlannerBkgDraw = {read=fOnPlannerBkgDraw, write=fOnPlannerBkgDraw};
	__property TPlannerBtnEvent OnPlannerNext = {read=fOnPlannerNext, write=fOnPlannerNext};
	__property TPlannerBtnEvent OnPlannerPrev = {read=fOnPlannerPrev, write=fOnPlannerPrev};
	__property Controls::TMouseMoveEvent OnPlannerMouseMove = {read=fOnPlannerMouseMove, write=fOnPlannerMouseMove
		};
	__property THeaderClickEvent OnHeaderClick = {read=fOnHeaderClick, write=fOnHeaderClick};
	__property THeaderClickEvent OnHeaderRightClick = {read=fOnHeaderRightClick, write=fOnHeaderRightClick
		};
	__property TPlannerBtnEvent OnTopLeftChanged = {read=fOnTopLeftChanged, write=fOnTopLeftChanged};
	__property TPlannerPrintEvent OnPrintStart = {read=fOnPrintStart, write=fOnPrintStart};
	__property Controls::TDragOverEvent OnDragOver = {read=FOnDragOver, write=FOnDragOver};
	__property Controls::TDragOverEvent OnDragOverCell = {read=FOnDragOverCell, write=FOnDragOverCell};
		
	__property TDragOverItemEvent OnDragOverItem = {read=FOnDragOverItem, write=FOnDragOverItem};
	__property Controls::TDragDropEvent OnDragDrop = {read=FOnDragDrop, write=FOnDragDrop};
	__property Controls::TDragDropEvent OnDragDropCell = {read=FOnDragDropCell, write=FOnDragDropCell};
		
	__property TDragDropItemEvent OnDragDropItem = {read=FOnDragDropItem, write=FOnDragDropItem};
public:
		
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TPlanner(HWND ParentWindow) : Controls::TCustomControl(
		ParentWindow) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TPlannerSideBar : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Classes::TAlignment fAlignment;
	Graphics::TColor fBackGround;
	Graphics::TFont* fFont;
	TPlanner* fOwner;
	bool fVisible;
	int fWidth;
	int fColOffset;
	int fRowOffset;
	TSideBarPosition fPosition;
	void __fastcall SetAlignment(const Classes::TAlignment Value);
	void __fastcall SetBackground(const Graphics::TColor Value);
	void __fastcall SetFont(const Graphics::TFont* Value);
	void __fastcall FontChanged(System::TObject* Sender);
	void __fastcall SetVisible(const bool Value);
	void __fastcall SetWidth(const int Value);
	void __fastcall SetPosition(const TSideBarPosition Value);
	
public:
	__fastcall TPlannerSideBar(TPlanner* aOwner);
	__fastcall virtual ~TPlannerSideBar(void);
	
protected:
	void __fastcall UpdateGrid(void);
	
__published:
	__property Graphics::TFont* Font = {read=fFont, write=SetFont};
	__property Classes::TAlignment Alignment = {read=fAlignment, write=SetAlignment, nodefault};
	__property Graphics::TColor Background = {read=fBackGround, write=SetBackground, nodefault};
	__property bool Visible = {read=fVisible, write=SetVisible, nodefault};
	__property int Width = {read=fWidth, write=SetWidth, nodefault};
	__property TSideBarPosition Position = {read=fPosition, write=SetPosition, nodefault};
};


typedef Byte TImageInt;

#pragma option push -b-
enum TCaptionType { ctNone, ctText, ctTime };
#pragma option pop

typedef void __fastcall (__closure *TImageChangeEvent)(System::TObject* Sender);

class DELPHICLASS TPlannerIntList;
class PASCALIMPLEMENTATION TPlannerIntList : public Classes::TList 
{
	typedef Classes::TList inherited;
	
private:
	TImageChangeEvent fOnChange;
	TPlannerItem* fPlannerItem;
	void __fastcall SetInteger(int Index, int Value);
	int __fastcall GetInteger(int Index);
	
public:
	__fastcall TPlannerIntList(TPlannerItem* value);
	__property int Items[int index] = {read=GetInteger, write=SetInteger/*, default*/};
	HIDESBASE void __fastcall Add(int Value);
	HIDESBASE void __fastcall Delete(int Index);
	
__published:
	__property TImageChangeEvent OnChange = {read=fOnChange, write=fOnChange};
public:
	#pragma option push -w-inl
	/* TList.Destroy */ inline __fastcall virtual ~TPlannerIntList(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TPlannerItemEdit { peMemo, peEdit, peMaskEdit, peRichText };
#pragma option pop

#pragma option push -b-
enum TPlannerLinkType { ltLinkFull, ltLinkBeginEnd, ltLinkEndBegin, ltLinkEndEnd, ltLinkBeginBegin }
	;
#pragma option pop

class PASCALIMPLEMENTATION TPlannerItem : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	int fTag;
	int fID;
	System::TObject* fObject;
	Classes::TAlignment fAlignment;
	TCaptionType fCaptionType;
	AnsiString fCaptionText;
	AnsiString fEditMask;
	Classes::TStringList* fText;
	TPlannerItemEdit fInplaceEdit;
	int fItemBegin;
	int fItemEnd;
	int fItemBeginPrecis;
	int fItemEndPrecis;
	int fImageID;
	Graphics::TColor fColor;
	bool fFixedPos;
	bool fFixedSize;
	bool fReadOnly;
	TPlanner* fPlanner;
	int fItemPos;
	int fConflicts;
	int fConflictPos;
	bool fVisible;
	bool fFocus;
	AnsiString fName;
	int fLayer;
	Graphics::TColor fTrackColor;
	TPlannerIntList* fPlannerIntList;
	System::TDateTime fItemStartTime;
	System::TDateTime fItemEndTime;
	bool fAllowOverlap;
	bool fBackground;
	Graphics::TFont* fFont;
	TPlannerItem* fLinkedItem;
	TPlannerLinkType fLinkType;
	void __fastcall SetColor(const Graphics::TColor Value);
	void __fastcall SetTrackColor(const Graphics::TColor Value);
	void __fastcall SetLayer(const int Value);
	void __fastcall SetItemEnd(const int Value);
	void __fastcall SetItemBegin(const int Value);
	void __fastcall SetText(const Classes::TStringList* Value);
	void __fastcall SetAlignment(const Classes::TAlignment Value);
	void __fastcall SetAllowOverlap(const bool Value);
	void __fastcall SetCaptionType(const TCaptionType Value);
	void __fastcall SetCaptionText(const AnsiString Value);
	void __fastcall SetImageID(const int Value);
	void __fastcall SetItemPos(const int Value);
	void __fastcall SetVisible(const bool Value);
	void __fastcall SetFocus(const bool Value);
	void __fastcall SetFont(const Graphics::TFont* Value);
	void __fastcall SetBackground(const bool Value);
	void __fastcall ReOrganize(void);
	void __fastcall Repaint(void);
	void __fastcall FontChange(System::TObject* Sender);
	void __fastcall ImageChange(System::TObject* Sender);
	void __fastcall TextChange(System::TObject* Sender);
	void __fastcall SetItemEndTime(const System::TDateTime Value);
	void __fastcall SetItemStartTime(const System::TDateTime Value);
	System::TDateTime __fastcall GetItemEndTime(void);
	System::TDateTime __fastcall GetItemStartTime(void);
	AnsiString __fastcall GetItemEndTimeStr();
	AnsiString __fastcall GetItemStartTimeStr();
	AnsiString __fastcall GetItemSpanTimeStr();
	
protected:
	virtual AnsiString __fastcall GetDisplayName();
	void __fastcall UpdateWnd(void);
	void __fastcall CalcConflictRect(Windows::TRect &r, int w, int h, bool position);
	
public:
	__fastcall virtual TPlannerItem(Classes::TCollection* Collection);
	__fastcall virtual ~TPlannerItem(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall ScrollInView(void);
	void __fastcall Edit(void);
	__property System::TObject* ItemObject = {read=fObject, write=fObject};
	__property int ID = {read=fID, write=fID, nodefault};
	__property int Conflicts = {read=fConflicts, nodefault};
	__property int ConflictPos = {read=fConflictPos, nodefault};
	__property bool Focus = {read=fFocus, write=SetFocus, nodefault};
	__property TPlannerIntList* ImageIndexList = {read=fPlannerIntList, write=fPlannerIntList};
	__property System::TDateTime ItemStartTime = {read=GetItemStartTime, write=SetItemStartTime};
	__property System::TDateTime ItemEndTime = {read=GetItemEndTime, write=SetItemEndTime};
	__property AnsiString ItemStartTimeStr = {read=GetItemStartTimeStr};
	__property AnsiString ItemEndTimeStr = {read=GetItemEndTimeStr};
	__property AnsiString ItemSpanTimeStr = {read=GetItemSpanTimeStr};
	void __fastcall DefOrganize(void);
	__property TPlannerItem* LinkedItem = {read=fLinkedItem, write=fLinkedItem};
	__property TPlannerLinkType LinkType = {read=fLinkType, write=fLinkType, nodefault};
	
__published:
	__property Classes::TAlignment Alignment = {read=fAlignment, write=SetAlignment, nodefault};
	__property bool AllowOverlap = {read=fAllowOverlap, write=SetAllowOverlap, nodefault};
	__property bool Background = {read=fBackground, write=SetBackground, nodefault};
	__property TCaptionType CaptionType = {read=fCaptionType, write=SetCaptionType, nodefault};
	__property AnsiString CaptionText = {read=fCaptionText, write=SetCaptionText};
	__property int ItemBegin = {read=fItemBegin, write=SetItemBegin, nodefault};
	__property int ItemEnd = {read=fItemEnd, write=SetItemEnd, nodefault};
	__property Classes::TStringList* Text = {read=fText, write=SetText};
	__property Graphics::TColor Color = {read=fColor, write=SetColor, nodefault};
	__property bool ReadOnly = {read=fReadOnly, write=fReadOnly, nodefault};
	__property bool FixedPos = {read=fFixedPos, write=fFixedPos, nodefault};
	__property bool FixedSize = {read=fFixedSize, write=fFixedSize, nodefault};
	__property Graphics::TFont* Font = {read=fFont, write=SetFont};
	__property int Tag = {read=fTag, write=fTag, nodefault};
	__property TPlannerItemEdit InplaceEdit = {read=fInplaceEdit, write=fInplaceEdit, nodefault};
	__property int ImageID = {read=fImageID, write=SetImageID, nodefault};
	__property int ItemPos = {read=fItemPos, write=SetItemPos, nodefault};
	__property bool Visible = {read=fVisible, write=SetVisible, nodefault};
	__property AnsiString Name = {read=fName, write=fName};
	__property AnsiString EditMask = {read=fEditMask, write=fEditMask};
	__property Graphics::TColor TrackColor = {read=fTrackColor, write=SetTrackColor, nodefault};
	__property int Layer = {read=fLayer, write=SetLayer, nodefault};
};


class DELPHICLASS TPlannerIO;
class PASCALIMPLEMENTATION TPlannerIO : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
__published:
	TPlannerItems* fItems;
	
public:
	__fastcall virtual TPlannerIO(Classes::TComponent* AOwner);
	__fastcall virtual ~TPlannerIO(void);
	
__published:
	__property TPlannerItems* Items = {read=fItems, write=fItems};
};


//-- var, const, procedure ---------------------------------------------------
static const Byte NumColors = 0xff;
static const Shortint MAX_COLS = 0x1f;
static const Byte MAX_ROWS = 0xff;
extern PACKAGE void __fastcall OutputDebugstr(AnsiString s);

}	/* namespace Planner */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Planner;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// planner
