{*******************************************************************
TPLANNER component demo application
version 0.9, August 2000

written by TMS Software
           copyright  1999-2000
           Email : info@tmssoftware.com
           Web : http://www.tmssoftware.com
********************************************************************}

unit Uplan;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  planner, Buttons, StdCtrls, Spin, ExtCtrls, ComCtrls, shellapi, Menus, Mask
  {$IFDEF VER120} ,ImgList {$ENDIF}
  {$IFDEF VER130} ,ImgList {$ENDIF}
  ;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    DayPlanner: TPlanner;
    monthplanner: TPlanner;
    Panel2: TPanel;
    unitgroup: TRadioGroup;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    SpinEdit2: TSpinEdit;
    Label2: TLabel;
    SpinEdit3: TSpinEdit;
    SpinEdit4: TSpinEdit;
    SpinEdit5: TSpinEdit;
    SpinEdit6: TSpinEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    ImageList1: TImageList;
    CheckBox3: TCheckBox;
    SpeedButton1: TSpeedButton;
    ColorDialog1: TColorDialog;
    CheckBox4: TCheckBox;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    CheckBox5: TCheckBox;
    SpeedButton8: TSpeedButton;
    BoldBtn: TSpeedButton;
    ItalBtn: TSpeedButton;
    UnderBtn: TSpeedButton;
    SpeedButton12: TSpeedButton;
    FontDialog1: TFontDialog;
    SpeedButton9: TSpeedButton;
    CheckBox6: TCheckBox;
    hourformat: TCheckBox;
    ImageList2: TImageList;
    SpeedButton10: TSpeedButton;
    PrintDialog1: TPrintDialog;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    StatusBar1: TStatusBar;
    TabSheet3: TTabSheet;
    ResPlanner: TPlanner;
    EventList: TListBox;
    Label10: TLabel;
    Label11: TLabel;
    StatusBar2: TStatusBar;
    Button4: TButton;
    RadioGroup1: TRadioGroup;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button5: TButton;
    Button6: TButton;
    CheckBox10: TCheckBox;
    Button7: TButton;
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure SpinEdit4Change(Sender: TObject);
    procedure SpinEdit5Change(Sender: TObject);
    procedure SpinEdit6Change(Sender: TObject);
    procedure unitgroupClick(Sender: TObject);
    procedure DayPlannerPlannerRightClick(Sender: TObject; position,
      fromSel, fromSelPrecis, toSel, toSelPrecis: Integer);
    procedure monthplannerPlannerRightClick(Sender: TObject; position, fromSel,
      fromSelPrecis, toSel, toSelPrecis: Integer);
    procedure SpeedButton1Click(Sender: TObject);
    procedure DayPlannerItemDelete(Sender: TObject; Item: TPlannerItem);
    procedure monthplannerItemDelete(Sender: TObject; Item: TPlannerItem);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure DayPlannerPlannerNext(Sender: TObject);
    procedure DayPlannerPlannerPrev(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure BoldBtnClick(Sender: TObject);
    procedure DayPlannerItemSelChange(Sender: TObject; Item: TPlannerItem);
    procedure SpeedButton12Click(Sender: TObject);
    procedure ItalBtnClick(Sender: TObject);
    procedure UnderBtnClick(Sender: TObject);
    procedure DayPlannerItemRightClick(Sender: TObject;
      Item: TPlannerItem);
    procedure FontNameChange(Sender: TObject);
    procedure SpeedButton9Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure hourformatClick(Sender: TObject);
    procedure DayPlannerItemImageClick(Sender: TObject; Item: TPlannerItem;
      ImageIdx: Integer);
    procedure DayPlannerHeaderClick(Sender: TObject; SectionIdx: Integer);
    procedure SpeedButton10Click(Sender: TObject);
    procedure DayPlannerItemAnchorClick(Sender: TObject;
      Item: TPlannerItem; Anchor: String);
    procedure monthplannerItemLeftClick(Sender: TObject;
      Item: TPlannerItem);
    procedure ResPlannerDragOverCell(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure ResPlannerDragDropCell(Sender, Source: TObject; X,
      Y: Integer);
    procedure DayPlannerItemAnchorEnter(Sender: TObject;
      Item: TPlannerItem; Anchor: String);
    procedure DayPlannerItemAnchorExit(Sender: TObject; Item: TPlannerItem;
      Anchor: String);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure ResPlannerItemAnchorClick(Sender: TObject;
      Item: TPlannerItem; Anchor: String);
    procedure DayPlannerPlannerMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure CheckBox10Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
  private
    day:tdatetime;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses uhelp;

{$R *.DFM}

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
 dayplanner.display.displayscale:=spinedit1.value;
end;

procedure TForm1.SpinEdit2Change(Sender: TObject);
begin
 dayplanner.positions:=spinedit2.value;
end;

procedure TForm1.SpinEdit3Change(Sender: TObject);
begin
 dayplanner.display.displaystart:=spinedit3.value;
end;

procedure TForm1.SpinEdit4Change(Sender: TObject);
begin
 dayplanner.display.displayend:=spinedit4.value;
end;

procedure TForm1.SpinEdit5Change(Sender: TObject);
begin
 dayplanner.display.activestart:=spinedit5.value;
end;

procedure TForm1.SpinEdit6Change(Sender: TObject);
begin
 dayplanner.display.activeend:=spinedit6.value;
end;

procedure TForm1.unitgroupClick(Sender: TObject);
begin
 case unitgroup.itemindex of
 0:dayplanner.display.displayunit:=5;
 1:dayplanner.display.displayunit:=6;
 2:dayplanner.display.displayunit:=10;
 3:dayplanner.display.displayunit:=15;
 4:dayplanner.display.displayunit:=30;
 5:dayplanner.display.displayunit:=60;
 end;

 spinedit3.value:=dayplanner.display.DisplayStart;
 spinedit4.value:=dayplanner.display.DisplayEnd;

end;

procedure TForm1.DayPlannerPlannerRightClick(Sender: TObject; position,
  fromSel, fromSelPrecis, toSel, toSelPrecis: Integer);
begin
 if dayplanner.Items.HasItem(fromSel,toSel,position) then
  begin
   showmessage('Cannot create item.'#13#10'Selected period already contains an item without overlap !');
   exit;
  end;


 with (dayplanner.Items.Add) do
  begin
   Text.Add('This item is created at');
   Text.Add('run-time in the planner');
   Text.Add('at '+timetostr(now));
   AllowOverlap:=not checkbox8.checked;
   Name:='Test';
   // ItemStartTime:=encodetime(12,30,0,0);
   // ItemEndTime:=encodetime(13,30,0,0);

   if checkbox1.checked then CaptionType:=ctTime;
   if checkbox2.checked then IMageID:=0;

   if checkbox4.checked then ImageIndexList.Add(0);
   if checkbox4.checked then ImageIndexList.Add(1);
   if checkbox4.checked then ImageIndexList.Add(2);

   FixedSize:=checkbox3.checked;
   FixedPos:=checkbox7.checked;

   ReadOnly:=checkbox5.checked;
   Background:=checkbox9.checked;

   ItemPos:=position;
   ItemEnd:=toSel;
   ItemBegin:=fromSel;


  end;

end;

procedure TForm1.monthplannerPlannerRightClick(Sender: TObject; position,
  fromSel, fromSelPrecis, toSel, toSelPrecis: Integer);
begin
 with (monthplanner.Items.Add) do
  begin
   Text.Add('Test');
   ItemEnd:=toSel;
   ItemBegin:=fromSel;
   ItemPos:=position;
   CaptionType:=ctTime;
  end;

end;


procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
 if assigned(dayplanner.items.Selected) then
  begin
   colordialog1.color:=dayplanner.items.Selected.color;
   if colordialog1.execute then
    dayplanner.items.Selected.Color:=colordialog1.color;
  end;
end;

procedure TForm1.DayPlannerItemDelete(Sender: TObject; Item: TPlannerItem);
begin
 Item.Free;
end;

procedure TForm1.monthplannerItemDelete(Sender: TObject;
  Item: TPlannerItem);
begin
 Item.Free;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
 if assigned(dayplanner.items.Selected) then
  dayplanner.Items.Selected.Alignment:=taLeftJustify;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
 if assigned(dayplanner.items.Selected) then
  dayplanner.Items.Selected.Alignment:=taCenter;

end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
 if assigned(dayplanner.items.Selected) then
  dayplanner.Items.Selected.Alignment:=taRightJustify;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
 dayplanner.SavetoHTML('test.htm');
 shellexecute(self.handle,'open','test.htm',nil,nil,sw_normal);
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
 form2.show;
end;

procedure TForm1.SpeedButton7Click(Sender: TObject);
begin
 with dayplanner.items.add do
  begin
   visible:=false;
   itempos:=dayplanner.selposition;
   itembegin:=dayplanner.selitembegin;
   itemend:=dayplanner.selitemend;

   Text.Add('This item is created');
   Text.Add('with the new button');
   Text.Add('at '+timetostr(now));
   if checkbox1.checked then CaptionType:=ctTime;
   if checkbox2.checked then IMageID:=0;
   if checkbox4.checked then ImageIndexList.Add(1);
   if checkbox4.checked then ImageIndexList.Add(2);

   FixedSize:=checkbox3.checked;
   FixedPos:=checkbox7.checked;
   ReadOnly:=checkbox5.checked;
   visible:=true;
  end;

end;

procedure TForm1.DayPlannerPlannerNext(Sender: TObject);
var
 ye,mo,da:word;
 s:string;
 fs:tfilestream;
begin
 decodedate(day,ye,mo,da);
 s:=format('%.4d%.2d%.2d',[ye,mo,da])+'.dat';
 if (dayplanner.items.Count>0) then
  begin
   fs:=TFileStream.Create(s,fmCreate);
   dayplanner.savetostream(fs);
   fs.Free;
  end
 else
  begin
   if fileexists(s) then deletefile(s);
  end;

 day:=day+1;
 dayplanner.Caption.Title :=formatdatetime(' DDD MMM, d YYYY',day);
 dayplanner.items.Clear;

 decodedate(day,ye,mo,da);
 s:=format('%.4d%.2d%.2d',[ye,mo,da])+'.dat';
 if fileexists(s) then
  begin
   fs:=TFileStream.Create(s,fmOpenRead);
   dayplanner.loadfromstream(fs);
   fs.Free;
  end;
end;

procedure TForm1.DayPlannerPlannerPrev(Sender: TObject);
var
 ye,mo,da:word;
 s:string;
 fs:tfilestream;

begin
 decodedate(day,ye,mo,da);
 s:=format('%.4d%.2d%.2d',[ye,mo,da])+'.dat';
 if (dayplanner.items.Count>0) then
  begin
   fs:=TFileStream.Create(s,fmCreate);
   dayplanner.savetostream(fs);
   fs.Free;
  end
 else
  begin
   if fileexists(s) then deletefile(s);
  end;


 day:=day-1;
 dayplanner.Caption.Title :=formatdatetime(' DDD MMM, d YYYY',day);
 dayplanner.items.Clear;
 decodedate(day,ye,mo,da);
 s:=format('%.4d%.2d%.2d',[ye,mo,da])+'.dat';
 if fileexists(s) then
  begin
   fs:=TFileStream.Create(s,fmOpenRead);
   dayplanner.loadfromstream(fs);
   fs.Free;
  end;

end;



procedure TForm1.FormCreate(Sender: TObject);
begin
 day:=now;
 dayplanner.Caption.Title :=formatdatetime(' DDD MMM, d YYYY',day);
{
 dayplanner.header.Captions.Strings[1]:='Meeting room 1'#13#10'Building A1';
 dayplanner.header.Captions.Strings[2]:='Meeting room 1'#13#10'Building B2';
 dayplanner.header.Captions.Strings[3]:='Meeting room 1'#13#10'Building C3';
}
 dayplanner.Items.Items[0].ScrollInView;

 dayplanner.backgroundcolor[1,35]:=rgb(192,255,225);
 dayplanner.backgroundcolor[2,36]:=rgb(192,255,225);
 dayplanner.backgroundcolor[3,37]:=rgb(192,252,225);

 timeamstring:='AM';
 timepmstring:='PM';

end;

procedure TForm1.SpeedButton8Click(Sender: TObject);
begin
 with dayplanner do
  begin
   richedit.text:='Rich text';
   richedit.selstart:=0;
   richedit.sellength:=4;
   richedit.selattributes.color:=clRed;
   richedit.selattributes.style:=[fsBold];
   richedit.selstart:=5;
   richedit.sellength:=4;
   richedit.selattributes.color:=clBlue;
   richedit.selattributes.style:=[fsItalic];
  end;

 with dayplanner.items.add do
  begin
   visible:=false;
   itempos:=dayplanner.selposition;
   itembegin:=dayplanner.selitembegin;
   itemend:=dayplanner.selitemend;

   Text.Text:=dayplanner.richtotext;

   if checkbox1.checked then CaptionType:=ctTime;
   if checkbox2.checked then IMageID:=0;
   if checkbox4.checked then ImageIndexList.Add(1);
   if checkbox4.checked then ImageIndexList.Add(2);

   FixedSize:=checkbox3.checked;
//   ReadOnly:=true;
   visible:=true;
  end;

end;

procedure TForm1.BoldBtnClick(Sender: TObject);
begin
 if BoldBtn.Down then
  DayPlanner.RichEdit.SelAttributes.Style:= DayPlanner.RichEdit.SelAttributes.Style+[fsBold]
 else
  DayPlanner.RichEdit.SelAttributes.Style:= DayPlanner.RichEdit.SelAttributes.Style-[fsBold];
end;

procedure TForm1.DayPlannerItemSelChange(Sender: TObject;
  Item: TPlannerItem);
begin
 BoldBtn.Down:= fsBold in DayPlanner.RichEdit.SelAttributes.Style;
 ItalBtn.Down:= fsItalic in DayPlanner.RichEdit.SelAttributes.Style;
 UnderBtn.Down:= fsUnderline in DayPlanner.RichEdit.SelAttributes.Style;



end;          

procedure TForm1.SpeedButton12Click(Sender: TObject);
begin
 if colordialog1.execute then
  begin
   DayPlanner.RichEdit.SelAttributes.Color:=colordialog1.Color;
  end;

end;

procedure TForm1.ItalBtnClick(Sender: TObject);
begin
 if ItalBtn.Down then
  DayPlanner.RichEdit.SelAttributes.Style:= DayPlanner.RichEdit.SelAttributes.Style+[fsItalic]
 else
  DayPlanner.RichEdit.SelAttributes.Style:= DayPlanner.RichEdit.SelAttributes.Style-[fsItalic];

end;

procedure TForm1.UnderBtnClick(Sender: TObject);
begin
 if UnderBtn.Down then
  DayPlanner.RichEdit.SelAttributes.Style:= DayPlanner.RichEdit.SelAttributes.Style+[fsUnderline]
 else
  DayPlanner.RichEdit.SelAttributes.Style:= DayPlanner.RichEdit.SelAttributes.Style-[fsUnderline];
end;

procedure TForm1.DayPlannerItemRightClick(Sender: TObject;
  Item: TPlannerItem);
begin

 if assigned(item) then
  begin
//   showmessage(timetostr(item.itemstarttime)+#13+timetostr(item.itemendtime));

   showmessage(inttostr(item.itempos)+#13+inttostr(item.conflicts)+#13+inttostr(item.conflictpos));

//   item.itemstarttime:=encodetime(10,30,0,0);
//   item.itemendtime:=encodetime(11,30,0,0);


//   messagedlg(item.text.text,mtinformation,[mbok],0);
   {
   colordialog1.color:=item.color;
   if colordialog1.execute then
    item.Color:=colordialog1.color;
   }


  end;

end;

procedure TForm1.FontNameChange(Sender: TObject);
begin

 DayPlanner.RichEdit.SelAttributes.Name:=self.Text;
 DayPlanner.RichEdit.visible:=true;
end;

procedure TForm1.SpeedButton9Click(Sender: TObject);
begin
 if fontdialog1.execute then
  begin
   DayPlanner.RichEdit.SelAttributes.Name:=fontdialog1.font.name;
   DayPlanner.RichEdit.SelAttributes.Style:=fontdialog1.font.style;
   DayPlanner.RichEdit.SelAttributes.Size:=fontdialog1.font.Size;

  end;
end;

procedure TForm1.CheckBox6Click(Sender: TObject);
begin
 dayplanner.EditRTF := checkbox6.checked;
end;

procedure TForm1.hourformatClick(Sender: TObject);
begin
 if hourformat.Checked then dayplanner.HourType := ht12hrs else
  dayplanner.HourType:=ht24hrs;
end;

procedure TForm1.DayPlannerItemImageClick(Sender: TObject;
  Item: TPlannerItem; ImageIdx: Integer);
begin

 if (Item.ImageIndexList.Count>0) then
  begin
   if ImageIdx=0 then
   begin
   if Item.ImageIndexList.Items[0]=5 then
    Item.ImageIndexList.Items[0]:=6
   else
    Item.ImageIndexList.Items[0]:=5;
   end; 
  end
 else
  begin
   if Item.ImageID=5 then Item.ImageID:=6 else Item.ImageID:=5;
  end;
end;

procedure TForm1.DayPlannerHeaderClick(Sender: TObject;
  SectionIdx: Integer);
begin
 messagedlg('you clicked header '+inttostr(sectionidx),mtinformation,[mbok],0);
end;

procedure TForm1.SpeedButton10Click(Sender: TObject);
begin
 if printdialog1.execute then dayplanner.print;
end;

procedure TForm1.DayPlannerItemAnchorClick(Sender: TObject;
  Item: TPlannerItem; Anchor: String);
begin
 showmessage('Clicked anchor in item : '+anchor);
end;

procedure TForm1.monthplannerItemLeftClick(Sender: TObject;
  Item: TPlannerItem);
begin
  statusbar1.simpletext:='Selected item planned time is '#13'From : '+datetostr(item.itemstarttime)+#13'To : '+datetostr(item.itemendtime);
end;

procedure TForm1.ResPlannerDragOverCell(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var
 c1,c2,c3:boolean;

begin
 c1:= assigned(ResPlanner.CellToItem(x,y));
 c2:= assigned(ResPlanner.CellToItem(x+1,y));
 c3:= assigned(ResPlanner.CellToItem(x+2,y));

 if Source=EventList then
  begin
   accept:=not (c1 or c2 or c3);
  end
 else
  accept:=false;


end;

procedure TForm1.ResPlannerDragDropCell(Sender, Source: TObject; X,
  Y: Integer);
var
 selitem:string;

begin
 with Source as TListBox do
  begin
   selitem:=Items[ItemIndex];
   Items.Delete(ItemIndex);
  end;

  with ResPlanner.Items.Add do
   begin
    ItemBegin:=x;
    ItemEnd:=x+3;
    ItemPos:=y;
    Text.Add(selitem);
    AllowOverlap:=false;

   end;
end;

procedure TForm1.DayPlannerItemAnchorEnter(Sender: TObject;
  Item: TPlannerItem; Anchor: String);
begin
   statusbar2.simpletext:=Anchor;
end;

procedure TForm1.DayPlannerItemAnchorExit(Sender: TObject;
  Item: TPlannerItem; Anchor: String);
begin
 statusbar2.simpletext:='';
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 resplanner.insertposition(2);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 resplanner.deleteposition(2);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 resplanner.moveposition(5,3);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 resplanner.print;
end;

procedure TForm1.Button5Click(Sender: TObject);
var
 pl1,pl2:tplanneritem;
begin
 resplanner.insertposition(resplanner.positions);
 resplanner.insertposition(resplanner.positions);
 resplanner.Header.Captions[resplanner.positions-1]:='New pos 1';
 resplanner.Header.Captions[resplanner.positions]:='New pos 2';
 pl1:=resplanner.Items.Add;
 pl2:=resplanner.Items.Add;
 with pl1 do
  begin
   ItemBegin:=5;
   ItemEnd:=10;
   ItemPos:=resplanner.positions-2;
   linkeditem:=pl2;
   linktype:=ltLinkFull;
   text.Add('Linked to 2');
  end;
 with pl2 do
  begin
   ItemBegin:=5;
   ItemEnd:=10;
   ItemPos:=resplanner.positions-1;
   text.Add('Linked from 1');
  end;

end;

procedure TForm1.Button6Click(Sender: TObject);
var
 pl1,pl2:tplanneritem;
begin
 resplanner.insertposition(resplanner.positions);
 resplanner.insertposition(resplanner.positions);
 resplanner.Header.Captions[resplanner.positions-1]:='New pos 1';
 resplanner.Header.Captions[resplanner.positions]:='New pos 2';

 pl1:=resplanner.Items.Add;
 pl2:=resplanner.Items.Add;
 with pl1 do
  begin
   ItemBegin:=1;
   ItemEnd:=5;
   ItemPos:=resplanner.positions-2;
   linkeditem:=pl2;
   linktype:=ltLinkEndBegin;
   text.Add('Linked to 2');
  end;
 with pl2 do
  begin
   ItemBegin:=5;
   ItemEnd:=10;
   ItemPos:=resplanner.positions-1;
   linkeditem:=pl1;
   linktype:=ltLinkBeginEnd;
   text.Add('Linked to 1');
  end;

end;

procedure TForm1.ResPlannerItemAnchorClick(Sender: TObject;
  Item: TPlannerItem; Anchor: String);
begin
  shellexecute(self.handle,'open',pchar(anchor),nil,nil,SW_NORMAL);
end;

procedure TForm1.DayPlannerPlannerMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
 rc:tpoint;
 i,j:integer;
 s:string;
 plit:tplanneritem;
begin
 rc:=dayplanner.XytoCell(x,y);
 j:=dayplanner.celltoitemnum(rc.x,rc.y);

 for i:=1 to j do
  begin
    plit:=dayplanner.celltoitemidx(rc.x,rc.y,i-1);
    if assigned(plit) then
     s:=plit.text.text else s:='';
  end;

end;

procedure TForm1.CheckBox10Click(Sender: TObject);
begin
 dayplanner.EditDirect:=checkbox10.checked;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
 resplanner.SavetoHTML('test.htm');
 shellexecute(self.handle,'open','test.htm',nil,nil,sw_normal);
end;

end.
