unit PEConsts;

interface

  uses Graphics;

  const
    PlanColors : array[0..31] of TColor = (clBlack, clMaroon, clGreen, clOlive, clNavy, clPurple, clTeal, clGray, clSilver, clRed, clLime, clYellow,
                                           clBlue, clFuchsia, clAqua, clWhite, TColor($008080FF), TColor($0080FFFF), TColor($0080FF80), TColor($0080FF00),
                                           TColor($00FFFF80), TColor($00FF8000), TColor($00C080FF), TColor($00FF80FF), TColor($00C08080),
                                           TColor($00404080), TColor($004080FF), TColor($00804000), TColor($00FF8080), TColor($00400080),
                                           TColor($008000FF), TColor($00A00000));

  resourcestring
     sLayerObjects             = 'Objects: %d';
     sTotalObjects             = 'Total objects: %d';
     sPropertyNameHeader       = 'Property';
     sPropertyValueHeader      = 'Value';
     sExitProgram              = 'Exit the Oxygen Plan Editor?';
     sBrushSolid               = 'Solid';
     sBrushClear               = 'Clear';
     sPlanSaveWarning          = 'Current Plan is not saved. Do you want to save it now?';
     sChildObjects             = 'Child objects: ';
     sLine                     = 'Line';
     sRectangle                = 'Rectangle';
     sCircle                   = 'Circle';
     sPolygon                  = 'Polygon';
     sPolyLine                 = 'PolyLine';
     sTraceLine                = 'TraceLine';
     sPicture                  = 'Picture';
     sAniPicture               = 'Animated picture';
     sAniGif                   = 'Animated GIF';
     sText                     = 'Text';
     sStartAnimating           = 'Start';
     sStopAnimating            = 'Stop';
     sAddLayerCaption          = 'Add new layer';
     sAddLayerPrompt           = 'Enter new layer name: ';
     sLayer                    = 'Layer ';
     sLayerNameExists          = 'Layer named %s already exists. Enter the new name?';
     sLayerNameEmpty           = 'Layer name can not be an empty string. Enter the new name?';
     sRemoveLayerHasChildren   = 'Layer %s has %d child object(s). When the layer will be removed, all these objects will be removed too. Do you want to remove layer %s?';
     sRemoveLayer              = ' Remove the layer %s ?';
     sRenameLayerCaption       = 'Rename layer';
     sRenameLayerPrompt        = 'Enter the new layer name: ';
     sPropertyAddCaption       = 'Add custom property';
     sPropertyAddPrompt        = 'Enter the new custom property name: ';
     sPropertyNameIsEmpty      = 'Custom property name can not be an empty string';
     sPropertyAlreadyExists    = 'Current object already has the %s property. Please, try again';
     sAddPropertyValueCaption  = 'Property value';
     sAddPropertyValuePrompt   = 'Enter the %s property value: ';
     sRemoveCurrentObject      = 'Do you want to remove current object (%s : %s) ?';
     sAddTextCaption           = 'Text';
     sAddTextPrompt            = 'Enter the text: ';
     sPeriodCaption            = 'Period';
     sPeriodPrompt             = 'Enter the animation period (in milliseconds): ';
     sAddStdPictureCaption     = 'Add Standard Picture';
     sAddStdPicturePrompt      = 'Enter the Standard Picture name: ';
     sStdPictureAlreadyExists  = 'Standard Picture named %s already exists';
     sRenameStdPictureCaption  = 'Rename Standard Picture';
     sRenameStdPicturePrompt   = 'Enter the Standard Picture name: ';
     sStdPictureHasReferences  = 'Standard Picture %s has %d references in the current plan. Delete all these picture objects first.';
     sStdPictureDeleteConfirm  = 'Do you really want to delete Standard Picture %s';
     sStdPictureReplaceConfirm = 'Do you want to replace existing picture with clipboard data?';
     sErrorGettingImage        = 'Error getting an image: ';
     sAddStdAniGifCaption      = 'Add Standard Animated GIF';
     sAddStdAniGifPrompt       = 'Enter the Standard Animated GIF name: ';
     sStdAniGifAlreadyExists   = 'Standard Animated GIF named %s already exists';
     sRenameStdAniGifCaption   = 'Rename Standard Animated GIF';
     sRenameStdAniGifPrompt    = 'Enter the Standard Animated GIF name: ';
     sStdAniGifHasReferences   = 'Standard Animated GIF %s has %d references in the current plan. Delete all these picture objects first.';
     sStdAniGifDeleteConfirm   = 'Do you really want to delete Standard Animated GIF %s';
     sStdAniGifReplaceConfirm  = 'Do you want to replace existing animated GIF with clipboard data?';
     sRemoveCustomProperty     = 'Remove custom property %s ?';
     sFindNameIsEmpty          = 'Name of object to find is empty';
     sFindIDIsZero             = 'ID of object to find is zero (default value for all new plan objects)';
     sCantFindObject           = 'Can''t find object satisfying selected criteria';
     sUnknownObjectType        = 'Unknown object type!';

implementation

end.
