// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'PlanObjects.pas' rev: 5.00

#ifndef PlanObjectsHPP
#define PlanObjectsHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <PlanUtils.hpp>	// Pascal unit
#include <jpeg.hpp>	// Pascal unit
#include <VCLUtils.hpp>	// Pascal unit
#include <RxGIF.hpp>	// Pascal unit
#include <TimerLst.hpp>	// Pascal unit
#include <StrF.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Planobjects
{
//-- type declarations -------------------------------------------------------
typedef TMetaClass*TPlanObjectClass;

#pragma option push -b-
enum TMarginType { mtNone, mtLeft, mtTopLeft, mtTop, mtTopRight, mtRight, mtBottomRight, mtBottom, mtBottomLeft, 
	mtMovePoint };
#pragma option pop

#pragma option push -b-
enum TCallHandler { chMouseDown, chMouseMove, chMouseUp };
#pragma option pop

#pragma option push -b-
enum TBlinkType { btNone, btPen, btBrush, btPicture, btFont, btText };
#pragma option pop

typedef Windows::TPoint TPointArray[10001];

typedef Windows::TPoint *PPointArray;

class DELPHICLASS TGradientRecord;
class PASCALIMPLEMENTATION TGradientRecord : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	Graphics::TColor StartColor;
	Graphics::TColor EndColor;
	Planutils::TGradientFillDirection Direction;
	Byte Colors;
	bool Active;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TGradientRecord(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TGradientRecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanLayer;
class DELPHICLASS TPlanObject;
class PASCALIMPLEMENTATION TPlanLayer : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Controls::TCustomControl* FOwner;
	Classes::TList* FObjectList;
	bool FVisible;
	HRGN HRegion;
	bool FReadOnly;
	TPlanObject* __fastcall GetObject(int Index);
	int __fastcall GetObjectsCount(void);
	void __fastcall SetVisible(bool Value);
	void __fastcall SetReadOnly(const bool Value);
	
public:
	AnsiString Name;
	int Index;
	__property TPlanObject* Objects[int Index] = {read=GetObject/*, default*/};
	__property int Count = {read=GetObjectsCount, nodefault};
	__property bool ReadOnly = {read=FReadOnly, write=SetReadOnly, nodefault};
	__property bool Visible = {read=FVisible, write=SetVisible, nodefault};
	__fastcall TPlanLayer(Controls::TCustomControl* AOwner);
	HIDESBASE void __fastcall Free(void);
	int __fastcall Add(TPlanObject* PlanObject);
	int __fastcall IndexOf(TPlanObject* PlanObject);
	void __fastcall Delete(int Index);
	void __fastcall Clear(void);
	void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	TPlanObject* __fastcall ObjectFromCoord(int X, int Y, TMarginType &MarginType);
	void __fastcall SetTopObject(TPlanObject* PlanObject);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanLayer(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanLayers;
class PASCALIMPLEMENTATION TPlanLayers : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Controls::TCustomControl* FOwner;
	Classes::TList* FLayersList;
	TPlanLayer* __fastcall NewLayer(const AnsiString LName);
	TPlanLayer* __fastcall Get(int Index);
	void __fastcall Put(int Index, TPlanLayer* Layer);
	int __fastcall GetCount(void);
	
public:
	__property TPlanLayer* Layers[int Index] = {read=Get, write=Put/*, default*/};
	__property int Count = {read=GetCount, nodefault};
	__fastcall TPlanLayers(Controls::TCustomControl* AOwner);
	HIDESBASE void __fastcall Free(void);
	int __fastcall Add(const AnsiString LayerName);
	void __fastcall Delete(int Index);
	int __fastcall IndexOf(const AnsiString LayerName);
	void __fastcall Clear(void);
	TPlanLayer* __fastcall LayerByName(const AnsiString LayerName);
	void __fastcall AddLayersDescr(Classes::TStrings* sl);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanLayers(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TPlanObject : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Controls::TCustomControl* FOwner;
	TPlanObject* FParent;
	Classes::TList* FChildren;
	TPlanLayer* FLayer;
	int FID;
	AnsiString FName;
	bool FSelected;
	Graphics::TPen* FPen;
	Graphics::TBrush* FBrush;
	Graphics::TColor FSelectColor;
	bool FVisible;
	bool FCanResize;
	HRGN FClippingRgn;
	bool FDestroying;
	bool FReadOnly;
	Classes::TStrings* FProperties;
	Controls::TCursor FCursor;
	TGradientRecord* FGradientRecord;
	int FBlinkTimerHandle;
	TBlinkType FBlinkType;
	Graphics::TPen* FBlinkPen;
	Graphics::TPen* FSavePen;
	Graphics::TBrush* FBlinkBrush;
	Graphics::TBrush* FSaveBrush;
	int FBlinkIndex;
	int __fastcall GetChildrenCount(void);
	virtual void __fastcall SetPen(Graphics::TPen* Value);
	virtual void __fastcall SetBrush(Graphics::TBrush* Value);
	virtual void __fastcall SetLayer(TPlanLayer* Value);
	void __fastcall SetName(AnsiString Value);
	int __fastcall GetObjectsCount(void);
	TPlanObject* __fastcall GetObject(int Index);
	void __fastcall SetParent(TPlanObject* Value);
	virtual void __fastcall SetSelected(bool Value);
	bool __fastcall GetSelectedByColor(void);
	void __fastcall SetVisible(const bool Value);
	bool __fastcall GetBlinking(void);
	
protected:
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	virtual void __fastcall SaveCoords(void);
	virtual Windows::TRect __fastcall GetDisplayRect(void) = 0 ;
	virtual void __fastcall DrawChildren(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight
		);
	virtual void __fastcall BlinkTimer(System::TObject* Sender);
	virtual HRGN __fastcall GetClippingRgn(void);
	void __fastcall SetReadOnly(const bool Value);
	void __fastcall SetProperties(Classes::TStrings* Value);
	
public:
	__property Classes::TStrings* Properties = {read=FProperties, write=SetProperties};
	__property bool Blinking = {read=GetBlinking, nodefault};
	__property TBlinkType BlinkType = {read=FBlinkType, write=FBlinkType, nodefault};
	__property Graphics::TPen* BlinkPen = {read=FBlinkPen};
	__property Graphics::TBrush* BlinkBrush = {read=FBlinkBrush};
	__property Graphics::TBrush* Brush = {read=FBrush, write=SetBrush};
	__property bool CanResize = {read=FCanResize, write=FCanResize, nodefault};
	__property int ChildrenCount = {read=GetChildrenCount, nodefault};
	__property Controls::TCursor Cursor = {read=FCursor, write=FCursor, nodefault};
	__property Windows::TRect DisplayRect = {read=GetDisplayRect};
	__property TGradientRecord* GradientRecord = {read=FGradientRecord};
	__property int ID = {read=FID, write=FID, nodefault};
	__property AnsiString Name = {read=FName, write=SetName};
	__property TPlanLayer* Layer = {read=FLayer, write=SetLayer};
	__property TPlanObject* Objects[int Index] = {read=GetObject};
	__property int ObjectsCount = {read=GetObjectsCount, nodefault};
	__property AnsiString ObjectTypeDescr = {read=GetObjectTypeDescr};
	__property Controls::TCustomControl* Owner = {read=FOwner};
	__property TPlanObject* Parent = {read=FParent, write=SetParent};
	__property Graphics::TPen* Pen = {read=FPen, write=SetPen};
	__property bool ReadOnly = {read=FReadOnly, write=SetReadOnly, nodefault};
	__property bool Selected = {read=FSelected, write=SetSelected, nodefault};
	__property bool SelectedByColor = {read=GetSelectedByColor, nodefault};
	__property bool Visible = {read=FVisible, write=SetVisible, nodefault};
	virtual void __fastcall AddObjectDescr(const int SpaceNum, Classes::TStrings* sl);
	virtual bool __fastcall AddPoint(const int CoordX, const int CoordY, TCallHandler CallHandler) = 0 
		;
	virtual bool __fastcall CanBeParent(void) = 0 ;
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent) = 0 ;
	__fastcall virtual TPlanObject(Controls::TCustomControl* Owner);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight) = 0 ;
		
	virtual void __fastcall EditMove(const Windows::TPoint &APoint);
	virtual void __fastcall EditResize(const Windows::TPoint &APoint) = 0 ;
	virtual void __fastcall FillObjectProperties(void);
	HIDESBASE virtual void __fastcall Free(void);
	virtual bool __fastcall HasInternalPoint(int X, int Y) = 0 ;
	virtual bool __fastcall HasInternalProperty(const AnsiString PropertyName);
	virtual bool __fastcall HasMarginPoint(int X, int Y, TMarginType &MarginType) = 0 ;
	virtual void __fastcall Move(const int DeltaX, const int DeltaY);
	virtual void __fastcall Resize(const int DeltaX, const int DeltaY) = 0 ;
	virtual void __fastcall NeedRepaint(void) = 0 ;
	virtual TPlanObject* __fastcall ObjectFromCoord(int X, int Y, TMarginType &MarginType);
	virtual void __fastcall ParentResized(void);
	virtual void __fastcall Select(void);
	virtual void __fastcall SelectByColor(const Graphics::TColor AColor);
	void __fastcall SetTopObject(TPlanObject* PlanObject);
	virtual void __fastcall StartBlink(const int Interval);
	virtual void __fastcall StopBlink(void);
	virtual void __fastcall UnSelect(void);
	virtual void __fastcall UnSelectColor(void);
	virtual void __fastcall UpdateObjectProperties(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanObject(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanLine;
class PASCALIMPLEMENTATION TPlanLine : public TPlanObject 
{
	typedef TPlanObject inherited;
	
private:
	int Fx1;
	int Fy1;
	int Fx2;
	int Fy2;
	Windows::TPoint ScrSave1;
	Windows::TPoint ScrSave2;
	void __fastcall SetX1(int Value);
	void __fastcall SetX2(int Value);
	void __fastcall SetY1(int Value);
	void __fastcall SetY2(int Value);
	Windows::TPoint __fastcall GetScrPoint1(void);
	Windows::TPoint __fastcall GetScrPoint2(void);
	void __fastcall SetScrPoint1(const Windows::TPoint &p);
	void __fastcall SetScrPoint2(const Windows::TPoint &p);
	
protected:
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	virtual void __fastcall SaveCoords(void);
	virtual HRGN __fastcall GetClippingRgn(void);
	
public:
	__property int X1 = {read=Fx1, write=SetX1, nodefault};
	__property int Y1 = {read=Fy1, write=SetY1, nodefault};
	__property int X2 = {read=Fx2, write=SetX2, nodefault};
	__property int Y2 = {read=Fy2, write=SetY2, nodefault};
	__property Windows::TPoint ScrPoint1 = {read=GetScrPoint1, write=SetScrPoint1};
	__property Windows::TPoint ScrPoint2 = {read=GetScrPoint2, write=SetScrPoint2};
	virtual bool __fastcall AddPoint(const int CoordX, const int CoordY, TCallHandler CallHandler);
	virtual bool __fastcall CanBeParent(void);
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent);
	__fastcall virtual TPlanLine(Controls::TCustomControl* Owner);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	virtual void __fastcall FillObjectProperties(void);
	virtual Windows::TRect __fastcall GetDisplayRect(void);
	virtual bool __fastcall HasInternalPoint(int X, int Y);
	virtual bool __fastcall HasInternalProperty(const AnsiString PropertyName);
	virtual bool __fastcall HasMarginPoint(int X, int Y, TMarginType &MarginType);
	virtual void __fastcall EditMove(const Windows::TPoint &APoint);
	virtual void __fastcall EditResize(const Windows::TPoint &APoint);
	virtual void __fastcall NeedRepaint(void);
	virtual void __fastcall Move(const int DeltaX, const int DeltaY);
	virtual void __fastcall Resize(const int DeltaX, const int DeltaY);
	virtual void __fastcall UpdateObjectProperties(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanLine(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanBox;
class PASCALIMPLEMENTATION TPlanBox : public TPlanObject 
{
	typedef TPlanObject inherited;
	
private:
	int Fx1;
	int Fy1;
	int Fx2;
	int Fy2;
	Windows::TPoint ScrSave1;
	Windows::TPoint ScrSave2;
	void __fastcall SetX1(int Value);
	void __fastcall SetX2(int Value);
	void __fastcall SetY1(int Value);
	void __fastcall SetY2(int Value);
	Windows::TPoint __fastcall GetScrPoint1(void);
	Windows::TPoint __fastcall GetScrPoint2(void);
	void __fastcall SetScrPoint1(const Windows::TPoint &p);
	void __fastcall SetScrPoint2(const Windows::TPoint &p);
	
protected:
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	virtual void __fastcall SaveCoords(void);
	
public:
	__property int X1 = {read=Fx1, write=SetX1, nodefault};
	__property int Y1 = {read=Fy1, write=SetY1, nodefault};
	__property int X2 = {read=Fx2, write=SetX2, nodefault};
	__property int Y2 = {read=Fy2, write=SetY2, nodefault};
	__property Windows::TPoint ScrPoint1 = {read=GetScrPoint1, write=SetScrPoint1};
	__property Windows::TPoint ScrPoint2 = {read=GetScrPoint2, write=SetScrPoint2};
	virtual bool __fastcall AddPoint(const int CoordX, const int CoordY, TCallHandler CallHandler);
	virtual bool __fastcall CanBeParent(void);
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent);
	__fastcall virtual TPlanBox(Controls::TCustomControl* Owner);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	virtual void __fastcall FillObjectProperties(void);
	virtual Windows::TRect __fastcall GetDisplayRect(void);
	virtual bool __fastcall HasInternalPoint(int X, int Y);
	virtual bool __fastcall HasInternalProperty(const AnsiString PropertyName);
	virtual bool __fastcall HasMarginPoint(int X, int Y, TMarginType &MarginType);
	virtual void __fastcall EditMove(const Windows::TPoint &APoint);
	virtual void __fastcall EditResize(const Windows::TPoint &APoint);
	virtual void __fastcall NeedRepaint(void);
	virtual void __fastcall Move(const int DeltaX, const int DeltaY);
	virtual void __fastcall Resize(const int DeltaX, const int DeltaY);
	virtual void __fastcall UpdateObjectProperties(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanBox(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanEllipse;
class PASCALIMPLEMENTATION TPlanEllipse : public TPlanBox 
{
	typedef TPlanBox inherited;
	
protected:
	virtual HRGN __fastcall GetClippingRgn(void);
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	
public:
	__property X1 ;
	__property Y1 ;
	__property X2 ;
	__property Y2 ;
	__property ScrPoint1 ;
	__property ScrPoint2 ;
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	virtual bool __fastcall HasInternalPoint(int X, int Y);
	virtual bool __fastcall HasMarginPoint(int X, int Y, TMarginType &MarginType);
	virtual void __fastcall EditMove(const Windows::TPoint &APoint);
	virtual void __fastcall NeedRepaint(void);
	virtual void __fastcall EditResize(const Windows::TPoint &APoint);
	virtual void __fastcall Move(const int DeltaX, const int DeltaY);
	virtual void __fastcall Resize(const int DeltaX, const int DeltaY);
public:
	#pragma option push -w-inl
	/* TPlanBox.Create */ inline __fastcall virtual TPlanEllipse(Controls::TCustomControl* Owner) : TPlanBox(
		Owner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanEllipse(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanCircle;
class PASCALIMPLEMENTATION TPlanCircle : public TPlanObject 
{
	typedef TPlanObject inherited;
	
private:
	int Fx;
	int Fy;
	int FRadius;
	Windows::TPoint ScrSaveCenter;
	int ScrSaveRadius;
	void __fastcall SetX(int Value);
	void __fastcall SetY(int Value);
	void __fastcall SetRadius(int Value);
	Windows::TPoint __fastcall GetScrCenter(void);
	int __fastcall GetScrRadius(void);
	void __fastcall SetScrCenter(const Windows::TPoint &p);
	void __fastcall SetScrRadius(int r);
	
protected:
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	virtual void __fastcall SaveCoords(void);
	virtual HRGN __fastcall GetClippingRgn(void);
	
public:
	__property int X = {read=Fx, write=SetX, nodefault};
	__property int Y = {read=Fy, write=SetY, nodefault};
	__property int Radius = {read=FRadius, write=SetRadius, nodefault};
	__property Windows::TPoint ScrCenter = {read=GetScrCenter, write=SetScrCenter};
	__property int ScrRadius = {read=GetScrRadius, write=SetScrRadius, nodefault};
	virtual bool __fastcall AddPoint(const int CoordX, const int CoordY, TCallHandler CallHandler);
	virtual bool __fastcall CanBeParent(void);
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent);
	__fastcall virtual TPlanCircle(Controls::TCustomControl* Owner);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	virtual void __fastcall FillObjectProperties(void);
	virtual Windows::TRect __fastcall GetDisplayRect(void);
	virtual bool __fastcall HasInternalPoint(int X, int Y);
	virtual bool __fastcall HasInternalProperty(const AnsiString PropertyName);
	virtual bool __fastcall HasMarginPoint(int X, int Y, TMarginType &MarginType);
	virtual void __fastcall EditMove(const Windows::TPoint &APoint);
	virtual void __fastcall NeedRepaint(void);
	virtual void __fastcall EditResize(const Windows::TPoint &APoint);
	virtual void __fastcall Move(const int DeltaX, const int DeltaY);
	virtual void __fastcall Resize(const int DeltaX, const int DeltaY);
	virtual void __fastcall UpdateObjectProperties(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanCircle(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanText;
class PASCALIMPLEMENTATION TPlanText : public TPlanBox 
{
	typedef TPlanBox inherited;
	
private:
	AnsiString FText;
	AnsiString FSaveText;
	AnsiString FBlinkText;
	Graphics::TFont* FFont;
	Graphics::TFont* FSaveFont;
	Graphics::TFont* FBlinkFont;
	Classes::TAlignment FAlignment;
	int FEscapement;
	void __fastcall SetText(AnsiString Value);
	void __fastcall SetFont(Graphics::TFont* Value);
	void __fastcall SetAlignment(Classes::TAlignment Value);
	void __fastcall SetEscapement(const int Value);
	
protected:
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	virtual void __fastcall BlinkTimer(System::TObject* Sender);
	
public:
	__property Graphics::TFont* BlinkFont = {read=FBlinkFont};
	__property AnsiString BlinkText = {read=FBlinkText, write=FBlinkText};
	__property X1 ;
	__property Y1 ;
	__property X2 ;
	__property Y2 ;
	__property AnsiString Text = {read=FText, write=SetText};
	__property Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property Classes::TAlignment Alignment = {read=FAlignment, write=SetAlignment, nodefault};
	__property int Escapement = {read=FEscapement, write=SetEscapement, nodefault};
	__property ScrPoint1 ;
	__property ScrPoint2 ;
	virtual bool __fastcall CanBeParent(void);
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent);
	__fastcall virtual TPlanText(Controls::TCustomControl* Owner);
	virtual void __fastcall Free(void);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	virtual void __fastcall FillObjectProperties(void);
	virtual bool __fastcall HasInternalProperty(const AnsiString PropertyName);
	virtual void __fastcall StartBlink(const int Interval);
	virtual void __fastcall StopBlink(void);
	virtual void __fastcall UpdateObjectProperties(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanText(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanPicture;
class PASCALIMPLEMENTATION TPlanPicture : public TPlanBox 
{
	typedef TPlanBox inherited;
	
private:
	Graphics::TPicture* FPicture;
	Graphics::TPicture* FSavePicture;
	Graphics::TPicture* FBlinkPicture;
	AnsiString FStdPictureName;
	void __fastcall SetStdPictureName(const AnsiString Value);
	bool __fastcall GetTransparent(void);
	void __fastcall SetTransparent(const bool Value);
	
protected:
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	virtual void __fastcall BlinkTimer(System::TObject* Sender);
	
public:
	__property Graphics::TPicture* BlinkPicture = {read=FBlinkPicture};
	__property X1 ;
	__property Y1 ;
	__property X2 ;
	__property Y2 ;
	__property ScrPoint1 ;
	__property ScrPoint2 ;
	__property AnsiString StdPictureName = {read=FStdPictureName, write=SetStdPictureName};
	__property Graphics::TPicture* Picture = {read=FPicture};
	__property bool Transparent = {read=GetTransparent, write=SetTransparent, nodefault};
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent);
	__fastcall virtual TPlanPicture(Controls::TCustomControl* Owner);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	virtual void __fastcall FillObjectProperties(void);
	virtual void __fastcall Free(void);
	virtual bool __fastcall HasInternalProperty(const AnsiString PropertyName);
	virtual void __fastcall StartBlink(const int Interval);
	virtual void __fastcall StopBlink(void);
	virtual void __fastcall UpdateObjectProperties(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanPicture(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanAniPicture;
class PASCALIMPLEMENTATION TPlanAniPicture : public TPlanPicture 
{
	typedef TPlanPicture inherited;
	
private:
	int FImageIndex;
	int FImageCount;
	Graphics::TBitmap* FCurBitmap;
	int FInterval;
	void __fastcall SetImageIndex(const int Value);
	void __fastcall SetImageCount(const int Value);
	
protected:
	virtual void __fastcall BlinkTimer(System::TObject* Sender);
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	
public:
	__property int ImageCount = {read=FImageCount, write=SetImageCount, nodefault};
	__property int ImageIndex = {read=FImageIndex, write=SetImageIndex, nodefault};
	__property int Interval = {read=FInterval, write=FInterval, nodefault};
	virtual bool __fastcall CanBeParent(void);
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent);
	__fastcall virtual TPlanAniPicture(Controls::TCustomControl* Owner);
	void __fastcall Animate(const int Interval);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	virtual void __fastcall FillObjectProperties(void);
	virtual void __fastcall Free(void);
	virtual bool __fastcall HasInternalProperty(const AnsiString PropertyName);
	virtual void __fastcall StartBlink(const int Interval);
	void __fastcall Stop(void);
	virtual void __fastcall StopBlink(void);
	virtual void __fastcall UpdateObjectProperties(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanAniPicture(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanPolygon;
class PASCALIMPLEMENTATION TPlanPolygon : public TPlanObject 
{
	typedef TPlanObject inherited;
	
private:
	int FPointCount;
	Windows::TPoint *FPointArray;
	Windows::TPoint *FScrPointArray;
	Windows::TPoint *FScrSaveArray;
	Windows::TPoint *FDrawArray;
	int FCurMovingPointIndex;
	void __fastcall SetPointCount(int Value);
	Windows::TPoint __fastcall GetPoint(int Index);
	void __fastcall SetPoint(int Index, const Windows::TPoint &Value);
	
protected:
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	virtual void __fastcall SaveCoords(void);
	virtual HRGN __fastcall GetClippingRgn(void);
	
public:
	__property int PointCount = {read=FPointCount, write=SetPointCount, nodefault};
	__property Windows::TPoint Points[int Index] = {read=GetPoint, write=SetPoint};
	virtual bool __fastcall AddPoint(const int CoordX, const int CoordY, TCallHandler CallHandler);
	virtual bool __fastcall CanBeParent(void);
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent);
	__fastcall virtual TPlanPolygon(Controls::TCustomControl* Owner);
	virtual void __fastcall ParentResized(void);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	void __fastcall DeletePoint(const int Index);
	virtual void __fastcall FillObjectProperties(void);
	virtual void __fastcall Free(void);
	virtual Windows::TRect __fastcall GetDisplayRect(void);
	virtual bool __fastcall HasInternalPoint(int X, int Y);
	virtual bool __fastcall HasInternalProperty(const AnsiString PropertyName);
	virtual bool __fastcall HasMarginPoint(int X, int Y, TMarginType &MarginType);
	virtual void __fastcall EditMove(const Windows::TPoint &APoint);
	virtual void __fastcall NeedRepaint(void);
	virtual void __fastcall EditResize(const Windows::TPoint &APoint);
	virtual void __fastcall Move(const int DeltaX, const int DeltaY);
	virtual void __fastcall Resize(const int DeltaX, const int DeltaY);
	virtual void __fastcall UpdateObjectProperties(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanPolygon(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanPolyLine;
class PASCALIMPLEMENTATION TPlanPolyLine : public TPlanPolygon 
{
	typedef TPlanPolygon inherited;
	
protected:
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	virtual HRGN __fastcall GetClippingRgn(void);
	
public:
	__property PointCount ;
	__property Points ;
	virtual bool __fastcall AddPoint(const int CoordX, const int CoordY, TCallHandler CallHandler);
	virtual bool __fastcall CanBeParent(void);
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	virtual bool __fastcall HasInternalPoint(int X, int Y);
public:
	#pragma option push -w-inl
	/* TPlanPolygon.Create */ inline __fastcall virtual TPlanPolyLine(Controls::TCustomControl* Owner) : 
		TPlanPolygon(Owner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanPolyLine(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanTraceLine;
class PASCALIMPLEMENTATION TPlanTraceLine : public TPlanPolyLine 
{
	typedef TPlanPolyLine inherited;
	
protected:
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	
public:
	__property PointCount ;
	__property Points ;
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	virtual Windows::TRect __fastcall GetDisplayRect(void);
public:
	#pragma option push -w-inl
	/* TPlanPolygon.Create */ inline __fastcall virtual TPlanTraceLine(Controls::TCustomControl* Owner)
		 : TPlanPolyLine(Owner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanTraceLine(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanCompositeObject;
class PASCALIMPLEMENTATION TPlanCompositeObject : public TPlanBox 
{
	typedef TPlanBox inherited;
	
private:
	virtual void __fastcall SetPen(Graphics::TPen* Value);
	virtual void __fastcall SetBrush(Graphics::TBrush* Value);
	virtual void __fastcall SetSelected(bool Value);
	
protected:
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	
public:
	virtual bool __fastcall CanBeParent(void);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	virtual void __fastcall Select(void);
	virtual void __fastcall UnSelect(void);
	virtual void __fastcall SelectByColor(const Graphics::TColor AColor);
	virtual void __fastcall UnSelectColor(void);
public:
	#pragma option push -w-inl
	/* TPlanBox.Create */ inline __fastcall virtual TPlanCompositeObject(Controls::TCustomControl* Owner
		) : TPlanBox(Owner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanCompositeObject(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPlanAniGif;
class PASCALIMPLEMENTATION TPlanAniGif : public TPlanBox 
{
	typedef TPlanBox inherited;
	
private:
	Rxgif::TGIFImage* FImage;
	AnsiString FStdAniGifName;
	unsigned __fastcall GetDelayTime(int Index);
	void __fastcall SetStdAniGifName(const AnsiString Value);
	void __fastcall SetGIFImage(Rxgif::TGIFImage* Value);
	int __fastcall GetFrameIndex(void);
	void __fastcall SetFrameIndex(const int Value);
	int __fastcall GetFrameCount(void);
	
protected:
	virtual void __fastcall BlinkTimer(System::TObject* Sender);
	Graphics::TBitmap* __fastcall GetFrameBitmap(int Index, Graphics::TColor &TransColor);
	virtual AnsiString __fastcall GetObjectTypeDescr(void);
	
public:
	__property AnsiString StdAniGifName = {read=FStdAniGifName, write=SetStdAniGifName};
	__property Rxgif::TGIFImage* GIFImage = {read=FImage, write=SetGIFImage};
	__property int FrameIndex = {read=GetFrameIndex, write=SetFrameIndex, nodefault};
	__property int FrameCount = {read=GetFrameCount, nodefault};
	virtual bool __fastcall CanBeParent(void);
	virtual TPlanObject* __fastcall Clone(TPlanObject* Parent);
	__fastcall virtual TPlanAniGif(Controls::TCustomControl* Owner);
	void __fastcall Animate(void);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const int CWidth, const int CHeight);
	virtual void __fastcall FillObjectProperties(void);
	virtual void __fastcall Free(void);
	virtual bool __fastcall HasInternalProperty(const AnsiString PropertyName);
	virtual void __fastcall StartBlink(const int Interval);
	virtual void __fastcall StopBlink(void);
	void __fastcall Stop(void);
	virtual void __fastcall UpdateObjectProperties(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPlanAniGif(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE System::ResourceString _ocLine;
#define Planobjects_ocLine System::LoadResourceString(&Planobjects::_ocLine)
extern PACKAGE System::ResourceString _ocBox;
#define Planobjects_ocBox System::LoadResourceString(&Planobjects::_ocBox)
extern PACKAGE System::ResourceString _ocCircle;
#define Planobjects_ocCircle System::LoadResourceString(&Planobjects::_ocCircle)
extern PACKAGE System::ResourceString _ocEllipse;
#define Planobjects_ocEllipse System::LoadResourceString(&Planobjects::_ocEllipse)
extern PACKAGE System::ResourceString _ocText;
#define Planobjects_ocText System::LoadResourceString(&Planobjects::_ocText)
extern PACKAGE System::ResourceString _ocPicture;
#define Planobjects_ocPicture System::LoadResourceString(&Planobjects::_ocPicture)
extern PACKAGE System::ResourceString _ocPolygon;
#define Planobjects_ocPolygon System::LoadResourceString(&Planobjects::_ocPolygon)
extern PACKAGE System::ResourceString _ocPolyLine;
#define Planobjects_ocPolyLine System::LoadResourceString(&Planobjects::_ocPolyLine)
extern PACKAGE System::ResourceString _ocTraceLine;
#define Planobjects_ocTraceLine System::LoadResourceString(&Planobjects::_ocTraceLine)
extern PACKAGE System::ResourceString _ocCompositeObject;
#define Planobjects_ocCompositeObject System::LoadResourceString(&Planobjects::_ocCompositeObject)
extern PACKAGE System::ResourceString _ocAniGif;
#define Planobjects_ocAniGif System::LoadResourceString(&Planobjects::_ocAniGif)
extern PACKAGE System::ResourceString _ocAniPicture;
#define Planobjects_ocAniPicture System::LoadResourceString(&Planobjects::_ocAniPicture)
extern PACKAGE System::ResourceString _sStartObject;
#define Planobjects_sStartObject System::LoadResourceString(&Planobjects::_sStartObject)
extern PACKAGE System::ResourceString _sEndObject;
#define Planobjects_sEndObject System::LoadResourceString(&Planobjects::_sEndObject)
extern PACKAGE void __fastcall SelectRectRgn(Graphics::TCanvas* ACanvas, Graphics::TColor SelectColor
	, const Windows::TPoint &p1, const Windows::TPoint &p2);

}	/* namespace Planobjects */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Planobjects;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// PlanObjects
