unit demou;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, PCSC,ShellAPI, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Memo1: TMemo;
    Button1: TButton;
    APDUCard1: TAPDUDemoCard;
    Panel1: TPanel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Button5: TButton;
    Memo2: TMemo;
    CheckBox1: TCheckBox;
    RadioGroup3: TRadioGroup;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    Button6: TButton;
    Button7: TButton;
    procedure Button1Click(Sender: TObject);
    procedure APDUCard1ReaderNameChange(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure APDUCard1Connected(Sender: TObject; Reader: TSmartcardReader;
      State: TReaderState);
    procedure APDUCard1Disconnected(Sender: TObject;
      Reader: TSmartcardReader; State: TReaderState);
    procedure APDUCard1CardAbsent(Sender: TObject;
      Reader: TSmartcardReader; State: TReaderState);
    procedure APDUCard1CardSwallowed(Sender: TObject;
      Reader: TSmartcardReader; State: TReaderState);
    procedure RadioGroup3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button7Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
 APDUCard1.SelectReader;
end;

procedure TForm1.APDUCard1ReaderNameChange(Sender: TObject);
begin
 memo2.lines.Clear;
 memo2.lines.ADD(apducard1.readername);
 memo2.lines.ADD('[reader info]');
 memo2.lines.ADD(ReaderStateToString(apducard1.ReaderState));
 memo2.lines.ADD(apducard1.AtrString);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 ShellExecute(0,'OPEN','http://friko3.onet.pl/ld/vizyp/delphi.htm','','',SW_SHOW);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
 apducard1.autoreset:=checkbox1.checked;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
 sh:TCardShare;
 pr:TProtocol;
begin
 case radiogroup2.ItemIndex of
  0:pr:=pr_Undefined;
  1:pr:=pr_Default;
  2:pr:=pr_T0;
  3:pr:=pr_T1;
  4:pr:=pr_Raw;
  else
  begin
   ShowMessage('Protocol not selected!');
   exit;
  end;
 end;
 case radiogroup3.ItemIndex of
  0:sh:=sm_Direct;
  1:sh:=sm_Shared;
  2:sh:=sm_Exclusive;
  else
  begin
   ShowMessage('Sharemode not selected!');
   exit;
  end;
 end;
 apducard1.Connect(sh,pr);
end;

procedure TForm1.Button6Click(Sender: TObject);
var
 filename:array[0..MAX_PATH] of char;
begin
 GetModuleFileName(0,filename,sizeof(filename));
 ShellExecute(handle,'OPEN',filename,'',nil,SW_SHOW);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 try
  apducard1.Command.hex:=edit1.text;
 except
  on Exception do begin
   ShowMessage('The command is in wrong format. Should be in hex format, eg. A0 05 01 23 40 60');
   exit;
  end;
 end;
 if apducard1.TransmitAndCheck = apduerr_OK then
  edit2.text:='Answer:'+apducard1.Answer.Hex+'['+apducard1.ResultDescription+']'
 else
  edit2.text:='Transmission failed. Error:'+apducard1.ResultDescription;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
 case radiogroup1.ItemIndex of
  0:apducard1.Disconnect(cd_Leave);
  1:apducard1.Disconnect(cd_Reset);
  2:apducard1.Disconnect(cd_Unpower);
 end;
end;

procedure TForm1.APDUCard1Connected(Sender: TObject;
  Reader: TSmartcardReader; State: TReaderState);
begin
 memo2.lines[1]:='Vendor name:'+Reader.Attribute[SCARD_ATTR_VENDOR_NAME].Str+' Channel:COM'+IntToHex(reader.Attribute[SCARD_ATTR_CHANNEL_ID].Byte,2);
 memo2.lines[2]:= ReaderStateToString(state);
end;

procedure TForm1.APDUCard1Disconnected(Sender: TObject;
            Reader: TSmartcardReader; State: TReaderState);
begin
 memo2.lines.Clear;
 memo2.lines.ADD(apducard1.readername);
 memo2.lines.ADD('Not connected');
 memo2.lines.ADD(ReaderStateToString(apducard1.ReaderState));
 memo2.lines.ADD(apducard1.AtrString);
end;

procedure TForm1.APDUCard1CardAbsent(Sender: TObject;
  Reader: TSmartcardReader; State: TReaderState);
begin
 memo2.lines[3]:='';
 memo2.lines[2]:= ReaderStateToString(state);
end;

procedure TForm1.APDUCard1CardSwallowed(Sender: TObject;
  Reader: TSmartcardReader; State: TReaderState);
begin
 memo2.lines[3]:=apducard1.AtrString;
 memo2.lines[2]:= ReaderStateToString(state);
end;


procedure TForm1.RadioGroup3Click(Sender: TObject);
begin
 if (RadioGroup3.ItemIndex=0) then
  RadioGroup2.ItemIndex:=0
 else
  RadioGroup2.ItemIndex:=1;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 try
  memo1.lines.loadfromfile('info.txt');
 except
  on Exception do
  if memo1.lines.count=0 then
  begin
   memo1.lines.Add('TAPDUDemoCard sample applicaiton.');
   memo1.Lines.Add('For more information go to page http://friko3.onet.pl/ld/vizyp  .');
  end; 
 end;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
 Close;
end;

end.
