type
 TCardState = (cs_CardUnknown,cs_CardAbsent,cs_CardPresent,cs_CardSwallowed,cs_CardPowered,cs_NegotiableMode,cs_SpecificMode);
 TReaderStates = (rs_NoReader,rs_Ignore,rs_Unaware,rs_ReaderUnknown,rs_Unavailable,rs_Empty,rs_CardPresent,rs_Exclusive,rs_Shared,rs_Unpowered,rs_Mute);
 TReaderState  = set of TReaderStates;
 TProtocol = (pr_T0,pr_T1,pr_Raw,pr_Undefined,pr_Default,pr_Error);
 TCardShare = (sm_Shared,sm_Exclusive,sm_Direct);
 TDisposition = (cd_Leave,cd_Reset,cd_Unpower,cd_Eject,cd_Swallow);

TAPDUCard = class(TComponent)
public
   constructor Create(aowner:TComponent);override;
   destructor  Destroy;override;
// Readerd being monitored
   function    SelectReader:boolean;
   property    ReaderName:string;
   property    CardPresent:boolean; // Readonly
   property    ReaderFound:boolean; // Readonly
   property    State:TCardState; // Readonly
   property    ReaderState:TReaderState; // Readonly
// Connection to the reader
   procedure   Disconnect(disposition:TDisposition);
   procedure   Connect(sharemode:TCardShare;prefprotocol:TProtocol);
   property    Connected:boolean; // Readonly
// ATR of the inserted card
   property    ATRString:string; // Readonly
   property    ATR:TATR; // Readonly
   property    ATRLength:dword; // Readonly
// APDU command transmission
   property    Answer:TAnswerAPDUBuffer;// Readonly
   property    Command:TCommandAPDUBuffer;// Readonly
   procedure   Transmit;
   function    TransmitAndCheck:integer;virtual;
   function    ResultDescription:string;virtual;
   function    ResultIsError:boolean;virtual;
   property    SW1:byte;
   property    SW2:byte;
   property    SW:word;
   property    DefaultCLA:byte;
// Transactions
   procedure   Reserve;
   procedure   Release;
 published
   property    OnCardSwallowed:TReaderEvent read FOnCardSwallowed write FOnCardSwallowed;
   property    OnCardAbsent:TReaderEvent read FOnCardAbsent write FOnCardAbsent;

   property    OnConnected:TReaderEvent read FOnConnected write FOnConnected;
   property    OnDisconnected:TReaderEvent read FOnDisconnected write FOnDisconnected;

   property    OnBeginTransaction:TReaderEvent read FOnBeginTransaction write FOnBeginTransaction;
   property    OnEndTransaction:TReaderEvent read FOnEndTransaction write FOnEndTransaction;

   property    OnCommandError:TNotifyEvent read FOnCommandError write FOnCommandError;

   property    OnReaderNameChange:TNotifyEvent read FOnReaderNameChange write FOnReaderNameChange;
   property    AutoReset:boolean read FAutoReset write FAutoReset default True;
   property    Scope:TDatabaseScope read FDatabaseScope write WrDatabaseScope;
 end;