unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Menus, PEdit;

type
  TForm1 = class(TForm)
    PC1: TPropertiesComponent;
    Button1: TButton;
    MainMenu1: TMainMenu;
    Spyme1: TMenuItem;
    Label1: TLabel;
    Animate1: TAnimate;
    ComboBox1: TComboBox;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Uses PropUni,TypInfo;

Procedure MyFilterComp( AComp : TComponent;
                        Var ToSkip : Boolean);
Begin
  //Skip himself...
  ToSkip:=AComp.Name=Form1.PC1.Name;
End;

Procedure MyFilter ( Var PropName : String;
                     Var PropVal : String;
                     AComp : TComponent;
                     APropInfo: PPropInfo;
                     Var ToSkip : Boolean);
Begin
  //Skip string property
  ToSkip := APropInfo.PropType^.Kind=tkLString;
  //Modify property name
  If Not ToSkip Then PropName:='+'+PropName
End;

procedure TForm1.Button1Click(Sender: TObject);
begin
  PC1.SpyComp(TComponent(Sender));
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  PC1.SpyComp(MainMenu1);
end;

Function EditControlScrollBar (AComponent : TObject; APropInfo : PPropInfo) : String;
Begin
  MessageDlg('Editing ControlScrollBar of component ' + TComponent(AComponent).Name, mtConfirmation, mbOkCancel, 0);
End;

procedure TForm1.FormCreate(Sender: TObject);
begin
  //Create new editor for TControlScrollBar property
  AddEditor ( 'TControlScrollBar', EditControlScrollBar );
  //Set a filter for properties
  PC1.SetFilterProperties ( MyFilter );
  //Set a filter for Components
  PC1.SetFilterComponent( MyFilterComp );
  //Change som properties...
  PC1.FormProperties.Caption:='Hi!';
  PC1.SpyComp(Self);
end;

end.
