unit fdemo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, Fctpars, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Close1: TMenuItem;
    Change1: TMenuItem;
    Term1: TMenuItem;
    N1: TMenuItem;
    xmin1: TMenuItem;
    xmax1: TMenuItem;
    ymin1: TMenuItem;
    ymax1: TMenuItem;
    Showinfo1: TMenuItem;
    Rescale1: TMenuItem;
    FunctionParser1: TFunctionParser;
    ParserDeclarations1: TParserDeclarations;
    PaintBox1: TPaintBox;
    N2: TMenuItem;
    Resolution1: TMenuItem;
    StatusBar1: TStatusBar;
    procedure Showinfo1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Term1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure Rescale1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    xmin, xmax, ymin, ymax: extended;
    ymincur, ymaxcur: extended;
    resolution: integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{(*1*),(*2*),(*3*) and (*Aa*) were performed at design time}

procedure TForm1.PaintBox1Paint(Sender: TObject);
var i: integer;
    x,y: extended;
    oldvalid, newvalid: boolean;
    mx, my, tx, ty: extended;
begin
  if FunctionParser1.ErrorCode<>0 then exit;     (*Ca*)
  statusbar1.panels[0].text:='displayed x-range: '+floattostrF(xmin,fffixed,3,2)
                            +' ... '+floattostrF(xmax,fffixed,3,2);
  statusbar1.panels[1].text:='displayed y-range: '+floattostrF(ymin,fffixed,3,2)
                            +' ... '+floattostrF(ymax,fffixed,3,2);
  ymincur:=1e4000;
  ymaxcur:=-1e4000;
  caption:=FunctionParser1.Term;
  mx:=paintbox1.width/(xmax-xmin);
  tx:=mx*xmin;
  my:=paintbox1.height/(ymin-ymax);
  ty:=my*ymax;
  oldvalid:=false;
  paintbox1.canvas.pen.color:=clred;
  for i:=0 to RESOLUTION do begin
    x:=xmin+i*(xmax-xmin)/RESOLUTION;
    FunctionParser1.VarValues['x']:=x;   (*5*)
(*****************************************************************************
   Deactivate the debugger option "Break on Exceptions" (Tools|Environment|..)
   for uninterrupted running.
******************************************************************************)
    y:=FunctionParser1.Result;           (*6*)
    if y>ymaxcur then ymaxcur:=y;
    if y<ymincur then ymincur:=y;
    newvalid:=FunctionParser1.ErrorCode=0;   (*Ca*)
    if newvalid then begin
      if oldvalid then
        Paintbox1.canvas.lineto(round(mx*x-tx),round(my*y-ty))
        else  Paintbox1.canvas.moveto(round(mx*x-tx),round(my*y-ty));
    end;
    oldvalid:=newvalid;
  end;
  with paintbox1.canvas do begin
    pen.color:=clblack;             {axes}
    moveto(round(mx*xmin-tx),-round(ty));
    lineto(round(mx*xmax-tx),-round(ty));
    moveto(-round(tx),round(my*ymax-ty));
    lineto(-round(tx),round(my*ymin-ty));
  end;
end;

procedure TForm1.Term1Click(Sender: TObject);
var h: string;
    q: extended;
begin
  if sender = term1
    then begin
      h:=FunctionParser1.Term;
      FunctionParser1.Term:=inputbox('Graphic Demo','Enter the new Term',h);(*4*)
      if FunctionParser1.ErrorCode<>0                        (*Ca*)
        then showmessage(FunctionParser1.ErrorMessage); end
    else begin
       h:=inputbox('Graphic Demo','Enter the new value','');
       q:=strtofloat(h);
       if sender = xmin1 then xmin:=q else
       if sender = xmax1 then xmax:=q else
       if sender = ymin1 then ymin:=q else
       if sender = ymax1 then ymax:=q else
       if sender = resolution1 then resolution:=strtoint(h);
    end;
    rescale1.enabled:=true;
    paintbox1.repaint;
end;

function twice(x:extended):extended; {sample user function}
begin
 result:=2*x;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  xmin:=0; xmax:=10;
  ymin:=0; ymax:=10;
  resolution:= 200;
   FunctionParser1.Userfct:=twice;        (*D*)
   FunctionParser1.Declarations.Functions.Add('TWICE(ABC)=USERFCT(ABC)'); (*Aa*)
               {the userfunction is set to the function above and renamed}
   FunctionParser1.Term:='twice(exp(x/5))+odd(round(x))'; (*4*) {Term is initialized here}
   ParserDeclarations1.Constants.loadfromfile('Natconst.dat'); (*Ac*)
               { includes physical constants}
end;

procedure TForm1.Rescale1Click(Sender: TObject);
begin
  ymin:=ymincur;
  ymax:=ymaxcur;
  paintbox1.repaint;
  rescale1.enabled:=false;
end;

procedure TForm1.Showinfo1Click(Sender: TObject);
begin
  FunctionParser1.ShowInfo;
end;

procedure TForm1.Close1Click(Sender: TObject);
begin
  application.terminate;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  statusbar1.panels[0].width:=paintbox1.width div 2;
  statusbar1.panels[1].width:=paintbox1.width div 2;
end;

end.
