unit cdemo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, Buttons, ExtCtrls, Fctpars, Fctpars3; //FctPars3 was included manually

type
  TForm1 = class(TForm)
    ComplexParser1: TComplexParser;
    Bevel1: TBevel;
    Label1: TLabel;
    Edit1: TEdit;
    Bevel2: TBevel;
    Edit2: TEdit;
    Edit3: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    BitBtn1: TBitBtn;
    Button1: TButton;
    Button2: TButton;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    ParserDeclarations1: TParserDeclarations;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  z: TComplex;
  zvalid: boolean;

implementation

{$R *.DFM}

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
   with ComplexParser1 do begin
   {(*1*),(*2*),(*3*) and (*Ab*) were performed at design time}
     Term:=edit1.text;    (*4*)
     try
       z.re:=strtofloat(edit2.text);
       z.im:=strtofloat(edit3.text);
       zvalid:=true;
     except
       on EConvertError do begin
         label4.caption:='Unvalid complex number';
         zvalid:=false;
         exit; end;
     end;
     VarValues['z'].Assign(z);   (*5*)
(*****************************************************************************
          IMPORTANT: Deactivate the option "Break on Exceptions"
                     at Tools|Environment|Preferences|Debugger.
 *****************************************************************************)
      label4.caption:='The result is '+Result.AsString;  (*6*)
      if ErrorCode<>0 then label4.caption:=ErrorMessage; (*Ca*)
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  z:=TComplex.Create(0.0,1.0);
  edit2change(sender);
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
  bitbtn1click(sender);
  if zvalid then begin
     label2.caption:='|z| = '+floattostr(z.abs);
     label3.caption:='arg(z) = '+floattostr(z.arg); end
  else begin
     label2.caption:='';
     label3.caption:=''; end
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  z.free;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  application.terminate;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  label4.caption:='';
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 ComplexParser1.ShowInfo;
end;

end.
