unit Uparchklst;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, paramchklist, ComCtrls;

type
  TForm1 = class(TForm)
    ParamCheckList1: TParamCheckList;
    ImageList1: TImageList;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    Edit3: TEdit;
    Button2: TButton;
    Button3: TButton;
    StatusBar1: TStatusBar;
    procedure FormCreate(Sender: TObject);
    procedure ParamCheckList1ParamPopup(Sender: TObject; idx: Integer;
      href: String; values: TStringList; var DoPopup: Boolean);
    procedure ParamCheckList1ParamList(Sender: TObject; idx: Integer;
      href: String; values: TStringList; var DoPopup: Boolean);
    procedure ParamCheckList1ParamClick(Sender: TObject; idx: Integer;
      href: String; var value: String);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ParamCheckList1ParamSelect(Sender: TObject; idx: Integer;
      href, value: String);
    procedure ParamCheckList1ParamEnter(Sender: TObject; idx: Integer;
      href, value: String);
    procedure ParamCheckList1ParamExit(Sender: TObject; idx: Integer; href,
      value: String);
    procedure ParamCheckList1ParamHint(Sender: TObject; href: String;
      var hintvalue: String; var showhint: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
 paramchecklist1.comment[0]:=true;
 paramchecklist1.comment[4]:=true;
 paramchecklist1.indent[5]:=1;
 paramchecklist1.comment[7]:=true;

end;

procedure TForm1.ParamCheckList1ParamPopup(Sender: TObject; idx: Integer;
  href: String; values: TStringList; var DoPopup: Boolean);
begin
 if href='case' then
  begin
   dopopup:=true;
   values.Add('Desktop');
   values.Add('Midi tower');
   values.Add('Maxi tower');
  end;
 if href='keyb' then
  begin
   dopopup:=true;
   values.Add('Cherry');
   values.Add('Logitech');
   values.Add('Noname');
  end;
end;

procedure TForm1.ParamCheckList1ParamList(Sender: TObject; idx: Integer;
  href: String; values: TStringList; var DoPopup: Boolean);
begin
 if href='cpu' then
  begin
   dopopup:=true;
   values.Add('Pentium 750');
   values.Add('Pentium 800');
   values.Add('Pentium 900');
   values.Add('Pentium 950');
   values.Add('AMD 650');
   values.Add('AMD 750');
   values.Add('AMD 900');
  end;
end;

procedure TForm1.ParamCheckList1ParamClick(Sender: TObject; idx: Integer;
  href: String; var value: String);
begin
  if (href='os') or (href='cancel') then
   if value='Yes' then value:='No' else value:='Yes';
  if (href='name') then
   InputQuery('Customer','Name',value);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 edit1.text:=paramchecklist1.Parameter['case'];
 edit2.text:=paramchecklist1.Parameter['cpu'];
 edit3.text:=paramchecklist1.Parameter['keyb'];
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 paramchecklist1.Parameter['case']:=edit1.text;
 paramchecklist1.Parameter['cpu']:=edit2.text;
 paramchecklist1.Parameter['keyb']:=edit3.text;
end;

procedure TForm1.ParamCheckList1ParamSelect(Sender: TObject; idx: Integer;
  href, value: String);
begin
 statusbar1.simpletext:='Last selection : '+value;
end;

procedure TForm1.ParamCheckList1ParamEnter(Sender: TObject; idx: Integer;
  href, value: String);
begin
statusbar1.simpletext:=href+' = '+value;
end;

procedure TForm1.ParamCheckList1ParamExit(Sender: TObject; idx: Integer;
  href, value: String);
begin
statusbar1.simpletext:='';
end;

procedure TForm1.ParamCheckList1ParamHint(Sender: TObject; href: String;
  var hintvalue: String; var showhint: Boolean);
begin
 hintvalue := '';
 if href='os' then
  hintvalue:='Price of the OS is added to the total system price when Windows is choosen';
 if href='cpu' then
  hintvalue:='Specify AMD Athlon type or Intel Pentium III type';

end;

end.
