//==============================================================================
//  Pano Max Demo
//  (c) 1998, Pratical Soft
//
//  This is the form we use for the "remote control"
//  - which is really fust a fun way of showing
//  the possibilities of the Panorama control.
//  All of the buttons and edits change the respective
//  property on the Panorama control.
//
//==============================================================================

unit Remote;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, ComCtrls,
  Main;

type
  TRemoteForm = class(TForm)
    CameraViewAngleTrackBar: TTrackBar;
    HorizonLineTrackBar: TTrackBar;
    RenderCheckBox: TCheckBox;
    OpenPanoramaButton: TButton;
    OpenDialog: TOpenDialog;
    CameraLookAtAngleEdit: TEdit;
    SetLookAtButton: TButton;
    InertiaEdit: TEdit;
    SetInertiaButton: TButton;
    VelocityEdit: TEdit;
    MoveLeftButton: TButton;
    MoveRightButton: TButton;
    InputModeComboBox: TComboBox;
    CameraQualityComboBox: TComboBox;
    GetActualTimer: TTimer;
    RenderingPriorityEdit: TEdit;
    SetRenderingPriorityButton: TButton;
    FieldOfViewLabel: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    StatusLabel: TLabel;
    Label2: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    DrawInCheckBox: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure CameraViewAngleTrackBarChange(Sender: TObject);
    procedure HorizonLineTrackBarChange(Sender: TObject);
    procedure RenderCheckBoxClick(Sender: TObject);
    procedure OpenPanoramaButtonClick(Sender: TObject);
    procedure SetLookAtButtonClick(Sender: TObject);
    procedure SetInertiaButtonClick(Sender: TObject);
    procedure CameraQualityComboBoxChange(Sender: TObject);
    procedure InputModeComboBoxChange(Sender: TObject);
    procedure SetRenderingPriorityButtonClick(Sender: TObject);
    procedure DrawInCheckBoxClick(Sender: TObject);
    procedure MoveLeftButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MoveRightButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  RemoteForm: TRemoteForm;


implementation
{$R *.DFM}


procedure TRemoteForm.FormCreate(Sender: TObject);
begin
inherited;
// this makes the RemoteForm always above the MainForm window
  SetWindowPos(Handle, HWND_TOPMOST, 0,0,0,0, SWP_NOMOVE or SWP_NOSIZE);

  CameraQualityComboBox.ItemIndex:=1;
  InputModeComboBox.ItemIndex:=2;
  MainForm.Panorama.CameraQuality:= CameraQualityComboBox.ItemIndex;
  MainForm.Panorama.InputMode:=InputModeComboBox.ItemIndex;

//load the panorama image file
  if (MainForm.Panorama.OpenPanorama('middeck.jpg', 0) = False) then
    ShowMessage('Cant find the Panorama image!');
    
// start rendering
  MainForm.Panorama.Render:=True;
end;

procedure TRemoteForm.CameraViewAngleTrackBarChange(Sender: TObject);
begin
  MainForm.Panorama.CameraViewAngle:= CameraViewAngleTrackBar.Position;
  FieldOfViewLabel.Caption:='Field of View: ' +
             IntToStr(CameraViewAngleTrackBar.Position) + ' degrees';
end;


//change the respective properties on the Panorama control...
procedure TRemoteForm.HorizonLineTrackBarChange(Sender: TObject);
begin
    MainForm.Panorama.HorizonLine:= Round(HorizonLineTrackBar.position / 100 *
                                          MainForm.Panorama.Height);
end;

procedure TRemoteForm.RenderCheckBoxClick(Sender: TObject);
begin
  if (RenderCheckBox.State = cbChecked) then
    MainForm.Panorama.Render:=True
  else
    MainForm.Panorama.Render:=False;
end;

procedure TRemoteForm.OpenPanoramaButtonClick(Sender: TObject);
begin
  OpenDialog.Filter := 'Jpeg files (*.jpg)|*.jpg|Bitmap files (*.bmp)|*.bmp|All files (*.*)|*.*';
  OpenDialog.FilterIndex := 3;

  if OpenDialog.Execute then begin
    MainForm.Panorama.OpenPanorama(OpenDialog.FileName, 0);
  end;

end;

procedure TRemoteForm.SetLookAtButtonClick(Sender: TObject);
begin
  MainForm.Panorama.CameraLookAtAngle:=StrToInt(CameraLookAtAngleEdit.Text);
end;

procedure TRemoteForm.SetInertiaButtonClick(Sender: TObject);
begin
  MainForm.Panorama.CameraInertia:=StrToFloat(InertiaEdit.Text);
end;

procedure TRemoteForm.CameraQualityComboBoxChange(Sender: TObject);
begin
  MainForm.Panorama.CameraQuality:= CameraQualityComboBox.ItemIndex;
end;

procedure TRemoteForm.InputModeComboBoxChange(Sender: TObject);
begin
  MainForm.Panorama.InputMode:=InputModeComboBox.ItemIndex;
end;


procedure TRemoteForm.SetRenderingPriorityButtonClick(Sender: TObject);
begin
  MainForm.Panorama.RenderingPriority:=StrToInt(RenderingPriorityEdit.text);
end;


procedure TRemoteForm.DrawInCheckBoxClick(Sender: TObject);
begin
//force a rendering
    MainForm.Panorama.Render:=False;
    MainForm.Panorama.Render:=True;
end;

procedure TRemoteForm.MoveLeftButtonMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MainForm.Panorama.CameraVelocity:=-StrToFloat(VelocityEdit.Text);
end;

procedure TRemoteForm.MoveRightButtonMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MainForm.Panorama.CameraVelocity:=StrToFloat(VelocityEdit.Text);
end;

end.
