//==============================================================================
//  Pano Max Demo
//  (c) 1998, Pratical Soft
//
//  This is the form we use to hold the Panorama Control
//  It simply resizes the control when the form is resized
//  and some events are handled here, notably the
//  OnAfterRendering Event
//
//==============================================================================

unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Panorama;

type
  TMainForm = class(TForm)
    Panorama: TPanoramaControl;
    procedure FormResize(Sender: TObject);
    procedure PanoramaClick(Sender: TObject);
    procedure PanoramaMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PanoramaMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PanoramaMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure PanoramaAfterRendering(Sender: TObject);
  private
    { Private declarations }
    Ship: TBitmap;
    ShipDx: integer;
    procedure WMEraseBkgnd(var m: TWMEraseBkgnd); message WM_ERASEBKGND;

  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses Remote;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
// The panorama control brings this stock cursor - kind of a fat plus sign
  Panorama.cursor:=-22;

//  set the dimensions for the control
  Panorama.SetBounds(0,0, ClientWidth, ClientHeight);

//also we load a bitmap to latter demonstrate the OnAfterRenderingProperty
  Ship := TBitmap.Create;
  Ship.LoadFromFile('ship.bmp');
  Ship.Transparent := True;
  Ship.TransParentColor := Ship.canvas.pixels[0,0];
  ShipDx:=0;
end;

// Handle the reizing of the container form -
// just resizes to (ClientWidth, ClientHeight)
procedure TMainForm.FormResize(Sender: TObject);
begin
  Panorama.SetBounds(0,0, ClientWidth, ClientHeight);
//or you could do:
//  Panorama.Width:=clientwidth;
//  Panorama.Height:=clientheight;
end;

// This is an old trick to avoid flashing when the form gets
// repaint (for example after a resizing)
procedure TMainForm.WMEraseBkgnd(var m : TWMEraseBkgnd);
begin
  m.Result := LRESULT(False);
end;

// These are a series of handlers to mouse related events
procedure TMainForm.PanoramaClick(Sender: TObject);
begin
  RemoteForm.StatusLabel.Caption:='Last Event: Click';
end;

procedure TMainForm.PanoramaMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  RemoteForm.StatusLabel.Caption:='Last Event: Mouse Down';
end;

procedure TMainForm.PanoramaMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  RemoteForm.StatusLabel.Caption:='Last Event: Mouse Up';
end;

procedure TMainForm.PanoramaMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  RemoteForm.StatusLabel.Caption:='Last Event: Mouse Move';
  if (Panorama.CameraVelocity <> 0) then
  if (x > (Panorama.Width div 2)) then begin
    if (ShipDx < 100) then
      ShipDx:=ShipDx+2;
  end
  else begin
    if (ShipDx > -100) then
      ShipDx:=ShipDx-2;
  end;

end;


// This is the handler for a very interesting event: OnAfterRendering.
// By painting here on the BackBMP of the control you can draw flicker free
// graphics which are mixed with the Panorama control.
// On this example we draw a ...
// this way you can seamlessly mix your graphics with the Panorama views
procedure TMainForm.PanoramaAfterRendering(Sender: TObject);
var
halfWidth: integer;
begin
  if (RemoteForm.DrawInCheckBox.State = cbChecked) then begin
    halfWidth:=Width div 2;
    halfWidth:=halfWidth+ ShipDx;
    Panorama.BackBMP.Canvas.StretchDraw(Rect(halfWidth - 150, Height - 300,
                                             halfWidth +150, Height) ,
                                        Ship);
  end;
end;

end.
