unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, ExtCtrls, OutLookTools, StdCtrls, Menus, Buttons;

type
  TForm1 = class(TForm)
    Panel2: TPanel;
    StringGrid1: TStringGrid;
    Panel1: TPanel;
    Label1: TLabel;
    Panel3: TPanel;
    ShowContact: TButton;
    Button1: TButton;
    CheckBox1: TCheckBox;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Edit1: TEdit;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    OutlookConnect1: TOutlookConnect;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure StringGrid1DblClick(Sender: TObject);
    procedure ShowContactClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure Fill;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Fill;
var
  Counter,Counter2:Word;
  MyContact:TContact;
begin
  StringGrid1.RowCount:=OutlookConnect1.ContactCount+1;
  for Counter:=1 to OutlookConnect1.ContactCount do
  begin
    MyContact:=OutLookConnect1.Contact(Counter);
    with StringGrid1 do
    begin
      Cells[0,Counter]:=IntToStr(Counter);
      Cells[1,Counter]:=MyContact.FirstName;
      Cells[2,Counter]:=MyContact.LastName;
      Cells[3,Counter]:=MyContact.FullName;
      Cells[4,Counter]:=MyContact.MobileTelephonenumber;
      Cells[5,Counter]:=MyContact.EntryId;
    end;
    Application.ProcessMessages;
  end;
  Label1.Caption:=IntToStr(OutlookConnect1.ContactCount)+' Kontakte gefunden';
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  with StringGrid1 do
  begin
    Cells[0,0]:='Index';
    Cells[1,0]:='FirstName';
    Cells[2,0]:='LastName';
    Cells[3,0]:='FullName';
    Cells[4,0]:='MobileTelephonenumber';
    Cells[5,0]:='EntryID';
  end;
  CheckBox1.Checked:=OutlookConnect1.Connected;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  if OutlookConnect1.Connected then Fill;
end;

procedure TForm1.StringGrid1DblClick(Sender: TObject);
begin
  ShowContactClick(Self);
end;

procedure TForm1.ShowContactClick(Sender: TObject);
begin
  OutlookConnect1.ShowContact(StringGrid1.Row);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  OutlookConnect1.Calendar.Display;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  OutlookConnect1.Connected:=CheckBox1.Checked;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Fill;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  Counter:Word;
begin
  ShowMessage(IntToStr(OutLookConnect1.GetSelectionCount)+' Selectedd Items');
  try
    ShowMessage(OutLookConnect1.GetSelection(1));
  except
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  MyContact:TContact;
begin
  MyContact:=OutlookConnect1.CreateContact;
  MyContact.FirstName:=Edit1.Text;
  MyContact.Save;
  ShowMessage('Kontakt erzeugt');
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  OutlookConnect1.FindContact(Edit1.Text).Display;
end;


procedure TForm1.Button6Click(Sender: TObject);
begin
  OutLookConnect1.GetSelection(1).Delete;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  OutlookConnect1.Notes.Display;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  OutlookConnect1.Notes.Items(1).Display;
end;

procedure TForm1.Button9Click(Sender: TObject);
var
  MyMail:Variant;
begin
  MyMail:=OutlookConnect1.Outbox.Items.Add;
  MyMail.Display;
  MyMail.To:='lothar.perr@gmx.net';
  MyMail.Save;
end;

end.
