unit StrF;
{$LONGSTRINGS ON}
  interface

    function CountChar(c:Char;s:String):Integer;
    function DeleteChar(s:String; c:Char):String;
    function ReplaceText(s, SourceText, DestText: String):String;
    function ExtractStr(Num:Integer; const s:String; const DelimStr:String):String;
    function LTrim(s:String):String;
    function RTrim(s:String):String;

  implementation

function CountChar(c:Char;s:String):Integer;
  var i:Integer;
begin
  Result:=0;
  if (Length(s)=0) then Exit;
  for i:=1 to Length(s) do if (s[i]=c) then Inc(Result);
end;

function DeleteChar(s:String; c:Char):String;
  var i:Integer;
      st:String;
begin
  DeleteChar:='';
  if (s='') then Exit;
  st:=s;
  i:=Pos(c,st);
  while (i>0) do begin
    Delete(st,i,1);
    i:=Pos(c,st);
  end;
  DeleteChar:=st;
end;

function ReplaceText(s, SourceText, DestText: String):String;
  var st,res:string;
      i:Integer;
begin
  ReplaceText:='';
  if ((s='') or (SourceText='')) then Exit;
  st:=s;
  res:='';
  i:=Pos(SourceText,s);
  while (i>0) do
  begin
    res:=res+Copy(st,1,i-1)+DestText;
    Delete(st,1,(i+Length(SourceText)-1));
    {if (DestText<>'') then Insert(DestText,st,i);}
    i:=Pos(SourceText,st);
  end;
  res:=res+st;
  ReplaceText:=res;
end;

function ExtractStr(Num:Integer; const s:String; const DelimStr:String):String;
  var st,res:String;
      i,n:Integer;
begin
  Result:='';
  res:='';
  n:=0;
  st:=s;
  while ((n<Num) and (st<>'')) do begin
    i:=Pos(DelimStr,st);
    if (i=0) then i:=Length(st)+1;
    res:=System.Copy(st,1,i-1);
    System.Delete(st,1,i);
    Inc(n);
  end;
  Result:=res;
end;

function LTrim(s:String):String;
  var st:String;
begin
  LTrim:='';
  if (s='') then Exit;
  st:=s;
  while (Length(st)>0) do if (st[1]=' ') then Delete(st,1,1) else Break;
  LTrim:=st;
end;

function RTrim(s:String):String;
  var st:String;
begin
  RTrim:='';
  if (s='') then Exit;
  st:=s;
  while (Length(st)>0) do if (st[Length(st)]=' ') then Delete(st,Length(st),1) else Break;
  RTrim:=st;
end;


end.
