unit demo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ObjInsp, DsgnIntf;

type
  TForm1 = class(TForm)
    Button2: TButton;
    Memo1: TMemo;
    Button3: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Button1: TButton;
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    FInspector: TObjectInspector;
    procedure FiltProperties(Sender: TPersistent; Prop: TPropertyEditor;
      var AText: String; var AllowShow: Boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button2Click(Sender: TObject);
begin
  Memo1.Lines.Add('Name=My name is');
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FInspector := TObjectInspector.Create(nil);
  FInspector.OnFilter := FiltProperties;
  FInspector.EditObjectProperties(Button1);
  FInspector.Show;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FInspector.Free;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  FInspector.Clear;
  FInspector.EditObjectProperties(Button1);
end;

procedure TForm1.FiltProperties(Sender: TPersistent; Prop: TPropertyEditor;
  var AText: String; var AllowShow: Boolean);
var
  S: String;
begin
  S := Memo1.Lines.Values[AText];
  AllowShow := S <> '';
  if AllowShow then
    AText := S;
end;

end.
