(*
1. for Record type, if you want edit it in inspector, you should
define this record as object and need not one lie code. because
inspector auto show subproperties in object (not record).
otherwise,
you need wirte more code.

type
  TTestRec = record
    Name: String;
    FType: TFieldType;
    Value: String;
  end;

  TTestRec = class(TPersistent)
  public
    FName: String;
    FType: TFieldType;
    FValue: String;
  published
    property Name: String read FName write FName;
    property FldType: TFieldType read FType write FType;
    property Value: String read FValue write FValue;
  end;

2.For array, need write some code, because delphi not support array property,
  So, must do it in my inspector. So, I modify my source to arround it.

  ***********************************************************
  NOTE: you should not compile this demo with old objinsp.dcu
  
*)

unit Demo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ObjInsp, DB, DsgnIntf;

type
  TTestRec = class(TPersistent)
  public
    FName: String;
    FType: TFieldType;
    FValue: String;
  published
    property Name: String read FName write FName;
    property FldType: TFieldType read FType write FType;
    property Value: String read FValue write FValue;
  end;

  PTestArray = ^TTestArray;
  TTestLong = Longint;
  TTestArray = array [0..9] of Integer;

  TArrayProperty = class(TIntegerProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetProperties(Proc: TGetPropEditProc); override;
    function GetValue: String; override;
    procedure SetValue(const Value: String); override;
  end;

  TArrayElementProperty = class(TIntegerProperty)
  private
    FParentProp: TPropertyEditor;
    FArray: PTestArray;
    FIndex: Integer;
  public
    constructor Create(AParent: TPropertyEditor; PArray: PTestArray; AIndex: Integer);
    function GetValue: String; override;
    procedure SetValue(const Value: String); override;
    function GetName: String; override;
  end;

  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    FInspector: TObjectInspector;
    FTestRec: TTestRec;
    FTestArray: TTestArray;
    procedure SetTestRec(ARec: TTestRec);
    function GetTestArray: TTestLong;
    procedure SetTestArray(Value: TTestLong);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure RefreshLabel;
  published
    property TestRec: TTestRec read FTestRec write SetTestRec;
    property TestArray: TTestLong read GetTestArray write SetTestArray;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function TArrayProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paReadOnly, paSubProperties];
end;

procedure TArrayProperty.GetProperties(Proc: TGetPropEditProc);
var
  I: Integer;
  P: PTestArray;
begin
  P := Pointer(GetOrdValue);
  for I := Low(TTestArray) to High(TTestArray) do
    Proc(TArrayElementProperty.Create(Self, P, I));
end;

function TArrayProperty.GetValue: String;
begin
  Result := '[Array]';
end;

procedure TArrayProperty.SetValue(const Value: String);
begin
  SetOrdValue(GetOrdValue);
end;

constructor TArrayElementProperty.Create(AParent: TPropertyEditor; PArray: PTestArray; AIndex: Integer);
begin
  inherited Create;
  FArray := PArray;
  FIndex := AIndex;
  FParentProp := AParent;
end;

function TArrayElementProperty.GetValue: String;
begin
  Result := IntToStr(FArray[FIndex]);
end;

procedure TArrayElementProperty.SetValue(const Value: String);
begin
  FArray[FIndex] := StrToInt(Value);
  FParentProp.SetValue('');
end;

function TArrayElementProperty.GetName: String;
begin
  Result := Format('[%d]', [FIndex]);
end;

constructor TForm1.Create(AOwner: TComponent);
begin
  FTestRec := TTestRec.Create;
  inherited;
end;

destructor TForm1.Destroy;
begin
  FTestRec.Free;
  inherited;
end;

procedure TForm1.SetTestRec(ARec: TTestRec);
begin
  with FTestRec do
  begin
    Name := ARec.Name;
    FType := ARec.FType;
    Value := ARec.Value;
  end;
end;

function TForm1.GetTestArray: TTestLong;
begin
  Result := TTestLong(@FTestArray);
end;

procedure TForm1.SetTestArray(Value: TTestLong);
begin
  RefreshLabel;
end;

procedure TForm1.RefreshLabel;
var
  S: String;
  I: Integer;
begin
  S := IntToStr(FTestArray[0]);
  for I := 1 to 9 do
    S := S + ', '+IntToStr(FTestArray[I]);
  Label2.Caption := S;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FInspector := TObjectInspector.Create(nil);
  FInspector.Options := [oioProperties];
  FInspector.Show;
  FInspector.EditObjectProperties(Self);
  RefreshLabel;
end;

initialization
begin
  RegisterPropertyEditor(TypeInfo(TTestLong), TForm1, 'TestArray', TArrayProperty);
end;

end.
