unit QBMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, Menus, StdCtrls, Buttons, ObjEdit, ObjInsp, DB, DBTables,
  QuickRpt, QrCtrls, QrTee, ObjIntf, ObjCPal, ObjLib, ObjStart;

type
  TQrBuildForm = class(TForm)
    Panel1: TPanel;
    Splitter1: TSplitter;
    Panel2: TPanel;
    MainMenu1: TMainMenu;
    FileMenu: TMenuItem;
    FileNewItem: TMenuItem;
    FileNewFormItem: TMenuItem;
    FileNewDataModuleItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileClosedFilesItem: TMenuItem;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    FileSaveAllItem: TMenuItem;
    FileCloseItem: TMenuItem;
    FileCloseAllItem: TMenuItem;
    N6: TMenuItem;
    FileExitItem: TMenuItem;
    EditMenu: TMenuItem;
    EditUndoItem: TMenuItem;
    EditRedoItem: TMenuItem;
    N15: TMenuItem;
    EditCutItem: TMenuItem;
    EditCopyItem: TMenuItem;
    EditPasteItem: TMenuItem;
    EditDeleteItem: TMenuItem;
    EditSelectAll: TMenuItem;
    N14: TMenuItem;
    EditAlignGridItem: TMenuItem;
    EditFrontItem: TMenuItem;
    EditBackItem: TMenuItem;
    EditAlignItem: TMenuItem;
    EditSizeItem: TMenuItem;
    EditScaleItem: TMenuItem;
    EditTabOrderItem: TMenuItem;
    CreationOrderItem: TMenuItem;
    ViewsMenu: TMenuItem;
    ViewObjectInspector: TMenuItem;
    ViewBrowserItem: TMenuItem;
    N1: TMenuItem;
    ViewSpeedBarItem: TMenuItem;
    ViewPaletteItem: TMenuItem;
    ViewSwapSourceFormItem: TMenuItem;
    ToolsMenu: TMenuItem;
    ToolsOptionsItem: TMenuItem;
    ToolsToolsItem: TMenuItem;
    HelpMenu: TMenuItem;
    HelpContentsItem: TMenuItem;
    HelpWhatsNew: TMenuItem;
    N13: TMenuItem;
    HelpAboutItem: TMenuItem;
    PaletteMenu: TPopupMenu;
    ShowPaletteHints: TMenuItem;
    Hide2: TMenuItem;
    PaletteHelpItem: TMenuItem;
    N9: TMenuItem;
    Configure2: TMenuItem;
    SpeedbarMenu: TPopupMenu;
    ShowSpeedHints: TMenuItem;
    Hide1: TMenuItem;
    SpeedbarHelpItem: TMenuItem;
    N12: TMenuItem;
    Configure1: TMenuItem;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    PrinterSetupDialog: TPrinterSetupDialog;
    SaveFileDialog: TSaveDialog;
    OpenFileDialog: TOpenDialog;
    N2: TMenuItem;
    PrintPreview1: TMenuItem;
    Print1: TMenuItem;
    btnOpenReport: TSpeedButton;
    btnSaveReport: TSpeedButton;
    btnPrintReport: TSpeedButton;
    btnPreviewReport: TSpeedButton;
    AdvSpeedButton1: TSpeedButton;
    btnNew: TSpeedButton;
    AdvSpeedButton2: TSpeedButton;
    PackageDialog: TOpenDialog;
    CompPal: TComponentPalette;
    procedure FormCreate(Sender: TObject);
    procedure FileNewFormItemClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure btnNewClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FileSaveItemClick(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure btnOpenReportClick(Sender: TObject);
    procedure btnSaveReportClick(Sender: TObject);
    procedure btnPrintReportClick(Sender: TObject);
    procedure btnPreviewReportClick(Sender: TObject);
    procedure AdvSpeedButton1Click(Sender: TObject);
    procedure ViewObjectInspectorClick(Sender: TObject);
    procedure AdvSpeedButton2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    FDesigner: TObjectEditor;
    FEditors: TStringList;
    FDPLPath: String;
    procedure Resized;
    procedure Open;
    function New: TObjectEditor;
    procedure Save;
    function SaveAs: String;
    procedure Print(Preview: Boolean);
  public
    { Public declarations }
  end;

  TQRForm = class(TForm);

var
  QrBuildForm: TQrBuildForm;

implementation

uses Registry, ObjAPal, ObjDebug;

{$R *.DFM}
{$R *.RES}

procedure TQrBuildForm.FormCreate(Sender: TObject);
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey :=HKEY_LOCAL_MACHINE;
    Reg.OpenKey('\Software\Borland\Delphi\3.0', False);
    FDPLPath := ExtractFilePath(Reg.ReadString('Delphi 3'));
  finally
    Reg.Free;
  end;
  ObjInitialize(TObjectInspector, TObjectEditor, nil, TObjectLibrary, nil);
  LoadPackageEx(FDPLPath + 'dclstd30.dpl');
  LoadPackageEx(FDPLPath + 'dcldb30.dpl');
  LoadPackageEx(FDPLPath + 'dclqrt30.dpl');
  LoadPackageEx(FDPLPath + 'dcltee30.dpl');
  CompPal.RefreshTabs;

  FEditors := TStringList.Create;
  Left := 0;
  Top := 0;
  Width := Screen.Width;

  with ObjectInspector do
  begin
    Left := 0;
    Top := Self.Top + Self.Height;
  end;
  ObjectInspector.Show;
  New;
end;

procedure TQrBuildForm.FormDestroy(Sender: TObject);
begin
  FEditors.Free;
end;

procedure TQrBuildForm.FileNewFormItemClick(Sender: TObject);
var
  AForm: TForm;
begin
  AForm := TForm.Create(nil);
  AForm.Name := 'Form1';
  AForm.Show;
  FDesigner.EditControl(AForm);
end;

procedure TQrBuildForm.FormResize(Sender: TObject);
begin
  Resized;
end;

procedure TQrBuildForm.Resized;
begin
end;

procedure TQrBuildForm.btnNewClick(Sender: TObject);
begin
  New;
end;

function TQrBuildForm.New: TObjectEditor;
var
  AForm: TForm;
begin
  AForm := TQRForm.CreateNew(Application);
  AForm.SetBounds(ObjectInspector.Width, Top + Height, 500, 400);
  AForm.Name := GetUniqueName(Application, GetBaseName(AForm.ClassType));
  ShowWindow(AForm.Handle, SW_SHOW);
  Result := EditControl(AForm);
  FEditors.AddObject('', Result);
end;

procedure TQrBuildForm.Save;
var
  AEditor: TObjectEditor;
  I: Integer;
  AName: String;
begin
  AEditor := GetActivateEditor;
  if AEditor <> nil then
  begin
    I := FEditors.IndexOfObject(AEditor);
    AName := FEditors[I];
    if AName <> '' then
      AEditor.SaveDFMToFile(AName)
    else
      SaveAs;
  end;
end;

function TQrBuildForm.SaveAs: String;
var
  AEditor: TObjectEditor;
  I: Integer;
begin
  Result := '';
  AEditor := GetActivateEditor;
  if AEditor <> nil then
  begin
    I := FEditors.IndexOfObject(AEditor);
    SaveFileDialog.FileName := FEditors[I];
    if SaveFileDialog.Execute then
    begin
      Result := SaveFileDialog.FileName;
      AEditor.SaveDFMToFile(Result);
      FEditors[I] := Result;
    end;
  end;
end;

procedure TQrBuildForm.FileSaveItemClick(Sender: TObject);
begin
  Save;
end;

procedure TQrBuildForm.FileOpenItemClick(Sender: TObject);
begin
  Open;
end;

procedure TQrBuildForm.Open;
var
  AEditor: TObjectEditor;
begin
  if OpenFileDialog.Execute then
  begin
    AEditor := New;
    if (AEditor <> nil) then
      AEditor.LoadDFMFromFile(OpenFileDialog.FileName);
  end;
end;

procedure TQrBuildForm.btnOpenReportClick(Sender: TObject);
begin
  Open;
end;

procedure TQrBuildForm.btnSaveReportClick(Sender: TObject);
begin
  Save;
end;

procedure TQrBuildForm.Print(Preview: Boolean);
var
  AEditor: TObjectEditor;
  AComp, AComp2: TComponent;
  I: Integer;
begin
  AEditor := GetActivateEditor;
  if AEditor <> nil then
  begin
    AComp := AEditor.ActivateComponent;
    if AComp is TControl then
    begin
      while (AComp <> nil) and (not (AComp is TQuickRep)) do
        AComp := TControl(AComp).Parent;
    end else
      AComp := nil;

    if AComp = nil then
    begin
      for I := 0 to AEditor.OwnerForm.ComponentCount-1 do
      begin
        AComp2 := AEditor.OwnerForm.Components[I];
        if AComp2 is TQuickRep then
        begin
          AComp := AComp2;
          Break;
        end;
      end;
    end;

    if AComp <> nil then
    begin
      if Preview then
        TQuickRep(AComp).Preview
      else
        TQuickRep(AComp).Print;
    end;
  end;
end;

procedure TQrBuildForm.btnPrintReportClick(Sender: TObject);
begin
  Print(False);
end;

procedure TQrBuildForm.btnPreviewReportClick(Sender: TObject);
begin
  Print(True);
end;

procedure TQrBuildForm.AdvSpeedButton1Click(Sender: TObject);
begin
  ShowAlignPalette;
end;

procedure TQrBuildForm.ViewObjectInspectorClick(Sender: TObject);
begin
  ObjectInspector.Visible := not ObjectInspector.Visible;
end;

procedure TQrBuildForm.AdvSpeedButton2Click(Sender: TObject);
begin
  PackageDialog.InitialDir := FDPLPath;
  if PackageDialog.Execute then
  begin
    LoadPackageEx(PackageDialog.FileName);
    CompPal.RefreshTabs;
  end;
end;

procedure TQrBuildForm.Button1Click(Sender: TObject);
begin
  DebugForm.Show;
end;

end.


