unit test;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ObjEdit, ExtCtrls, Grids, Db, DBTables, DBCtrls, ComCtrls, Menus, Buttons,
  ObjInsp;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button6: TButton;
    Button7: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog3: TOpenDialog;
    Button5: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    SaveDialog2: TSaveDialog;
    OpenDialog2: TOpenDialog;
    SaveDialog3: TSaveDialog;
    OpenDialog1: TOpenDialog;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
  private
    FEditor: TObjectEditor;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses testform, ObjIntf;

{$R *.DFM}
{$R COMPICON.RES}

procedure TForm1.FormCreate(Sender: TObject);
begin
  ObjectInspector := TObjectInspector.Create(nil);
  FEditor := TObjectEditor.Create;
  ObjectInspector.Designer := FEditor;
  ObjectInspector.Show;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Form2.Show;
  FEditor.EditControl(Form2);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  FEditor.EditControl(nil);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  FEditor.EnterNewComponent(Self, TPanel);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  FEditor.EnterNewComponent(Self, TTable);
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
    FEditor.SaveTextToFile(SaveDialog1.FileName);
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    FEditor.LoadTextFromFile(OpenDialog1.FileName);
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  if SaveDialog2.Execute then
    FEditor.SaveBinaryToFile(SaveDialog2.FileName);
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  if OpenDialog2.Execute then
    FEditor.LoadBinaryFromFile(OpenDialog2.FileName);
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
  if SaveDialog3.Execute then
    FEditor.SaveDFMToFile(SaveDialog3.FileName);
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
  if OpenDialog3.Execute then
    FEditor.LoadDFMFromFile(OpenDialog3.FileName);
end;

end.


