// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'odbclink.pas' rev: 3.00

#ifndef odbclinkHPP
#define odbclinkHPP
#include <odbccst.hpp>
#include <ComCtrls.hpp>
#include <Controls.hpp>
#include <seldlg.hpp>
#include <Grids.hpp>
#include <DsgnIntf.hpp>
#include <Dialogs.hpp>
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Odbclink
{
//-- type declarations -------------------------------------------------------
typedef int *phandle;

typedef char TSQLstringbuf[256];

typedef TSQLstringbuf *PSQLstringbuf;

enum TODBCStatus { odbcOpening, odbcInserting, odbcUpdating, odbcCreating, odbcDeleting, odbcNormal 
	};

enum TODBCKeyType { odbcNormalKey, odbcRequiredKey };

class DELPHICLASS EODBCError;
class PASCALIMPLEMENTATION EODBCError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall EODBCError(const System::AnsiString Msg) : Sysutils::Exception(Msg
		) { }
	/* Exception.CreateFmt */ __fastcall EODBCError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall EODBCError(int Ident, Extended Dummy) : Sysutils::Exception(Ident
		, Dummy) { }
	/* Exception.CreateResFmt */ __fastcall EODBCError(int Ident, const System::TVarRec * Args, const int 
		Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall EODBCError(const System::AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall EODBCError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall EODBCError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall EODBCError(int Ident, const System::TVarRec * Args, const 
		int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext) { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~EODBCError(void) { }
	
};

typedef void __fastcall (__closure *TODBCErrorEvent)(System::TObject* Sender, System::AnsiString odbcstate
	, System::AnsiString odbcmsg, int errcode);

class DELPHICLASS TODBCField;
class PASCALIMPLEMENTATION TODBCField : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	System::AnsiString fFieldName;
	System::AnsiString fDisplayName;
	int fSize;
	int fDataType;
	bool fKey;
	void __fastcall SetFieldName(System::AnsiString value);
	void __fastcall SetDisplName(System::AnsiString value);
	
public:
	int ColIndex;
	
__published:
	__property System::AnsiString DisplayName = {read=fDisplayName, write=SetDisplName};
	__property System::AnsiString FieldName = {read=fFieldName, write=SetFieldName};
	__property int Size = {read=fSize, write=fSize, nodefault};
	__property int Datatype = {read=fDataType, write=fDataType, nodefault};
	__property bool Key = {read=fKey, write=fKey, nodefault};
public:
	/* TCollectionItem.Create */ __fastcall virtual TODBCField(Classes::TCollection* Collection) : Classes::
		TCollectionItem(Collection) { }
	/* TCollectionItem.Destroy */ __fastcall virtual ~TODBCField(void) { }
	
};

class DELPHICLASS TODBCFieldCollection;
class DELPHICLASS TODBCLink;
class PASCALIMPLEMENTATION TODBCLink : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	System::AnsiString fAuthentication;
	System::AnsiString fUserID;
	bool fActive;
	Classes::TStringList* fSQL;
	System::AnsiString fDataSource;
	System::AnsiString fDriver;
	System::AnsiString fTable;
	System::AnsiString fDBFile;
	Classes::TStrings* fResultList;
	Grids::TStringGrid* fGrid;
	Comctrls::TListView* fListView;
	TODBCFieldCollection* fFields;
	bool fShowFields;
	bool fShowErrors;
	TODBCErrorEvent fOnODBCError;
	TODBCStatus fODBCStatus;
	TODBCKeyType fKeyType;
	void __fastcall SetActive(bool avalue);
	void __fastcall SetTable(System::AnsiString avalue);
	void __fastcall SetDriver(System::AnsiString avalue);
	void __fastcall SetDataSource(System::AnsiString avalue);
	void __fastcall SetSQL(Classes::TStringList* avalue);
	void __fastcall SetFieldCollection(TODBCFieldCollection* value);
	
protected:
	virtual void __fastcall Loaded(void);
	
public:
	__fastcall virtual TODBCLink(Classes::TComponent* aOwner);
	__fastcall virtual ~TODBCLink(void);
	void __fastcall OpenDatabase(void);
	void __fastcall SaveDatabase(void);
	bool __fastcall BrowseDatabase(bool doOpen);
	Classes::TStrings* __fastcall DataSources(void);
	Classes::TStrings* __fastcall Drivers(void);
	bool __fastcall HasDataType(int sqltype);
	bool __fastcall CreateDataSource(System::AnsiString szDriver, System::AnsiString szAttr);
	bool __fastcall InsertRows(int RowIndex, int RowCount);
	bool __fastcall UpdateRows(int RowIndex, int RowCount);
	bool __fastcall DeleteRows(int RowIndex, int RowCount);
	__property TODBCStatus Status = {read=fODBCStatus, nodefault};
	__property TODBCKeyType KeyType = {read=fKeyType, write=fKeyType, nodefault};
	
__published:
	__property bool Active = {read=fActive, write=SetActive, nodefault};
	__property Classes::TStringList* SQL = {read=fSQL, write=SetSQL};
	__property System::AnsiString DataSource = {read=fDataSource, write=SetDataSource};
	__property System::AnsiString Driver = {read=fDriver, write=SetDriver};
	__property System::AnsiString Table = {read=fTable, write=SetTable};
	__property System::AnsiString Databasefile = {read=fDBFile, write=fDBFile};
	__property Grids::TStringGrid* Grid = {read=fGrid, write=fGrid};
	__property Comctrls::TListView* ListView = {read=fListView, write=fListView};
	__property TODBCFieldCollection* Fields = {read=fFields, write=SetFieldCollection};
	__property bool ShowFields = {read=fShowFields, write=fShowFields, nodefault};
	__property bool ShowErrors = {read=fShowErrors, write=fShowErrors, nodefault};
	__property System::AnsiString UserID = {read=fUserID, write=fUserID};
	__property System::AnsiString Authentication = {read=fAuthentication, write=fAuthentication};
	__property TODBCErrorEvent OnODBCError = {read=fOnODBCError, write=fOnODBCError};
};

class PASCALIMPLEMENTATION TODBCFieldCollection : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TODBCLink* fodbclink;
	
public:
	__fastcall TODBCFieldCollection(TODBCLink* odbclink);
	bool __fastcall HasKey(void);
	
protected:
	virtual void __fastcall Update(Classes::TCollectionItem* Item);
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
public:
	/* TCollection.Destroy */ __fastcall virtual ~TODBCFieldCollection(void) { }
	
};

struct TODBCTypeInfo
{
	System::AnsiString typename;
	System::AnsiString prefix;
	System::AnsiString suffix;
	System::AnsiString creparams;
} ;

class DELPHICLASS TODBCConnection;
class PASCALIMPLEMENTATION TODBCConnection : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	void *henv;
	void *hdbc;
	void *stmt;
	void *querystmt;
	Classes::TStrings* strlist;
	char info[1025];
	char sql[1025];
	System::AnsiString odbctablepath;
	System::AnsiString odbctablename;
	TODBCFieldCollection* afieldcollection;
	System::AnsiString fAuthentication;
	System::AnsiString fUserID;
	__fastcall TODBCConnection(TODBCFieldCollection* afc);
	__fastcall virtual ~TODBCConnection(void);
	System::AnsiString __fastcall DriverConnect(HWND wnd, System::AnsiString cstr);
	System::AnsiString __fastcall BrowseConnect(HWND wnd, System::AnsiString cstr);
	Classes::TStrings* __fastcall DriverConnectFile(HWND wnd, System::AnsiString drv, System::AnsiString 
		fname);
	Classes::TStrings* __fastcall DSNConnectFile(HWND wnd, System::AnsiString dsn, System::AnsiString fname
		);
	int __fastcall FullConnect(System::AnsiString dsn);
	Classes::TStrings* __fastcall DataSources(void);
	Classes::TStrings* __fastcall Drivers(void);
	Classes::TStrings* __fastcall Tables(void);
	bool __fastcall HasTables(void);
	int __fastcall NumFields(System::AnsiString table);
	Classes::TStrings* __fastcall Fields(System::AnsiString table, bool update);
	Classes::TStrings* __fastcall Statistics(System::AnsiString table);
	int __fastcall ExecDirect(System::AnsiString s);
	int __fastcall ExecSQL(System::AnsiString s);
	int __fastcall PrepSQL(System::AnsiString s);
	int __fastcall Error(void);
	void __fastcall BindCol(int i, int coltype, void * ptr, short sz, int &avail);
	bool __fastcall Fetch(void);
	int __fastcall GetInfoInt(int i);
	System::AnsiString __fastcall GetInfoStr(int i);
	System::TDateTime __fastcall DateField(System::AnsiString s);
	Classes::TStrings* __fastcall DataSourceFileExt(System::AnsiString ext);
	int __fastcall DataSourceFileUse(System::AnsiString drv);
	System::AnsiString __fastcall DataSourceFilter();
	TODBCTypeInfo __fastcall GetTypeInfo(int datatype);
	int __fastcall BindParam(short parnum, void * par, short parintype, short pardbtype, short parlen);
		
	int __fastcall Exec(void);
	int __fastcall FreeSTMT(void);
};

class DELPHICLASS TODBCStatement;
class PASCALIMPLEMENTATION TODBCStatement : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	void *sqlstmt;
	TODBCConnection* odbcConnection;
	__fastcall TODBCStatement(TODBCConnection* aODBCConnection);
	__fastcall virtual ~TODBCStatement(void);
	bool __fastcall BindCol(int i, int coltype, void * ptr, short sz, int &avail);
	int __fastcall BindParam(short parnum, void * par, short parintype, short pardbtype, short parlen);
		
	bool __fastcall Fetch(void);
	bool __fastcall ExtendedFetch(Word fetchtype, int row, int &numrows, void * rowstatus);
	bool __fastcall Prep(System::AnsiString s);
	bool __fastcall ExecDirect(System::AnsiString s);
	bool __fastcall Execute(void);
	bool __fastcall Cancel(void);
	int __fastcall Columns(void);
	int __fastcall Rows(void);
	int __fastcall Error(void);
	bool __fastcall SetCursorName(System::AnsiString cursname);
	System::AnsiString __fastcall GetCursorName();
	bool __fastcall SetPos(Word row, Word option, Word lock);
	bool __fastcall SetOption(Word option, int param);
	int __fastcall Attribute(Word i, Word desc);
};

class DELPHICLASS TODBCDataSourceProperty;
class PASCALIMPLEMENTATION TODBCDataSourceProperty : public Dsgnintf::TStringProperty 
{
	typedef Dsgnintf::TStringProperty inherited;
	
public:
	virtual Dsgnintf::TPropertyAttributes __fastcall GetAttributes(void);
	virtual void __fastcall GetValues(Classes::TGetStrProc Proc);
public:
	/* TPropertyEditor.Destroy */ __fastcall virtual ~TODBCDataSourceProperty(void) { }
	
public:
	/* TObject.Create */ __fastcall TODBCDataSourceProperty(void) : Dsgnintf::TStringProperty() { }
	
};

class DELPHICLASS TODBCDriverProperty;
class PASCALIMPLEMENTATION TODBCDriverProperty : public Dsgnintf::TStringProperty 
{
	typedef Dsgnintf::TStringProperty inherited;
	
public:
	virtual Dsgnintf::TPropertyAttributes __fastcall GetAttributes(void);
	virtual void __fastcall GetValues(Classes::TGetStrProc Proc);
public:
	/* TPropertyEditor.Destroy */ __fastcall virtual ~TODBCDriverProperty(void) { }
	
public:
	/* TObject.Create */ __fastcall TODBCDriverProperty(void) : Dsgnintf::TStringProperty() { }
	
};

class DELPHICLASS TODBCTableProperty;
class PASCALIMPLEMENTATION TODBCTableProperty : public Dsgnintf::TStringProperty 
{
	typedef Dsgnintf::TStringProperty inherited;
	
public:
	virtual Dsgnintf::TPropertyAttributes __fastcall GetAttributes(void);
	virtual void __fastcall GetValues(Classes::TGetStrProc Proc);
public:
	/* TPropertyEditor.Destroy */ __fastcall virtual ~TODBCTableProperty(void) { }
	
public:
	/* TObject.Create */ __fastcall TODBCTableProperty(void) : Dsgnintf::TStringProperty() { }
	
};

class DELPHICLASS TODBCFieldProperty;
class PASCALIMPLEMENTATION TODBCFieldProperty : public Dsgnintf::TIntegerProperty 
{
	typedef Dsgnintf::TIntegerProperty inherited;
	
public:
	virtual Dsgnintf::TPropertyAttributes __fastcall GetAttributes(void);
	virtual void __fastcall GetValues(Classes::TGetStrProc Proc);
	virtual void __fastcall SetValue(const System::AnsiString value);
	virtual System::AnsiString __fastcall GetValue();
public:
	/* TPropertyEditor.Destroy */ __fastcall virtual ~TODBCFieldProperty(void) { }
	
public:
	/* TObject.Create */ __fastcall TODBCFieldProperty(void) : Dsgnintf::TIntegerProperty() { }
	
};

class DELPHICLASS TODBCFieldNameProperty;
class PASCALIMPLEMENTATION TODBCFieldNameProperty : public Dsgnintf::TStringProperty 
{
	typedef Dsgnintf::TStringProperty inherited;
	
public:
	virtual Dsgnintf::TPropertyAttributes __fastcall GetAttributes(void);
	virtual void __fastcall GetValues(Classes::TGetStrProc Proc);
public:
	/* TPropertyEditor.Destroy */ __fastcall virtual ~TODBCFieldNameProperty(void) { }
	
public:
	/* TObject.Create */ __fastcall TODBCFieldNameProperty(void) : Dsgnintf::TStringProperty() { }
	
};

//-- var, const, procedure ---------------------------------------------------
#define ODBCSUCCESS (System::Set<Byte, 0, 255> () << 0x0 << 0x1 )
extern PACKAGE System::AnsiString __fastcall StrListToPas(char * p, Word len);
extern PACKAGE System::AnsiString __fastcall GetListParam(System::AnsiString par, System::AnsiString 
	s);
extern PACKAGE System::AnsiString __fastcall ReplaceStr(const System::AnsiString S, const System::AnsiString 
	Srch, const System::AnsiString Replace);
extern PACKAGE System::AnsiString __fastcall UpcaseStr(const System::AnsiString S);
extern PACKAGE int __fastcall NCPos(const System::AnsiString Srch, const System::AnsiString S);
extern "C" short __stdcall SQLAllocConnect(void * henv, void * &phdbc);
extern "C" short __stdcall SQLAllocEnv(void * &phenv);
extern "C" short __stdcall SQLAllocStmt(void * hdbc, void * &pstmt);
extern "C" short __stdcall SQLBindCol(void * stmt, short icol, short fctype, void * data, int cbmax, 
	int &datalen);
extern "C" short __stdcall SQLBindParameter(void * stmt, Word paramnum, short fparamtype, short ctype
	, short sqltype, int coldef, short scale, void * buf, int bufsize, void * pbuflen);
extern "C" short __stdcall SQLBrowseConnect(void * hdbc, char * szConnStrIn, short cbConnStrIn, char * 
	szConnStrOut, short cbConnStrOutMax, short &pcbConnStrOut);
extern "C" short __stdcall SQLCancel(void * stmt);
extern "C" short __stdcall SQLConnect(void * hdbc, char * szDSN, short cbDSN, char * szUID, short cbUID
	, char * szAuth, short cbAuth);
extern "C" short __stdcall SQLDriverConnect(void * hdbc, HWND hwindow, char * ConnStr, short cbStr, 
	char * szCompl, short cbMax, void * cbCompl, Word compl);
extern "C" short __stdcall SQLExecDirect(void * stmt, char * cmd, int cbCMD);
extern "C" short __stdcall SQLExecute(void * stmt);
extern "C" short __stdcall SQLDisconnect(void * hdbc);
extern "C" short __stdcall SQLFreeConnect(void * hdbc);
extern "C" short __stdcall SQLFreeEnv(void * henv);
extern "C" short __stdcall SQLFreeStmt(void * stmt, Word foption);
extern "C" short __stdcall SQLError(void * henv, void * hdbc, void * hstmt, char * state, int &errcode
	, char * errmsg, Word count, short &pberr);
extern "C" short __stdcall SQLPrepare(void * stmt, char * sqlstr, int cbMax);
extern "C" short __stdcall SQLSetParam(void * stmt, Word paramnum, short ctype, short sqltype, int coldef
	, int scale, void * buf, void * pbuflen);
extern "C" short __stdcall SQLNumResultCols(void * stmt, short &numcols);
extern "C" short __stdcall SQLDescribeCol(void * stmt, int icol, char * colname, short cbmax, short 
	&pcollen, short &psqltype, short &plcoldef, short &pscale, short &pnull);
extern "C" short __stdcall SQLFetch(void * stmt);
extern "C" short __stdcall SQLExtendedFetch(void * stmt, Word fetchtype, int row, int &numrows, void * 
	rowstatus);
extern "C" short __stdcall SQLTables(void * stmt, char * szTableQualifier, short cbTableQualifier, char * 
	szTableOwner, short cbTableOwner, char * szTableName, short cbTableName, char * szTableType, short 
	cbTableType);
extern "C" short __stdcall SQLColumns(void * stmt, char * szTableQualifier, short cbTableQualifier, 
	char * szTableOwner, short cbTableOwner, char * szTableName, short cbTableName, char * szColumnName
	, short cbColumnName);
extern "C" short __stdcall SQLGetInfo(void * hdbc, Word finfotype, void * retbuf, short buflen, short 
	&buflenret);
extern "C" short __stdcall SQLGetTypeInfo(void * stmt, Word fsqltype);
extern "C" short __stdcall SQLGetFunctions(void * hdbc, Word functype, void * retfunc);
extern "C" short __stdcall SQLDataSources(void * henv, Word direction, char * szDSN, Word cbDSN, Word 
	&pbDSN, char * szDescr, Word cbDescr, Word &pbDescr);
extern "C" short __stdcall SQLDrivers(void * henv, Word direction, char * szDescr, Word cbDescr, Word 
	&pbDescr, char * szAttr, Word cbAttr, Word &pbAttr);
extern "C" short __stdcall SQLSetConnectOption(void * hdbc, Word fOption, int vParam);
extern "C" short __stdcall SQLSetPos(void * hstmt, Word irow, Word fOption, Word fLock);
extern "C" short __stdcall SQLGetStmtOption(void * hstmt, Word fOption, void * pvParam);
extern "C" short __stdcall SQLSetCursorName(void * hstmt, char * szCursor, short cbCursor);
extern "C" short __stdcall SQLGetCursorName(void * hstmt, char * szCursor, short cbCursorMax, short 
	&pcbCursor);
extern "C" short __stdcall SQLRowCount(void * hstmt, int &pcrow);
extern "C" short __stdcall SQLGetData(void * hstmt, short icol, short fCType, void * rgbValue, int cbValueMax
	, int &pcbValue);
extern "C" short __stdcall SQLPutData(void * hstmt, void * rgbValue, int cbValue);
extern "C" short __stdcall SQLSetScrollOptions(void * hstmt, Word fConcurrency, int crowKeyset, short 
	crowRowset);
extern "C" short __stdcall SQLSetStmtOption(void * hstmt, Word fOption, int vParam);
extern "C" short __stdcall SQLPrimaryKeys(void * hstmt, char * szTableQualifier, short cbTableQualifier
	, char * szTableOwner, short cbTableOwner, char * szTableName, short cbTableName);
extern "C" short __stdcall SQLColAttributes(void * hstmt, short icol, short fDesc, void * pDesc, Word 
	cbDesc, Word &pcbDesc, int &pfDesc);
extern "C" short __stdcall SQLStatistics(void * hstmt, char * szTableQualifier, short cbTableQualifier
	, char * szTableOwner, short cbTableOwner, char * szTableName, short cbTableName, Word fUnique, Word 
	fAccuracy);
extern "C" bool __stdcall SQLConfigDataSource(HWND HWND, Word fRequest, char * lpszDriver, char * lpszAttributes
	);

}	/* namespace Odbclink */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Odbclink;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// odbclink
