unit uodbc;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, odbclink, Grids, ComCtrls, odbccst;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    ListBox2: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    ODBCLink1: TODBCLink;
    ListView1: TListView;
    StringGrid1: TStringGrid;
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    Button3: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
 listbox1.items.assign(odbclink1.drivers);
 listbox2.items.assign(odbclink1.datasources);
 listbox1.itemindex:=0;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 odbclink1.grid:=stringgrid1;
 odbclink1.ListView :=nil;
 odbclink1.BrowseDatabase(true);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 odbclink1.grid:=nil;
 odbclink1.ListView := listview1;
 odbclink1.BrowseDatabase(true); 
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
 odbclink1.showfields:=checkbox1.checked;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
 odbcfield:todbcfield;
 drvr:string;
 i:integer;
begin
  if (listbox2.items.IndexOf('Text Files')<0)  then
   begin
    messagedlg('ODBC Text driver not found to load file in grid'#13#10+
               'that will be saved to selected database',mtError,[mbok],0);
   end;

  stringgrid1.fixedcols:=1;

  odbclink1.Driver:='';
  odbclink1.Datasource:='Text Files';
  odbclink1.Databasefile :=getcurrentdir;
  odbclink1.Table:='sample.txt';
  odbclink1.grid:=stringgrid1;
  odbclink1.listview:=nil;

  odbclink1.active:=true;

  for i:=1 to stringgrid1.rowcount-1 do stringgrid1.cells[0,i]:=inttostr(i);

  stringgrid1.cells[0,0]:='Nr';
  stringgrid1.fixedcols:=0;

  messagedlg('Sample file loaded in grid and ready to save to other database',mtinformation,[mbok],0);

  drvr:=listbox1.items[listbox1.itemindex];

  if (pos('Paradox',drvr)>0) then
   odbclink1.KeyType := odbcRequiredKey
  else
   odbclink1.KeyType := odbcNormalKey;

  if (pos('Access',drvr)>0) then
   begin
    if not odbclink1.CreateDataSource(drvr,'CREATE_DB=unnamed General') then
     begin
      messagedlg('Failed to create access datasource',mtinformation,[mbok],0);
      exit;
     end;
    odbclink1.databasefile:=getcurrentdir+'\unnamed.mdb';
   end;

  odbclink1.Driver :=drvr;
  odbclink1.Datasource:='';

  odbclink1.Table:='unnamed';

  odbclink1.Fields.Clear;

  odbcfield:=odbclink1.fields.add as TODBCField;
  odbcfield.FieldName:='NR';
  odbcfield.Datatype :=SQL_DOUBLE;
  odbcfield.Size := 5;
  odbcfield.Key:=false;

  odbcfield:=odbclink1.fields.add as TODBCField;
  odbcfield.FieldName:='CAR';
  odbcfield.Datatype :=SQL_VARCHAR;
  odbcfield.Size := 15;
  odbcfield.Key:=false;

  odbcfield:=odbclink1.fields.add as TODBCField;
  odbcfield.FieldName:='TYPE';
  odbcfield.Datatype :=SQL_VARCHAR;
  odbcfield.Size := 15;
  odbcfield.Key:=false;

  odbcfield:=odbclink1.fields.add as TODBCField;
  odbcfield.FieldName:='CC';
  odbcfield.Datatype :=SQL_DOUBLE;
  odbcfield.Size := 10;
  odbcfield.Key:=false;

  odbcfield:=odbclink1.fields.add as TODBCField;
  odbcfield.FieldName:='KW';
  odbcfield.Datatype :=SQL_DOUBLE;
  odbcfield.Size := 10;
  odbcfield.Key:=false;

  odbcfield:=odbclink1.fields.add as TODBCField;
  odbcfield.FieldName:='CYL';
  odbcfield.Datatype :=SQL_DOUBLE;
  odbcfield.Size := 10;
  odbcfield.Key:=false;

  odbcfield:=odbclink1.fields.add as TODBCField;
  odbcfield.FieldName:='PK';
  odbcfield.Datatype :=SQL_DOUBLE;
  odbcfield.Size := 10;
  odbcfield.Key:=false;

  odbcfield:=odbclink1.fields.add as TODBCField;
  odbcfield.FieldName:='PRICE';
  odbcfield.Datatype :=SQL_DOUBLE;
  odbcfield.Size := 10;
  odbcfield.Key:=false;

  odbclink1.SaveDatabase;

  messagedlg('Finished',mtinformation,[mbok],0);

end;

end.
