unit D3DemoM;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, ObjInsp, Buttons, ExtCtrls, Dialogs;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    SpeedButton1: TSpeedButton;
    Image1: TImage;
    Button1: TButton;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    Label2: TLabel;
    OpenDialog1: TOpenDialog;
    procedure Label1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure Panel1Click(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Label2Click(Sender: TObject);
  private
    FInsp: TObjectInspector;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  FInsp := TObjectInspector.Create(nil);
  FInsp.AlphaSort := True;
  FInsp.Show;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FInsp.Free;
end;

procedure TForm1.Label1Click(Sender: TObject);
begin
  FInsp.EditAloneProperties(Sender as TPersistent);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  FInsp.EditAloneProperties(Sender as TPersistent);
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  FInsp.EditAloneProperties(Sender as TPersistent);
end;

procedure TForm1.Panel1Click(Sender: TObject);
begin
  FInsp.EditAloneProperties(Sender as TPersistent);
end;

procedure TForm1.Image1Click(Sender: TObject);
begin
  FInsp.EditAloneProperties(Sender as TPersistent);
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  Image1.Left := Image1.Left + 10;
  Image1.Top := Image1.Top + 10;
  FInsp.RefreshContent;
end;

procedure TForm1.Label2Click(Sender: TObject);
var
  AList: TStringList;
  I: Integer;
  AComponent: TComponent;
begin
  AList := TStringList.Create;
  try
    for I := 0 to ComponentCount-1 do
    begin
      AComponent := Components[I];
      AList.AddObject(AComponent.Name, AComponent);
    end;
    FInsp.EditDivProperties(AList);
  finally
    AList.Free;
  end;
end;

end.
