unit test;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ObjEdit, ExtCtrls, Grids, Db, DBTables, Qrctrls, DBCtrls,
  ComCtrls, Menus, ObjInsp, Buttons;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    Button5: TButton;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    Demo: TStaticText;
    Button6: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
  private
    FEditor: TObjectEditor;
    FInspector: TObjectInspector;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses testform;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  FInspector := TObjectInspector.CreateEx(TObjectEditor);
  FInspector.Show;
  FEditor := TObjectEditor(FInspector.Designer);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Form2.Show;
  FEditor.EditControl(Form2);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  FEditor.EditControl(nil);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
    FEditor.SaveTextToFile(SaveDialog1.FileName);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    FEditor.LoadTextFromFile(OpenDialog1.FileName);
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  Form2.Show;
  FEditor.EditControl(Form2.Panel1);
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  FEditor.WillNewClass := TTable;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  FEditor.WillNewClass := TQuery;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  FEditor.WillNewClass := TLabel;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  FEditor.WillNewClass := TButton;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
  FEditor.WillNewClass := TPanel;
end;

end.

