unit BlinkParams;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, Buttons, RXSpin, ExtCtrls, PEConsts, jpeg, rxgif,
  ExtDlgs;

type
  TBlinkParamsForm = class(TForm)
    Label1: TLabel;
    BlinkTypeCombo: TComboBox;
    OkButton: TBitBtn;
    CancelButton: TBitBtn;
    BlinkNotebook: TNotebook;
    Label2: TLabel;
    PenColorPanel: TPanel;
    Label3: TLabel;
    PenWidthEdit: TRxSpinEdit;
    Label4: TLabel;
    PenStyleCombo: TComboBox;
    PenPaintBox: TPaintBox;
    Label5: TLabel;
    ColorDialog: TColorDialog;
    Label6: TLabel;
    BrushColorPanel: TPanel;
    Label7: TLabel;
    Label8: TLabel;
    BrushPaintBox: TPaintBox;
    BrushStyleCombo: TComboBox;
    Label9: TLabel;
    BlinkImage: TImage;
    SelectPictureButton: TBitBtn;
    SelectPictureDialog: TOpenPictureDialog;
    Label10: TLabel;
    FontPanel: TPanel;
    FontDialog: TFontDialog;
    TextEdit: TEdit;
    Label11: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PenStyleComboDrawItem(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
    procedure PenPaintBoxPaint(Sender: TObject);
    procedure PenWidthEditChange(Sender: TObject);
    procedure PenColorPanelClick(Sender: TObject);
    procedure BrushStyleComboDrawItem(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
    procedure BrushPaintBoxPaint(Sender: TObject);
    procedure BrushColorPanelClick(Sender: TObject);
    procedure BrushStyleComboClick(Sender: TObject);
    procedure SelectPictureButtonClick(Sender: TObject);
    procedure FontPanelClick(Sender: TObject);
    procedure BlinkTypeComboClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  BlinkParamsForm: TBlinkParamsForm;

implementation

{$R *.DFM}

procedure TBlinkParamsForm.FormCreate(Sender: TObject);
begin
  BlinkTypeCombo.Items.Clear;
  BlinkNotebook.PageIndex := 0;
end;

procedure TBlinkParamsForm.FormShow(Sender: TObject);
begin
  BlinkTypeCombo.ItemIndex := 0;
  BlinkTypeComboClick(Self);
end;

procedure TBlinkParamsForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  //
end;

procedure TBlinkParamsForm.PenStyleComboDrawItem(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  with PenStyleCombo.Canvas do begin
    Brush.Color:=clWindow;
    FillRect(Rect);
    with Pen do begin
      Color:=0;
      Width:=1;
      Style:=TPenStyle(Index);
    end;
    with Rect do begin
      MoveTo(Left+3, Top+7);
      LineTo(Right-3, Top+7);
    end;
  end;
end;

procedure TBlinkParamsForm.PenPaintBoxPaint(Sender: TObject);
begin
  with PenPaintBox.Canvas do begin
    Pen.Color := PenColorPanel.Color;
    Pen.Width := PenWidthEdit.AsInteger;
    Pen.Style := TPenStyle(PenStyleCombo.ItemIndex);
    MoveTo(5,PenPaintBox.Height div 2);
    LineTo(PenPaintBox.Width-5,PenPaintBox.Height div 2);
  end;
end;

procedure TBlinkParamsForm.PenWidthEditChange(Sender: TObject);
begin
  PenPaintBox.Repaint;
end;

procedure TBlinkParamsForm.PenColorPanelClick(Sender: TObject);
begin
  ColorDialog.Color := PenColorPanel.Color;
  if ColorDialog.Execute then PenColorPanel.Color := ColorDialog.Color;
  PenPaintBox.Repaint;
end;

procedure TBlinkParamsForm.BrushStyleComboDrawItem(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  with BrushStyleCombo.Canvas do begin
    with Pen do begin
      Color:=0;
      Width:=1;
      Style:=psSolid;
    end;
    with Brush do begin
      Color:=clWindow;
      Style:=TBrushStyle(Index);
    end;
    FillRect(Rect);
    if (Index=0) then TextOut(Rect.Left+2,Rect.Top,sBrushSolid)
    else if (Index=1) then TextOut(Rect.Left+2,Rect.Top,sBrushClear);
  end;
end;

procedure TBlinkParamsForm.BrushPaintBoxPaint(Sender: TObject);
begin
  with BrushPaintBox.Canvas do begin
    Brush.Color := BrushColorPanel.Color;
    Brush.Style := TBrushStyle(BrushStyleCombo.ItemIndex);
    Rectangle(1,1,BrushPaintBox.Width-1,BrushPaintBox.Height-1);
  end;
end;

procedure TBlinkParamsForm.BrushColorPanelClick(Sender: TObject);
begin
  ColorDialog.Color := BrushColorPanel.Color;
  if ColorDialog.Execute then BrushColorPanel.Color := ColorDialog.Color;
  BrushPaintBox.Repaint;
end;

procedure TBlinkParamsForm.BrushStyleComboClick(Sender: TObject);
begin
  BrushPaintBox.Repaint;
end;

procedure TBlinkParamsForm.SelectPictureButtonClick(Sender: TObject);
begin
  if SelectPictureDialog.Execute then BlinkImage.Picture.LoadFromFile(SelectPictureDialog.FileName);
end;

procedure TBlinkParamsForm.FontPanelClick(Sender: TObject);
begin
  FontDialog.Font.Assign(FontPanel.Font);
  if FontDialog.Execute then FontPanel.Font.Assign(FontDialog.Font);
end;

procedure TBlinkParamsForm.BlinkTypeComboClick(Sender: TObject);
begin
  BlinkNotebook.ActivePage := BlinkTypeCombo.Items[BlinkTypeCombo.ItemIndex];
end;

end.
