unit SAGManager;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, O2Plan, jpeg, rxgif,
  ExtDlgs, StrF, ClipBrd, Animate, GIFCtrl, PEConsts;

type
  TStandardAniGifsForm = class(TForm)
    SPListBox: TListBox;
    AddButton: TBitBtn;
    RenameButton: TBitBtn;
    SelectPictureButton: TBitBtn;
    DeleteButton: TBitBtn;
    HelpButton: TBitBtn;
    CloseButton: TBitBtn;
    SelectGifDialog: TOpenPictureDialog;
    CopyButton: TBitBtn;
    PasteButton: TBitBtn;
    GIFAnimator: TRxGIFAnimator;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SPListBoxClick(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure RenameButtonClick(Sender: TObject);
    procedure SelectPictureButtonClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure CopyButtonClick(Sender: TObject);
    procedure PasteButtonClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetButtons;
    procedure UpdatePicture;
  public
    { Public declarations }
    FPlan : TOxygenPlan;
    FWasChanges : Boolean;
  end;

var
  StandardAniGifsForm: TStandardAniGifsForm;

implementation

{$R *.DFM}

// private
procedure TStandardAniGifsForm.SetButtons;
begin
  RenameButton.Enabled := (SPListBox.ItemIndex >= 0);
  SelectPictureButton.Enabled := RenameButton.Enabled;
  DeleteButton.Enabled := RenameButton.Enabled;
  CopyButton.Enabled := RenameButton.Enabled;
  PasteButton.Enabled := RenameButton.Enabled;
end;

procedure TStandardAniGifsForm.UpdatePicture;
  var i : Integer;
begin
  i := SPListBox.ItemIndex;
  GIFAnimator.Animate := False;
  if (i >= 0) then try
    GIFAnimator.Image.Assign(FPlan.AniGifs[i]);
    GIFAnimator.Animate := True;
  except
    on E : Exception do begin
      GIFAnimator.Image.Assign(nil);
      MessageDlg(sErrorGettingImage+E.Message,mtError,[mbOk],0);
    end;
  end;
end;

// published
procedure TStandardAniGifsForm.FormCreate(Sender: TObject);
begin
  FPlan := nil;
  FWasChanges := False;
end;

procedure TStandardAniGifsForm.FormShow(Sender: TObject);
  var i : Integer;
begin
  if (FPlan = nil) then begin
    Close;
    Exit;
  end;
  for i := 1 to FPlan.AniGifCount do SPListBox.Items.Add(FPlan.AniGifs[i-1].Name);
  with SPListBox do if (Items.Count > 0) then begin
    ItemIndex := 0;
    UpdatePicture;
  end;
  SetButtons;
end;

procedure TStandardAniGifsForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  //
end;

procedure TStandardAniGifsForm.SPListBoxClick(Sender: TObject);
begin
  UpdatePicture;
end;

procedure TStandardAniGifsForm.AddButtonClick(Sender: TObject);
  label m1;
  var PName : String;
      Picture : TGifImage;
      i : Integer;
begin
  if not SelectGifDialog.Execute then Exit;
  Picture := TGIFImage.Create;
  try
    Picture.LoadFromFile(SelectGifDialog.FileName);
    if not Picture.Empty then begin
m1:
      i := 1;
      while (FPlan.AniGifIndex('StdAniGif'+IntToStr(i)) >= 0) do Inc(i);
      PName := 'StdAniGif'+IntToStr(i);
      if InputQuery(sAddStdAniGifCaption,sAddStdAniGifPrompt,PName) then begin
        PName := StrF.DeleteChar(PName,',');
        if (FPlan.AniGifIndex(PName) >= 0) then begin
          MessageDlg(Format(sStdAniGifAlreadyExists,[PName]),mtError,[mbOk],0);
          goto m1;
        end;
        FPlan.AddAniGif(PName,Picture);
        i := SPListBox.Items.Add(PName);
        SPListBox.ItemIndex := i;
        SPListBoxClick(Self);
        FWasChanges := True;
      end;
    end;
  except
    Picture.Free;
    raise;
  end;
  SetButtons;
end;

procedure TStandardAniGifsForm.RenameButtonClick(Sender: TObject);
  var PName : String;
      i : Integer;
begin
  i := SPListBox.ItemIndex;
  if (i < 0) then Exit;
  PName := SPListBox.Items[i];
  if InputQuery(sRenameStdAniGifCaption,sRenameStdAniGifPrompt,PName) then begin
    if (FPlan.AniGifIndex(PName) >= 0) then begin
      MessageDlg(Format(sStdAniGifAlreadyExists,[PName]),mtError,[mbOk],0);
      Exit;
    end;
    FPlan.AniGifs[i].Name := PName;
    O2Plan.RenameStdAniGif(FPlan,SPListBox.Items[i],PName);
    SPListBox.Items[i] := PName;
    FWasChanges := True;
  end;
end;

procedure TStandardAniGifsForm.SelectPictureButtonClick(Sender: TObject);
  var i : Integer;
begin
  i := SPListBox.ItemIndex;
  if (i < 0) then Exit;
  if not SelectGifDialog.Execute then Exit;
  FPlan.AniGifs[i].LoadFromFile(SelectGifDialog.FileName);
  GIFAnimator.Image.Assign(FPlan.AniGifs[i]);
  FWasChanges := True;
end;

procedure TStandardAniGifsForm.DeleteButtonClick(Sender: TObject);
  var i, rc : Integer;
      s : String;
begin
  i := SPListBox.ItemIndex;
  if (i < 0) then Exit;
  s := SPListBox.Items[i];
  rc := StandardAniGifReferenceCount(FPlan,s);
  if (rc > 0) then begin
    MessageDlg(Format(sStdAniGifHasReferences,[s,rc]),mtWarning,[mbOk],0);
    Exit;
  end;
  if (MessageDlg(Format(sStdAniGifDeleteConfirm,[s]),mtConfirmation,mbYesNoCancel,0) <> mrYes) then Exit;
  FPlan.DeleteAniGif(i);
  SPListBox.Items.Delete(i);
  FWasChanges := True;
  if (i > 0) then SPListBox.ItemIndex := i-1 else if (SPListBox.Items.Count > 0) then SPListBox.ItemIndex := 0;
  if (SPListBox.ItemIndex >= 0) then SPListBoxClick(Self) else GIFAnimator.Image.Assign(nil);
  SetButtons;
end;

procedure TStandardAniGifsForm.CopyButtonClick(Sender: TObject);
begin
  Clipboard.Assign(GIFAnimator.Image);
end;

procedure TStandardAniGifsForm.PasteButtonClick(Sender: TObject);
  var i : Integer;
begin
  i := SPListBox.ItemIndex;
  if (i < 0) then Exit;
  if Clipboard.HasFormat(CF_GIF) then
    if (MessageDlg(sStdAniGifReplaceConfirm,mtConfirmation,mbYesNoCancel,0) = mrYes) then begin
      FPlan.AniGifs[i].Assign(Clipboard);
      SPListBoxClick(Self);
      FWasChanges := True;
    end;
end;

end.
