unit MoveResizeDlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, RXSpin, PlanObjects;

type
  TMoveResizeDialog = class(TForm)
    Label1: TLabel;
    DeltaXEdit: TRxSpinEdit;
    Label2: TLabel;
    DeltaYEdit: TRxSpinEdit;
    procedure FormShow(Sender: TObject);
    procedure DeltaXEditBottomClick(Sender: TObject);
    procedure DeltaYEditBottomClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    dx, dy : Integer;
  public
    { Public declarations }
    PlanObject : TPlanObject;
    FMove : Boolean;
  end;

var
  MoveResizeDialog: TMoveResizeDialog;

implementation

{$R *.DFM}

procedure TMoveResizeDialog.FormShow(Sender: TObject);
begin
  if (PlanObject = nil) then Close;
  dx := 0;
  dy := 0;
  DeltaXEdit.Value := 0;
  DeltaYEdit.Value := 0;
end;

procedure TMoveResizeDialog.DeltaXEditBottomClick(Sender: TObject);
begin
  if FMove then PlanObject.Move(DeltaXEdit.AsInteger - dx,0) else PlanObject.Resize(DeltaXEdit.AsInteger - dx,0);
  dx := DeltaXEdit.AsInteger;
end;

procedure TMoveResizeDialog.DeltaYEditBottomClick(Sender: TObject);
begin
  if FMove then PlanObject.Move(0,DeltaYEdit.AsInteger - dy) else PlanObject.Resize(0,DeltaYEdit.AsInteger - dy);
  dy := DeltaYEdit.AsInteger;
end;

procedure TMoveResizeDialog.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = #27) then Close;
end;

end.
