unit FrmShare;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, NTCommon, Share;

type
  TForm1 = class(TForm)
    cmbComputer: TComboBox;
    Label1: TLabel;
    pcShare: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    lbxResources: TListBox;
    btnAddShareDisk: TButton;
    btnRemoveShare: TButton;
    btnSessionClose: TButton;
    lbxSessions: TListBox;
    lbxUsages: TListBox;
    btnCloseUsage: TButton;
    btnRefresh: TButton;
    hdrResurces: THeaderControl;
    hdrSessions: THeaderControl;
    hdrUsage: THeaderControl;
    btnProperty: TButton;
    TabSheet4: TTabSheet;
    btnAddConnect: TButton;
    btnRemoveConnect: TButton;
    hdrConnections: THeaderControl;
    lbxConnections: TListBox;
    Button1: TButton;
    Share1: TShare;
    procedure FormCreate(Sender: TObject);
    procedure lbxResourcesDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure hdrResurcesSectionResize(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure btnRemoveShareClick(Sender: TObject);
    procedure btnRefreshClick(Sender: TObject);
    procedure btnAddShareDiskClick(Sender: TObject);
    procedure lbxSessionsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure hdrSessionsSectionResize(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure btnSessionCloseClick(Sender: TObject);
    procedure lbxUsagesDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure hdrUsageSectionResize(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure btnCloseUsageClick(Sender: TObject);
    procedure btnPropertyClick(Sender: TObject);
    procedure hdrConnectionsSectionResize(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure lbxConnectionsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure pcShareChange(Sender: TObject);
    procedure btnRemoveConnectClick(Sender: TObject);
    procedure btnAddConnectClick(Sender: TObject);
    procedure cmbComputerClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    ResourceList:   TResourceList;
    SessionList:    TSessionList;
    UsageList:      TUsageList;
    ConnectionList: TConnectionList;
  public
    { Public declarations }
    procedure RefreshState;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses FrmAdd, FrmProp, FrNewConn;

procedure TForm1.FormCreate(Sender: TObject);
var
  List: TStringList;
begin
  pcShare.ActivePage := TabSheet1;
  List := Share1.GetServers('');
  try
  cmbComputer.Items.Assign(List);
  finally
  List.Free;
  end;
  RefreshState;
end;

  procedure TForm1.RefreshState;
var
  i: integer;
begin
  Share1.MachineName := cmbComputer.Text;
//  if ResourceList = nil then ResourceList.Free;
  lbxResources.Items.Clear;
  lbxSessions.Items.Clear;
  lbxUsages.Items.Clear;
  lbxConnections.Items.Clear;

  ResourceList   := Share1.Resources;
  SessionList    := Share1.Sessions;
  ConnectionList := Share1.Connections;
  try
    UsageList    := Share1.Usages;
  except
    on E: Exception do
      begin
      lbxUsages.Items.Add(E.Message);
      UsageList := nil;
      end;
  end;
  for i := 0 to ResourceList.Count - 1 do lbxResources.Items.Add(ResourceList[i].ShareName);
  for i := 0 to SessionList.Count - 1 do lbxSessions.Items.Add(SessionList[i].UserName);
  for i := 0 to ConnectionList.Count - 1 do lbxConnections.Items.Add(ConnectionList[i].LocalName);
  if UsageList <> nil then for i := 0 to UsageList.Count - 1 do lbxUsages.Items.Add(UsageList[i].UserName);

  lbxResources.Refresh;
  lbxSessions.Refresh;
  lbxUsages.Refresh;
  lbxConnections.Refresh;
  btnRemoveShare.Enabled := ResourceList.Count > 0;
  btnProperty.Enabled := btnRemoveShare.Enabled;
  if btnRemoveShare.Enabled then lbxResources.ItemIndex := 0;
  btnSessionClose.Enabled := SessionList.Count > 0;
  if btnSessionClose.Enabled then lbxSessions.ItemIndex := 0;
  btnCloseUsage.Enabled := (UsageList <> nil) and (UsageList.Count > 0);
  if btnCloseUsage.Enabled then lbxUsages.ItemIndex := 0;
  btnRemoveConnect.Enabled := ConnectionList.Count > 0;
  if btnRemoveConnect.Enabled then lbxConnections.ItemIndex := 0;
end;

procedure TForm1.lbxResourcesDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
begin
   with lbxResources.Canvas do
     begin
     TextRect(Rect, Rect.left+1, Rect.Top+1, ResourceList[Index].ShareName);
     Rect.Left := Rect.Left + hdrResurces.Sections[0].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, ResourceList[Index].ShareComment);
     Rect.Left := Rect.Left + hdrResurces.Sections[1].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, IntToStr(ResourceList[Index].CurrentUsers));
     Rect.Left := Rect.Left + hdrResurces.Sections[2].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, IntToStr(ResourceList[Index].MaxUsers));
     Rect.Left := Rect.Left + hdrResurces.Sections[3].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, ResourceList[Index].Path);
     end;
end;

procedure TForm1.hdrResurcesSectionResize(HeaderControl: THeaderControl;
  Section: THeaderSection);
begin
  lbxResources.Refresh;
end;

procedure TForm1.btnRemoveShareClick(Sender: TObject);
begin
  ResourceList.Delete(lbxResources.ItemIndex);
  RefreshState;
end;

procedure TForm1.btnRefreshClick(Sender: TObject);
begin
  RefreshState;
end;

procedure TForm1.btnAddShareDiskClick(Sender: TObject);
begin
  with TFrmShareDisk.Create(Application) do
    try
    if ShowModal = mrOk then
      begin
      ResourceList.Add(edtName.Text, edtPath.Text, stDisk);
      RefreshState;
      end;
    finally
    Free;
    end;
end;

procedure TForm1.lbxSessionsDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
begin
   with lbxSessions.Canvas do
     begin
     TextRect(Rect, Rect.left+1, Rect.Top+1, SessionList[Index].UserName);
     Rect.Left := Rect.Left + hdrSessions.Sections[0].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, SessionList[Index].ClientName);
     Rect.Left := Rect.Left + hdrSessions.Sections[1].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, IntToStr(SessionList[Index].OpenResourses));
     Rect.Left := Rect.Left + hdrSessions.Sections[2].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, FormatDateTime('hh:mm:ss',SessionList[Index].SessionTime));
     Rect.Left := Rect.Left + hdrSessions.Sections[3].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, FormatDateTime('hh:mm:ss',SessionList[Index].IdleTime));
     Rect.Left := Rect.Left + hdrSessions.Sections[4].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, SessionList[Index].ClientType);
     end;
end;

procedure TForm1.hdrSessionsSectionResize(HeaderControl: THeaderControl;
  Section: THeaderSection);
begin
  lbxSessions.Refresh;
end;

procedure TForm1.btnSessionCloseClick(Sender: TObject);
begin
  SessionList.Delete(lbxSessions.ItemIndex);
  RefreshState;
end;

procedure TForm1.lbxUsagesDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
begin
   with lbxUsages.Canvas do
     begin
     if UsageList = nil then
       begin  TextRect(Rect, Rect.left+1, Rect.Top+1, lbxUsages.Items[0]); Exit; end;
     TextRect(Rect, Rect.left+1, Rect.Top+1, UsageList[Index].UserName);
     Rect.Left := Rect.Left + hdrUsage.Sections[0].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, AccessTypesToStr(UsageList[Index].Permissions));
     Rect.Left := Rect.Left + hdrUsage.Sections[1].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, IntToStr(UsageList[Index].NumLocks));
     Rect.Left := Rect.Left + hdrUsage.Sections[2].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, UsageList[Index].PathName);
     end;
end;

procedure TForm1.hdrUsageSectionResize(HeaderControl: THeaderControl;
  Section: THeaderSection);
begin
  lbxUsages.Refresh;
end;

procedure TForm1.btnCloseUsageClick(Sender: TObject);
begin
  UsageList.Delete(lbxUsages.ItemIndex);
  RefreshState;
end;

procedure TForm1.btnPropertyClick(Sender: TObject);
begin
  with TFrmProperty.Create(Application) do
    try
    Share1.ShareName := ResourceList[lbxResources.ItemIndex].ShareName;
    edtComment.Text  := Share1.ShareComment;
    speUsers.Value   := Share1.MaxUsers;
    if ShowModal = mrOk then
      begin
      Share1.ShareComment  := edtComment.Text;
      Share1.MaxUsers := speUsers.Value;
      end;
    finally
    Free;
    end;
  RefreshState;
end;

procedure TForm1.hdrConnectionsSectionResize(HeaderControl: THeaderControl;
  Section: THeaderSection);
begin
  lbxConnections.Refresh;
end;

procedure TForm1.lbxConnectionsDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
   with lbxConnections.Canvas do
     begin
     TextRect(Rect, Rect.left+1, Rect.Top+1, ConnectionList[Index].LocalName);
     Rect.Left := Rect.Left + hdrConnections.Sections[0].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, ConnectionList[Index].RemoteName);
     Rect.Left := Rect.Left + hdrConnections.Sections[1].Width;
     TextRect(Rect, Rect.left+1, Rect.Top+1, ConnectionList[Index].UserName);
     Rect.Left := Rect.Left + hdrConnections.Sections[2].Width;
     end;
end;

procedure TForm1.pcShareChange(Sender: TObject);
begin
  if pcShare.ActivePage = TabSheet4 then
    begin
    cmbComputer.ItemIndex := -1;
    cmbComputer.Enabled := false;
    end else cmbComputer.Enabled := true;
end;

procedure TForm1.btnRemoveConnectClick(Sender: TObject);
begin
  ConnectionList.Delete(lbxConnections.ItemIndex);
  RefreshState;
end;

procedure TForm1.btnAddConnectClick(Sender: TObject);
begin
  with TFrmConnection.Create(Application) do
    try
    ResourceType := stDisk;
    if ShowModal <> mrOk then Exit;
    ConnectionList.Add(cmbDrive.Text, edtName.Text, stDisk);
    finally
    Free;
    end;
  RefreshState;
end;

procedure TForm1.cmbComputerClick(Sender: TObject);
begin
  RefreshState;
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  with TFrmConnection.Create(Application) do
    try
    ResourceType := stPrint;
    if ShowModal <> mrOk then Exit;
    ConnectionList.Add(cmbDrive.Text, edtName.Text, stPrint);
    finally
    Free;
    end;
  RefreshState;
end;


end.
